/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.env.binding;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hibernate.cfg.Configuration;
import org.ow2.bonita.env.binding.PropertiesBinding;
import org.ow2.bonita.env.binding.WireDescriptorBinding;
import org.ow2.bonita.env.descriptor.HibernateConfigurationDescriptor;
import org.ow2.bonita.env.descriptor.PropertiesDescriptor;
import org.ow2.bonita.util.ReflectUtil;
import org.ow2.bonita.util.stream.FileStreamSource;
import org.ow2.bonita.util.stream.ResourceStreamSource;
import org.ow2.bonita.util.stream.StreamSource;
import org.ow2.bonita.util.stream.UrlStreamSource;
import org.ow2.bonita.util.xml.Parse;
import org.ow2.bonita.util.xml.Parser;
import org.ow2.bonita.util.xml.XmlUtil;
import org.w3c.dom.Element;

public class HibernateConfigurationBinding
extends WireDescriptorBinding {
    static final Logger LOG = Logger.getLogger(HibernateConfigurationBinding.class.getName());
    private static final PropertiesBinding PROPERTIES_BINDING = new PropertiesBinding();
    private static final MappingParser MAPPING_PARSER = new MappingParser();

    public HibernateConfigurationBinding() {
        super("hibernate-configuration");
    }

    protected HibernateConfigurationBinding(String tagName) {
        super(tagName);
    }

    static void parseMapping(Element element, HibernateConfigurationDescriptor descriptor, Parse parse) {
        if (element.hasAttribute("resource")) {
            String resource = element.getAttribute("resource");
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("adding hibernate configuration resource " + resource);
            }
            descriptor.addMappingOperation(new HibernateConfigurationDescriptor.AddResource(resource));
        } else if (element.hasAttribute("file")) {
            String fileName = element.getAttribute("file");
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("adding hibernate configuration file " + fileName);
            }
            descriptor.addMappingOperation(new HibernateConfigurationDescriptor.AddFile(fileName));
        } else if (element.hasAttribute("class")) {
            String className = element.getAttribute("class");
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("adding hibernate configuration class " + className);
            }
            descriptor.addMappingOperation(new HibernateConfigurationDescriptor.AddClass(className));
        } else if (element.hasAttribute("url")) {
            String urlText = element.getAttribute("url");
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("adding hibernate configuration url " + urlText);
            }
            descriptor.addMappingOperation(new HibernateConfigurationDescriptor.AddUrl(urlText));
        } else {
            parse.addProblem("exactly 1 attribute in {resource, file, class, url} was expected in mapping: " + XmlUtil.toString(element));
        }
    }

    @Override
    public Object parse(Element element, Parse parse, Parser parser) {
        List<Element> configElements;
        HibernateConfigurationDescriptor descriptor = new HibernateConfigurationDescriptor();
        String configurationClassName = null;
        configurationClassName = element.hasAttribute("class") ? element.getAttribute("class") : Configuration.class.getName();
        descriptor.setClassName(configurationClassName);
        if (element.hasAttribute("schema-operation")) {
            String schemaOperation = element.getAttribute("schema-operation");
            if ("create".equals(schemaOperation)) {
                descriptor.setSchemaOperation(HibernateConfigurationDescriptor.CreateSchema.getInstance());
            } else if ("update".equals(schemaOperation)) {
                descriptor.setSchemaOperation(HibernateConfigurationDescriptor.UpdateSchema.getInstance());
            }
        }
        if ((configElements = XmlUtil.elements(element)) != null) {
            for (Element configElement : configElements) {
                if ("mappings".equals(XmlUtil.getTagLocalName(configElement))) {
                    if (!configElement.hasAttribute("resource")) continue;
                    String resources = configElement.getAttribute("resource");
                    try {
                        URL url = ReflectUtil.getResource(parse.getClassLoader(), resources);
                        if (url == null) continue;
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("importing mappings from " + url);
                        }
                        InputStream inputStream = url.openStream();
                        MAPPING_PARSER.createParse().pushObject(descriptor).setInputStream(inputStream).execute();
                    }
                    catch (Exception e) {
                        parse.addProblem("couldn't parse hibernate mapping resources '" + resources + "'", e);
                    }
                    continue;
                }
                if ("mapping".equals(XmlUtil.getTagLocalName(configElement))) {
                    HibernateConfigurationBinding.parseMapping(configElement, descriptor, parse);
                    continue;
                }
                if ("properties".equals(XmlUtil.getTagLocalName(configElement))) {
                    PropertiesDescriptor propertiesDescriptor = (PropertiesDescriptor)PROPERTIES_BINDING.parse(configElement, parse, parser);
                    descriptor.setPropertiesDescriptor(propertiesDescriptor);
                    continue;
                }
                if ("cache-configuration".equals(XmlUtil.getTagLocalName(configElement))) {
                    List<Element> cacheElements;
                    StreamSource streamSource = null;
                    String cacheUsage = configElement.getAttribute("usage");
                    if (!("read-only".equals(cacheUsage) || "nonstrict-read-write".equals(cacheUsage) || "read-write".equals(cacheUsage) || "transactional".equals(cacheUsage))) {
                        parse.addProblem("problem in cache-configuration: no usage attribute or illegal value: " + cacheUsage + " Possible values are {read-only, nonstrict-read-write, read-write, transactional}");
                        continue;
                    }
                    if (configElement.hasAttribute("file")) {
                        String fileName = configElement.getAttribute("file");
                        File file = new File(fileName);
                        if (file.exists() && file.isFile()) {
                            streamSource = new FileStreamSource(file);
                        } else {
                            parse.addProblem("file " + fileName + " isn't a file");
                        }
                    }
                    if (configElement.hasAttribute("resource")) {
                        String resource = configElement.getAttribute("resource");
                        streamSource = new ResourceStreamSource(resource, parse.getClassLoader());
                    }
                    if (configElement.hasAttribute("url")) {
                        String urlText = configElement.getAttribute("url");
                        try {
                            URL url = new URL(urlText);
                            streamSource = new UrlStreamSource(url);
                        }
                        catch (Exception e) {
                            parse.addProblem("couldn't open url " + urlText, e);
                        }
                    }
                    if (streamSource != null) {
                        parser.importStream(streamSource, configElement, parse);
                    }
                    if ((cacheElements = XmlUtil.elements(configElement)) == null) continue;
                    for (Element cacheElement : cacheElements) {
                        if ("class-cache".equals(XmlUtil.getTagLocalName(cacheElement))) {
                            String className = cacheElement.getAttribute("class");
                            descriptor.addCacheOperation(new HibernateConfigurationDescriptor.SetCacheConcurrencyStrategy(className, cacheUsage));
                            continue;
                        }
                        if ("collection-cache".equals(XmlUtil.getTagLocalName(cacheElement))) {
                            String collection = cacheElement.getAttribute("collection");
                            descriptor.addCacheOperation(new HibernateConfigurationDescriptor.SetCollectionCacheConcurrencyStrategy(collection, cacheUsage));
                            continue;
                        }
                        parse.addProblem("unknown hibernate cache configuration element " + XmlUtil.toString(configElement));
                    }
                    continue;
                }
                parse.addProblem("unknown hibernate configuration element " + XmlUtil.toString(configElement));
            }
        }
        return descriptor;
    }

    static class MappingParser
    extends Parser {
        MappingParser() {
        }

        @Override
        public Object parseDocumentElement(Element documentElement, Parse parse) {
            List<Element> elements = XmlUtil.elements(documentElement, "mapping");
            if (elements != null) {
                HibernateConfigurationDescriptor descriptor = parse.findObject(HibernateConfigurationDescriptor.class);
                for (Element element : elements) {
                    HibernateConfigurationBinding.parseMapping(element, descriptor, parse);
                }
            }
            return null;
        }
    }
}

