/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.env.xml;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.util.ReflectUtil;
import org.ow2.bonita.util.xml.Binding;
import org.ow2.bonita.util.xml.Bindings;
import org.ow2.bonita.util.xml.Parse;
import org.ow2.bonita.util.xml.Parser;
import org.ow2.bonita.util.xml.XmlUtil;
import org.w3c.dom.Element;

public class BindingParser
extends Parser {
    static final Logger LOG = Logger.getLogger(BindingParser.class.getName());

    @Override
    public Object parseDocumentElement(Element documentElement, Parse parse) {
        List<Element> elements = XmlUtil.elements(documentElement, "binding");
        if (elements != null) {
            for (Element bindingElement : elements) {
                String bindingClassName = XmlUtil.attribute(bindingElement, "class");
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("adding wire binding for " + bindingClassName);
                }
                Binding binding = null;
                if (bindingClassName != null) {
                    try {
                        Class<?> bindingClass = ReflectUtil.loadClass(this.classLoader, bindingClassName);
                        binding = (Binding)bindingClass.newInstance();
                    }
                    catch (Exception e) {
                        parse.addProblem("couldn't instantiate binding " + bindingClassName, e);
                    }
                } else {
                    parse.addProblem("class is a required attribute in a binding " + XmlUtil.toString(bindingElement));
                }
                if (binding != null) {
                    Bindings bindings = parse.findObject(Bindings.class);
                    bindings.addBinding(binding);
                    continue;
                }
                if (!LOG.isLoggable(Level.INFO)) continue;
                LOG.info("WARNING: binding for " + bindingClassName + " could not be parsed. See parsing problems for more details.");
            }
        }
        return null;
    }
}

