/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.def.majorElement.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ow2.bonita.facade.def.element.BoundaryEvent;
import org.ow2.bonita.facade.def.element.DeadlineDefinition;
import org.ow2.bonita.facade.def.element.FilterDefinition;
import org.ow2.bonita.facade.def.element.HookDefinition;
import org.ow2.bonita.facade.def.element.IncomingEventDefinition;
import org.ow2.bonita.facade.def.element.MultiInstantiationDefinition;
import org.ow2.bonita.facade.def.element.OutgoingEventDefinition;
import org.ow2.bonita.facade.def.element.SubflowParameterDefinition;
import org.ow2.bonita.facade.def.element.impl.BoundaryEventImpl;
import org.ow2.bonita.facade.def.element.impl.ConnectorDefinitionImpl;
import org.ow2.bonita.facade.def.element.impl.ErrorBoundaryEventImpl;
import org.ow2.bonita.facade.def.element.impl.IncomingEventDefinitionImpl;
import org.ow2.bonita.facade.def.element.impl.MessageBoundaryEventImpl;
import org.ow2.bonita.facade.def.element.impl.OutgoingEventDefinitionImpl;
import org.ow2.bonita.facade.def.element.impl.SignalBoundaryEventImpl;
import org.ow2.bonita.facade.def.element.impl.SubflowParameterDefinitionImpl;
import org.ow2.bonita.facade.def.element.impl.TimerBoundaryEventImpl;
import org.ow2.bonita.facade.def.majorElement.ActivityDefinition;
import org.ow2.bonita.facade.def.majorElement.DataFieldDefinition;
import org.ow2.bonita.facade.def.majorElement.TransitionDefinition;
import org.ow2.bonita.facade.def.majorElement.impl.DataFieldDefinitionImpl;
import org.ow2.bonita.facade.def.majorElement.impl.ProcessElementImpl;
import org.ow2.bonita.facade.def.majorElement.impl.TransitionDefinitionImpl;
import org.ow2.bonita.facade.uuid.ActivityDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;

public class ActivityDefinitionImpl
extends ProcessElementImpl
implements ActivityDefinition {
    private static final long serialVersionUID = 1545928041850807545L;
    protected ActivityDefinitionUUID uuid;
    protected Set<DeadlineDefinition> deadlines;
    protected Set<String> performers;
    protected ActivityDefinition.JoinType joinType;
    protected ActivityDefinition.SplitType splitType;
    protected List<HookDefinition> connectors;
    protected FilterDefinition filter;
    protected Set<DataFieldDefinition> dataFields;
    protected Set<TransitionDefinition> outgoingTransitions;
    protected Set<TransitionDefinition> incomingTransitions;
    protected Map<String, BoundaryEvent> boundaryEvents;
    protected Set<SubflowParameterDefinition> subflowInParameters;
    protected Set<SubflowParameterDefinition> subflowOutParameters;
    protected String subflowProcessName;
    protected String subflowProcessVersion;
    @Deprecated
    protected MultiInstantiationDefinition activityInstantiator;
    protected MultiInstantiationDefinition instantiator;
    protected MultiInstantiationDefinition joinChecker;
    protected boolean asynchronous;
    protected long executingTime;
    protected int priority;
    protected boolean inCycle;
    protected String timerCondition;
    protected IncomingEventDefinition incomingEvent;
    protected Set<OutgoingEventDefinition> outgoingEvents;
    protected ActivityDefinition.Type type;
    protected boolean loop;
    protected String loopCondition;
    protected String loopMaximum;
    protected boolean beforeExecution;
    protected String dynamicLabel;
    protected String dynamicDescription;
    protected String executionSummary;
    protected boolean catchEvent;
    protected boolean terminateProcess;

    protected ActivityDefinitionImpl() {
    }

    public static ActivityDefinitionImpl createAutomaticActivity(ProcessDefinitionUUID processUUID, String name) {
        return new ActivityDefinitionImpl(processUUID, name, ActivityDefinition.Type.Automatic, null, null, null, null, null, null);
    }

    public static ActivityDefinitionImpl createSubflowActivity(ProcessDefinitionUUID processUUID, String name, String subflowProcessName, String subflowProcessVersion) {
        return new ActivityDefinitionImpl(processUUID, name, ActivityDefinition.Type.Subflow, null, subflowProcessName, subflowProcessVersion, null, null, null);
    }

    public static ActivityDefinitionImpl createTimerActivity(ProcessDefinitionUUID processUUID, String name, String timerCondition) {
        return new ActivityDefinitionImpl(processUUID, name, ActivityDefinition.Type.Timer, null, null, null, timerCondition, null, null);
    }

    public static ActivityDefinitionImpl createHumanActivity(ProcessDefinitionUUID processUUID, String name, Set<String> performers) {
        return new ActivityDefinitionImpl(processUUID, name, ActivityDefinition.Type.Human, performers, null, null, null, null, null);
    }

    public static ActivityDefinitionImpl createSendEventActivity(ProcessDefinitionUUID processUUID, String name) {
        return new ActivityDefinitionImpl(processUUID, name, ActivityDefinition.Type.SendEvents, null, null, null, null, null, null);
    }

    public static ActivityDefinitionImpl createReceiveEventActivity(ProcessDefinitionUUID processUUID, String name, String eventName, String expression) {
        return new ActivityDefinitionImpl(processUUID, name, ActivityDefinition.Type.ReceiveEvent, null, null, null, null, eventName, expression);
    }

    public static ActivityDefinitionImpl createErrorEventActivity(ProcessDefinitionUUID processUUID, String eventName, String errorCode) {
        return new ActivityDefinitionImpl(processUUID, eventName, ActivityDefinition.Type.ErrorEvent, null, null, null, errorCode, null, null);
    }

    public static ActivityDefinitionImpl createSignalEventActivity(ProcessDefinitionUUID processUUID, String eventName, String signalCode) {
        return new ActivityDefinitionImpl(processUUID, eventName, ActivityDefinition.Type.SignalEvent, null, null, null, signalCode, null, null);
    }

    private ActivityDefinitionImpl(ProcessDefinitionUUID processUUID, String name, ActivityDefinition.Type type, Set<String> performers, String subflowProcessName, String subFlowProcessVersion, String timerCondition, String eventName, String receiveEventExpression) {
        super(name, processUUID);
        this.uuid = new ActivityDefinitionUUID(processUUID, name);
        this.performers = performers;
        this.subflowProcessName = subflowProcessName;
        this.subflowProcessVersion = subFlowProcessVersion;
        this.timerCondition = timerCondition;
        this.joinType = ActivityDefinition.JoinType.XOR;
        this.splitType = ActivityDefinition.SplitType.AND;
        this.dataFields = new HashSet<DataFieldDefinition>();
        this.asynchronous = false;
        this.loop = false;
        this.type = type;
        if (eventName != null) {
            this.incomingEvent = new IncomingEventDefinitionImpl(eventName, receiveEventExpression);
        }
    }

    public ActivityDefinitionImpl(ActivityDefinition src) {
        super(src);
        Set<SubflowParameterDefinition> subFlowOutParams;
        Set<OutgoingEventDefinition> outgoingEvents;
        List<BoundaryEvent> boundaryevents;
        Set<TransitionDefinition> ictransitions;
        Set<TransitionDefinition> ogtransitions;
        Set<DataFieldDefinition> dataFields;
        this.uuid = new ActivityDefinitionUUID(src.getUUID());
        this.executingTime = src.getExecutingTime();
        this.priority = src.getPriority();
        this.timerCondition = src.getTimerCondition();
        Set<DeadlineDefinition> deadlines = src.getDeadlines();
        if (deadlines != null) {
            this.deadlines = new HashSet<DeadlineDefinition>();
            for (DeadlineDefinition d : deadlines) {
                this.deadlines.add(new ConnectorDefinitionImpl(d));
            }
        }
        Set<String> performers = src.getPerformers();
        this.performers = new HashSet<String>();
        for (String performer : performers) {
            this.performers.add(performer);
        }
        this.joinType = src.getJoinType();
        this.splitType = src.getSplitType();
        List<HookDefinition> hooks = src.getConnectors();
        if (hooks != null) {
            this.connectors = new ArrayList<HookDefinition>();
            for (HookDefinition d : hooks) {
                this.connectors.add(new ConnectorDefinitionImpl(d));
            }
        }
        if (src.getFilter() != null) {
            this.filter = new ConnectorDefinitionImpl(src.getFilter());
        }
        if ((dataFields = src.getDataFields()) != null) {
            this.dataFields = new HashSet<DataFieldDefinition>();
            for (DataFieldDefinition d : dataFields) {
                this.dataFields.add(new DataFieldDefinitionImpl(d));
            }
        }
        if ((ogtransitions = src.getOutgoingTransitions()) != null) {
            this.outgoingTransitions = new HashSet<TransitionDefinition>();
            for (TransitionDefinition d : ogtransitions) {
                this.outgoingTransitions.add(new TransitionDefinitionImpl(d));
            }
        }
        if ((ictransitions = src.getIncomingTransitions()) != null) {
            this.incomingTransitions = new HashSet<TransitionDefinition>();
            for (TransitionDefinition d : ictransitions) {
                this.incomingTransitions.add(new TransitionDefinitionImpl(d));
            }
        }
        if ((boundaryevents = src.getBoundaryEvents()) != null) {
            this.boundaryEvents = new HashMap<String, BoundaryEvent>();
            for (BoundaryEvent boundaryEvent : boundaryevents) {
                BoundaryEventImpl event = null;
                if (boundaryEvent instanceof TimerBoundaryEventImpl) {
                    TimerBoundaryEventImpl timer = (TimerBoundaryEventImpl)boundaryEvent;
                    event = new TimerBoundaryEventImpl(timer);
                } else if (boundaryEvent instanceof MessageBoundaryEventImpl) {
                    MessageBoundaryEventImpl message = (MessageBoundaryEventImpl)boundaryEvent;
                    event = new MessageBoundaryEventImpl(message);
                } else if (boundaryEvent instanceof ErrorBoundaryEventImpl) {
                    ErrorBoundaryEventImpl error = (ErrorBoundaryEventImpl)boundaryEvent;
                    event = new ErrorBoundaryEventImpl(error);
                } else if (boundaryEvent instanceof SignalBoundaryEventImpl) {
                    SignalBoundaryEventImpl signal = (SignalBoundaryEventImpl)boundaryEvent;
                    event = new SignalBoundaryEventImpl(signal);
                }
                this.boundaryEvents.put(boundaryEvent.getName(), event);
            }
        }
        if (src.getIncomingEvent() != null) {
            this.incomingEvent = new IncomingEventDefinitionImpl(src.getIncomingEvent());
        }
        if ((outgoingEvents = src.getOutgoingEvents()) != null) {
            this.outgoingEvents = new HashSet<OutgoingEventDefinition>();
            for (OutgoingEventDefinition eventDefinition : outgoingEvents) {
                this.outgoingEvents.add(new OutgoingEventDefinitionImpl(eventDefinition));
            }
        }
        if (src.getMultiInstantiationDefinition() != null) {
            this.activityInstantiator = new ConnectorDefinitionImpl(src.getMultiInstantiationDefinition());
        }
        if (src.getMultipleInstancesInstantiator() != null) {
            this.instantiator = new ConnectorDefinitionImpl(src.getMultipleInstancesInstantiator());
        }
        if (src.getMultipleInstancesJoinChecker() != null) {
            this.joinChecker = new ConnectorDefinitionImpl(src.getMultipleInstancesJoinChecker());
        }
        this.asynchronous = src.isAsynchronous();
        Set<SubflowParameterDefinition> subFlowInParams = src.getSubflowInParameters();
        if (subFlowInParams != null) {
            this.subflowInParameters = new HashSet<SubflowParameterDefinition>();
            for (SubflowParameterDefinition p : subFlowInParams) {
                this.subflowInParameters.add(new SubflowParameterDefinitionImpl(p));
            }
        }
        if ((subFlowOutParams = src.getSubflowOutParameters()) != null) {
            this.subflowOutParameters = new HashSet<SubflowParameterDefinition>();
            for (SubflowParameterDefinition p : subFlowOutParams) {
                this.subflowOutParameters.add(new SubflowParameterDefinitionImpl(p));
            }
        }
        this.subflowProcessName = src.getSubflowProcessName();
        this.subflowProcessVersion = src.getSubflowProcessVersion();
        this.inCycle = src.isInCycle();
        this.type = src.getType();
        this.loop = src.isInALoop();
        this.loopCondition = src.getLoopCondition();
        this.beforeExecution = src.evaluateLoopConditionBeforeExecution();
        this.loopMaximum = src.getLoopMaximum();
        this.dynamicDescription = src.getDynamicDescription();
        this.dynamicLabel = src.getDynamicLabel();
        this.executionSummary = src.getDynamicExecutionSummary();
        this.catchEvent = src.catchEvent();
        this.terminateProcess = src.isTerminateProcess();
    }

    public String toString() {
        return this.getUUID().toString();
    }

    @Override
    public String getDynamicDescription() {
        return this.dynamicDescription;
    }

    @Override
    public String getDynamicLabel() {
        return this.dynamicLabel;
    }

    @Override
    public String getDynamicExecutionSummary() {
        return this.executionSummary;
    }

    @Override
    public Set<DeadlineDefinition> getDeadlines() {
        if (this.deadlines == null) {
            return Collections.emptySet();
        }
        return this.deadlines;
    }

    @Override
    public Set<TransitionDefinition> getOutgoingTransitions() {
        if (this.outgoingTransitions == null) {
            return Collections.emptySet();
        }
        return this.outgoingTransitions;
    }

    @Override
    public Set<TransitionDefinition> getIncomingTransitions() {
        if (this.incomingTransitions == null) {
            return Collections.emptySet();
        }
        return this.incomingTransitions;
    }

    @Override
    public TransitionDefinition getOutgoingTransition(String transitionName) {
        for (TransitionDefinition transition : this.getOutgoingTransitions()) {
            if (!transition.getName().equals(transitionName)) continue;
            return transition;
        }
        return null;
    }

    @Override
    public TransitionDefinition getIncomingTransitions(String transitionName) {
        for (TransitionDefinition transition : this.getIncomingTransitions()) {
            if (!transition.getName().equals(transitionName)) continue;
            return transition;
        }
        return null;
    }

    @Override
    public Set<String> getPerformers() {
        if (this.performers == null) {
            return Collections.emptySet();
        }
        return this.performers;
    }

    @Override
    public String getSubflowProcessName() {
        return this.subflowProcessName;
    }

    @Override
    public String getSubflowProcessVersion() {
        return this.subflowProcessVersion;
    }

    @Override
    public List<HookDefinition> getConnectors() {
        if (this.connectors == null) {
            return Collections.emptyList();
        }
        return this.connectors;
    }

    @Override
    public FilterDefinition getFilter() {
        return this.filter;
    }

    @Override
    public Set<DataFieldDefinition> getDataFields() {
        if (this.dataFields == null) {
            return Collections.emptySet();
        }
        return this.dataFields;
    }

    @Override
    public ActivityDefinitionUUID getUUID() {
        return this.uuid;
    }

    @Override
    @Deprecated
    public MultiInstantiationDefinition getMultiInstantiationDefinition() {
        return this.activityInstantiator;
    }

    @Override
    public MultiInstantiationDefinition getMultipleInstancesInstantiator() {
        return this.instantiator;
    }

    @Override
    public MultiInstantiationDefinition getMultipleInstancesJoinChecker() {
        return this.joinChecker;
    }

    @Override
    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    @Override
    public ActivityDefinition.JoinType getJoinType() {
        return this.joinType;
    }

    @Override
    public ActivityDefinition.SplitType getSplitType() {
        return this.splitType;
    }

    @Override
    public boolean isAutomatic() {
        return ActivityDefinition.Type.Automatic.equals((Object)this.getType());
    }

    @Override
    public boolean isTask() {
        return ActivityDefinition.Type.Human.equals((Object)this.getType());
    }

    @Override
    public ActivityDefinition.Type getType() {
        return this.type;
    }

    public void addOutgoingTransition(TransitionDefinition transition) {
        if (this.outgoingTransitions == null) {
            this.outgoingTransitions = new HashSet<TransitionDefinition>();
        }
        this.outgoingTransitions.add(transition);
    }

    @Override
    public boolean hasIncomingTransitions() {
        return this.getIncomingTransitions().size() > 0;
    }

    @Override
    public boolean hasOutgoingTransitions() {
        return this.getOutgoingTransitions().size() > 0;
    }

    public void addIncomingTransition(TransitionDefinition transition) {
        if (this.incomingTransitions == null) {
            this.incomingTransitions = new HashSet<TransitionDefinition>();
        }
        this.incomingTransitions.add(transition);
    }

    public void addData(DataFieldDefinition data) {
        if (this.dataFields == null) {
            this.dataFields = new HashSet<DataFieldDefinition>();
        }
        this.dataFields.add(data);
    }

    public void setFilter(FilterDefinition filter) {
        this.filter = filter;
    }

    @Deprecated
    public void setMultiInstanciation(MultiInstantiationDefinition multiInstanciation) {
        this.activityInstantiator = multiInstanciation;
    }

    public void setMultipleInstancesInstantiator(MultiInstantiationDefinition instantiator) {
        this.instantiator = instantiator;
    }

    public void setMultipleInstancesJoinChecker(MultiInstantiationDefinition joinChecker) {
        this.joinChecker = joinChecker;
    }

    public void addDeadline(DeadlineDefinition deadline) {
        if (this.deadlines == null) {
            this.deadlines = new HashSet<DeadlineDefinition>();
        }
        this.deadlines.add(deadline);
    }

    public void addConnector(HookDefinition connector) {
        if (this.connectors == null) {
            this.connectors = new ArrayList<HookDefinition>();
        }
        this.connectors.add(connector);
    }

    public void setJoinType(ActivityDefinition.JoinType join) {
        this.joinType = join;
    }

    public void setSplitType(ActivityDefinition.SplitType split) {
        this.splitType = split;
    }

    public void setAsynchronous(boolean asynchronous) {
        this.asynchronous = asynchronous;
    }

    @Override
    public Set<SubflowParameterDefinition> getSubflowInParameters() {
        if (this.subflowInParameters == null) {
            return Collections.emptySet();
        }
        return this.subflowInParameters;
    }

    @Override
    public Set<SubflowParameterDefinition> getSubflowOutParameters() {
        if (this.subflowOutParameters == null) {
            return Collections.emptySet();
        }
        return this.subflowOutParameters;
    }

    @Override
    public boolean isSubflow() {
        return ActivityDefinition.Type.Subflow.equals((Object)this.getType());
    }

    public void addSubflowOutParameter(SubflowParameterDefinition param) {
        if (this.subflowOutParameters == null) {
            this.subflowOutParameters = new HashSet<SubflowParameterDefinition>();
        }
        this.subflowOutParameters.add(param);
    }

    public void addSubflowInParameter(SubflowParameterDefinition param) {
        if (this.subflowInParameters == null) {
            this.subflowInParameters = new HashSet<SubflowParameterDefinition>();
        }
        this.subflowInParameters.add(param);
    }

    public void setExecutingTime(long executingTime) {
        this.executingTime = executingTime;
    }

    @Override
    public long getExecutingTime() {
        return this.executingTime;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public Set<String> getClassDependencies() {
        HashSet<String> classDependencies = new HashSet<String>();
        for (DeadlineDefinition deadline : this.getDeadlines()) {
            classDependencies.add(deadline.getClassName());
        }
        for (HookDefinition connector : this.getConnectors()) {
            classDependencies.add(connector.getClassName());
        }
        if (this.getMultiInstantiationDefinition() != null) {
            classDependencies.add(this.getMultiInstantiationDefinition().getClassName());
        }
        if (this.getFilter() != null) {
            classDependencies.add(this.getFilter().getClassName());
        }
        return classDependencies;
    }

    public void setInCycle(boolean inCycle) {
        this.inCycle = inCycle;
    }

    @Override
    public boolean isInCycle() {
        return this.inCycle;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivityDefinition)) {
            return false;
        }
        ActivityDefinition other = (ActivityDefinition)obj;
        if (other.getUUID() == null) {
            return this.uuid == null;
        }
        return other.getUUID().equals(this.uuid);
    }

    @Override
    public IncomingEventDefinition getIncomingEvent() {
        return this.incomingEvent;
    }

    @Override
    public String getTimerCondition() {
        return this.timerCondition;
    }

    @Override
    public boolean isTimer() {
        return ActivityDefinition.Type.Timer.equals((Object)this.getType());
    }

    @Override
    public boolean isSendEvents() {
        return ActivityDefinition.Type.SendEvents.equals((Object)this.getType());
    }

    @Override
    public boolean isReceiveEvent() {
        return ActivityDefinition.Type.ReceiveEvent.equals((Object)this.getType());
    }

    @Override
    public boolean isThrowingErrorEvent() {
        return ActivityDefinition.Type.ErrorEvent.equals((Object)this.getType()) && this.getOutgoingTransitions().isEmpty();
    }

    @Override
    public boolean isSignalEvent() {
        return ActivityDefinition.Type.SignalEvent.equals((Object)this.getType());
    }

    @Override
    public boolean isThrowingSignalEvent() {
        return this.isSignalEvent() && !this.catchEvent;
    }

    @Override
    public boolean isCatchingSignalEvent() {
        return this.isSignalEvent() && this.catchEvent;
    }

    @Override
    public boolean isCatchingErrorEvent() {
        return ActivityDefinition.Type.ErrorEvent.equals((Object)this.getType()) && this.getIncomingTransitions().isEmpty();
    }

    @Override
    public Set<OutgoingEventDefinition> getOutgoingEvents() {
        if (this.outgoingEvents == null) {
            return Collections.emptySet();
        }
        return this.outgoingEvents;
    }

    public void addOutgoingEvent(OutgoingEventDefinition oged) {
        if (this.outgoingEvents == null) {
            this.outgoingEvents = new HashSet<OutgoingEventDefinition>();
        }
        this.outgoingEvents.add(oged);
    }

    @Override
    public boolean evaluateLoopConditionBeforeExecution() {
        return this.beforeExecution;
    }

    @Override
    public String getLoopCondition() {
        return this.loopCondition;
    }

    @Override
    public String getLoopMaximum() {
        return this.loopMaximum;
    }

    @Override
    public boolean isInALoop() {
        return this.loop;
    }

    public void setLoop(String condition, boolean beforeExecution, String loopMaximum) {
        this.loop = true;
        this.loopCondition = condition;
        this.beforeExecution = beforeExecution;
        this.loopMaximum = loopMaximum;
    }

    public void setDynamicDescription(String dynamicDescription) {
        this.dynamicDescription = dynamicDescription;
    }

    public void setDynamicLabel(String dynamicLabel) {
        this.dynamicLabel = dynamicLabel;
    }

    public void setDynamicExecutionSummary(String expression) {
        this.executionSummary = expression;
    }

    public void addBoundaryEvent(BoundaryEvent event) {
        if (this.boundaryEvents == null) {
            this.boundaryEvents = new HashMap<String, BoundaryEvent>();
        }
        this.boundaryEvents.put(event.getName(), event);
    }

    public void addExceptionTransition(String eventName, TransitionDefinition transition) {
        BoundaryEventImpl event;
        if (this.boundaryEvents != null && (event = (BoundaryEventImpl)this.boundaryEvents.get(eventName)) != null) {
            event.setExceptionTransition(transition);
            this.boundaryEvents.put(eventName, event);
        }
    }

    @Override
    public BoundaryEvent getBoundaryEvent(String eventName) {
        if (this.boundaryEvents == null) {
            return null;
        }
        return this.boundaryEvents.get(eventName);
    }

    @Override
    public List<BoundaryEvent> getBoundaryEvents() {
        ArrayList<BoundaryEvent> events = new ArrayList<BoundaryEvent>();
        if (this.boundaryEvents != null) {
            events.addAll(this.boundaryEvents.values());
        }
        return events;
    }

    @Override
    public boolean hasBoundaryEvents() {
        return this.getBoundaryEvents().size() > 0;
    }

    @Override
    public boolean catchEvent() {
        return this.catchEvent;
    }

    public void setCatchEvent(boolean catchEvent) {
        this.catchEvent = catchEvent;
    }

    @Override
    public boolean isTerminateProcess() {
        return this.terminateProcess;
    }

    public void setTerminateProcess(boolean terminateProcess) {
        this.terminateProcess = terminateProcess;
    }
}

