/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.exception;

import org.ow2.bonita.facade.exception.BonitaInternalException;
import org.ow2.bonita.facade.uuid.ParticipantDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.util.BonitaException;
import org.ow2.bonita.util.ExceptionManager;

public class ParticipantNotFoundException
extends BonitaException {
    private static final long serialVersionUID = -3384942707469224537L;
    private final String participantId;
    private final ProcessDefinitionUUID processUUID;
    private final ParticipantDefinitionUUID participantUUID;

    public ParticipantNotFoundException(String id, String participantId, ProcessDefinitionUUID processDefinitionUUID) {
        super(ExceptionManager.getInstance().getIdMessage(id) + ExceptionManager.getInstance().getMessage("PartNFE1", participantId, processDefinitionUUID));
        this.participantId = participantId;
        this.processUUID = processDefinitionUUID;
        this.participantUUID = null;
    }

    public ParticipantNotFoundException(String id, ParticipantDefinitionUUID participantDefinitionUUID) {
        super(ExceptionManager.getInstance().getIdMessage(id) + ExceptionManager.getInstance().getMessage("PartNFE2", participantDefinitionUUID));
        this.participantUUID = participantDefinitionUUID;
        this.participantId = null;
        this.processUUID = null;
    }

    public ParticipantNotFoundException(ParticipantNotFoundException e) {
        super(e.getMessage());
        this.participantId = e.getParticipantId();
        this.processUUID = e.getProcessUUID();
        this.participantUUID = e.getParticipantUUID();
    }

    public static ParticipantNotFoundException build(String id, Throwable e) {
        if (!(e instanceof ParticipantNotFoundException)) {
            ExceptionManager manager = ExceptionManager.getInstance();
            String message = manager.getIdMessage(id) + manager.getMessage("PartNFE3", new Object[0]);
            throw new BonitaInternalException(message, e);
        }
        return new ParticipantNotFoundException((ParticipantNotFoundException)e);
    }

    public String getParticipantId() {
        return this.participantId;
    }

    public ProcessDefinitionUUID getProcessUUID() {
        return this.processUUID;
    }

    public ParticipantDefinitionUUID getParticipantUUID() {
        return this.participantUUID;
    }
}

