/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.CommandAPI;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.util.Command;
import org.ow2.bonita.util.EnvTool;

public class CommandAPIImpl
implements CommandAPI {
    private static final Logger LOG = Logger.getLogger(CommandAPIImpl.class.getName());

    protected CommandAPIImpl(String queryList) {
    }

    @Override
    public <T> T execute(Command<T> command) throws Exception {
        return this.executeCommand(command, null);
    }

    @Override
    public <T> T execute(Command<T> command, ProcessDefinitionUUID processUUID) throws Exception {
        return this.executeCommand(command, processUUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T executeCommand(Command<T> command, ProcessDefinitionUUID processUUID) throws Exception {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Executing command: " + command + ". ProcessUUID: " + processUUID);
        }
        ClassLoader classLoader = null;
        if (processUUID != null) {
            classLoader = EnvTool.getClassDataLoader().getProcessClassLoader(processUUID);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Executing a command. processUUID is not null, processClassLoader found: " + classLoader);
            }
        }
        if (classLoader == null) {
            classLoader = EnvTool.getClassDataLoader().getCommonClassLoader();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Executing a command. commonClassLoader found: " + classLoader);
            }
        }
        if (classLoader == null) {
            classLoader = contextClassLoader;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Executing a command. commonClassLoader not found, taking the contextClassLoader: " + classLoader);
            }
        }
        try {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Executing a command. Setting current classloader to: " + classLoader);
            }
            Thread.currentThread().setContextClassLoader(classLoader);
            T t = command.execute(Environment.getCurrent());
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }
}

