/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ow2.bonita.deployment.Deployer;
import org.ow2.bonita.deployment.DeploymentRuntimeException;
import org.ow2.bonita.facade.ManagementAPI;
import org.ow2.bonita.facade.def.InternalProcessDefinition;
import org.ow2.bonita.facade.def.element.BusinessArchive;
import org.ow2.bonita.facade.def.majorElement.ProcessDefinition;
import org.ow2.bonita.facade.exception.DeploymentException;
import org.ow2.bonita.facade.exception.InstanceNotFoundException;
import org.ow2.bonita.facade.exception.PrivilegeNotFoundException;
import org.ow2.bonita.facade.exception.ProcessNotFoundException;
import org.ow2.bonita.facade.exception.RuleAlreadyExistsException;
import org.ow2.bonita.facade.exception.RuleNotFoundException;
import org.ow2.bonita.facade.exception.UndeletableInstanceException;
import org.ow2.bonita.facade.exception.UndeletableProcessException;
import org.ow2.bonita.facade.exception.UserNotFoundException;
import org.ow2.bonita.facade.identity.Group;
import org.ow2.bonita.facade.identity.impl.GroupImpl;
import org.ow2.bonita.facade.identity.impl.MembershipImpl;
import org.ow2.bonita.facade.identity.impl.RoleImpl;
import org.ow2.bonita.facade.identity.impl.UserImpl;
import org.ow2.bonita.facade.impl.FacadeUtil;
import org.ow2.bonita.facade.impl.RuntimeAPIImpl;
import org.ow2.bonita.facade.privilege.PrivilegePolicy;
import org.ow2.bonita.facade.privilege.Rule;
import org.ow2.bonita.facade.privilege.RuleTypePolicy;
import org.ow2.bonita.facade.privilege.impl.ActivityRuleImpl;
import org.ow2.bonita.facade.privilege.impl.CategoryRuleImpl;
import org.ow2.bonita.facade.privilege.impl.CustomRuleImpl;
import org.ow2.bonita.facade.privilege.impl.ProcessRuleImpl;
import org.ow2.bonita.facade.privilege.impl.RuleImpl;
import org.ow2.bonita.facade.privilege.impl.RuleTypePolicyImpl;
import org.ow2.bonita.facade.privilege.impl.SimpleRuleImpl;
import org.ow2.bonita.facade.runtime.InstanceState;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.facade.uuid.AbstractUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.runtime.event.Master;
import org.ow2.bonita.services.Archiver;
import org.ow2.bonita.services.AuthenticationService;
import org.ow2.bonita.services.IdentityService;
import org.ow2.bonita.services.Journal;
import org.ow2.bonita.services.LargeDataRepository;
import org.ow2.bonita.services.PrivilegeService;
import org.ow2.bonita.services.Querier;
import org.ow2.bonita.services.Recorder;
import org.ow2.bonita.util.BonitaException;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.Misc;

public class ManagementAPIImpl
implements ManagementAPI {
    private static final String DEFAULT_USERS_CREATED = "DEFAULT_USERS_CREATED";
    private static final String MASTER_CREATED = "MASTER_CREATED";
    private final String queryList;

    protected ManagementAPIImpl(String queryList) {
        this.queryList = queryList;
    }

    private String getQueryList() {
        return this.queryList;
    }

    @Override
    public ProcessDefinition deploy(BusinessArchive businessArchive) throws DeploymentException {
        FacadeUtil.checkArgsNotNull(businessArchive);
        try {
            return Deployer.deploy(businessArchive);
        }
        catch (Exception e) {
            throw new DeploymentException(e.getMessage(), e);
        }
    }

    @Override
    public void deployJar(String jarName, byte[] jar) throws DeploymentException {
        FacadeUtil.checkArgsNotNull(jarName, jar);
        if (!jarName.endsWith(".jar")) {
            throw new DeploymentException("Invalid jar name: " + jarName + ". A jar file name must ends with .jar extension.");
        }
        LargeDataRepository ldr = EnvTool.getLargeDataRepository();
        if (ldr.getData(byte[].class, Misc.getGlobalClassDataCategories(), jarName) != null) {
            throw new DeploymentException("A jar with name: " + jarName + " already exists in repository.");
        }
        ldr.storeData(Misc.getGlobalClassDataCategories(), jarName, (Serializable)jar, true);
        EnvTool.getClassDataLoader().resetCommonClassloader();
    }

    @Override
    public void removeJar(String jarName) throws DeploymentException {
        FacadeUtil.checkArgsNotNull(jarName);
        if (!jarName.endsWith(".jar")) {
            throw new DeploymentException("Invalid jar name: " + jarName + ". A jar file name must ends with .jar extension.");
        }
        LargeDataRepository ldr = EnvTool.getLargeDataRepository();
        boolean found = ldr.deleteData(Misc.getGlobalClassDataCategories(), jarName);
        if (!found) {
            String message = ExceptionManager.getInstance().getFullMessage("bai_MAPII_6", new Object[0]);
            throw new DeploymentException(message, jarName);
        }
        EnvTool.getClassDataLoader().resetCommonClassloader();
    }

    @Override
    public Set<String> getAvailableJars() {
        LargeDataRepository ldr = EnvTool.getLargeDataRepository();
        return ldr.getKeys(Misc.getGlobalClassDataCategories());
    }

    @Override
    public void delete(Collection<ProcessDefinitionUUID> processUUIDs) throws ProcessNotFoundException, UndeletableProcessException, UndeletableInstanceException {
        FacadeUtil.checkArgsNotNull(processUUIDs);
        for (ProcessDefinitionUUID processUUID : processUUIDs) {
            this.deleteProcess(processUUID);
        }
    }

    @Override
    public void deleteProcess(ProcessDefinitionUUID processUUID) throws ProcessNotFoundException, UndeletableProcessException, UndeletableInstanceException {
        FacadeUtil.checkArgsNotNull(processUUID);
        this.deleteProcess(true, processUUID);
    }

    private void deleteProcess(boolean deleteAll, ProcessDefinitionUUID processUUID) throws ProcessNotFoundException, UndeletableProcessException, UndeletableInstanceException {
        boolean inJournal;
        FacadeUtil.checkArgsNotNull(processUUID);
        boolean access = EnvTool.isRestrictedApplicationAcces();
        if (access) {
            try {
                HashSet<ProcessDefinitionUUID> itemsToRemove = new HashSet<ProcessDefinitionUUID>();
                itemsToRemove.add(processUUID);
                this.removeProcessDefinitionUUIDFromAllRules(itemsToRemove, Rule.RuleType.PROCESS_READ, Rule.RuleType.PROCESS_START);
            }
            catch (Exception e) {
                throw new ProcessNotFoundException("Unknown process", processUUID);
            }
        }
        Querier journal = EnvTool.getJournalQueriers();
        Querier history = EnvTool.getHistoryQueriers();
        InternalProcessDefinition processDef = journal.getProcess(processUUID);
        boolean bl = inJournal = processDef != null;
        if (processDef == null) {
            processDef = history.getProcess(processUUID);
        } else {
            processDef.setState(ProcessDefinition.ProcessState.DISABLED);
        }
        if (processDef == null) {
            throw new ProcessNotFoundException("bai_MAPII_9", processUUID);
        }
        Deployer.removeStartEvents(processDef);
        if (deleteAll) {
            RuntimeAPIImpl runtimeAPI = new RuntimeAPIImpl(this.getQueryList());
            try {
                runtimeAPI.deleteAllProcessInstances(processUUID);
            }
            catch (ProcessNotFoundException e) {
                throw new BonitaRuntimeException(e);
            }
        }
        if (inJournal) {
            Set<InternalProcessInstance> instances = EnvTool.getJournalQueriers().getProcessInstances(processUUID, InstanceState.STARTED);
            if (!instances.isEmpty()) {
                ProcessInstanceUUID instanceUUID = instances.iterator().next().getUUID();
                throw new UndeletableProcessException("bai_MAPII_10", processUUID, instanceUUID);
            }
            this.removeProcessDependencies(processDef);
            Recorder recorder = EnvTool.getRecorder();
            recorder.remove(processDef);
        }
        if (!inJournal) {
            Archiver archiver = EnvTool.getArchiver();
            archiver.remove(processDef);
        }
        EnvTool.getClassDataLoader().removeProcessClassLoader(processDef.getUUID());
        EnvTool.getUUIDService().archiveOrDeleteProcess(processUUID);
        LargeDataRepository ldr = EnvTool.getLargeDataRepository();
        ldr.deleteData(Misc.getBusinessArchiveCategories(processUUID));
        ldr.deleteData(Misc.getAttachmentCategories(processUUID));
    }

    private void removeProcessDefinitionUUIDFromAllRules(Set<ProcessDefinitionUUID> itemsToRemove, Rule.RuleType ... ruleTypes) throws RuleNotFoundException, PrivilegeNotFoundException {
        FacadeUtil.checkArgsNotNull(new Object[]{itemsToRemove, ruleTypes});
        PrivilegeService privilegeService = EnvTool.getPrivilegeService();
        Set<Rule> rules = privilegeService.getRulesByType(ruleTypes);
        for (Rule rule : rules) {
            this.removeExceptionsFromRuleByUUID(rule.getUUID(), itemsToRemove);
        }
    }

    private void removeProcessDependencies(ProcessDefinition processDef) {
        Set<InternalProcessInstance> instances = EnvTool.getJournalQueriers().getProcessInstances(processDef.getUUID(), InstanceState.STARTED);
        if (instances != null && !instances.isEmpty()) {
            String message = ExceptionManager.getInstance().getFullMessage("bd_D_9", new Object[0]);
            throw new DeploymentRuntimeException(message);
        }
        EnvTool.getClassDataLoader().removeProcessClassLoader(processDef.getUUID());
    }

    @Override
    public void deleteAllProcesses() throws UndeletableInstanceException, UndeletableProcessException {
        Querier querier = EnvTool.getAllQueriers();
        Set<Object> processes = new HashSet();
        Set<Object> parentInstances = new HashSet();
        boolean access = EnvTool.isRestrictedApplicationAcces();
        if (access) {
            Set<ProcessDefinitionUUID> readyToRemove;
            String applicationName = EnvTool.getApplicationAccessName();
            if (applicationName != null && !(readyToRemove = FacadeUtil.getAllowedProcessUUIDsFor(applicationName, Rule.RuleType.PROCESS_READ)).isEmpty()) {
                processes = querier.getProcesses(readyToRemove);
                parentInstances = querier.getProcessInstances(readyToRemove);
            }
        } else {
            parentInstances = querier.getParentInstances();
            processes = querier.getProcesses();
        }
        RuntimeAPIImpl runtimeAPI = new RuntimeAPIImpl(this.getQueryList());
        for (InternalProcessInstance internalProcessInstance : parentInstances) {
            try {
                runtimeAPI.deleteProcessInstance(internalProcessInstance.getUUID());
            }
            catch (InstanceNotFoundException e) {
                throw new BonitaRuntimeException("Unable to delete process instance: " + internalProcessInstance.getUUID());
            }
        }
        for (InternalProcessDefinition internalProcessDefinition : processes) {
            try {
                this.deleteProcess(false, internalProcessDefinition.getUUID());
            }
            catch (ProcessNotFoundException e) {
                throw new BonitaRuntimeException("Unable to delete process: " + internalProcessDefinition.getUUID());
            }
        }
    }

    @Override
    public String getLoggedUser() {
        return EnvTool.getUserId();
    }

    @Override
    public void addMetaData(String key, String value) {
        EnvTool.getJournal().storeMetaData(key, value);
    }

    @Override
    public void deleteMetaData(String key) {
        EnvTool.getJournal().deleteMetaData(key);
    }

    @Override
    public String getMetaData(String key) {
        return EnvTool.getJournal().getMetaData(key);
    }

    @Override
    public void archive(ProcessDefinitionUUID processUUID) throws DeploymentException {
        FacadeUtil.checkArgsNotNull(processUUID);
        try {
            Deployer.archiveProcess(processUUID, EnvTool.getUserId());
        }
        catch (DeploymentRuntimeException e) {
            throw new DeploymentException(e.getMessage(), e);
        }
    }

    @Override
    public void archive(Collection<ProcessDefinitionUUID> processUUIDs) throws DeploymentException {
        FacadeUtil.checkArgsNotNull(processUUIDs);
        for (ProcessDefinitionUUID processUUID : processUUIDs) {
            try {
                Deployer.archiveProcess(processUUID, EnvTool.getUserId());
            }
            catch (DeploymentRuntimeException e) {
                throw new DeploymentException(e.getMessage(), e);
            }
        }
    }

    @Override
    public void disable(ProcessDefinitionUUID processUUID) throws DeploymentException {
        FacadeUtil.checkArgsNotNull(processUUID);
        try {
            Deployer.disableProcess(processUUID);
        }
        catch (DeploymentRuntimeException e) {
            throw new DeploymentException(e.getMessage(), e);
        }
    }

    @Override
    public void disable(Collection<ProcessDefinitionUUID> processUUIDs) throws DeploymentException {
        FacadeUtil.checkArgsNotNull(processUUIDs);
        for (ProcessDefinitionUUID processUUID : processUUIDs) {
            try {
                Deployer.disableProcess(processUUID);
            }
            catch (DeploymentRuntimeException e) {
                throw new DeploymentException(e.getMessage(), e, processUUID);
            }
        }
    }

    @Override
    public void enable(ProcessDefinitionUUID processUUID) throws DeploymentException {
        FacadeUtil.checkArgsNotNull(processUUID);
        try {
            Deployer.enableProcess(processUUID);
        }
        catch (DeploymentRuntimeException e) {
            throw new DeploymentException(e.getMessage(), e);
        }
    }

    @Override
    public void enable(Collection<ProcessDefinitionUUID> processUUIDs) throws DeploymentException {
        FacadeUtil.checkArgsNotNull(processUUIDs);
        for (ProcessDefinitionUUID processUUID : processUUIDs) {
            this.enable(processUUID);
        }
    }

    @Override
    public boolean isUserAdmin(String username) throws UserNotFoundException {
        AuthenticationService adminService = EnvTool.getAuthenticationService();
        return adminService.isUserAdmin(username);
    }

    @Override
    public boolean checkUserCredentials(String username, String password) {
        this.initializeDefaultDatabase();
        return this.checkUserCredentials(username, password, false);
    }

    private boolean checkUserCredentials(String username, String password, boolean isPasswordHash) {
        boolean allowed = false;
        AuthenticationService authenticationService = EnvTool.getAuthenticationService();
        allowed = !isPasswordHash ? authenticationService.checkUserCredentials(username, password) : authenticationService.checkUserCredentialsWithPasswordHash(username, password);
        return allowed;
    }

    private void createDefaultUsers() {
        String defaultUsersCreated = EnvTool.getJournal().getMetaData(DEFAULT_USERS_CREATED);
        if (defaultUsersCreated == null) {
            IdentityService identityService = EnvTool.getIdentityService();
            RoleImpl memberRole = this.createDefaultRole(identityService, "user", "User", "The user role");
            RoleImpl adminRole = this.createDefaultRole(identityService, "admin", "Admin", "The admin role");
            GroupImpl defaultGroup = this.createDefaultGroup(identityService, "platform", "Platform", "The default group", null);
            MembershipImpl memberMembership = this.createDefaultMembership(identityService, defaultGroup, memberRole);
            MembershipImpl adminMembership = this.createDefaultMembership(identityService, defaultGroup, adminRole);
            UserImpl adminUser = this.addDefaultUser(identityService, "admin", null, null, "bpm", null, null);
            identityService.addMembershipToUser(adminUser, adminMembership);
            UserImpl user1 = this.addDefaultUser(identityService, "john", "John", "Doe", "bpm", null, null);
            identityService.addMembershipToUser(user1, memberMembership);
            UserImpl user2 = this.addDefaultUser(identityService, "jack", "Jack", "Doe", "bpm", user1.getUUID(), user1.getUUID());
            identityService.addMembershipToUser(user2, memberMembership);
            UserImpl user3 = this.addDefaultUser(identityService, "james", "James", "Doe", "bpm", user1.getUUID(), user2.getUUID());
            identityService.addMembershipToUser(user3, memberMembership);
            EnvTool.getJournal().storeMetaData(DEFAULT_USERS_CREATED, "true");
        }
    }

    private void initializeMaster() {
        String masterCreated = EnvTool.getJournal().getMetaData(MASTER_CREATED);
        if (masterCreated == null) {
            Journal recorder = EnvTool.getJournal();
            Master master = new Master(0L, "unknown");
            recorder.recordNewMaster(master);
            EnvTool.getJournal().storeMetaData(MASTER_CREATED, "true");
        }
    }

    private void initializeDefaultDatabase() {
        this.createDefaultUsers();
        this.initializeMaster();
    }

    @Override
    public boolean checkUserCredentialsWithPasswordHash(String username, String passwordHash) {
        this.initializeDefaultDatabase();
        return this.checkUserCredentials(username, passwordHash, true);
    }

    private MembershipImpl createDefaultMembership(IdentityService identityService, GroupImpl group, RoleImpl role) {
        MembershipImpl membership = identityService.findMembershipByRoleAndGroup(role.getUUID(), group.getUUID());
        if (membership == null) {
            membership = new MembershipImpl();
            membership.setGroup(group);
            membership.setRole(role);
            identityService.addMembership(membership);
        }
        return membership;
    }

    private RoleImpl createDefaultRole(IdentityService identityService, String name, String label, String description) {
        RoleImpl role = identityService.findRoleByName(name);
        if (role == null) {
            role = new RoleImpl(name);
            role.setLabel(label);
            role.setDescription(description);
            identityService.addRole(role);
        }
        return role;
    }

    private GroupImpl createDefaultGroup(IdentityService identityService, String name, String label, String description, Group parentGroup) {
        Set<GroupImpl> groups = identityService.findGroupsByName(name);
        GroupImpl group = null;
        if (groups == null || groups.isEmpty()) {
            group = new GroupImpl(name);
            group.setLabel(label);
            group.setDescription(description);
            group.setParentGroup(parentGroup);
            identityService.addGroup(group);
        } else {
            group = groups.iterator().next();
        }
        return group;
    }

    private UserImpl addDefaultUser(IdentityService identityService, String username, String firstName, String lastName, String password, String manager, String delegee) {
        UserImpl user = identityService.findUserByUsername(username);
        if (user == null) {
            user = new UserImpl(username, password);
            user.setFirstName(firstName);
            user.setLastName(lastName);
            user.setManagerUUID(manager);
            user.setDelegeeUUID(delegee);
            identityService.addUser(user);
        }
        return user;
    }

    public void grantAccessAuthorisation(String applicationName, ProcessDefinitionUUID definitionUUID) {
        FacadeUtil.checkArgsNotNull(applicationName, definitionUUID);
        PrivilegeService privilegeService = EnvTool.getPrivilegeService();
        RuleImpl rule = (RuleImpl)privilegeService.findRuleByName(applicationName);
        try {
            HashSet<ProcessDefinitionUUID> processes = new HashSet<ProcessDefinitionUUID>();
            processes.add(definitionUUID);
            if (rule != null) {
                this.addExceptionsToRuleByUUID(rule.getUUID(), processes);
            } else {
                rule = (RuleImpl)this.createRule(applicationName, applicationName, applicationName, Rule.RuleType.PROCESS_READ);
                this.addExceptionsToRuleByUUID(rule.getUUID(), processes);
            }
        }
        catch (BonitaException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void grantAccessAuthorisation(String applicationName, Set<ProcessDefinitionUUID> definitionUUIDs) {
        FacadeUtil.checkArgsNotNull(applicationName, definitionUUIDs);
        for (ProcessDefinitionUUID definitionUUID : definitionUUIDs) {
            this.grantAccessAuthorisation(applicationName, definitionUUID);
        }
    }

    @Override
    public Rule createRule(String name, String label, String description, Rule.RuleType type) throws RuleAlreadyExistsException {
        FacadeUtil.checkArgsNotNull(new Object[]{name, type});
        PrivilegeService privilegeService = EnvTool.getPrivilegeService();
        Rule rule = privilegeService.findRuleByName(name);
        if (rule != null) {
            throw new RuleAlreadyExistsException("bai_MAPII_13", name);
        }
        switch (type) {
            case PROCESS_START: 
            case PROCESS_READ: 
            case PROCESS_ADD_COMMENT: 
            case PROCESS_INSTANTIATION_DETAILS_VIEW: 
            case PROCESS_MANAGE: 
            case PROCESS_PDF_EXPORT: {
                rule = new ProcessRuleImpl(name, label, description, type, null);
                privilegeService.addRule(rule);
                break;
            }
            case ACTIVITY_READ: 
            case ACTIVITY_DETAILS_READ: 
            case ASSIGN_TO_ME_STEP: 
            case ASSIGN_TO_STEP: 
            case UNASSIGN_STEP: 
            case CHANGE_PRIORITY_STEP: 
            case RESUME_STEP: 
            case SUSPEND_STEP: 
            case SKIP_STEP: {
                rule = new ActivityRuleImpl(name, label, description, type, null);
                privilegeService.addRule(rule);
                break;
            }
            case CATEGORY_READ: {
                rule = new CategoryRuleImpl(name, label, description, type, null);
                privilegeService.addRule(rule);
                break;
            }
            case REPORT_MANAGE: 
            case REPORT_VIEW: {
                rule = new CustomRuleImpl(name, label, description, type, null);
                privilegeService.addRule(rule);
                break;
            }
            case LOGOUT: 
            case PASSWORD_UPDATE: 
            case DELEGEE_UPDATE: 
            case PROCESS_INSTALL: 
            case REPORT_INSTALL: {
                rule = new SimpleRuleImpl(name, label, description, type);
                privilegeService.addRule(rule);
                break;
            }
            default: {
                throw new IllegalArgumentException("ManagementAPI.createRule(): RuleType not yet supported: " + type.name());
            }
        }
        return rule;
    }

    private List<Rule> buildRulesResultList(List<Rule> rules) {
        ArrayList<Rule> rulesResult = new ArrayList<Rule>();
        for (Rule rule : rules) {
            rulesResult.add(RuleImpl.createRule(rule));
        }
        return rulesResult;
    }

    @Override
    public List<Rule> getRules(Rule.RuleType ruleType, int fromIndex, int pageSige) {
        PrivilegeService privilegeService = EnvTool.getPrivilegeService();
        List<Rule> rules = privilegeService.getRules(ruleType, fromIndex, pageSige);
        if (rules == null || rules.isEmpty()) {
            return Collections.emptyList();
        }
        return this.buildRulesResultList(rules);
    }

    @Override
    public long getNumberOfRules(Rule.RuleType ruleType) {
        PrivilegeService privilegeService = EnvTool.getPrivilegeService();
        return privilegeService.getNumberOfRules(ruleType);
    }

    @Override
    public PrivilegePolicy getRuleTypePolicy(Rule.RuleType ruleType) {
        PrivilegeService privilegeService = EnvTool.getPrivilegeService();
        RuleTypePolicy ruleTypePolicy = privilegeService.getRuleTypePolicy(ruleType);
        return ruleTypePolicy.getPolicy();
    }

    @Override
    public void setRuleTypePolicy(Rule.RuleType ruleType, PrivilegePolicy newPolicy) {
        PrivilegeService privilegeService = EnvTool.getPrivilegeService();
        RuleTypePolicyImpl ruleTypePolicy = (RuleTypePolicyImpl)privilegeService.getRuleTypePolicy(ruleType);
        if (newPolicy != ruleTypePolicy.getPolicy()) {
            ruleTypePolicy.setPolicy(newPolicy);
            privilegeService.updateRuleTypePolicy(ruleTypePolicy);
        }
    }

    @Override
    public <E extends AbstractUUID> void addExceptionsToRuleByUUID(String ruleUUID, Set<E> exceptions) throws RuleNotFoundException {
        FacadeUtil.checkArgsNotNull(ruleUUID, exceptions);
        if (exceptions.size() > 0) {
            PrivilegeService privilegeService = EnvTool.getPrivilegeService();
            RuleImpl rule = (RuleImpl)privilegeService.getRule(ruleUUID);
            if (rule == null) {
                throw new RuleNotFoundException("bai_MAPII_12", ruleUUID);
            }
            if (rule instanceof ProcessRuleImpl) {
                ((ProcessRuleImpl)rule).addProcesses(exceptions);
            } else if (rule instanceof CategoryRuleImpl) {
                ((CategoryRuleImpl)rule).addCategories(exceptions);
            } else if (rule instanceof CustomRuleImpl) {
                ((CustomRuleImpl)rule).addCustomExceptions(exceptions);
            } else if (rule instanceof ActivityRuleImpl) {
                ((ActivityRuleImpl)rule).addActivities(exceptions);
            } else {
                throw new IllegalArgumentException("Un-managed rule type: " + (Object)((Object)rule.getType()));
            }
            privilegeService.updateRule(rule);
        }
    }

    @Override
    public void applyRuleToEntities(String ruleUUID, Collection<String> userUUIDs, Collection<String> roleUUIDs, Collection<String> groupUUIDs, Collection<String> membershipUUIDs, Collection<String> entityIDs) throws RuleNotFoundException {
        FacadeUtil.checkArgsNotNull(ruleUUID);
        PrivilegeService privilegeService = EnvTool.getPrivilegeService();
        Rule rule = privilegeService.getRule(ruleUUID);
        if (rule == null) {
            throw new RuleNotFoundException("bai_MAPII_12", ruleUUID);
        }
        if (userUUIDs != null) {
            ((RuleImpl)rule).addUsers(userUUIDs);
        }
        if (groupUUIDs != null) {
            ((RuleImpl)rule).addGroups(groupUUIDs);
        }
        if (roleUUIDs != null) {
            ((RuleImpl)rule).addRoles(roleUUIDs);
        }
        if (membershipUUIDs != null) {
            ((RuleImpl)rule).addMemberships(membershipUUIDs);
        }
        if (entityIDs != null) {
            ((RuleImpl)rule).addEntities(entityIDs);
        }
        privilegeService.updateRule(rule);
    }

    @Override
    public void deleteRuleByUUID(String ruleUUID) throws RuleNotFoundException {
        FacadeUtil.checkArgsNotNull(ruleUUID);
        PrivilegeService privilegeService = EnvTool.getPrivilegeService();
        Rule rule = privilegeService.getRule(ruleUUID);
        if (rule == null) {
            throw new RuleNotFoundException("bai_MAPII_12", ruleUUID);
        }
        privilegeService.deleteRule(rule);
    }

    @Override
    public List<Rule> getAllApplicableRules(String userUUID, Collection<String> roleUUIDs, Collection<String> groupUUIDs, Collection<String> membershipUUIDs, String entityID) {
        PrivilegeService privilegeService = EnvTool.getPrivilegeService();
        List<Rule> rules = privilegeService.getAllApplicableRules(userUUID, roleUUIDs, groupUUIDs, membershipUUIDs, entityID);
        return this.buildRulesResultList(rules);
    }

    @Override
    public List<Rule> getApplicableRules(Rule.RuleType ruleType, String userUUID, Collection<String> roleUUIDs, Collection<String> groupUUIDs, Collection<String> membershipUUIDs, String entityID) {
        FacadeUtil.checkArgsNotNull(new Object[]{ruleType});
        PrivilegeService privilegeService = EnvTool.getPrivilegeService();
        List<Rule> rules = privilegeService.getApplicableRules(ruleType, userUUID, roleUUIDs, groupUUIDs, membershipUUIDs, entityID);
        return this.buildRulesResultList(rules);
    }

    @Override
    public List<Rule> getAllRules() {
        PrivilegeService privilegeService = EnvTool.getPrivilegeService();
        List<Rule> rules = privilegeService.getAllRules();
        if (rules == null || rules.isEmpty()) {
            return Collections.emptyList();
        }
        return this.buildRulesResultList(rules);
    }

    @Override
    public Rule getRuleByUUID(String ruleUUID) throws RuleNotFoundException {
        FacadeUtil.checkArgsNotNull(ruleUUID);
        PrivilegeService privilegeService = EnvTool.getPrivilegeService();
        Rule rule = privilegeService.getRule(ruleUUID);
        if (rule == null) {
            throw new RuleNotFoundException("bai_MAPII_12", ruleUUID);
        }
        return RuleImpl.createRule(rule);
    }

    @Override
    public List<Rule> getRulesByUUIDs(Collection<String> ruleUUIDs) throws RuleNotFoundException {
        PrivilegeService privilegeService = EnvTool.getPrivilegeService();
        if (ruleUUIDs.size() > 0) {
            List<Rule> rules = privilegeService.getRules(ruleUUIDs);
            if (ruleUUIDs.size() != rules.size()) {
                HashSet<String> storedRuleUUID = new HashSet<String>();
                for (Rule rule : rules) {
                    storedRuleUUID.add(rule.getUUID());
                }
                for (String ruleUUID : ruleUUIDs) {
                    if (storedRuleUUID.contains(ruleUUID)) continue;
                    throw new RuleNotFoundException("bai_MAPII_12", ruleUUID);
                }
            }
            return this.buildRulesResultList(rules);
        }
        return Collections.emptyList();
    }

    @Override
    public <E extends AbstractUUID> void removeExceptionsFromRuleByUUID(String ruleUUID, Set<E> exceptions) throws RuleNotFoundException {
        FacadeUtil.checkArgsNotNull(ruleUUID, exceptions);
        if (exceptions.size() > 0) {
            PrivilegeService privilegeService = EnvTool.getPrivilegeService();
            RuleImpl rule = (RuleImpl)privilegeService.getRule(ruleUUID);
            if (rule == null) {
                throw new RuleNotFoundException("bai_MAPII_12", ruleUUID);
            }
            if (rule instanceof ProcessRuleImpl) {
                ((ProcessRuleImpl)rule).removeProcesses(exceptions);
            } else if (rule instanceof CategoryRuleImpl) {
                ((CategoryRuleImpl)rule).removeCategories(exceptions);
            } else if (rule instanceof CustomRuleImpl) {
                ((CustomRuleImpl)rule).removeCustomExceptions(exceptions);
            } else if (rule instanceof ActivityRuleImpl) {
                ((ActivityRuleImpl)rule).removeActivities(exceptions);
            } else {
                throw new IllegalArgumentException("Un-managed rule type: " + (Object)((Object)rule.getType()));
            }
            privilegeService.updateRule(rule);
        }
    }

    @Override
    public void removeRuleFromEntities(String ruleUUID, Collection<String> userUUIDs, Collection<String> roleUUIDs, Collection<String> groupUUIDs, Collection<String> membershipUUIDs, Collection<String> entityIDs) throws RuleNotFoundException {
        FacadeUtil.checkArgsNotNull(ruleUUID);
        PrivilegeService privilegeService = EnvTool.getPrivilegeService();
        Rule rule = privilegeService.getRule(ruleUUID);
        if (rule == null) {
            throw new RuleNotFoundException("bai_MAPII_12", ruleUUID);
        }
        if (userUUIDs != null) {
            ((RuleImpl)rule).removeUsers(userUUIDs);
        }
        if (groupUUIDs != null) {
            ((RuleImpl)rule).removeGroups(groupUUIDs);
        }
        if (roleUUIDs != null) {
            ((RuleImpl)rule).removeRoles(roleUUIDs);
        }
        if (membershipUUIDs != null) {
            ((RuleImpl)rule).removeMemberships(membershipUUIDs);
        }
        if (entityIDs != null) {
            ((RuleImpl)rule).removeEntities(entityIDs);
        }
        privilegeService.updateRule(rule);
    }

    @Override
    public Rule updateRuleByUUID(String ruleUUID, String name, String label, String description) throws RuleNotFoundException, RuleAlreadyExistsException {
        FacadeUtil.checkArgsNotNull(ruleUUID);
        PrivilegeService privilegeService = EnvTool.getPrivilegeService();
        RuleImpl rule = (RuleImpl)privilegeService.getRule(ruleUUID);
        if (rule == null) {
            throw new RuleNotFoundException("bai_MAPII_12", ruleUUID);
        }
        Rule ruleWithSameName = privilegeService.findRuleByName(name);
        if (ruleWithSameName != null && !ruleWithSameName.getUUID().equals(ruleUUID)) {
            throw new RuleAlreadyExistsException("bai_MAPII_13", name);
        }
        rule.setName(name);
        rule.setLabel(label);
        rule.setDescription(description);
        privilegeService.updateRule(rule);
        return RuleImpl.createRule(rule);
    }

    @Override
    public void updateMigrationDate(ProcessDefinitionUUID processUUID, Date migrationDate) throws ProcessNotFoundException {
        Misc.checkArgsNotNull(processUUID);
        InternalProcessDefinition process = EnvTool.getAllQueriers().getProcess(processUUID);
        if (process == null) {
            throw new ProcessNotFoundException("bai_QDAPII_5", processUUID);
        }
        process.setMigrationDate(migrationDate);
    }

    @Override
    public void setResource(ProcessDefinitionUUID processUUID, String resourcePath, byte[] content) throws ProcessNotFoundException {
        Misc.checkArgsNotNull(processUUID, resourcePath, content);
        InternalProcessDefinition process = EnvTool.getAllQueriers(this.getQueryList()).getProcess(processUUID);
        if (process == null) {
            throw new ProcessNotFoundException("bai_QDAPII_5", processUUID);
        }
        LargeDataRepository ldr = EnvTool.getLargeDataRepository();
        ldr.storeData(Misc.getBusinessArchiveCategories(processUUID), resourcePath, (Serializable)content, true);
        EnvTool.getClassDataLoader().removeProcessClassLoader(processUUID);
    }
}

