/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.impl;

import java.rmi.RemoteException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ow2.bonita.facade.BAMAPI;
import org.ow2.bonita.facade.def.majorElement.ActivityDefinition;
import org.ow2.bonita.facade.exception.MonitoringException;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.internal.RemoteBAMAPI;
import org.ow2.bonita.facade.uuid.ActivityDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.identity.auth.DomainOwner;
import org.ow2.bonita.identity.auth.PasswordOwner;
import org.ow2.bonita.identity.auth.RESTUserOwner;
import org.ow2.bonita.identity.auth.UserOwner;

public class RemoteBAMAPIImpl
implements RemoteBAMAPI {
    protected Map<String, BAMAPI> apis = new HashMap<String, BAMAPI>();

    protected BAMAPI getAPI(Map<String, String> options) {
        if (options == null) {
            throw new IllegalArgumentException("The options are null or not well set.");
        }
        String queryList = options.get("queryList");
        String user = options.get("user");
        String domain = options.get("domain");
        UserOwner.setUser(user);
        DomainOwner.setDomain(domain);
        String restUser = options.get("restUser");
        if (restUser != null) {
            RESTUserOwner.setUser(restUser);
            String restPswd = options.get("passwordHash");
            PasswordOwner.setPassword(restPswd);
        }
        if (!this.apis.containsKey(queryList)) {
            this.apis.put(queryList, new StandardAPIAccessorImpl().getBAMAPI(queryList));
        }
        return this.apis.get(queryList);
    }

    @Override
    public List<Integer> getNumberOfExecutingCasesPerDay(Date since, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfExecutingCasesPerDay(since);
    }

    @Override
    public List<Integer> getNumberOfFinishedCasesPerDay(Date since, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfFinishedCasesPerDay(since);
    }

    @Override
    public int getNumberOfOpenSteps(Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfOpenSteps();
    }

    @Override
    public List<Integer> getNumberOfOpenStepsPerDay(Date since, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfOpenStepsPerDay(since);
    }

    @Override
    public int getNumberOfOverdueSteps(Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfOverdueSteps();
    }

    @Override
    public int getNumberOfStepsAtRisk(int remainingDays, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfStepsAtRisk(remainingDays);
    }

    @Override
    public int getNumberOfUserOpenSteps(Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfUserOpenSteps();
    }

    @Override
    public int getNumberOfUserOverdueSteps(Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfUserOverdueSteps();
    }

    @Override
    public int getNumberOfUserStepsAtRisk(int remainingDays, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfUserStepsAtRisk(remainingDays);
    }

    @Override
    public int getNumberOfFinishedSteps(int priority, Date since, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfFinishedSteps(priority, since);
    }

    @Override
    public int getNumberOfOpenSteps(int priority, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfOpenSteps(priority);
    }

    @Override
    public int getNumberOfUserFinishedSteps(int priority, Date since, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfUserFinishedSteps(priority, since);
    }

    @Override
    public int getNumberOfUserOpenSteps(int priority, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfUserOpenSteps(priority);
    }

    @Override
    public List<Long> getActivityInstancesExecutionTime(Date since, Date until, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getActivityInstancesExecutionTime(since, until);
    }

    @Override
    public List<Long> getActivityInstancesExecutionTime(ProcessDefinitionUUID processUUID, Date since, Date until, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getActivityInstancesExecutionTime(processUUID, since, until);
    }

    @Override
    public List<Long> getActivityInstancesExecutionTime(ActivityDefinitionUUID activityUUID, Date since, Date until, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getActivityInstancesExecutionTime(activityUUID, since, until);
    }

    @Override
    public List<Long> getActivityInstancesExecutionTimeFromActivityUUIDs(Set<ActivityDefinitionUUID> activityUUIDs, Date since, Date until, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getActivityInstancesExecutionTimeFromActivityUUIDs(activityUUIDs, since, until);
    }

    @Override
    public List<Long> getActivityInstancesExecutionTimeFromProcessUUIDs(Set<ProcessDefinitionUUID> processUUIDs, Date since, Date until, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getActivityInstancesExecutionTimeFromProcessUUIDs(processUUIDs, since, until);
    }

    @Override
    public List<Long> getProcessInstancesDuration(Date since, Date until, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getProcessInstancesDuration(since, until);
    }

    @Override
    public List<Long> getProcessInstancesDuration(ProcessDefinitionUUID processUUID, Date since, Date until, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getProcessInstancesDuration(processUUID, since, until);
    }

    @Override
    public List<Long> getProcessInstancesDuration(Set<ProcessDefinitionUUID> processUUIDs, Date since, Date until, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getProcessInstancesDuration(processUUIDs, since, until);
    }

    @Override
    public List<Long> getTaskInstancesWaitingTime(Date since, Date until, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getTaskInstancesWaitingTime(since, until);
    }

    @Override
    public List<Long> getTaskInstancesWaitingTime(ProcessDefinitionUUID processUUID, Date since, Date until, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getTaskInstancesWaitingTime(processUUID, since, until);
    }

    @Override
    public List<Long> getTaskInstancesWaitingTime(ActivityDefinitionUUID taskUUID, Date since, Date until, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getTaskInstancesWaitingTime(taskUUID, since, until);
    }

    @Override
    public List<Long> getTaskInstancesWaitingTimeFromProcessUUIDs(Set<ProcessDefinitionUUID> processUUIDs, Date since, Date until, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getTaskInstancesWaitingTimeFromProcessUUIDs(processUUIDs, since, until);
    }

    @Override
    public List<Long> getTaskInstancesWaitingTimeFromTaskUUIDs(Set<ActivityDefinitionUUID> taskUUIDs, Date since, Date until, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getTaskInstancesWaitingTimeFromTaskUUIDs(taskUUIDs, since, until);
    }

    @Override
    public List<Long> getActivityInstancesDuration(Date since, Date until, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getActivityInstancesDuration(since, until);
    }

    @Override
    public List<Long> getActivityInstancesDuration(ProcessDefinitionUUID processUUID, Date since, Date until, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getActivityInstancesDuration(processUUID, since, until);
    }

    @Override
    public List<Long> getActivityInstancesDuration(ActivityDefinitionUUID activityUUID, Date since, Date until, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getActivityInstancesDuration(activityUUID, since, until);
    }

    @Override
    public List<Long> getActivityInstancesDurationByActivityType(ActivityDefinition.Type activityType, Date since, Date until, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getActivityInstancesDurationByActivityType(activityType, since, until);
    }

    @Override
    public List<Long> getActivityInstancesDurationByActivityType(ActivityDefinition.Type activityType, ProcessDefinitionUUID processUUID, Date since, Date until, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getActivityInstancesDurationByActivityType(activityType, processUUID, since, until);
    }

    @Override
    public List<Long> getActivityInstancesDurationByActivityTypeFromProcessUUIDs(ActivityDefinition.Type activityType, Set<ProcessDefinitionUUID> processUUIDs, Date since, Date until, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getActivityInstancesDurationByActivityTypeFromProcessUUIDs(activityType, processUUIDs, since, until);
    }

    @Override
    public List<Long> getActivityInstancesDurationFromActivityUUIDs(Set<ActivityDefinitionUUID> activityUUIDs, Date since, Date until, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getActivityInstancesDurationFromActivityUUIDs(activityUUIDs, since, until);
    }

    @Override
    public List<Long> getActivityInstancesDurationFromProcessUUIDs(Set<ProcessDefinitionUUID> processUUIDs, Date since, Date until, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getActivityInstancesDurationFromProcessUUIDs(processUUIDs, since, until);
    }

    @Override
    public long getNumberOfCreatedProcessInstances(Date since, Date until, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfCreatedProcessInstances(since, until);
    }

    @Override
    public long getNumberOfCreatedProcessInstances(ProcessDefinitionUUID processUUID, Date since, Date until, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfCreatedProcessInstances(processUUID, since, until);
    }

    @Override
    public List<Long> getTaskInstancesWaitingTimeOfUser(String username, Date since, Date until, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getTaskInstancesWaitingTimeOfUser(username, since, until);
    }

    @Override
    public List<Long> getTaskInstancesWaitingTimeOfUser(String username, ProcessDefinitionUUID processUUID, Date since, Date until, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getTaskInstancesWaitingTimeOfUser(username, processUUID, since, until);
    }

    @Override
    public List<Long> getTaskInstancesWaitingTimeOfUser(String username, ActivityDefinitionUUID taskUUID, Date since, Date until, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getTaskInstancesWaitingTimeOfUser(username, taskUUID, since, until);
    }

    @Override
    public List<Long> getTaskInstancesWaitingTimeOfUserFromProcessUUIDs(String username, Set<ProcessDefinitionUUID> processUUIDs, Date since, Date until, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getTaskInstancesWaitingTimeOfUserFromProcessUUIDs(username, processUUIDs, since, until);
    }

    @Override
    public List<Long> getTaskInstancesWaitingTimeOfUserFromTaskUUIDs(String username, Set<ActivityDefinitionUUID> taskUUIDs, Date since, Date until, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getTaskInstancesWaitingTimeOfUserFromTaskUUIDs(username, taskUUIDs, since, until);
    }

    @Override
    public long getNumberOfCreatedActivityInstances(Date since, Date until, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfCreatedActivityInstances(since, until);
    }

    @Override
    public long getNumberOfCreatedActivityInstances(ProcessDefinitionUUID processUUID, Date since, Date until, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfCreatedActivityInstances(processUUID, since, until);
    }

    @Override
    public long getNumberOfCreatedActivityInstances(ActivityDefinitionUUID activityUUID, Date since, Date until, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfCreatedActivityInstances(activityUUID, since, until);
    }

    @Override
    public long getNumberOfCreatedActivityInstancesByActivityType(ActivityDefinition.Type activityType, Date since, Date until, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfCreatedActivityInstancesByActivityType(activityType, since, until);
    }

    @Override
    public long getNumberOfCreatedActivityInstancesByActivityType(ActivityDefinition.Type activityType, ProcessDefinitionUUID processUUID, Date since, Date until, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfCreatedActivityInstancesByActivityType(activityType, processUUID, since, until);
    }

    @Override
    public long getNumberOfCreatedActivityInstancesByActivityTypeFromProcessUUIDs(ActivityDefinition.Type activityType, Set<ProcessDefinitionUUID> processUUIDs, Date since, Date until, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfCreatedActivityInstancesByActivityTypeFromProcessUUIDs(activityType, processUUIDs, since, until);
    }

    @Override
    public long getNumberOfCreatedActivityInstancesFromActivityUUIDs(Set<ActivityDefinitionUUID> activityUUIDs, Date since, Date until, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfCreatedActivityInstancesFromActivityUUIDs(activityUUIDs, since, until);
    }

    @Override
    public long getNumberOfCreatedActivityInstancesFromProcessUUIDs(Set<ProcessDefinitionUUID> processUUIDs, Date since, Date until, Map<String, String> options) throws RemoteException {
        return this.getAPI(options).getNumberOfCreatedActivityInstancesFromProcessUUIDs(processUUIDs, since, until);
    }

    @Override
    public double getSystemLoadAverage(Map<String, String> options) throws RemoteException, MonitoringException {
        return this.getAPI(options).getSystemLoadAverage();
    }

    @Override
    public long getCurrentMemoryUsage(Map<String, String> options) throws RemoteException, MonitoringException {
        return this.getAPI(options).getCurrentMemoryUsage();
    }

    @Override
    public float getMemoryUsagePercentage(Map<String, String> options) throws RemoteException, MonitoringException {
        return this.getAPI(options).getMemoryUsagePercentage();
    }

    @Override
    public long getUpTime(Map<String, String> options) throws RemoteException, MonitoringException {
        return this.getAPI(options).getUpTime();
    }

    @Override
    public long getStartTime(Map<String, String> options) throws RemoteException, MonitoringException {
        return this.getAPI(options).getStartTime();
    }

    @Override
    public long getTotalThreadsCpuTime(Map<String, String> options) throws RemoteException, MonitoringException {
        return this.getAPI(options).getTotalThreadsCpuTime();
    }

    @Override
    public int getThreadCount(Map<String, String> options) throws RemoteException, MonitoringException {
        return this.getAPI(options).getThreadCount();
    }

    @Override
    public String getOSArch(Map<String, String> options) throws RemoteException, MonitoringException {
        return this.getAPI(options).getOSArch();
    }

    @Override
    public String getOSName(Map<String, String> options) throws RemoteException, MonitoringException {
        return this.getAPI(options).getOSName();
    }

    @Override
    public String getOSVersion(Map<String, String> options) throws RemoteException, MonitoringException {
        return this.getAPI(options).getOSVersion();
    }

    @Override
    public String getJvmName(Map<String, String> options) throws RemoteException, MonitoringException {
        return this.getAPI(options).getJvmName();
    }

    @Override
    public String getJvmVendor(Map<String, String> options) throws RemoteException, MonitoringException {
        return this.getAPI(options).getJvmVendor();
    }

    @Override
    public String getJvmVersion(Map<String, String> options) throws RemoteException, MonitoringException {
        return this.getAPI(options).getJvmVersion();
    }

    @Override
    public int getAvailableProcessors(Map<String, String> options) throws RemoteException, MonitoringException {
        return this.getAPI(options).getAvailableProcessors();
    }

    @Override
    public Map<String, String> getJvmSystemProperties(Map<String, String> options) throws RemoteException, MonitoringException {
        return this.getAPI(options).getJvmSystemProperties();
    }
}

