/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ow2.bonita.connector.core.Connector;
import org.ow2.bonita.connector.core.Mapper;
import org.ow2.bonita.definition.activity.ConnectorExecutor;
import org.ow2.bonita.facade.WebAPI;
import org.ow2.bonita.facade.def.InternalProcessDefinition;
import org.ow2.bonita.facade.exception.CategoryAlreadyExistsException;
import org.ow2.bonita.facade.exception.CategoryNotFoundException;
import org.ow2.bonita.facade.exception.DocumentAlreadyExistsException;
import org.ow2.bonita.facade.exception.DocumentationCreationException;
import org.ow2.bonita.facade.exception.ProcessNotFoundException;
import org.ow2.bonita.facade.impl.FacadeUtil;
import org.ow2.bonita.facade.runtime.ActivityInstance;
import org.ow2.bonita.facade.runtime.Category;
import org.ow2.bonita.facade.runtime.Document;
import org.ow2.bonita.facade.runtime.Label;
import org.ow2.bonita.facade.runtime.WebTemporaryToken;
import org.ow2.bonita.facade.runtime.impl.CaseImpl;
import org.ow2.bonita.facade.runtime.impl.CategoryImpl;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.facade.runtime.impl.LabelImpl;
import org.ow2.bonita.facade.runtime.impl.WebTemporaryTokenImpl;
import org.ow2.bonita.facade.uuid.CategoryUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.light.LightProcessDefinition;
import org.ow2.bonita.light.LightProcessInstance;
import org.ow2.bonita.light.impl.LightProcessDefinitionImpl;
import org.ow2.bonita.light.impl.LightProcessInstanceImpl;
import org.ow2.bonita.services.DocumentationManager;
import org.ow2.bonita.services.WebService;
import org.ow2.bonita.services.WebTokenManagementService;
import org.ow2.bonita.util.DocumentService;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.Misc;

public class WebAPIImpl
implements WebAPI {
    protected WebAPIImpl(String queryList) {
    }

    @Override
    public void deletePhantomCases() {
        Set<ProcessInstanceUUID> webCases = EnvTool.getWebService().getAllCases();
        Set<ProcessInstanceUUID> runtimeCases = EnvTool.getAllQueriers().getParentInstancesUUIDs();
        webCases.removeAll(runtimeCases);
        if (!webCases.isEmpty()) {
            EnvTool.getWebService().deleteCases(webCases);
        }
    }

    @Override
    public void addLabel(String labelName, String ownerName, String editableCSSStyleName, String readonlyCSSStyleName, String previewCSSStyleName, boolean isVisible, boolean hasToBeDisplayed, String iconCSSStyle, Set<ProcessInstanceUUID> caseList, int displayOrder, boolean isSystemLabel) {
        WebService webService = EnvTool.getWebService();
        LabelImpl label = new LabelImpl(labelName, ownerName, editableCSSStyleName, readonlyCSSStyleName, previewCSSStyleName, isVisible, hasToBeDisplayed, iconCSSStyle, displayOrder, isSystemLabel);
        webService.addLabel(label);
        this.addCasesToLabel(ownerName, labelName, caseList);
    }

    @Override
    public void removeLabel(String ownerName, String labelName) {
        EnvTool.getWebService().removeLabel(ownerName, labelName);
    }

    @Override
    public void removeCasesFromLabel(String ownerName, String labelName, Set<ProcessInstanceUUID> caseList) {
        Set<InternalProcessInstance> instances = EnvTool.getAllQueriers().getProcessInstances((Collection<ProcessInstanceUUID>)caseList);
        WebService webService = EnvTool.getWebService();
        for (InternalProcessInstance parentNewOrUpdatedInstance : instances) {
            webService.removeCase(parentNewOrUpdatedInstance.getUUID(), ownerName, labelName);
        }
        EnvTool.getWebService().removeCasesFromLabel(ownerName, labelName, caseList);
    }

    @Override
    public void deleteAllCases() {
        EnvTool.getWebService().deleteAllCases();
    }

    @Override
    public void updateLabelCSS(String ownerName, String labelName, String aEditableCSSStyle, String aPreviewCSSStyle, String aReadOnlyCSSStyle) {
        LabelImpl label = EnvTool.getWebService().getLabel(ownerName, labelName);
        label.setEditableCSSStyleName(aEditableCSSStyle);
        label.setPreviewCSSStyleName(aPreviewCSSStyle);
        label.setReadonlyCSSStyleName(aReadOnlyCSSStyle);
    }

    @Override
    public void addCasesToLabel(String ownerName, String labelName, Set<ProcessInstanceUUID> caseList) {
        Set<InternalProcessInstance> instances = EnvTool.getAllQueriers().getProcessInstances((Collection<ProcessInstanceUUID>)caseList);
        WebService webService = EnvTool.getWebService();
        for (InternalProcessInstance internalProcessInstance : instances) {
            if (webService.getCase(internalProcessInstance.getUUID(), ownerName, labelName) != null) continue;
            webService.addCase(new CaseImpl(internalProcessInstance.getUUID(), ownerName, labelName));
        }
    }

    @Override
    public Label getLabel(String ownerName, String labelName) {
        LabelImpl label = EnvTool.getWebService().getLabel(ownerName, labelName);
        if (label == null) {
            return null;
        }
        return new LabelImpl(label);
    }

    @Override
    public Set<Label> getLabels(String ownerName) {
        Set<LabelImpl> labels = EnvTool.getWebService().getLabels(ownerName);
        return this.getCopy(labels);
    }

    @Override
    public List<Label> getSystemLabels(String ownerName) {
        List<LabelImpl> labels = EnvTool.getWebService().getSystemLabels(ownerName);
        return this.getCopy(labels);
    }

    @Override
    public List<Label> getUserCustomLabels(String ownerName) {
        List<LabelImpl> labels = EnvTool.getWebService().getUserCustomLabels(ownerName);
        return this.getCopy(labels);
    }

    @Override
    public Set<Label> getCaseLabels(String ownerName, ProcessInstanceUUID case_) {
        Set<LabelImpl> labels = EnvTool.getWebService().getCaseLabels(ownerName, case_);
        return this.getCopy(labels);
    }

    @Override
    public Map<ProcessInstanceUUID, Set<Label>> getCasesLabels(String ownerName, Set<ProcessInstanceUUID> cases) {
        if (cases == null || cases.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<ProcessInstanceUUID, Set<Label>> result = new HashMap<ProcessInstanceUUID, Set<Label>>();
        for (ProcessInstanceUUID case_ : cases) {
            result.put(case_, this.getCaseLabels(ownerName, case_));
        }
        return result;
    }

    @Override
    public void removeAllCasesFromLabels(Set<ProcessInstanceUUID> caseList) {
        if (caseList != null && !caseList.isEmpty()) {
            WebService webService = EnvTool.getWebService();
            for (ProcessInstanceUUID case_ : caseList) {
                webService.removeCase(case_);
            }
        }
    }

    @Override
    public Set<ProcessInstanceUUID> getCases(String ownerName, Set<String> labels) {
        if (ownerName != null && labels != null && !labels.isEmpty()) {
            WebService webService = EnvTool.getWebService();
            Set<ProcessInstanceUUID> cases = webService.getCases(ownerName, labels);
            if (cases == null) {
                return Collections.emptySet();
            }
            HashSet<ProcessInstanceUUID> result = new HashSet<ProcessInstanceUUID>();
            for (ProcessInstanceUUID instanceUUID : cases) {
                result.add(new ProcessInstanceUUID(instanceUUID));
            }
            return result;
        }
        return Collections.emptySet();
    }

    @Override
    public List<LightProcessInstance> getLightProcessInstances(String ownerName, Set<String> theLabelsName, int fromIndex, int pageSize) {
        if (ownerName == null || theLabelsName == null || theLabelsName.isEmpty()) {
            return Collections.emptyList();
        }
        List<ProcessInstanceUUID> caseUUIDs = EnvTool.getWebService().getLabelsCaseUUIDs(ownerName, theLabelsName, fromIndex, pageSize);
        Set<InternalProcessInstance> internalList = EnvTool.getAllQueriers().getProcessInstances(caseUUIDs);
        if (internalList == null || internalList.isEmpty()) {
            return Collections.emptyList();
        }
        Comparator<InternalProcessInstance> comparator = new Comparator<InternalProcessInstance>(){

            @Override
            public int compare(InternalProcessInstance o1, InternalProcessInstance o2) {
                return o2.getLastUpdate().compareTo(o1.getLastUpdate());
            }
        };
        ArrayList<InternalProcessInstance> sortedInstances = new ArrayList<InternalProcessInstance>(internalList);
        Collections.sort(sortedInstances, comparator);
        ArrayList<LightProcessInstance> list = new ArrayList<LightProcessInstance>();
        for (InternalProcessInstance internalProcessInstance : sortedInstances) {
            list.add(new LightProcessInstanceImpl(internalProcessInstance));
        }
        return list;
    }

    @Override
    public Set<Label> getLabels(String ownerName, Set<String> labelsName) {
        Set<LabelImpl> labels = EnvTool.getWebService().getLabels(ownerName, labelsName);
        return this.getCopy(labels);
    }

    private Set<Label> getCopy(Set<LabelImpl> labels) {
        if (labels == null || labels.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Label> result = new HashSet<Label>();
        for (LabelImpl label : labels) {
            result.add(new LabelImpl(label));
        }
        return result;
    }

    private List<Label> getCopy(List<LabelImpl> labels) {
        if (labels == null || labels.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Label> result = new ArrayList<Label>();
        for (LabelImpl label : labels) {
            result.add(new LabelImpl(label));
        }
        return result;
    }

    @Override
    public void removeLabels(String ownerName, Collection<String> labelNames) {
        for (String labelName : labelNames) {
            this.removeLabel(ownerName, labelName);
        }
    }

    @Override
    public void updateLabelName(String ownerName, String labelName, String newName) {
        EnvTool.getWebService().updateLabelName(ownerName, labelName, newName);
    }

    @Override
    public void updateLabelVisibility(String ownerName, String labelName, boolean isVisible) {
        LabelImpl label = EnvTool.getWebService().getLabel(ownerName, labelName);
        label.setVisible(isVisible);
    }

    @Override
    public void updateLabelVisibility(String ownerName, Map<String, Boolean> labelvisibilities) {
        for (Map.Entry<String, Boolean> labelVisibility : labelvisibilities.entrySet()) {
            this.updateLabelVisibility(ownerName, labelVisibility.getKey(), labelVisibility.getValue());
        }
    }

    @Override
    public Map<String, Integer> getCasesNumber(String ownerName, Collection<String> labelNames, int limit) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        WebService webService = EnvTool.getWebService();
        for (String label : labelNames) {
            int number = 0;
            if (limit <= 2500) {
                Set<CaseImpl> cases = webService.getCases(ownerName, label, limit + 1);
                number = cases.size();
                if (number > limit) {
                    number = -limit;
                }
            } else {
                number = webService.getCasesNumber(ownerName, label);
            }
            result.put(label, number);
        }
        return result;
    }

    @Override
    public Map<String, Integer> getCasesNumber(String ownerName, Collection<String> labelNames) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        WebService webService = EnvTool.getWebService();
        for (String label : labelNames) {
            int number = webService.getCasesNumber(ownerName, label);
            result.put(label, number);
        }
        return result;
    }

    @Override
    public Map<String, Integer> getCasesNumber(String ownerName, String labelName, Collection<String> labelNames, int limit) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        WebService webService = EnvTool.getWebService();
        for (String label : labelNames) {
            int number = 0;
            if (limit <= 2500) {
                Set<CaseImpl> cases = webService.getCases(ownerName, labelName, label, limit + 1);
                number = cases.size();
                if (number > limit) {
                    number = -limit;
                }
            } else {
                number = webService.getCasesNumber(ownerName, labelName, label);
            }
            result.put(label, number);
        }
        return result;
    }

    @Override
    public String generateTemporaryToken(String identityKey) {
        FacadeUtil.checkArgsNotNull(identityKey);
        if (identityKey.length() == 0) {
            throw new IllegalArgumentException();
        }
        WebTokenManagementService webTokenManagementService = EnvTool.getWebTokenManagementService();
        String tokenKey = Misc.getUniqueId("");
        long expirationDate = new Date().getTime() + 3600000L;
        WebTemporaryTokenImpl temporaryToken = new WebTemporaryTokenImpl(tokenKey, expirationDate, identityKey);
        webTokenManagementService.addTemporaryToken(temporaryToken);
        return temporaryToken.getToken();
    }

    @Override
    public String getIdentityKeyFromTemporaryToken(String token) {
        WebTokenManagementService webTokenManagementService = EnvTool.getWebTokenManagementService();
        WebTemporaryToken temporaryToken = webTokenManagementService.getToken(token);
        if (temporaryToken == null) {
            return null;
        }
        webTokenManagementService.deleteToken((WebTemporaryTokenImpl)temporaryToken);
        Set<WebTemporaryToken> expiredTokens = webTokenManagementService.getExpiredTokens();
        for (WebTemporaryToken expiredToken : expiredTokens) {
            webTokenManagementService.deleteToken((WebTemporaryTokenImpl)expiredToken);
        }
        return temporaryToken.getIdentityKey();
    }

    @Override
    public Set<Category> getAllCategories() {
        Set<Category> categories = EnvTool.getJournalQueriers().getAllCategories();
        HashSet<Category> result = new HashSet<Category>();
        for (Category category : categories) {
            result.add(new CategoryImpl(category));
        }
        return result;
    }

    @Override
    public Set<Category> getCategories(Set<String> names) {
        Set<Category> categories = EnvTool.getJournalQueriers().getCategories(names);
        HashSet<Category> result = new HashSet<Category>();
        for (Category category : categories) {
            result.add(new CategoryImpl(category));
        }
        return result;
    }

    @Override
    public void deleteCategoriesByUUIDs(Set<CategoryUUID> uuids) {
        Set<CategoryImpl> categories = EnvTool.getJournalQueriers().getCategoriesByUUIDs(uuids);
        EnvTool.getWebService().removeCategories(new HashSet<Category>(categories));
    }

    @Override
    public Set<Category> getCategoriesByUUIDs(Set<CategoryUUID> uuids) {
        Set<CategoryImpl> categories = EnvTool.getJournalQueriers().getCategoriesByUUIDs(uuids);
        HashSet<Category> result = new HashSet<Category>();
        for (CategoryImpl category : categories) {
            result.add(new CategoryImpl(category));
        }
        return result;
    }

    @Override
    public void removeAllLabelsExcept(Set<String> labelNames) {
        Set<LabelImpl> labels = EnvTool.getWebService().getLabelsByNameExcept(labelNames);
        for (LabelImpl label : labels) {
            this.removeLabel(label.getOwnerName(), label.getName());
        }
    }

    @Override
    public void removeLabels(Set<String> labelNames) {
        Set<LabelImpl> labels = EnvTool.getWebService().getLabelsByName(labelNames);
        for (LabelImpl label : labels) {
            this.removeLabel(label.getOwnerName(), label.getName());
        }
    }

    @Override
    public void deleteCategories(Set<String> categoryNames) {
        Set<Category> categories = EnvTool.getJournalQueriers().getCategories(categoryNames);
        EnvTool.getWebService().removeCategories(categories);
    }

    @Override
    public void executeConnectorAndSetVariables(String connectorClassName, Map<String, Object[]> parameters, ActivityInstance activityInstance, Map<String, Object> context) throws Exception {
        ProcessDefinitionUUID processDefinitionUUID = activityInstance.getProcessDefinitionUUID();
        Connector connector = (Connector)EnvTool.getClassDataLoader().getInstance(processDefinitionUUID, connectorClassName);
        if (connector instanceof Mapper) {
            throw new IllegalAccessException(connectorClassName + " is a instance of RoleResolver or Filter");
        }
        ConnectorExecutor.executeConnector(connector, parameters, activityInstance.getProcessInstanceUUID(), activityInstance, context);
    }

    @Override
    public Map<String, Object> executeConnectorAndGetVariablesToSet(String connectorClassName, Map<String, Object[]> parameters, ProcessDefinitionUUID processDefinitionUUID, Map<String, Object> context) throws Exception {
        Connector connector = (Connector)EnvTool.getClassDataLoader().getInstance(processDefinitionUUID, connectorClassName);
        if (connector instanceof Mapper) {
            throw new IllegalAccessException(connectorClassName + " is a instance of RoleResolver or Filter");
        }
        return ConnectorExecutor.executeConnector(connector, parameters, processDefinitionUUID, context);
    }

    @Override
    public LightProcessDefinition setProcessCategories(ProcessDefinitionUUID aProcessUUID, Set<String> aCategoriesName) throws ProcessNotFoundException {
        FacadeUtil.checkArgsNotNull(aProcessUUID);
        InternalProcessDefinition internalProcess = EnvTool.getAllQueriers().getProcess(aProcessUUID);
        if (internalProcess == null) {
            throw new ProcessNotFoundException("web_1", aProcessUUID);
        }
        internalProcess.setCategories(aCategoriesName);
        return new LightProcessDefinitionImpl(internalProcess);
    }

    @Override
    public void addCategory(String name, String iconCSSStyle, String previewCSSStyleName, String cssStyleName) throws CategoryAlreadyExistsException {
        FacadeUtil.checkArgsNotNull(name);
        Set<Category> categories = EnvTool.getJournalQueriers().getCategories(Arrays.asList(name));
        if (categories != null && !categories.isEmpty()) {
            throw new CategoryAlreadyExistsException(name);
        }
        CategoryImpl newCategory = new CategoryImpl(name);
        newCategory.setIconCSSStyle(iconCSSStyle);
        newCategory.setPreviewCSSStyleName(previewCSSStyleName);
        newCategory.setReadonlyCSSStyleName(cssStyleName);
        EnvTool.getRecorder().recordNewCategory(newCategory);
    }

    @Override
    public Category updateCategoryByUUID(String uuid, String name, String iconCSSStyle, String previewCSSStyleName, String cssStyleName) throws CategoryNotFoundException, CategoryAlreadyExistsException {
        FacadeUtil.checkArgsNotNull(uuid, name);
        CategoryImpl category = EnvTool.getJournalQueriers().getCategoryByUUID(uuid);
        if (category == null) {
            throw new CategoryNotFoundException(name);
        }
        Set<Category> categories = EnvTool.getJournalQueriers().getCategories(Arrays.asList(name));
        if (categories != null && !categories.isEmpty() && !categories.iterator().next().getUUID().equals(uuid)) {
            throw new CategoryAlreadyExistsException(name);
        }
        category.setIconCSSStyle(iconCSSStyle);
        category.setPreviewCSSStyleName(previewCSSStyleName);
        category.setReadonlyCSSStyleName(cssStyleName);
        category.setName(name);
        return new CategoryImpl(category);
    }

    @Override
    public Set<Category> getAllCategoriesByUUIDExcept(Set<CategoryUUID> uuids) {
        HashSet<String> ids = new HashSet<String>();
        for (CategoryUUID categoryUUID : uuids) {
            ids.add(categoryUUID.getValue());
        }
        Set<Category> categories = EnvTool.getJournalQueriers().getAllCategoriesExcept(ids);
        HashSet<Category> result = new HashSet<Category>();
        for (Category category : categories) {
            result.add(new CategoryImpl(category));
        }
        return result;
    }

    @Override
    public Document addProcessDocumentTemplate(String name, ProcessDefinitionUUID processDefinitionUUID, String fileName, String mimeType, byte[] content) throws ProcessNotFoundException, DocumentAlreadyExistsException, DocumentationCreationException {
        InternalProcessDefinition process = EnvTool.getAllQueriers().getProcess(processDefinitionUUID);
        if (process == null) {
            throw new ProcessNotFoundException("bai_RAPII_29", processDefinitionUUID);
        }
        if (content != null && (fileName == null || mimeType == null)) {
            new DocumentationCreationException("");
        }
        DocumentationManager manager = EnvTool.getDocumentationManager();
        return DocumentService.getClientDocument(manager, manager.createMetaDocument(processDefinitionUUID, name, fileName, mimeType, content));
    }

    @Override
    public List<Document> getProcessDocumentTemplates(ProcessDefinitionUUID processDefinitionUUID) throws ProcessNotFoundException, DocumentationCreationException {
        InternalProcessDefinition process = EnvTool.getAllQueriers().getProcess(processDefinitionUUID);
        if (process == null) {
            throw new ProcessNotFoundException("bai_RAPII_29", processDefinitionUUID);
        }
        DocumentationManager manager = EnvTool.getDocumentationManager();
        return DocumentService.getClientDocuments(manager, manager.getMetaDocuments(processDefinitionUUID));
    }
}

