/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.rest;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Map;
import org.ow2.bonita.facade.exception.BonitaInternalException;
import org.ow2.bonita.facade.interceptor.InterceptorUtil;
import org.ow2.bonita.facade.rest.wrapper.RESTCommand;
import org.ow2.bonita.facade.rest.wrapper.RESTMap;
import org.ow2.bonita.facade.rest.wrapper.RESTObject;
import org.ow2.bonita.util.Command;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.xml.XStreamUtil;

public class RESTClientAPIInterceptor
implements InvocationHandler {
    private final Object api;

    public RESTClientAPIInterceptor(Object api) {
        this.api = api;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            Class<?>[] params = method.getParameterTypes();
            Method m = this.api.getClass().getMethod(method.getName(), params);
            if ((m.getName().equals("setVariable") || m.getName().equals("setProcessInstanceVariable") || m.getName().equals("setActivityInstanceVariable")) && args.length == 3) {
                args[2] = new RESTObject((Serializable)args[2]);
            } else if (m.getName().equals("execute") && (args.length == 1 || args.length == 2)) {
                if (args[0] instanceof Command) {
                    args[0] = this.getRESTCommand((Command)args[0]);
                }
            } else if (m.getName().equals("instantiateProcess") && args.length == 3 && args[1] instanceof Map) {
                XStream xstream = XStreamUtil.getDefaultXstream();
                String xml = xstream.toXML(args[1]);
                args[1] = this.getRESTMAP(xml);
            } else if (m.getName().equals("getModifiedJavaObject") && args.length == 4) {
                args[2] = new RESTObject((Serializable)args[2]);
                args[3] = new RESTObject((Serializable)args[3]);
            }
            return m.invoke(this.api, args);
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                Throwable invocationExceptionCause = e.getCause();
                if (invocationExceptionCause instanceof RemoteException) {
                    RemoteException remoteException = (RemoteException)invocationExceptionCause;
                    Throwable remoteCause = this.getRemoteCause(remoteException);
                    InterceptorUtil.manageInvokeExceptionCause(method, remoteCause);
                } else {
                    throw invocationExceptionCause;
                }
            }
            String message = ExceptionManager.getInstance().getFullMessage("baa_CAPII_1", e);
            throw new BonitaInternalException(message, e);
        }
    }

    private <K, V> RESTMap<K, V> getRESTMAP(String xml) {
        return new RESTMap(xml);
    }

    private <T> RESTCommand<T> getRESTCommand(Command<T> command) {
        RESTCommand<T> retCommand = null;
        try {
            retCommand = new RESTCommand<T>(command);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return retCommand;
    }

    private Throwable getRemoteCause(RemoteException e) {
        Throwable t = e;
        while (t instanceof RemoteException) {
            t = ((Throwable)t).getCause();
        }
        return t;
    }
}

