/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.runtime.command;

import java.util.HashSet;
import java.util.Set;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.WebAPI;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.util.Command;

public class WebDeleteProcessInstancesCommand
implements Command<Void> {
    private static final long serialVersionUID = 1L;
    private final Set<ProcessInstanceUUID> instancesUUIDs;

    public WebDeleteProcessInstancesCommand(Set<ProcessInstanceUUID> instancesUUIDs) {
        this.instancesUUIDs = instancesUUIDs;
    }

    @Override
    public Void execute(Environment environment) throws Exception {
        StandardAPIAccessorImpl accessor = new StandardAPIAccessorImpl();
        if (this.instancesUUIDs != null && !this.instancesUUIDs.isEmpty()) {
            WebAPI webAPI = accessor.getWebAPI();
            HashSet<ProcessInstanceUUID> uuids = new HashSet<ProcessInstanceUUID>();
            HashSet<String> instanceUuidsAsString = new HashSet<String>();
            for (ProcessInstanceUUID uuid : this.instancesUUIDs) {
                uuids.add(uuid);
                instanceUuidsAsString.add(uuid.getValue());
                if (uuids.size() != 100) continue;
                webAPI.removeAllCasesFromLabels(uuids);
                uuids.clear();
                instanceUuidsAsString.clear();
            }
            webAPI.removeAllCasesFromLabels(uuids);
            accessor.getRuntimeAPI().deleteProcessInstances(this.instancesUUIDs);
        }
        return null;
    }
}

