/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.identity.auth;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Destroyable;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.ow2.bonita.facade.ManagementAPI;
import org.ow2.bonita.identity.auth.BonitaPrincipal;
import org.ow2.bonita.identity.auth.DomainOwner;
import org.ow2.bonita.identity.auth.UserOwner;
import org.ow2.bonita.util.AccessorUtil;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.Misc;

public class BonitaIdentityLoginModule
implements LoginModule {
    private static final String NAME_PROMPT = "Name: ";
    private static final String PASSWORD_PROMPT = "Password: ";
    private static final String JAVAX_SECURITY_AUTH_LOGIN_PASSWORD = "javax.security.auth.login.password";
    private static final String JAVAX_SECURITY_AUTH_LOGIN_NAME = "javax.security.auth.login.name";
    public static final String DEBUG_OPTION_NAME = "debug";
    public static final String DOMAIN_OPTION_NAME = "domain";
    private Subject subject = null;
    private CallbackHandler callbackHandler = null;
    private Map<String, Object> sharedState;
    private boolean debug = false;
    private String domain;
    private String id;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        Misc.checkArgsNotNull(subject, callbackHandler, sharedState, options);
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        String debugFlag = (String)options.get(DEBUG_OPTION_NAME);
        if (debugFlag != null) {
            this.debug = Boolean.valueOf(debugFlag);
        }
        this.domain = (String)options.get(DOMAIN_OPTION_NAME);
        if (this.domain == null) {
            this.domain = "default";
        }
    }

    @Override
    public boolean login() throws LoginException {
        if (this.debug) {
            System.err.println("[" + BonitaIdentityLoginModule.class.getName() + "] login() - preparing - step 1");
        }
        try {
            String name = (String)this.sharedState.get(JAVAX_SECURITY_AUTH_LOGIN_NAME);
            String password = (String)this.sharedState.get(JAVAX_SECURITY_AUTH_LOGIN_PASSWORD);
            ArrayList<Callback> callbacks = new ArrayList<Callback>();
            NameCallback nameCallback = new NameCallback(NAME_PROMPT);
            PasswordCallback passwordCallback = new PasswordCallback(PASSWORD_PROMPT, false);
            if (name == null) {
                callbacks.add(nameCallback);
            }
            if (password == null) {
                callbacks.add(passwordCallback);
            }
            if (!callbacks.isEmpty()) {
                if (this.debug) {
                    System.err.println("[" + BonitaIdentityLoginModule.class.getName() + "] login() - callback - step 2");
                }
                this.callbackHandler.handle(callbacks.toArray(new Callback[0]));
                if (name == null) {
                    name = nameCallback.getName();
                }
                if (password == null) {
                    password = new String(passwordCallback.getPassword());
                    passwordCallback.clearPassword();
                }
            }
            if (this.debug) {
                System.err.println("[" + BonitaIdentityLoginModule.class.getName() + "] login() - authenticating - step 3");
            }
            if (name != null) {
                DomainOwner.setDomain(this.domain);
                ManagementAPI managementAPI = AccessorUtil.getManagementAPI();
                if (managementAPI.checkUserCredentials(name, password)) {
                    this.id = name;
                }
                DomainOwner.setDomain(null);
            }
            if (this.debug) {
                System.err.println("[" + BonitaIdentityLoginModule.class.getName() + "] login() - storing data - step 4");
            }
            this.sharedState.put(JAVAX_SECURITY_AUTH_LOGIN_NAME, name);
            this.sharedState.put(JAVAX_SECURITY_AUTH_LOGIN_PASSWORD, password);
            if (this.debug) {
                System.err.println("[" + BonitaIdentityLoginModule.class.getName() + "] login() - returning - step 5");
            }
            if (this.id == null) {
                String message = ExceptionManager.getInstance().getFullMessage("bi_LSLM_1", new Object[0]);
                throw new FailedLoginException(message);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            LoginException le = new LoginException();
            le.initCause(e);
            throw le;
        }
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.id == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bi_PLM_2", new Object[0]);
            throw new FailedLoginException(message);
        }
        Set<Principal> principals = this.subject.getPrincipals();
        principals.add(new BonitaPrincipal(this.id));
        UserOwner.setUser(null);
        DomainOwner.setDomain(null);
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.debug) {
            System.err.println("[" + BonitaIdentityLoginModule.class.getName() + "] abort()");
        }
        if (this.id == null) {
            return false;
        }
        this.subject = null;
        this.id = null;
        UserOwner.setUser(null);
        DomainOwner.setDomain(null);
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.id != null) {
            if (this.debug) {
                System.err.println("[" + BonitaIdentityLoginModule.class.getName() + "] logout() - removing principals");
            }
            HashSet<Principal> principals = new HashSet<Principal>(this.subject.getPrincipals());
            for (Principal p : principals) {
                if (!(p instanceof BonitaPrincipal)) continue;
                if (this.debug) {
                    System.err.println("[" + BonitaIdentityLoginModule.class.getName() + "] logout() - removing principal: " + p);
                }
                this.subject.getPrincipals().remove(p);
            }
            UserOwner.setUser(null);
            DomainOwner.setDomain(null);
            if (this.debug) {
                System.err.println("[" + BonitaIdentityLoginModule.class.getName() + "] logout() - destroying/removing credentials");
            }
            HashSet<Object> credentials = new HashSet<Object>(this.subject.getPublicCredentials());
            for (Object e : credentials) {
                if (e instanceof Destroyable && this.debug) {
                    System.err.println("[" + BonitaIdentityLoginModule.class.getName() + "] logout() - destroying credential: " + e);
                }
                if (this.subject.isReadOnly()) continue;
                if (this.debug) {
                    System.err.println("[" + BonitaIdentityLoginModule.class.getName() + "] logout() - removing credential: " + e);
                }
                this.subject.getPublicCredentials().remove(e);
            }
        }
        return true;
    }
}

