/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.runtime.event;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.runtime.event.EventAddedNotification;
import org.ow2.bonita.runtime.event.EventMatcher;
import org.ow2.bonita.runtime.event.GetDomainCommand;
import org.ow2.bonita.runtime.event.JobExecutor;
import org.ow2.bonita.runtime.event.MasterChecker;
import org.ow2.bonita.runtime.event.NewJobNotification;
import org.ow2.bonita.services.CommandService;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.Misc;
import org.ow2.bonita.util.ReflectUtil;

public class EventExecutor
implements Serializable {
    private static final Logger LOG = Logger.getLogger(EventExecutor.class.getName());
    private static final long serialVersionUID = 1L;
    transient CommandService commandService;
    int nbrOfThreads = 3;
    int idleMillis = 5000;
    int lockMillis = 120000;
    int minimumInterval = 50;
    int retries = 1;
    boolean expressionMatcherEnable = true;
    int matcherMaxCouples = 50;
    String name;
    private transient EventMatcher eventMatcher;
    String jobExecutorClassName;
    String eventMatcherClassName;
    String masterCheckerClassName;
    private transient JobExecutor jobExecutor = null;
    int locksToQuery = 50;
    int lockIdleTime = 5000;
    boolean cleanLocks = false;
    private boolean isActive = false;
    private String domain;
    private MasterChecker masterChecker;
    boolean masterCheckerEnable;
    int masterCheckerMasterHeartbeatDelay;
    int masterCheckerSlaveHeartbeatDelay;
    int masterCheckerMaxIdleDelay;

    public JobExecutor getJobExecutor() {
        return this.jobExecutor;
    }

    public synchronized void start() {
        this.domain = this.commandService.execute(new GetDomainCommand());
        this.name = EventExecutor.class.getSimpleName() + "-" + Misc.getHostName() + "-" + this.domain;
        if (this.isActive) {
            LOG.severe("Cannot start event executor '" + this.name + "' because it is already running...");
            return;
        }
        if (!this.isActive) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("starting event executor threads for event executor '" + this.name + "'...");
            }
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Starting job dispatcher thread for executing events '" + this.name + "'...");
            }
            Class<?> jobExecutorClass = ReflectUtil.loadClass(Thread.currentThread().getContextClassLoader(), this.jobExecutorClassName);
            Constructor<?> jobExecutorConstructor = ReflectUtil.getConstructor(jobExecutorClass, new Class[]{EventExecutor.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE});
            this.jobExecutor = (JobExecutor)ReflectUtil.newInstance(jobExecutorConstructor, new Object[]{this, jobExecutorClass.getSimpleName() + "-" + Misc.getHostName() + "-" + this.domain, this.nbrOfThreads, this.locksToQuery, this.lockIdleTime});
            this.jobExecutor.start();
            Class<?> masterCheckerClass = ReflectUtil.loadClass(Thread.currentThread().getContextClassLoader(), this.masterCheckerClassName);
            Constructor<?> masterCheckerConstructor = ReflectUtil.getConstructor(masterCheckerClass, new Class[]{EventExecutor.class, String.class});
            this.masterChecker = (MasterChecker)ReflectUtil.newInstance(masterCheckerConstructor, new Object[]{this, masterCheckerClass.getSimpleName() + "-" + Misc.getHostName() + "-" + this.domain});
            this.masterChecker.setEnable(this.masterCheckerEnable);
            this.masterChecker.setMasterHeartbeatDelay(this.masterCheckerMasterHeartbeatDelay);
            this.masterChecker.setSlaveHeartbeatDelay(this.masterCheckerSlaveHeartbeatDelay);
            this.masterChecker.setMaxIdleDelay(this.masterCheckerMaxIdleDelay);
            this.masterChecker.start();
            this.isActive = true;
        }
    }

    public synchronized boolean isActive() {
        return this.isActive;
    }

    public synchronized void stop() {
        this.stop(false);
    }

    public synchronized void stop(boolean join) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("stopping event executor");
        }
        if (this.isActive) {
            this.isActive = false;
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Event executor: deactivating job dispatcher thread...");
            }
            this.jobExecutor.deactivate(join);
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Event executor: job dispatcher thread deactivated.");
            }
            if (this.eventMatcher != null) {
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.info("Event executor: deactivating event matcher...");
                }
                this.eventMatcher.deactivate(true);
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.info("Event executor: event matcher deactivated.");
                }
            }
            if (this.masterChecker != null) {
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.info("Event executor: deactivating masterChekcer...");
                }
                this.masterChecker.interrupt();
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.info("Event executor: masterChecker deactivated.");
                }
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("ignoring stop: event executor '" + this.name + "' not started");
        }
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Event executor stopped");
        }
    }

    public int getNbrOfThreads() {
        return this.nbrOfThreads;
    }

    public int getIdleMillis() {
        return this.idleMillis;
    }

    public int getLockMillis() {
        return this.lockMillis;
    }

    public CommandService getCommandService() {
        return this.commandService;
    }

    public int getMinimumInterval() {
        return this.minimumInterval;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setCommandService(CommandService commandService) {
        this.commandService = commandService;
    }

    public void internalJobExecutorRefresh() {
        if (this.jobExecutor != null && this.jobExecutor.isActive()) {
            this.jobExecutor.refresh();
        }
    }

    public void internalEventMatcherRefresh() {
        if (this.eventMatcher != null && this.eventMatcher.isActive()) {
            this.eventMatcher.refresh();
        }
    }

    public void refreshJobExecutor() {
        EnvTool.getTransaction().registerSynchronization(new NewJobNotification(this));
    }

    public void refreshEventMatcher() {
        EnvTool.getTransaction().registerSynchronization(new EventAddedNotification(this));
    }

    public synchronized boolean isJobExecutorActive() {
        return this.isActive && this.jobExecutor != null && this.jobExecutor.isActive();
    }

    public synchronized boolean isMatcherActive() {
        return this.isActive && this.eventMatcher != null && this.eventMatcher.isActive();
    }

    public synchronized boolean isMatchingConditionMatcherActive() {
        return this.isMatcherActive() && this.expressionMatcherEnable;
    }

    public synchronized boolean isMasterCheckerActive() {
        return this.isActive && this.masterChecker != null && this.masterChecker.isActive();
    }

    public synchronized void startMatcher() {
        if (!this.isMatcherActive()) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Starting matcher of message correlation based on correlation keys/no expression '" + this.name + "'...");
            }
            Class<?> eventMatcherClass = ReflectUtil.loadClass(Thread.currentThread().getContextClassLoader(), this.eventMatcherClassName);
            Constructor<?> constructor = ReflectUtil.getConstructor(eventMatcherClass, new Class[]{EventExecutor.class, String.class});
            this.eventMatcher = (EventMatcher)ReflectUtil.newInstance(constructor, new Object[]{this, this.eventMatcherClassName + "-" + Misc.getHostName() + "-" + this.domain});
            this.eventMatcher.setMaxCouples(this.matcherMaxCouples);
            this.eventMatcher.setMatchingConditionMatcher(this.expressionMatcherEnable);
            this.eventMatcher.start();
        }
    }

    public synchronized void startMatchingConditionMatcher() {
        if (this.isMatcherActive()) {
            this.expressionMatcherEnable = true;
            this.eventMatcher.setMatchingConditionMatcher(true);
        }
    }

    public synchronized void stopMatcher() {
        if (this.isMatcherActive()) {
            this.eventMatcher.deactivate(true);
            this.eventMatcher = null;
        }
    }

    public synchronized void stopMatchingConditionMatcher() {
        if (this.isMatchingConditionMatcherActive() && this.isMatcherActive()) {
            this.expressionMatcherEnable = false;
            this.eventMatcher.setMatchingConditionMatcher(false);
        }
    }

    public synchronized void declareMaster() {
        this.startMatcher();
    }

    public synchronized void declareSlave() {
        this.stopMatcher();
    }

    public void setMasterChecker(MasterChecker masterChecker) {
        this.masterChecker = masterChecker;
    }

    static final class EventRejectionHandler
    implements RejectedExecutionHandler {
        static final EventRejectionHandler INSTANCE = new EventRejectionHandler();

        EventRejectionHandler() {
        }

        @Override
        public void rejectedExecution(Runnable task, ThreadPoolExecutor executor) {
            try {
                executor.getQueue().put(task);
            }
            catch (InterruptedException e) {
                throw new RejectedExecutionException("queuing " + task + " got interrupted", e);
            }
        }
    }
}

