/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.runtime.event;

import java.util.HashSet;
import java.util.Set;
import org.ow2.bonita.facade.uuid.ActivityDefinitionUUID;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.runtime.event.EventInstance;

public class IncomingEventInstance
extends EventInstance {
    private static final long serialVersionUID = -2391431532148921303L;
    private ActivityDefinitionUUID activityDefinitionUUID;
    private String expression;
    private String executionUUID;
    private String signal;
    private long enableTime;
    private boolean executionLocked;
    private String exception;
    private boolean permanent = false;
    private Set<Long> incompatibleEvents;
    private ProcessInstanceUUID eventSubProcessRootInstanceUUID;

    public IncomingEventInstance() {
    }

    public IncomingEventInstance(String name, String expression, ProcessInstanceUUID instanceUUID, ActivityDefinitionUUID activityDefinitionUUID, ActivityInstanceUUID activityUUID, String processName, String activityName, String executionUUID, String signal, long enableTime, boolean executionLocked) {
        super(name, processName, activityName, instanceUUID, activityUUID);
        this.activityDefinitionUUID = activityDefinitionUUID;
        this.expression = expression;
        this.executionUUID = executionUUID;
        this.signal = signal;
        this.enableTime = enableTime;
        this.executionLocked = executionLocked;
    }

    public String getExecutionUUID() {
        return this.executionUUID;
    }

    public void setException(String exception) {
        this.exception = exception;
    }

    public String getException() {
        return this.exception;
    }

    public ActivityDefinitionUUID getActivityDefinitionUUID() {
        return this.activityDefinitionUUID;
    }

    public String getExpression() {
        return this.expression;
    }

    public String getSignal() {
        return this.signal;
    }

    public long getEnableTime() {
        return this.enableTime;
    }

    public boolean isExecutionLocked() {
        return this.executionLocked;
    }

    public void setPermanent(boolean permanent) {
        this.permanent = permanent;
    }

    public boolean isPermanent() {
        return this.permanent;
    }

    public void setEventSubProcessRootInstanceUUID(ProcessInstanceUUID eventSubProcessRootInstanceUUID) {
        this.eventSubProcessRootInstanceUUID = eventSubProcessRootInstanceUUID;
    }

    public ProcessInstanceUUID getEventSubProcessRootInstanceUUID() {
        return this.eventSubProcessRootInstanceUUID;
    }

    public void setEnableTime(long time) {
        this.enableTime = time;
    }

    public synchronized void addIncompatibleEvent(long id) {
        if (this.incompatibleEvents == null) {
            this.incompatibleEvents = new HashSet<Long>();
        }
        this.incompatibleEvents.add(id);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("IncomingEventInstance [id=");
        builder.append(this.getId());
        builder.append(", name=");
        builder.append(this.getName());
        builder.append(", process name=");
        builder.append(this.getProcessName());
        builder.append(", process instance UUID=");
        builder.append(this.getInstanceUUID());
        builder.append(", activity name=");
        builder.append(this.getActivityName());
        builder.append(", activity instance UUID=");
        builder.append(this.getActivityUUID());
        builder.append(", activityDefinitionUUID=");
        builder.append(this.activityDefinitionUUID);
        builder.append(", expression=");
        builder.append(this.expression);
        builder.append(", executionUUID=");
        builder.append(this.executionUUID);
        builder.append(", signal=");
        builder.append(this.signal);
        builder.append(", enableTime=");
        builder.append(this.enableTime);
        builder.append(", executionLocked=");
        builder.append(this.executionLocked);
        builder.append(", exception=");
        builder.append(this.exception);
        builder.append(", permanent=");
        builder.append(this.permanent);
        builder.append(", incompatibleEvents=");
        builder.append(this.incompatibleEvents);
        builder.append(", eventSubProcessRootInstanceUUID=");
        builder.append(this.eventSubProcessRootInstanceUUID);
        builder.append(", getCorrelationKey1()=");
        builder.append(this.getCorrelationKey1());
        builder.append(", getCorrelationKey2()=");
        builder.append(this.getCorrelationKey2());
        builder.append(", getCorrelationKey3()=");
        builder.append(this.getCorrelationKey3());
        builder.append(", getCorrelationKey4()=");
        builder.append(this.getCorrelationKey4());
        builder.append(", getCorrelationKey5()=");
        builder.append(this.getCorrelationKey5());
        builder.append("]");
        return builder.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.activityDefinitionUUID == null ? 0 : this.activityDefinitionUUID.hashCode());
        result = 31 * result + (int)(this.enableTime ^ this.enableTime >>> 32);
        result = 31 * result + (this.eventSubProcessRootInstanceUUID == null ? 0 : this.eventSubProcessRootInstanceUUID.hashCode());
        result = 31 * result + (this.exception == null ? 0 : this.exception.hashCode());
        result = 31 * result + (this.executionLocked ? 1231 : 1237);
        result = 31 * result + (this.executionUUID == null ? 0 : this.executionUUID.hashCode());
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        result = 31 * result + (this.incompatibleEvents == null ? 0 : ((Object)this.incompatibleEvents).hashCode());
        result = 31 * result + (this.permanent ? 1231 : 1237);
        result = 31 * result + (this.signal == null ? 0 : this.signal.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IncomingEventInstance other = (IncomingEventInstance)obj;
        if (this.activityDefinitionUUID == null ? other.activityDefinitionUUID != null : !this.activityDefinitionUUID.equals(other.activityDefinitionUUID)) {
            return false;
        }
        if (this.enableTime != other.enableTime) {
            return false;
        }
        if (this.eventSubProcessRootInstanceUUID == null ? other.eventSubProcessRootInstanceUUID != null : !this.eventSubProcessRootInstanceUUID.equals(other.eventSubProcessRootInstanceUUID)) {
            return false;
        }
        if (this.exception == null ? other.exception != null : !this.exception.equals(other.exception)) {
            return false;
        }
        if (this.executionLocked != other.executionLocked) {
            return false;
        }
        if (this.executionUUID == null ? other.executionUUID != null : !this.executionUUID.equals(other.executionUUID)) {
            return false;
        }
        if (this.expression == null ? other.expression != null : !this.expression.equals(other.expression)) {
            return false;
        }
        if (this.incompatibleEvents == null ? other.incompatibleEvents != null : !((Object)this.incompatibleEvents).equals(other.incompatibleEvents)) {
            return false;
        }
        if (this.permanent != other.permanent) {
            return false;
        }
        return !(this.signal == null ? other.signal != null : !this.signal.equals(other.signal));
    }
}

