/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.runtime.event;

import java.util.List;
import java.util.Set;
import org.ow2.bonita.runtime.event.EventExecutor;
import org.ow2.bonita.runtime.event.GetNextJobDueDate;
import org.ow2.bonita.runtime.event.GetNonlockedProcessUUIDs;
import org.ow2.bonita.runtime.event.Job;
import org.ow2.bonita.runtime.event.JobExecutor;
import org.ow2.bonita.services.EventService;
import org.ow2.bonita.util.Command;
import org.ow2.bonita.util.EnvTool;

public class MemoryLockJobExecutor
extends JobExecutor {
    MemoryLockJobExecutor(EventExecutor executor, String name, int nbOfThreads, int locksToQuery, int lockIdleTime) {
        super(executor, name, nbOfThreads, locksToQuery, lockIdleTime);
    }

    @Override
    protected Long getNextDueDate() {
        return this.getCommandService().execute(new GetNextJobDueDate(this.getProcessUUIDsToExclude()));
    }

    @Override
    protected Command<List<String>> getNonlockedProcessUUIDsCommand(Set<String> processUUIDsToExclude) {
        return new GetNonlockedProcessUUIDs(processUUIDsToExclude, this.getLocksToQuery());
    }

    @Override
    protected List<Job> getLockedJobs(String processUUID) {
        EventService eventService = EnvTool.getEventService();
        return eventService.getExecutableJobs(processUUID);
    }

    @Override
    protected boolean lockJob(String processUUID) {
        return true;
    }

    @Override
    protected void releaseLock(String processUUID) {
    }

    @Override
    protected String getJobExecutorName() {
        return this.getClass().getSimpleName();
    }
}

