/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.runtime.event;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.runtime.event.EventInstance;
import org.ow2.bonita.type.Variable;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.VariableUtil;

public class OutgoingEventInstance
extends EventInstance {
    private static final long serialVersionUID = -4173833339581321213L;
    private Map<String, Variable> parameters;
    private long overdue;
    private Long incomingId;

    public OutgoingEventInstance() {
    }

    public OutgoingEventInstance(String name, String processName, String activityName, Map<String, Object> parameters, ProcessInstanceUUID instanceUUID, ActivityInstanceUUID activityUUID, long overdue) {
        super(name, processName, activityName, instanceUUID, activityUUID);
        if (parameters != null) {
            this.parameters = new HashMap<String, Variable>();
            InternalProcessInstance instance = EnvTool.getJournalQueriers().getProcessInstance(instanceUUID);
            for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
                String key = parameter.getKey();
                Object value = parameter.getValue();
                this.parameters.put(key, VariableUtil.createVariable(instance.getProcessDefinitionUUID(), key, value));
            }
        }
        this.overdue = overdue;
    }

    public Map<String, Object> getParameters() {
        if (this.parameters == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Variable> entry : this.parameters.entrySet()) {
            result.put(entry.getKey(), entry.getValue().getValue());
        }
        return result;
    }

    public long getOverdue() {
        return this.overdue;
    }

    public Long getIncomingId() {
        return this.incomingId;
    }

    public void setIncomingId(Long incomingId) {
        this.incomingId = incomingId;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.incomingId == null ? 0 : this.incomingId.hashCode());
        result = 31 * result + (int)(this.overdue ^ this.overdue >>> 32);
        result = 31 * result + (this.parameters == null ? 0 : ((Object)this.parameters).hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OutgoingEventInstance other = (OutgoingEventInstance)obj;
        if (this.incomingId == null ? other.incomingId != null : !this.incomingId.equals(other.incomingId)) {
            return false;
        }
        if (this.overdue != other.overdue) {
            return false;
        }
        return !(this.parameters == null ? other.parameters != null : !((Object)this.parameters).equals(other.parameters));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("OutgoingEventInstance [id=");
        builder.append(this.getId());
        builder.append(", name=");
        builder.append(this.getName());
        builder.append(", process name=");
        builder.append(this.getProcessName());
        builder.append(", process instance UUID=");
        builder.append(this.getInstanceUUID());
        builder.append(", activity name=");
        builder.append(this.getActivityName());
        builder.append(", activity instance UUID=");
        builder.append(this.getActivityUUID());
        builder.append(", correlation key 1=");
        builder.append(this.getCorrelationKey1());
        builder.append(", correlation key 2=");
        builder.append(this.getCorrelationKey2());
        builder.append(", correlation key 3=");
        builder.append(this.getCorrelationKey3());
        builder.append(", correlation key 4=");
        builder.append(this.getCorrelationKey4());
        builder.append(", correlation key 5=");
        builder.append(this.getCorrelationKey5());
        builder.append(", parameters=");
        builder.append(this.parameters);
        builder.append(", overdue=");
        builder.append(this.overdue);
        builder.append("]");
        return builder.toString();
    }
}

