/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.search;

import java.lang.annotation.ElementType;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.util.Version;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.store.FSDirectoryProvider;
import org.ow2.bonita.facade.def.InternalProcessDefinition;
import org.ow2.bonita.facade.def.majorElement.impl.DescriptionElementImpl;
import org.ow2.bonita.facade.def.majorElement.impl.NamedElementImpl;
import org.ow2.bonita.facade.exception.BonitaInternalException;
import org.ow2.bonita.facade.identity.ContactInfo;
import org.ow2.bonita.facade.identity.impl.GroupImpl;
import org.ow2.bonita.facade.identity.impl.RoleImpl;
import org.ow2.bonita.facade.identity.impl.UserImpl;
import org.ow2.bonita.facade.runtime.ActivityInstance;
import org.ow2.bonita.facade.runtime.Comment;
import org.ow2.bonita.facade.runtime.TaskInstance;
import org.ow2.bonita.facade.runtime.impl.ActivityInstanceImpl;
import org.ow2.bonita.facade.runtime.impl.CaseImpl;
import org.ow2.bonita.facade.runtime.impl.CommentImpl;
import org.ow2.bonita.facade.runtime.impl.InternalActivityInstance;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.facade.runtime.impl.ProcessInstanceImpl;
import org.ow2.bonita.facade.runtime.impl.RuntimeRecordImpl;
import org.ow2.bonita.light.LightActivityInstance;
import org.ow2.bonita.light.impl.LightActivityInstanceImpl;
import org.ow2.bonita.light.impl.LightProcessDefinitionImpl;
import org.ow2.bonita.light.impl.LightProcessInstanceImpl;
import org.ow2.bonita.search.ObjectMapFieldBridge;
import org.ow2.bonita.search.StringSetFieldBridge;
import org.ow2.bonita.search.UUIDFieldBridge;

public class SearchUtil {
    private static final Logger LOG = Logger.getLogger(SearchUtil.class.getName());
    public static final Version LUCENE_VERSION = Version.LUCENE_29;

    private static boolean disableSearchConfiguration(Configuration configuration) {
        boolean disable = false;
        String sysValue = System.getProperty("bonita.search.use");
        if ("false".equals(sysValue)) {
            disable = true;
        } else {
            String useSearch = configuration.getProperty("bonita.search.use");
            if (!"true".equals(useSearch)) {
                disable = true;
            }
        }
        return disable;
    }

    public static void addSearchConfiguration(Configuration configuration) {
        boolean disable = SearchUtil.disableSearchConfiguration(configuration);
        if (disable) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Disable Bonita Indexes");
            }
        } else {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Configuring indexes");
            }
            SearchMapping mapping = new SearchMapping();
            mapping.entity(InternalProcessDefinition.class).indexed().indexName("process_definition").property("dbid", ElementType.FIELD).documentId().name("dbid").entity(LightProcessDefinitionImpl.class).property("uuid", ElementType.FIELD).field().name("uuid").bridge(UUIDFieldBridge.class).property("categoryNames", ElementType.METHOD).field().name("categoryName").bridge(StringSetFieldBridge.class).entity(NamedElementImpl.class).property("name", ElementType.METHOD).field().name("name").entity(DescriptionElementImpl.class).property("description", ElementType.METHOD).field().name("description").entity(InternalProcessInstance.class).indexed().indexName("process_instance").property("dbid", ElementType.FIELD).documentId().name("dbid").entity(ProcessInstanceImpl.class).property("commentFeed", ElementType.METHOD).indexEmbedded().property("involvedUsers", ElementType.METHOD).field().name("involvedUser").bridge(StringSetFieldBridge.class).property("activities", ElementType.METHOD).indexEmbedded().property("lastKnownVariableValues", ElementType.METHOD).field().name("variable").bridge(ObjectMapFieldBridge.class).property("activeUsers", ElementType.METHOD).field().name("activeUser").bridge(StringSetFieldBridge.class).entity(LightProcessInstanceImpl.class).property("nb", ElementType.FIELD).field().name("nb").property("startedBy", ElementType.METHOD).field().name("startedBy").property("endedBy", ElementType.METHOD).field().name("endedBy").property("startedDate", ElementType.METHOD).field().name("startedDate").index(Index.UN_TOKENIZED).dateBridge(Resolution.MILLISECOND).property("endedDate", ElementType.METHOD).field().name("endedDate").index(Index.UN_TOKENIZED).dateBridge(Resolution.MILLISECOND).property("lastUpdate", ElementType.METHOD).field().name("lastUpdate").index(Index.UN_TOKENIZED).dateBridge(Resolution.MILLISECOND).entity(RuntimeRecordImpl.class).property("processDefinitionUUID", ElementType.METHOD).field().name("processDefUUID").bridge(UUIDFieldBridge.class).property("processInstanceUUID", ElementType.METHOD).field().name("instanceUUID").bridge(UUIDFieldBridge.class).property("rootInstanceUUID", ElementType.METHOD).field().name("rootInstanceUUID").bridge(UUIDFieldBridge.class).entity(CommentImpl.class).indexed().indexName("comment").property("dbid", ElementType.FIELD).documentId().name("dbid").entity(Comment.class).property("message", ElementType.METHOD).field().name("message").property("userId", ElementType.METHOD).field().name("author").property("date", ElementType.METHOD).field().name("date").index(Index.UN_TOKENIZED).dateBridge(Resolution.MILLISECOND).entity(InternalActivityInstance.class).indexed().indexName("activity_instance").property("dbid", ElementType.FIELD).documentId().name("dbid").entity(TaskInstance.class).property("taskCandidates", ElementType.METHOD).field().name("candidate").bridge(StringSetFieldBridge.class).entity(ActivityInstanceImpl.class).property("taskCandidates", ElementType.METHOD).field().name("candidate").bridge(StringSetFieldBridge.class).property("lastKnownVariableValues", ElementType.METHOD).field().name("variable").bridge(ObjectMapFieldBridge.class).entity(LightActivityInstanceImpl.class).property("taskUser", ElementType.METHOD).field().name("userId").property("activityName", ElementType.METHOD).field().name("name").property("state", ElementType.METHOD).field().name("state").property("priority", ElementType.METHOD).field().name("priority").index(Index.UN_TOKENIZED).property("lastUpdate", ElementType.METHOD).field().name("lastUpdate").index(Index.UN_TOKENIZED).dateBridge(Resolution.MILLISECOND).property("expectedEndDate", ElementType.METHOD).field().name("expectedEndDate").index(Index.UN_TOKENIZED).dateBridge(Resolution.MILLISECOND).entity(ActivityInstance.class).property("activityName", ElementType.METHOD).field().name("name").property("state", ElementType.METHOD).field().name("state").property("lastKnownVariableValues", ElementType.METHOD).field().name("variable").bridge(ObjectMapFieldBridge.class).entity(LightActivityInstance.class).property("activityDescription", ElementType.METHOD).field().name("description").property("priority", ElementType.METHOD).field().name("priority").index(Index.UN_TOKENIZED).property("lastUpdate", ElementType.METHOD).field().name("lastUpdate").index(Index.UN_TOKENIZED).dateBridge(Resolution.MILLISECOND).property("expectedEndDate", ElementType.METHOD).field().name("expectedEndDate").index(Index.UN_TOKENIZED).dateBridge(Resolution.MILLISECOND).entity(UserImpl.class).indexed().indexName("user").property("dbid", ElementType.FIELD).documentId().name("dbid").property("username", ElementType.FIELD).field().name("name").property("firstName", ElementType.FIELD).field().name("firstName").property("lastName", ElementType.FIELD).field().name("lastName").property("manager", ElementType.FIELD).field().name("manager").property("delegate", ElementType.FIELD).field().name("delegate").property("title", ElementType.FIELD).field().name("title").property("jobTitle", ElementType.FIELD).field().name("jobTitle").property("professionalContactInfo", ElementType.FIELD).indexEmbedded().property("personalContactInfo", ElementType.FIELD).indexEmbedded().entity(ContactInfo.class).property("email", ElementType.METHOD).field().name("email").property("phoneNumber", ElementType.METHOD).field().name("faxNumber").property("faxNumber", ElementType.METHOD).field().name("priority").property("building", ElementType.METHOD).field().name("building").property("room", ElementType.METHOD).field().name("room").property("address", ElementType.METHOD).field().name("address").property("zipCode", ElementType.METHOD).field().name("zipCode").property("city", ElementType.METHOD).field().name("city").property("state", ElementType.METHOD).field().name("state").property("country", ElementType.METHOD).field().name("country").property("website", ElementType.METHOD).field().name("website").entity(RoleImpl.class).indexed().indexName("role").property("dbid", ElementType.FIELD).documentId().name("dbid").property("name", ElementType.FIELD).field().name("name").property("label", ElementType.FIELD).field().name("label").entity(GroupImpl.class).indexed().indexName("group").property("dbid", ElementType.FIELD).documentId().name("dbid").property("name", ElementType.METHOD).field().name("name").property("label", ElementType.METHOD).field().name("label").entity(CaseImpl.class).indexed().indexName("case").property("dbid", ElementType.FIELD).documentId().name("dbid").property("labelName", ElementType.FIELD).field().name("labelName").property("ownerName", ElementType.FIELD).field().name("ownerName").property("uuid", ElementType.FIELD).field().name("uuid").bridge(UUIDFieldBridge.class);
            configuration.getProperties().put("hibernate.search.model_mapping", mapping);
            configuration.setProperty("hibernate.search.default.directory_provider", FSDirectoryProvider.class.getName());
            String path = SearchUtil.getDefaultIndexesDirectorPath(configuration);
            configuration.setProperty("hibernate.search.default.indexBase", path);
        }
    }

    public static String getIndexesDirectoryPath(Configuration configuration) {
        if (SearchUtil.disableSearchConfiguration(configuration)) {
            return null;
        }
        return configuration.getProperty("hibernate.search.default.indexBase");
    }

    private static String getDefaultIndexesDirectorPath(Configuration configuration) {
        String indexBasePath = SearchUtil.getIndexesDirectoryPath(configuration);
        if (indexBasePath == null || "".equals(indexBasePath.trim())) {
            throw new BonitaInternalException("The hibernate.search.default.indexBase property is not set");
        }
        if (indexBasePath.startsWith("${BONITA_HOME}")) {
            indexBasePath = indexBasePath.replace("${BONITA_HOME}", System.getProperty("BONITA_HOME"));
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Hibernate search index base:" + indexBasePath);
        }
        return indexBasePath;
    }
}

