/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.services.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ow2.bonita.facade.identity.Membership;
import org.ow2.bonita.facade.identity.ProfileMetadata;
import org.ow2.bonita.facade.identity.impl.GroupImpl;
import org.ow2.bonita.facade.identity.impl.MembershipImpl;
import org.ow2.bonita.facade.identity.impl.ProfileMetadataImpl;
import org.ow2.bonita.facade.identity.impl.RoleImpl;
import org.ow2.bonita.facade.identity.impl.UserImpl;
import org.ow2.bonita.facade.paging.GroupCriterion;
import org.ow2.bonita.facade.paging.RoleCriterion;
import org.ow2.bonita.facade.paging.UserCriterion;
import org.ow2.bonita.persistence.IdentityDbSession;
import org.ow2.bonita.persistence.db.HibernateDbSession;
import org.ow2.bonita.services.IdentityService;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.Misc;

public class DbIdentity
extends HibernateDbSession
implements IdentityService {
    private String persistenceServiceName;

    public DbIdentity(String persistenceServiceName) {
        this.persistenceServiceName = persistenceServiceName;
    }

    protected IdentityDbSession getDbSession() {
        return EnvTool.getIdentityDbSession(this.persistenceServiceName);
    }

    @Override
    public void addRole(RoleImpl role) {
        this.getDbSession().save(role);
    }

    @Override
    public void addUser(UserImpl user) {
        String passwordHash = Misc.hash(user.getPassword());
        user.setPassword(passwordHash);
        this.getDbSession().save(user);
    }

    @Override
    public void importUser(UserImpl user) {
        this.getDbSession().save(user);
    }

    @Override
    public void deleteRole(RoleImpl role) {
        this.getDbSession().delete(role);
    }

    @Override
    public void deleteUser(UserImpl user) {
        Map<ProfileMetadata, String> metadata = user.getMetadata();
        for (ProfileMetadata profileMetadata : metadata.keySet()) {
            ProfileMetadataImpl impl = (ProfileMetadataImpl)profileMetadata;
            impl.removeUser(user);
        }
        this.getDbSession().delete(user);
    }

    @Override
    public void addGroup(GroupImpl group) {
        this.getDbSession().save(group);
    }

    @Override
    public void addMembership(MembershipImpl membership) {
        this.getDbSession().save(membership);
    }

    @Override
    public void addMembershipToUser(UserImpl user, MembershipImpl membership) {
        user.getMemberships().add(membership);
    }

    @Override
    public void addProfileMetadata(ProfileMetadataImpl metadata) {
        this.getDbSession().save(metadata);
    }

    @Override
    public void deleteGroup(GroupImpl group) {
        this.getDbSession().delete(group);
    }

    @Override
    public void deleteMembership(MembershipImpl membership) {
        this.getDbSession().delete(membership);
    }

    @Override
    public void deleteProfileMetadata(ProfileMetadataImpl metadata) {
        this.getDbSession().delete(metadata);
    }

    @Override
    public List<GroupImpl> getAllGroups() {
        return this.getDbSession().getAllGroups();
    }

    @Override
    public Set<MembershipImpl> getAllMemberships() {
        return this.getDbSession().getAllMemberships();
    }

    @Override
    public List<ProfileMetadataImpl> getAllProfileMetadata() {
        return this.getDbSession().getAllProfileMetadata();
    }

    @Override
    public List<RoleImpl> getAllRoles() {
        return this.getDbSession().getAllRoles();
    }

    @Override
    public List<UserImpl> getAllUsers() {
        return this.getDbSession().getAllUsers();
    }

    @Override
    public Set<GroupImpl> findGroupsByName(String name) {
        return this.getDbSession().findGroupsByName(name);
    }

    @Override
    public List<GroupImpl> getGroupChildren(String parentGroupUUID) {
        return this.getDbSession().getGroupChildren(parentGroupUUID);
    }

    @Override
    public List<GroupImpl> getGroupChildren(String parentGroupUUID, int fromIndex, int numberOfGroups) {
        return this.getDbSession().getGroupChildren(parentGroupUUID, fromIndex, numberOfGroups);
    }

    @Override
    public List<GroupImpl> getGroupChildren(String parentGroupUUID, int fromIndex, int numberOfGroups, GroupCriterion pagingCriterion) {
        return this.getDbSession().getGroupChildren(parentGroupUUID, fromIndex, numberOfGroups, pagingCriterion);
    }

    @Override
    public int getNumberOfGroupChildren(String parentGroupUUID) {
        return this.getDbSession().getNumberOfGroupChildren(parentGroupUUID);
    }

    @Override
    public RoleImpl findRoleByName(String roleName) {
        return this.getDbSession().findRoleByName(roleName);
    }

    @Override
    public UserImpl findUserByUsername(String username) {
        return this.getDbSession().findUserByUsername(username);
    }

    @Override
    public ProfileMetadataImpl findProfileMetadataByName(String metadataName) {
        return this.getDbSession().findProfileMetadataByName(metadataName);
    }

    @Override
    public void removeMembershipFromUser(UserImpl user, MembershipImpl membership) {
        user.getMemberships().remove(membership);
    }

    @Override
    public void setUserMemberships(UserImpl user, Set<MembershipImpl> memberships) {
        HashSet<Membership> membershipsToSet = new HashSet<Membership>(memberships);
        user.setMemberships(membershipsToSet);
    }

    @Override
    public void updateGroup(GroupImpl group) {
    }

    @Override
    public void updateProfileMetadata(ProfileMetadataImpl profileMetadata) {
    }

    @Override
    public void updateRole(RoleImpl role) {
    }

    @Override
    public void updateUser(UserImpl user) {
    }

    @Override
    public void updateUserPassword(UserImpl user, String password) {
        user.setPassword(Misc.hash(password));
    }

    @Override
    public GroupImpl getGroup(String groupUUID) {
        return this.getDbSession().getGroup(groupUUID);
    }

    @Override
    public RoleImpl getRole(String roleUUID) {
        return this.getDbSession().getRole(roleUUID);
    }

    @Override
    public UserImpl getUser(String userUUID) {
        return this.getDbSession().getUser(userUUID);
    }

    @Override
    public MembershipImpl getMembership(String membershipUUID) {
        return this.getDbSession().getMembership(membershipUUID);
    }

    @Override
    public MembershipImpl findMembershipByRoleAndGroup(String roleUUID, String groupUUID) {
        return this.getDbSession().findMembershipByRoleAndGroup(roleUUID, groupUUID);
    }

    @Override
    public Set<MembershipImpl> getMembershipsByGroup(String groupUUID) {
        return this.getDbSession().getMembershipsByGroup(groupUUID);
    }

    @Override
    public Set<MembershipImpl> getMembershipsByRole(String roleUUID) {
        return this.getDbSession().getMembershipsByRole(roleUUID);
    }

    @Override
    public List<UserImpl> getUsersByGroup(String groupUUID) {
        return this.getDbSession().getUsersByGroup(groupUUID);
    }

    @Override
    public List<UserImpl> getUsersByMembership(String membershipUUID) {
        return this.getDbSession().getUsersByMembership(membershipUUID);
    }

    @Override
    public List<UserImpl> getUsersByRole(String roleUUID) {
        return this.getDbSession().getUsersByRole(roleUUID);
    }

    @Override
    public List<UserImpl> getUsersByManager(String managerUUID) {
        return this.getDbSession().getUsersByManager(managerUUID);
    }

    @Override
    public List<UserImpl> getUsersByDelegee(String delegeeUUID) {
        return this.getDbSession().getUsersByDelegee(delegeeUUID);
    }

    @Override
    public ProfileMetadataImpl getProfileMetadata(String profileMetadataUUID) {
        return this.getDbSession().getProfileMetadata(profileMetadataUUID);
    }

    @Override
    public List<GroupImpl> getGroups(int fromIndex, int numberOfGroups) {
        return this.getDbSession().getGroups(fromIndex, numberOfGroups);
    }

    @Override
    public List<GroupImpl> getGroups(int fromIndex, int numberOfGroups, GroupCriterion pagingCriterion) {
        return this.getDbSession().getGroups(fromIndex, numberOfGroups, pagingCriterion);
    }

    @Override
    public int getNumberOfGroups() {
        return this.getDbSession().getNumberOfGroups();
    }

    @Override
    public int getNumberOfRoles() {
        return this.getDbSession().getNumberOfRoles();
    }

    @Override
    public int getNumberOfUsers() {
        return this.getDbSession().getNumberOfUsers();
    }

    @Override
    public int getNumberOfUsersByGroup(String groupUUID) {
        return this.getDbSession().getNumberOfUsersByGroup(groupUUID);
    }

    @Override
    public int getNumberOfUsersByRole(String roleUUID) {
        return this.getDbSession().getNumberOfUsersByRole(roleUUID);
    }

    @Override
    public List<RoleImpl> getRoles(int fromIndex, int numberOfRoles) {
        return this.getDbSession().getRoles(fromIndex, numberOfRoles);
    }

    @Override
    public List<RoleImpl> getRoles(int fromIndex, int numberOfRoles, RoleCriterion pagingCriterion) {
        return this.getDbSession().getRoles(fromIndex, numberOfRoles, pagingCriterion);
    }

    @Override
    public List<UserImpl> getUsers(int fromIndex, int numberOfUsers) {
        return this.getDbSession().getUsers(fromIndex, numberOfUsers);
    }

    @Override
    public List<UserImpl> getUsers(int fromIndex, int numberOfUsers, UserCriterion pagingCriterion) {
        return this.getDbSession().getUsers(fromIndex, numberOfUsers, pagingCriterion);
    }

    @Override
    public List<UserImpl> getUsersByGroup(String groupUUID, int fromIndex, int numberOfUsers) {
        return this.getDbSession().getUsersByGroup(groupUUID, fromIndex, numberOfUsers);
    }

    @Override
    public List<UserImpl> getUsersByGroup(String groupUUID, int fromIndex, int numberOfUsers, UserCriterion pagingCriterion) {
        return this.getDbSession().getUsersByGroup(groupUUID, fromIndex, numberOfUsers, pagingCriterion);
    }

    @Override
    public List<UserImpl> getUsersByRole(String roleUUID, int fromIndex, int numberOfUsers) {
        return this.getDbSession().getUsersByRole(roleUUID, fromIndex, numberOfUsers);
    }

    @Override
    public List<UserImpl> getUsersByRole(String roleUUID, int fromIndex, int numberOfUsers, UserCriterion pagingCriterion) {
        return this.getDbSession().getUsersByRole(roleUUID, fromIndex, numberOfUsers, pagingCriterion);
    }

    @Override
    public List<ProfileMetadataImpl> getProfileMetadata(int fromIndex, int numberOfMetadata) {
        return this.getDbSession().getProfileMetadata(fromIndex, numberOfMetadata);
    }

    @Override
    public int getNumberOfProfileMetadata() {
        return this.getDbSession().getNumberOfProfileMetadata();
    }

    @Override
    public List<GroupImpl> getGroups(Collection<String> groupUUIDs) {
        return this.getDbSession().getGroups(groupUUIDs);
    }

    @Override
    public List<MembershipImpl> getMemberships(Collection<String> membershipUUIDs) {
        return this.getDbSession().getMemberships(membershipUUIDs);
    }

    @Override
    public List<RoleImpl> getRoles(Collection<String> roleUUIDs) {
        return this.getDbSession().getRoles(roleUUIDs);
    }

    @Override
    public List<UserImpl> getUsers(Collection<String> userUUIDs) {
        return this.getDbSession().getUsers(userUUIDs);
    }
}

