/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.services.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.services.LargeDataRepository;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.Misc;

public class FileLargeDataRepository
implements LargeDataRepository {
    private static final Logger LOG = Logger.getLogger(FileLargeDataRepository.class.getName());
    private final File base;
    private static final Object CONSTRUCTOR_MUTEX = new Object();
    private static final String INDEX_NAME = "index.txt";

    @Override
    public void clean() {
        Misc.deleteDir(this.base, 10, 5L);
        this.createRepository();
    }

    @Override
    public boolean isEmpty() {
        return this.checkIsEmpty(this.base);
    }

    private boolean checkIsEmpty(File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            return true;
        }
        for (File file : files) {
            if (file.isFile() && !file.getName().equals(INDEX_NAME)) {
                return false;
            }
            if (this.checkIsEmpty(file)) continue;
            return false;
        }
        return true;
    }

    public FileLargeDataRepository(String value) {
        Misc.checkArgsNotNull(value);
        String property = "property:";
        String path = value;
        if (value.startsWith("property:")) {
            path = System.getProperty(value.substring("property:".length()));
        } else if (value.startsWith("${BONITA_HOME}")) {
            path = path.replace("${BONITA_HOME}", System.getProperty("BONITA_HOME"));
        }
        this.base = new File(path, "bonita-large-data-repository");
        if (LOG.isLoggable(Level.INFO)) {
            LOG.fine("Creating " + this.getClass().getName() + " with base: " + this.base);
        }
        this.createRepository();
    }

    @Override
    public boolean deleteData(List<String> categories, String key) {
        block6: {
            try {
                File file = this.removeFromIndex(categories, key);
                if (file != null && file.exists()) {
                    int counter = 0;
                    while (!file.delete() && counter < 50) {
                        ++counter;
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException e) {}
                    }
                    break block6;
                }
                return false;
            }
            catch (IOException e) {
                throw new BonitaRuntimeException(e);
            }
        }
        return true;
    }

    @Override
    public boolean deleteData(List<String> categories) {
        File dir = this.getPath(categories, false);
        if (dir != null && dir.exists()) {
            Misc.deleteDir(dir, 10, 5L);
            if (!dir.exists()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public <T> T getData(Class<T> clazz, List<String> categories, String key) {
        try {
            File file = this.getFromIndex(categories, key);
            if (file == null || !file.exists()) {
                return null;
            }
            return this.getData(clazz, file);
        }
        catch (IOException e) {
            throw new BonitaRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getKeys(List<String> categories, String regex) {
        File dir = this.getPath(categories, false);
        if (dir == null || !dir.exists()) {
            return Collections.emptySet();
        }
        try {
            File index = this.getIndex(categories);
            String string = index.getAbsolutePath();
            synchronized (string) {
                Properties properties = this.loadIndex(index);
                Enumeration<Object> keys = properties.keys();
                HashSet<String> result = new HashSet<String>();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    if (regex != null && !key.matches(regex)) continue;
                    result.add(key);
                }
                return result;
            }
        }
        catch (IOException e) {
            throw new BonitaRuntimeException(e);
        }
    }

    @Override
    public Set<String> getKeys(List<String> categories) {
        return this.getKeys(categories, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Map<String, T> getDataFromRegex(Class<T> clazz, List<String> categories, String regex) {
        File dir = this.getPath(categories, false);
        if (dir == null || !dir.exists()) {
            return Collections.emptyMap();
        }
        try {
            File index = this.getIndex(categories);
            String string = index.getAbsolutePath();
            synchronized (string) {
                Properties properties = this.loadIndex(index);
                HashMap<String, T> result = new HashMap<String, T>();
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    String key = (String)entry.getKey();
                    File f = new File(dir + File.separator + entry.getValue());
                    if (!f.isFile() || regex != null && !key.matches(regex)) continue;
                    result.put(key, this.getData(clazz, f));
                }
                return result;
            }
        }
        catch (IOException e) {
            throw new BonitaRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Map<String, T> getData(Class<T> clazz, List<String> categories, Collection<String> keys) {
        if (keys == null) {
            return Collections.emptyMap();
        }
        File dir = this.getPath(categories, false);
        if (dir == null || !dir.exists()) {
            return Collections.emptyMap();
        }
        try {
            File index = this.getIndex(categories);
            String string = index.getAbsolutePath();
            synchronized (string) {
                Properties properties = this.loadIndex(index);
                HashMap<String, T> result = new HashMap<String, T>();
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    File f;
                    String key = (String)entry.getKey();
                    if (!keys.contains(key) || !(f = new File(dir + File.separator + entry.getValue())).isFile()) continue;
                    result.put(key, this.getData(clazz, f));
                }
                return result;
            }
        }
        catch (IOException e) {
            throw new BonitaRuntimeException(e);
        }
    }

    @Override
    public <T> Map<String, T> getData(Class<T> clazz, List<String> categories) {
        return this.getDataFromRegex(clazz, categories, null);
    }

    @Override
    public void storeData(List<String> categories, String key, Serializable value, boolean overWrite) {
        try {
            File file = this.getFromIndex(categories, key);
            if (file != null && file.exists()) {
                if (!overWrite) {
                    return;
                }
                file.delete();
            }
            int lastDotIndex = key.lastIndexOf(46);
            String extension = "";
            if (lastDotIndex > 0) {
                extension = key.substring(lastDotIndex);
            }
            String fileName = UUID.randomUUID().toString() + extension;
            file = new File(this.getPath(categories, true) + File.separator + fileName);
            file.createNewFile();
            Misc.write(file, Misc.serialize(value));
            this.addEntryToIndex(categories, key, fileName);
        }
        catch (IOException e) {
            throw new BonitaRuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new BonitaRuntimeException(e);
        }
    }

    @Override
    public Set<String> getKeys() {
        HashSet<String> keys = new HashSet<String>();
        try {
            this.analysePath(this.base, keys);
        }
        catch (Exception e) {
            throw new BonitaRuntimeException(e);
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analysePath(File dir, Set<String> keys) throws FileNotFoundException, IOException {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isFile() && !file.getName().equals(INDEX_NAME)) {
                    File index = new File(dir.getAbsolutePath() + File.separator + INDEX_NAME);
                    String string = index.getAbsolutePath();
                    synchronized (string) {
                        Properties properties = this.loadIndex(index);
                        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                            if (!entry.getValue().equals(file.getName())) continue;
                            keys.add((String)entry.getKey());
                        }
                        continue;
                    }
                }
                if (!file.isDirectory()) continue;
                this.analysePath(file, keys);
            }
        }
    }

    public String getDataPath(List<String> categories, String key) {
        try {
            File file = this.getFromIndex(categories, key);
            return file.getPath();
        }
        catch (IOException e) {
            throw new BonitaRuntimeException(e);
        }
    }

    private <T> T getData(Class<T> clazz, File file) {
        try {
            byte[] value = Misc.getAllContentFrom(file);
            return (T)Misc.deserialize(value);
        }
        catch (IOException e) {
            throw new BonitaRuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new BonitaRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getFromIndex(List<String> categories, String key) throws IOException {
        File index = this.getIndex(categories);
        String string = index.getAbsolutePath();
        synchronized (string) {
            Properties properties = this.loadIndex(index);
            String file = (String)properties.get(key);
            if (file == null) {
                return null;
            }
            return new File(this.getPath(categories, false) + File.separator + file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File removeFromIndex(List<String> categories, String key) throws IOException {
        File index = this.getIndex(categories);
        String string = index.getAbsolutePath();
        synchronized (string) {
            Properties properties = this.loadIndex(index);
            String file = (String)properties.remove(key);
            this.storeIndex(index, properties);
            return new File(this.getPath(categories, false) + File.separator + file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getIndex(List<String> categories) throws IOException {
        File dir = this.getPath(categories, true);
        File index = new File(dir.getAbsolutePath() + File.separator + INDEX_NAME);
        String string = dir.getAbsolutePath();
        synchronized (string) {
            if (!index.exists()) {
                index.createNewFile();
            }
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEntryToIndex(List<String> categories, String key, String value) throws FileNotFoundException, IOException {
        File index = this.getIndex(categories);
        String string = index.getAbsolutePath();
        synchronized (string) {
            Properties properties = this.loadIndex(index);
            properties.setProperty(key, value);
            this.storeIndex(index, properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadIndex(File index) throws FileNotFoundException, IOException {
        Properties properties = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(index);
            properties.load(fis);
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeIndex(File index, Properties properties) throws FileNotFoundException, IOException {
        FileOutputStream fos = new FileOutputStream(index);
        try {
            properties.store(fos, null);
        }
        finally {
            fos.close();
        }
    }

    public File getPath(List<String> categories, boolean create) {
        List<String> convertedCategories = this.convertCategories(categories);
        File dir = this.base;
        if (categories != null) {
            for (String category : convertedCategories) {
                File file = this.getFile(dir, category);
                if (file == null && create) {
                    dir = new File(dir.getAbsolutePath() + File.separator + category);
                    dir.mkdirs();
                    continue;
                }
                if (file == null) {
                    return null;
                }
                dir = file;
            }
        }
        return dir;
    }

    private List<String> convertCategories(List<String> categories) {
        ArrayList<String> result = new ArrayList<String>();
        for (String category : categories) {
            result.add(Misc.convertToJavaIdentifier(category));
        }
        return result;
    }

    private File getFile(File currentDir, String category) {
        File[] files = currentDir.listFiles();
        if (files == null || files.length == 0) {
            return null;
        }
        for (File file : files) {
            if (!file.isDirectory() || !file.getName().equals(category)) continue;
            return file;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRepository() {
        if (LOG.isLoggable(Level.CONFIG)) {
            LOG.config("Configuring Large Data Repository: " + FileLargeDataRepository.class.getName() + " with base: " + this.base);
        }
        Object object = CONSTRUCTOR_MUTEX;
        synchronized (object) {
            if (this.base.exists()) {
                if (!(this.base.isDirectory() && this.base.canRead() && this.base.canWrite())) {
                    String message = ExceptionManager.getInstance().getFullMessage("bai_QDAPII_20", this.base.getAbsolutePath());
                    throw new BonitaRuntimeException(message);
                }
            } else if (!this.base.mkdirs()) {
                String message = ExceptionManager.getInstance().getFullMessage("bai_QDAPII_21", this.base.getAbsolutePath());
                throw new BonitaRuntimeException(message);
            }
        }
    }
}

