/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.services.impl;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.facade.def.InternalProcessDefinition;
import org.ow2.bonita.facade.runtime.ActivityInstance;
import org.ow2.bonita.facade.runtime.ActivityState;
import org.ow2.bonita.facade.runtime.Category;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.runtime.event.Master;
import org.ow2.bonita.services.Recorder;
import org.ow2.bonita.type.lob.Lob;

public class LoggerRecorder
implements Recorder {
    private static final Logger LOG = Logger.getLogger(LoggerRecorder.class.getName());
    private final Level level;

    public LoggerRecorder() {
        this(Level.FINE);
    }

    public LoggerRecorder(String levelName) {
        this(Level.parse(levelName));
    }

    public LoggerRecorder(Level level) {
        this.level = level;
    }

    @Override
    public void recordProcessDeployed(InternalProcessDefinition processDef, String userId) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Deployed process: processDefinitionUUID: " + processDef.getUUID() + ", processId: " + processDef.getName() + ", userId: " + userId + ", description: " + processDef.getDescription());
        }
    }

    @Override
    public void recordProcessEnable(InternalProcessDefinition processDef) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Enable process: processDefinitionUUID: " + processDef.getUUID() + ", processId: " + processDef.getName() + ", userId: " + processDef.getDeployedBy() + ", description: " + processDef.getDescription());
        }
    }

    @Override
    public void recordProcessDisable(InternalProcessDefinition processDef) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Disable process: processDefinitionUUID: " + processDef.getUUID());
        }
    }

    @Override
    public void recordProcessArchive(InternalProcessDefinition processDef, String userId) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Archive process: processDefinitionUUID: " + processDef.getUUID() + ", userId = " + userId);
        }
    }

    @Override
    public void recordInstanceVariableUpdated(String variableId, Object variableValue, ProcessInstanceUUID instanceUUID, String userId) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Global variable updated: processUUID: " + instanceUUID + ", variableId: " + variableId + ", userId = " + userId);
        }
    }

    @Override
    public void recordActivityVariableUpdated(String variableId, Object variableValue, ActivityInstanceUUID activityUUID, String userId) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Local variable updated: activityUUID: " + activityUUID + ", variableId: " + variableId + ", userId = " + userId);
        }
    }

    @Override
    public void remove(InternalProcessDefinition processDef) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "ProcessDefinition " + processDef.getUUID() + " removed.");
        }
    }

    @Override
    public void remove(InternalProcessInstance processInst) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "ProcessInstance " + processInst.getUUID() + " removed.");
        }
    }

    public void clear() {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Clearing recorder");
        }
    }

    @Override
    public void recordBodyEnded(ActivityInstance activityInstance) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Activity body ended: " + activityInstance.getActivityName() + " (" + activityInstance.getProcessInstanceUUID() + ")");
        }
    }

    @Override
    public void recordBodyAborted(ActivityInstance activityInstance) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Activity body aborted: " + activityInstance.getActivityName() + " (" + activityInstance.getProcessInstanceUUID() + ")");
        }
    }

    @Override
    public void recordBodyCancelled(ActivityInstance activityInstance) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Activity body cancelled: " + activityInstance.getActivityName() + " (" + activityInstance.getProcessInstanceUUID() + ")");
        }
    }

    @Override
    public void recordBodyStarted(ActivityInstance activityInstance) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Activity body started: " + activityInstance.getActivityName() + " (" + activityInstance.getProcessInstanceUUID() + ")");
        }
    }

    @Override
    public void recordEnterActivity(ActivityInstance activityInstance) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Activity ready: " + activityInstance.getActivityName() + " (" + activityInstance.getProcessInstanceUUID() + ")");
        }
    }

    @Override
    public void recordActivityFailed(ActivityInstance activityInstance) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Activity failed: " + activityInstance.getActivityName() + " (" + activityInstance.getProcessInstanceUUID() + ")");
        }
    }

    @Override
    public void recordInstanceEnded(ProcessInstanceUUID instanceUUID, String loggedInUserId) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Ended instance: " + instanceUUID + ", userId = " + loggedInUserId);
        }
    }

    @Override
    public void recordInstanceAborted(ProcessInstanceUUID instanceUUID, String loggedInUserId) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Aborted instance: " + instanceUUID + ", userId = " + loggedInUserId);
        }
    }

    @Override
    public void recordInstanceCancelled(ProcessInstanceUUID instanceUUID, String loggedInUserId) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Cancelled instance: " + instanceUUID + ", userId = " + loggedInUserId);
        }
    }

    @Override
    public void recordInstanceStarted(InternalProcessInstance instance, String loggedInUserId) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Started instance: " + instance.getUUID() + ", userId = " + loggedInUserId);
        }
    }

    @Override
    public void recordTaskAssigned(ActivityInstanceUUID taskUUID, ActivityState taskState, String loggedInUserId, Set<String> candidates, String assignedUserId) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Task " + taskUUID + " Assigned by: " + loggedInUserId + " Assigned to: " + assignedUserId + "and candidates: " + candidates);
        }
    }

    @Override
    public void recordTaskFinished(ActivityInstanceUUID taskUUID, String loggedInUserId) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Task " + taskUUID + " finished by " + loggedInUserId);
        }
    }

    @Override
    public void recordTaskReady(ActivityInstanceUUID taskUUID, Set<String> candidates, String userId) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Task ready " + taskUUID);
        }
    }

    @Override
    public void recordTaskResumed(ActivityInstanceUUID taskUUID, String loggedInUserId) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Task " + taskUUID + " resumed by " + loggedInUserId + ".");
        }
    }

    @Override
    public void recordTaskStarted(ActivityInstanceUUID taskUUID, String loggedInUserId) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Task " + taskUUID + " started by " + loggedInUserId + ".");
        }
    }

    @Override
    public void recordTaskSuspended(ActivityInstanceUUID taskUUID, String loggedInUserId) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Task " + taskUUID + " suspended by " + loggedInUserId + ".");
        }
    }

    @Override
    public void recordTaskSkipped(ActivityInstanceUUID taskUUID, String loggedInUserId) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Task " + taskUUID + " skipped by " + loggedInUserId + ".");
        }
    }

    @Override
    public void recordActivitySkipped(ActivityInstance activityInstance, String loggedInUserId) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Activity " + activityInstance.getUUID() + " skipped by " + loggedInUserId + ".");
        }
    }

    public void removeLob(Lob lob) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Removing lob " + lob + ".");
        }
    }

    @Override
    public void recordActivityPriorityUpdated(ActivityInstanceUUID activityUUID, int priority) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Activity " + activityUUID + " priority changed to " + priority + ".");
        }
    }

    @Override
    public void recordNewCategory(Category category) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Category " + category.getName() + " created.");
        }
    }

    @Override
    public void recordNewMaster(Master master) {
        if (LOG.isLoggable(this.level)) {
            LOG.log(this.level, "Master " + master.getNode() + " created.");
        }
    }
}

