/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import org.ow2.bonita.facade.def.element.AttachmentDefinition;
import org.ow2.bonita.facade.def.element.BoundaryEvent;
import org.ow2.bonita.facade.def.element.HookDefinition;
import org.ow2.bonita.facade.def.element.IncomingEventDefinition;
import org.ow2.bonita.facade.def.element.MultiInstantiationDefinition;
import org.ow2.bonita.facade.def.element.impl.AttachmentDefinitionImpl;
import org.ow2.bonita.facade.def.element.impl.ConnectorDefinitionImpl;
import org.ow2.bonita.facade.def.element.impl.ErrorBoundaryEventImpl;
import org.ow2.bonita.facade.def.element.impl.EventDefinitionImpl;
import org.ow2.bonita.facade.def.element.impl.IncomingEventDefinitionImpl;
import org.ow2.bonita.facade.def.element.impl.MessageBoundaryEventImpl;
import org.ow2.bonita.facade.def.element.impl.OutgoingEventDefinitionImpl;
import org.ow2.bonita.facade.def.element.impl.SignalBoundaryEventImpl;
import org.ow2.bonita.facade.def.element.impl.SubflowParameterDefinitionImpl;
import org.ow2.bonita.facade.def.element.impl.TimerBoundaryEventImpl;
import org.ow2.bonita.facade.def.majorElement.ActivityDefinition;
import org.ow2.bonita.facade.def.majorElement.DataFieldDefinition;
import org.ow2.bonita.facade.def.majorElement.ParticipantDefinition;
import org.ow2.bonita.facade.def.majorElement.ProcessDefinition;
import org.ow2.bonita.facade.def.majorElement.TransitionDefinition;
import org.ow2.bonita.facade.def.majorElement.impl.ActivityDefinitionImpl;
import org.ow2.bonita.facade.def.majorElement.impl.DataFieldDefinitionImpl;
import org.ow2.bonita.facade.def.majorElement.impl.DescriptionElementImpl;
import org.ow2.bonita.facade.def.majorElement.impl.EventProcessDefinitionImpl;
import org.ow2.bonita.facade.def.majorElement.impl.NamedElementImpl;
import org.ow2.bonita.facade.def.majorElement.impl.ParticipantDefinitionImpl;
import org.ow2.bonita.facade.def.majorElement.impl.ProcessDefinitionImpl;
import org.ow2.bonita.facade.def.majorElement.impl.TransitionDefinitionImpl;
import org.ow2.bonita.light.LightProcessDefinition;
import org.ow2.bonita.parsing.def.XmlDefParser;
import org.ow2.bonita.parsing.xpdl.XpdlParser;
import org.ow2.bonita.util.BonitaConstants;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.DateUtil;
import org.ow2.bonita.util.GroovyExpression;
import org.ow2.bonita.util.Misc;
import org.ow2.bonita.util.xml.Parse;
import org.ow2.bonita.util.xml.Problem;
import org.w3c.dom.Document;

public final class ProcessBuilder {
    private final Collection<Problem> problems = new ArrayList<Problem>();
    private final Stack<Object> stack = new Stack();
    private OutgoingEventDefinitionImpl outgoingEvent;

    public static ProcessBuilder createProcess(String name, String version) {
        return new ProcessBuilder(name, version);
    }

    public static ProcessDefinition createProcessFromXpdlFile(URL xpdlUrl) {
        Parse parse = new XpdlParser().createParse();
        parse.setUrl(xpdlUrl);
        ProcessDefinition process = (ProcessDefinition)parse.execute().getDocumentObject();
        Misc.showProblems(parse.getProblems(), "xpdl file");
        Misc.badStateIfNull(process, "Ouch! The returned client process is null!");
        return process;
    }

    public static ProcessDefinition createProcessFromXmlDefFile(URL xmlDefUrl) {
        Parse parse = new XmlDefParser().createParse();
        parse.setUrl(xmlDefUrl);
        ProcessDefinition process = (ProcessDefinition)parse.execute().getDocumentObject();
        Misc.showProblems(parse.getProblems(), "xml file");
        Misc.badStateIfNull(process, "Ouch! The returned client process is null!");
        return process;
    }

    private ProcessBuilder(String processame, String processVersion) {
        Misc.checkArgsNotNull(processame);
        ProcessDefinitionImpl process = null;
        if ("".equals(processame.trim())) {
            this.problems.add(new Problem("Process name is an empty string.", "error"));
        }
        process = processVersion == null || "".equals(processVersion.trim()) ? new ProcessDefinitionImpl(processame, "1.0") : new ProcessDefinitionImpl(processame, processVersion);
        this.push(process);
    }

    public ProcessBuilder addDescription(String description) {
        Object obj = this.peek(DescriptionElementImpl.class);
        if (this.isDescriptionElement(obj)) {
            ((DescriptionElementImpl)obj).setDescription(description);
        } else {
            this.problems.add(new Problem("Unable to set description " + description + " on an object of type: " + this.getClass(obj), "error"));
        }
        return this;
    }

    public ProcessBuilder addLabel(String label) {
        Object obj = this.peek(NamedElementImpl.class);
        if (this.isNamedElement(obj)) {
            ((NamedElementImpl)obj).setLabel(label);
        } else {
            this.problems.add(new Problem("Unable to set label " + label + " on an object of type: " + this.getClass(obj), "error"));
        }
        return this;
    }

    public ProcessBuilder addCharData(String dataName) {
        return this.addCharData(dataName, (Character)null);
    }

    public ProcessBuilder addShortData(String dataName) {
        return this.addShortData(dataName, (Short)null);
    }

    public ProcessBuilder addLongData(String dataName) {
        return this.addLongData(dataName, (Long)null);
    }

    public ProcessBuilder addDoubleData(String dataName) {
        return this.addDoubleData(dataName, (Double)null);
    }

    public ProcessBuilder addFloatData(String dataName) {
        return this.addFloatData(dataName, (Float)null);
    }

    public ProcessBuilder addBooleanData(String dataName) {
        return this.addBooleanData(dataName, (Boolean)null);
    }

    public ProcessBuilder addIntegerData(String dataName) {
        return this.addIntegerData(dataName, (Integer)null);
    }

    public ProcessBuilder addStringData(String dataName) {
        return this.addStringData(dataName, null);
    }

    public ProcessBuilder addXMLData(String dataName) {
        return this.addXMLData(dataName, (Document)null);
    }

    public ProcessBuilder addDateData(String dataName) {
        return this.addDateData(dataName, (Date)null);
    }

    public ProcessBuilder addCharData(String dataName, Character initialValue) {
        return this.addObjectData(dataName, Character.class.getName(), initialValue);
    }

    public ProcessBuilder addCharData(String dataName, String scriptingValue) {
        return this.addObjectData(dataName, Character.class.getName(), scriptingValue);
    }

    public ProcessBuilder addShortData(String dataName, Short initialValue) {
        return this.addObjectData(dataName, Short.class.getName(), initialValue);
    }

    public ProcessBuilder addShortData(String dataName, String scriptingValue) {
        return this.addObjectData(dataName, Short.class.getName(), scriptingValue);
    }

    public ProcessBuilder addLongData(String dataName, Long initialValue) {
        return this.addObjectData(dataName, Long.class.getName(), initialValue);
    }

    public ProcessBuilder addLongData(String dataName, String scriptingValue) {
        return this.addObjectData(dataName, Long.class.getName(), scriptingValue);
    }

    public ProcessBuilder addDoubleData(String dataName, Double initialValue) {
        return this.addObjectData(dataName, Double.class.getName(), initialValue);
    }

    public ProcessBuilder addDoubleData(String dataName, String scriptingValue) {
        return this.addObjectData(dataName, Double.class.getName(), scriptingValue);
    }

    public ProcessBuilder addFloatData(String dataName, Float initialValue) {
        return this.addObjectData(dataName, Float.class.getName(), initialValue);
    }

    public ProcessBuilder addFloatData(String dataName, String scriptingValue) {
        return this.addObjectData(dataName, Float.class.getName(), scriptingValue);
    }

    public ProcessBuilder addBooleanData(String dataName, Boolean initialValue) {
        return this.addObjectData(dataName, Boolean.class.getName(), initialValue);
    }

    public ProcessBuilder addBooleanData(String dataName, String scriptingValue) {
        return this.addObjectData(dataName, Boolean.class.getName(), scriptingValue);
    }

    public ProcessBuilder addIntegerData(String dataName, Integer initialValue) {
        return this.addObjectData(dataName, Integer.class.getName(), initialValue);
    }

    public ProcessBuilder addIntegerData(String dataName, String scriptingValue) {
        return this.addObjectData(dataName, Integer.class.getName(), scriptingValue);
    }

    public ProcessBuilder addStringData(String dataName, String initialValue) {
        return this.addObjectData(dataName, String.class.getName(), (Object)initialValue);
    }

    public ProcessBuilder addXMLData(String dataName, String initialValue) {
        Document doc = null;
        if (initialValue != null) {
            try {
                doc = Misc.generateDocument(initialValue);
            }
            catch (Exception e) {
                throw new BonitaRuntimeException("Unable to generate Document from String: " + initialValue);
            }
        }
        return this.addObjectData(dataName, Document.class.getName(), doc);
    }

    public ProcessBuilder addXMLDataFromScript(String dataName, String scriptValue) {
        return this.addObjectData(dataName, Document.class.getName(), scriptValue);
    }

    public ProcessBuilder addXMLData(String dataName, Document initialValue) {
        return this.addObjectData(dataName, Document.class.getName(), initialValue);
    }

    public ProcessBuilder addStringDataFromScript(String dataName, String scriptingValue) {
        return this.addObjectData(dataName, String.class.getName(), scriptingValue);
    }

    public ProcessBuilder addDateData(String dataName, Date initialValue) {
        return this.addObjectData(dataName, Date.class.getName(), initialValue);
    }

    public ProcessBuilder addDateData(String dataName, String scriptingValue) {
        return this.addObjectData(dataName, Date.class.getName(), scriptingValue);
    }

    public ProcessBuilder addEnumData(String dataName, Set<String> enumeariontValues, String initialValue) {
        return this.addObjectData(dataName, String.class.getName(), initialValue, null, enumeariontValues);
    }

    public ProcessBuilder addEnumData(String dataName, String scriptingValue, Set<String> enumeariontValues) {
        return this.addObjectData(dataName, String.class.getName(), null, scriptingValue, enumeariontValues);
    }

    public ProcessBuilder addAttachment(String name) {
        return this.addAttachment(name, null, null);
    }

    public ProcessBuilder addAttachment(String name, String filePath) {
        return this.addAttachment(name, filePath, null);
    }

    public ProcessBuilder addAttachment(String name, String filePath, String fileName) {
        Object obj;
        Misc.checkArgsNotNull(name);
        if ("".equals(name.trim())) {
            this.problems.add(new Problem("Attachment name is an empty string.", "error"));
        }
        if (this.isProcess(obj = this.peek(ProcessDefinitionImpl.class))) {
            ProcessDefinitionImpl process = (ProcessDefinitionImpl)obj;
            AttachmentDefinitionImpl attachment = new AttachmentDefinitionImpl(process.getUUID(), name);
            attachment.setFilePath(filePath);
            attachment.setFileName(fileName);
            process.addAttachment(attachment);
            this.push(attachment);
        }
        return this;
    }

    private ProcessBuilder addObjectData(String dataName, String dataTypeClassName, Object initialValue, String scriptingValue, Set<String> enumerationValues) {
        Misc.checkArgsNotNull(dataName, dataTypeClassName);
        if ("".equals(dataName.trim())) {
            this.problems.add(new Problem("Data name is an empty string.", "error"));
        }
        if ("".equals(dataTypeClassName.trim())) {
            this.problems.add(new Problem("Data type class name is an empty string.", "error"));
        }
        if (initialValue != null && scriptingValue != null) {
            this.problems.add(new Problem("Either the initial value or the scripting value must be set.", "error"));
        }
        if (scriptingValue != null && !Misc.isJustAGroovyExpression(scriptingValue)) {
            this.problems.add(new Problem("The scripting value must be a groovy expression.", "error"));
        }
        Object obj = this.peek(ActivityDefinitionImpl.class);
        DataFieldDefinitionImpl data = null;
        if (this.isActivity(obj)) {
            ActivityDefinitionImpl activity = (ActivityDefinitionImpl)obj;
            data = new DataFieldDefinitionImpl(activity.getProcessDefinitionUUID(), activity.getUUID(), dataName, dataTypeClassName);
            activity.addData(data);
            this.push(data);
        } else if (this.isProcess(obj)) {
            ProcessDefinitionImpl process = (ProcessDefinitionImpl)obj;
            data = new DataFieldDefinitionImpl(process.getUUID(), dataName, dataTypeClassName);
            process.addData(data);
            this.push(data);
        }
        if (initialValue != null) {
            if (!(initialValue instanceof Serializable)) {
                throw new BonitaRuntimeException("Unable to store initialValue for data: " + dataTypeClassName + ". The given initialValue must be serializable.");
            }
            Class<?> clazz = null;
            try {
                clazz = Thread.currentThread().getContextClassLoader().loadClass(dataTypeClassName);
            }
            catch (ClassNotFoundException e) {
                throw new BonitaRuntimeException("Unable to load data type class: " + dataTypeClassName);
            }
            if (!clazz.isAssignableFrom(initialValue.getClass())) {
                throw new BonitaRuntimeException("Unable to store initialValue for data: " + dataTypeClassName + ". The given initialValue does not correspond to the given data type className.");
            }
        }
        data.setInitialValue((Serializable)initialValue);
        data.setEnumerationValues(enumerationValues);
        data.setScriptingValue(scriptingValue);
        return this;
    }

    public ProcessBuilder addObjectData(String dataName, String dataTypeClassName) {
        return this.addObjectData(dataName, dataTypeClassName, null, null, null);
    }

    public ProcessBuilder addObjectData(String dataName, String dataTypeClassName, Object initialValue) {
        return this.addObjectData(dataName, dataTypeClassName, initialValue, null, null);
    }

    public ProcessBuilder addObjectData(String dataName, String dataTypeClassName, String scriptingValue) {
        return this.addObjectData(dataName, dataTypeClassName, null, scriptingValue, null);
    }

    public ProcessBuilder addGroup(String groupName) {
        Object obj;
        Misc.checkArgsNotNull(groupName);
        if ("".equals(groupName.trim())) {
            this.problems.add(new Problem("Group name is an empty string.", "error"));
        }
        if (this.isProcess(obj = this.peek(ProcessDefinitionImpl.class))) {
            ProcessDefinitionImpl process = (ProcessDefinitionImpl)obj;
            ParticipantDefinitionImpl group = new ParticipantDefinitionImpl(process.getUUID(), groupName);
            process.addGroup(group);
            this.push(group);
        } else {
            this.problems.add(new Problem("Unable to add group " + groupName + " on an object of type: " + this.getClass(obj), "error"));
        }
        return this;
    }

    public ProcessBuilder addGroupResolver(String groupResolverClassName) {
        Object obj;
        Misc.checkArgsNotNull(groupResolverClassName);
        if ("".equals(groupResolverClassName.trim())) {
            this.problems.add(new Problem("Resolver class name is an empty string.", "error"));
        }
        if (this.isParticipant(obj = this.peek(ParticipantDefinitionImpl.class))) {
            ParticipantDefinitionImpl group = (ParticipantDefinitionImpl)obj;
            ConnectorDefinitionImpl resolver = new ConnectorDefinitionImpl(groupResolverClassName);
            group.setResolver(resolver);
            ProcessDefinitionImpl process = this.getProcess();
            process.addGroup(group);
            this.push(group);
            this.push(resolver);
        } else {
            this.problems.add(new Problem("Unable to add resolver " + groupResolverClassName + " on an object of type: " + this.getClass(obj), "error"));
        }
        return this;
    }

    public ProcessBuilder addHuman(String humanName) {
        Object obj;
        Misc.checkArgsNotNull(humanName);
        if ("".equals(humanName.trim())) {
            this.problems.add(new Problem("Human name is an empty string.", "error"));
        }
        if (this.isProcess(obj = this.peek(ProcessDefinitionImpl.class))) {
            ProcessDefinitionImpl process = (ProcessDefinitionImpl)obj;
            ParticipantDefinitionImpl group = new ParticipantDefinitionImpl(process.getUUID(), humanName);
            process.addGroup(group);
            this.push(group);
        } else {
            this.problems.add(new Problem("Unable to add human " + humanName + " on an object of type: " + this.getClass(obj), "error"));
        }
        return this;
    }

    public ProcessBuilder setEventSubProcess() {
        Object obj = this.peek(ProcessDefinitionImpl.class);
        if (this.isProcess(obj)) {
            ProcessDefinitionImpl process = (ProcessDefinitionImpl)obj;
            process.setType(LightProcessDefinition.ProcessType.EVENT_SUB_PROCESS);
        } else {
            this.problems.add(new Problem("Unable to define that the process is a sub-process on an object of type: " + this.getClass(obj), "error"));
        }
        return this;
    }

    public ProcessBuilder setTransient() {
        Object obj = this.peek(DataFieldDefinitionImpl.class);
        if (this.isDataFieldDefinition(obj)) {
            DataFieldDefinitionImpl data = (DataFieldDefinitionImpl)obj;
            data.setTransient(true);
        } else {
            this.problems.add(new Problem("Unable to define as transient an object of type: " + this.getClass(obj), "error"));
        }
        return this;
    }

    public ProcessBuilder addSystemTask(String taskName) {
        Object obj;
        Misc.checkArgsNotNull(taskName);
        if ("".equals(taskName.trim())) {
            this.problems.add(new Problem("Task name is an empty string.", "error"));
        }
        if (this.isProcess(obj = this.peek(ProcessDefinitionImpl.class))) {
            ProcessDefinitionImpl process = (ProcessDefinitionImpl)obj;
            ActivityDefinitionImpl activity = ActivityDefinitionImpl.createAutomaticActivity(process.getUUID(), taskName);
            process.addActivity(activity);
            this.push(activity);
        } else {
            this.problems.add(new Problem("Unable to add system task " + taskName + " on an object of type: " + this.getClass(obj), "error"));
        }
        return this;
    }

    public ProcessBuilder addHumanTask(String taskName, String ... authorityNames) {
        Misc.checkArgsNotNull(taskName, authorityNames);
        if ("".equals(taskName.trim())) {
            this.problems.add(new Problem("Task name is an empty string.", "error"));
        }
        for (String authorityName : authorityNames) {
            if (!"".equals(authorityName.trim())) continue;
            this.problems.add(new Problem("Authority name is an empty string.", "error"));
        }
        Object obj = this.peek(ProcessDefinitionImpl.class);
        if (this.isProcess(obj)) {
            HashSet<String> groups = new HashSet<String>();
            for (String authorityName : authorityNames) {
                groups.add(authorityName);
            }
            ProcessDefinitionImpl process = (ProcessDefinitionImpl)obj;
            ActivityDefinitionImpl activity = ActivityDefinitionImpl.createHumanActivity(process.getUUID(), taskName, groups);
            process.addActivity(activity);
            this.push(activity);
        } else {
            this.problems.add(new Problem("Unable to add human task " + taskName + " on an object of type: " + this.getClass(obj), "error"));
        }
        return this;
    }

    public ProcessBuilder addEventSubProcess(String processName, String version) {
        Object obj;
        if ("".equals(processName.trim())) {
            this.problems.add(new Problem("Event sub-process name is an empty string.", "error"));
        }
        if (this.isProcess(obj = this.peek(ProcessDefinitionImpl.class))) {
            ProcessDefinitionImpl process = (ProcessDefinitionImpl)obj;
            EventProcessDefinitionImpl event = new EventProcessDefinitionImpl(processName, version);
            process.addEventSubProcess(event);
            this.push(event);
        } else {
            this.problems.add(new Problem("Unable to add an event sub process " + processName + " on an object of type: " + this.getClass(obj), "error"));
        }
        return this;
    }

    public ProcessBuilder addSubProcess(String taskName, String processName) {
        return this.addSubProcess(taskName, processName, null);
    }

    public ProcessBuilder addSubProcess(String taskName, String processName, String version) {
        Object obj;
        Misc.checkArgsNotNull(taskName);
        if ("".equals(taskName.trim())) {
            this.problems.add(new Problem("Task name is an empty string.", "error"));
        }
        if ("".equals(processName.trim())) {
            this.problems.add(new Problem("Subprocess name is an empty string.", "error"));
        }
        if (this.isProcess(obj = this.peek(ProcessDefinitionImpl.class))) {
            ProcessDefinitionImpl process = (ProcessDefinitionImpl)obj;
            ActivityDefinitionImpl activity = ActivityDefinitionImpl.createSubflowActivity(process.getUUID(), taskName, processName, version);
            process.addActivity(activity);
            this.push(activity);
        } else {
            this.problems.add(new Problem("Unable to add sub process " + taskName + " on an object of type: " + this.getClass(obj), "error"));
        }
        return this;
    }

    public ProcessBuilder addSubProcessInParameter(String parentProcessDatafieldName, String subProcessDatafieldName) {
        Object obj;
        Misc.checkArgsNotNull(parentProcessDatafieldName, subProcessDatafieldName);
        if ("".equals(parentProcessDatafieldName.trim())) {
            this.problems.add(new Problem("Parent process datafield name is an empty string.", "error"));
        }
        if ("".equals(subProcessDatafieldName.trim())) {
            this.problems.add(new Problem("Sub process datafield name is an empty string.", "error"));
        }
        if (this.isActivity(obj = this.peek(ActivityDefinitionImpl.class))) {
            ActivityDefinitionImpl activity = (ActivityDefinitionImpl)obj;
            activity.addSubflowInParameter(new SubflowParameterDefinitionImpl(parentProcessDatafieldName, subProcessDatafieldName));
        } else {
            this.problems.add(new Problem("Unable to add sub process parameter {" + parentProcessDatafieldName + ", " + subProcessDatafieldName + "} on an object of type: " + this.getClass(obj), "error"));
        }
        return this;
    }

    public ProcessBuilder addSubProcessOutParameter(String subProcessDatafieldName, String parentProcessDatafieldName) {
        Object obj;
        Misc.checkArgsNotNull(parentProcessDatafieldName, subProcessDatafieldName);
        if ("".equals(subProcessDatafieldName.trim())) {
            this.problems.add(new Problem("Sub process datafield name is an empty string.", "error"));
        }
        if ("".equals(parentProcessDatafieldName.trim())) {
            this.problems.add(new Problem("Parent process datafield name is an empty string.", "error"));
        }
        if (this.isActivity(obj = this.peek(ActivityDefinitionImpl.class))) {
            ActivityDefinitionImpl activity = (ActivityDefinitionImpl)obj;
            activity.addSubflowOutParameter(new SubflowParameterDefinitionImpl(subProcessDatafieldName, parentProcessDatafieldName));
        } else {
            this.problems.add(new Problem("Unable to add sub process parameter {" + parentProcessDatafieldName + ", " + subProcessDatafieldName + "} on an object of type: " + this.getClass(obj), "error"));
        }
        return this;
    }

    public ProcessBuilder addDecisionNode(String taskName) {
        Object obj;
        Misc.checkArgsNotNull(taskName);
        if ("".equals(taskName.trim())) {
            this.problems.add(new Problem("Task name is an empty string.", "error"));
        }
        if (this.isProcess(obj = this.peek(ProcessDefinitionImpl.class))) {
            ProcessDefinitionImpl process = (ProcessDefinitionImpl)obj;
            ActivityDefinitionImpl activity = ActivityDefinitionImpl.createAutomaticActivity(process.getUUID(), taskName);
            process.addActivity(activity);
            this.push(activity);
        } else {
            this.problems.add(new Problem("Unable to add decision node " + taskName + " on an object of type: " + this.getClass(obj), "error"));
        }
        return this;
    }

    public ProcessBuilder addDeadline(String condition, String connectorClassName) {
        return this.addDeadline(condition, connectorClassName, true);
    }

    public ProcessBuilder addDeadline(String condition, String connectorClassName, boolean throwingException) {
        Object obj;
        Misc.checkArgsNotNull(condition, connectorClassName);
        if ("".equals(condition.trim())) {
            this.problems.add(new Problem("Condition is an empty string.", "error"));
        }
        if ("".equals(connectorClassName.trim())) {
            this.problems.add(new Problem("Connector class name is an empty string.", "error"));
        }
        if (this.isActivity(obj = this.peek(ActivityDefinitionImpl.class))) {
            if (!Misc.isJustAGroovyExpression(condition)) {
                try {
                    Long.parseLong(condition);
                }
                catch (NumberFormatException e1) {
                    try {
                        DateUtil.parseDate(condition);
                    }
                    catch (IllegalArgumentException e2) {
                        this.problems.add(new Problem("deadline condition '" + condition + "' is neither a Long nor a formatted date", "error"));
                    }
                }
            }
            ActivityDefinitionImpl activity = (ActivityDefinitionImpl)obj;
            ConnectorDefinitionImpl deadline = new ConnectorDefinitionImpl(connectorClassName);
            deadline.setCondition(condition);
            deadline.setThrowingException(throwingException);
            activity.addDeadline(deadline);
            this.push(deadline);
        } else {
            this.problems.add(new Problem("Unable to add a deadline with condition " + condition + " on an object of type: " + this.getClass(obj), "error"));
        }
        return this;
    }

    public ProcessBuilder addConnector(HookDefinition.Event event, String className, boolean throwingException) {
        Object obj;
        Misc.checkArgsNotNull(new Object[]{className, event});
        if ("".equals(className.trim())) {
            this.problems.add(new Problem("Class name is an empty string.", "error"));
        }
        if (this.isActivity(obj = this.peek(ActivityDefinitionImpl.class))) {
            ActivityDefinitionImpl activity = (ActivityDefinitionImpl)obj;
            if (activity.isTimer()) {
                if (!HookDefinition.Event.onTimer.equals((Object)event)) {
                    this.problems.add(new Problem("A timer task accepts only a connector with an " + (Object)((Object)HookDefinition.Event.onTimer) + " event" + " ", "error"));
                }
            } else if (activity.isAutomatic()) {
                if (!HookDefinition.Event.automaticOnEnter.equals((Object)event) && !HookDefinition.Event.automaticOnExit.equals((Object)event)) {
                    this.problems.add(new Problem("An automatic activity accepts only a connector with an " + (Object)((Object)HookDefinition.Event.automaticOnEnter) + " or an " + (Object)((Object)HookDefinition.Event.automaticOnExit) + " event" + " ", "error"));
                }
            } else if (activity.isSubflow()) {
                if (!HookDefinition.Event.automaticOnEnter.equals((Object)event) && !HookDefinition.Event.automaticOnExit.equals((Object)event)) {
                    this.problems.add(new Problem("A sub process accepts only a connector with an " + (Object)((Object)HookDefinition.Event.automaticOnEnter) + " or an " + (Object)((Object)HookDefinition.Event.automaticOnExit) + " event" + " ", "error"));
                }
            } else if (!HookDefinition.Event.TASK_EVENTS.contains((Object)event)) {
                this.problems.add(new Problem("A human task accepts only a connector with an event of this list: " + HookDefinition.Event.TASK_EVENTS, "error"));
            }
            ConnectorDefinitionImpl connector = new ConnectorDefinitionImpl(className);
            connector.setEvent(event);
            connector.setThrowingException(throwingException);
            activity.addConnector(connector);
            this.push(connector);
        } else {
            obj = this.peek(ProcessDefinitionImpl.class);
            if (this.isProcess(obj)) {
                if (!HookDefinition.Event.PROCESS_EVENTS.contains((Object)event)) {
                    this.problems.add(new Problem("A process accepts only a connector with an event of this list: " + HookDefinition.Event.PROCESS_EVENTS, "error"));
                }
                ProcessDefinitionImpl process = (ProcessDefinitionImpl)obj;
                ConnectorDefinitionImpl connector = new ConnectorDefinitionImpl(className);
                connector.setEvent(event);
                connector.setThrowingException(throwingException);
                process.addConnector(connector);
                this.push(connector);
            } else {
                this.problems.add(new Problem("Unable to add a connector with class " + className + " on an object of type: " + this.getClass(obj), "error"));
            }
        }
        return this;
    }

    public ProcessBuilder addInputParameter(String fieldName, Object ... value) {
        Misc.checkArgsNotNull(fieldName);
        if ("".equals(fieldName.trim())) {
            this.problems.add(new Problem("Connector field name is an empty string.", "error"));
        }
        String setterName = null;
        if (fieldName.startsWith("set") || fieldName.startsWith("get") || fieldName.startsWith("is") || "file:".equals(fieldName) || "resource:".equals(fieldName) || "bar:".equals(fieldName)) {
            setterName = fieldName;
        } else {
            StringBuilder builder = new StringBuilder("set");
            builder.append(String.valueOf(fieldName.charAt(0)).toUpperCase());
            builder.append(fieldName.substring(1));
            setterName = builder.toString();
        }
        return this.setParameter(setterName, value);
    }

    @Deprecated
    public ProcessBuilder addParameter(String fieldName, Object ... value) {
        return this.addInputParameter(fieldName, value);
    }

    public ProcessBuilder addOutputParameter(String groovyExpression, String variableName) {
        Misc.checkArgsNotNull(groovyExpression, variableName);
        if ("".equals(groovyExpression.trim())) {
            this.problems.add(new Problem("Connector field name is an empty string.", "error"));
        }
        if ("".equals(variableName.trim())) {
            this.problems.add(new Problem("Connector field name is an empty string.", "error"));
        }
        if (!GroovyExpression.isGroovyExpression(groovyExpression)) {
            StringBuilder builder = new StringBuilder("${");
            builder.append(groovyExpression);
            builder.append("}");
            groovyExpression = builder.toString();
        }
        return this.setParameter(variableName, groovyExpression);
    }

    private ProcessBuilder setParameter(String setterOrGetterName, Object ... value) {
        Object obj;
        Misc.checkArgsNotNull(setterOrGetterName, value);
        if ("".equals(setterOrGetterName.trim())) {
            this.problems.add(new Problem("Setter/Getter name is an empty string.", "error"));
        }
        if (this.isConnector(obj = this.peek(ConnectorDefinitionImpl.class))) {
            ((ConnectorDefinitionImpl)obj).addParameter(setterOrGetterName, value);
        } else {
            this.problems.add(new Problem("Unable to add a parameter with field " + setterOrGetterName + " on an object of type: " + this.getClass(obj), "error"));
        }
        return this;
    }

    public ProcessBuilder addFilter(String className) {
        Object obj;
        Misc.checkArgsNotNull(className);
        if ("".equals(className.trim())) {
            this.problems.add(new Problem("Filter class name is an empty string.", "error"));
        }
        if (this.isActivity(obj = this.peek(ActivityDefinitionImpl.class))) {
            ActivityDefinitionImpl activity = (ActivityDefinitionImpl)obj;
            ConnectorDefinitionImpl filter = new ConnectorDefinitionImpl(className);
            activity.setFilter(filter);
            this.push(filter);
        } else {
            this.problems.add(new Problem("Unable to add a filter with class name " + className + " on an object of type: " + this.getClass(obj), "error"));
        }
        return this;
    }

    @Deprecated
    public ProcessBuilder addMultiInstanciation(String variableName, String className) {
        Object obj;
        Misc.checkArgsNotNull(className, variableName);
        if ("".equals(variableName.trim())) {
            this.problems.add(new Problem("Multi instantiation variable name is an empty string.", "error"));
        }
        if ("".equals(className.trim())) {
            this.problems.add(new Problem("Multi instantiation class name is an empty string.", "error"));
        }
        if (this.isActivity(obj = this.peek(ActivityDefinitionImpl.class))) {
            ActivityDefinitionImpl activity = (ActivityDefinitionImpl)obj;
            ConnectorDefinitionImpl multiInstanciation = new ConnectorDefinitionImpl(className);
            multiInstanciation.setVariableName(variableName);
            activity.setMultiInstanciation(multiInstanciation);
            this.push(multiInstanciation);
        } else {
            this.problems.add(new Problem("Unable to add a multi instantiation with variable name " + variableName + " on an object of type: " + this.getClass(obj), "error"));
        }
        return this;
    }

    public ProcessBuilder addMultipleActivitiesInstantiator(String className) {
        Object obj;
        Misc.checkArgsNotNull(className);
        if ("".equals(className.trim())) {
            this.problems.add(new Problem("Multiple Activities Instantiator class name is an empty string.", "error"));
        }
        if (this.isActivity(obj = this.peek(ActivityDefinitionImpl.class))) {
            ActivityDefinitionImpl activity = (ActivityDefinitionImpl)obj;
            ConnectorDefinitionImpl instantiator = new ConnectorDefinitionImpl(className);
            activity.setMultipleInstancesInstantiator(instantiator);
            this.push(instantiator);
        } else {
            this.problems.add(new Problem("Unable to add a multiple activities instantiatior with class name " + className + " on an object of type: " + this.getClass(obj), "error"));
        }
        return this;
    }

    public ProcessBuilder addMultipleActivitiesJoinChecker(String className) {
        Object obj;
        Misc.checkArgsNotNull(className);
        if ("".equals(className.trim())) {
            this.problems.add(new Problem("Multiple Activities Join Checker class name is an empty string.", "error"));
        }
        if (this.isActivity(obj = this.peek(ActivityDefinitionImpl.class))) {
            ActivityDefinitionImpl activity = (ActivityDefinitionImpl)obj;
            ConnectorDefinitionImpl joinChecker = new ConnectorDefinitionImpl(className);
            activity.setMultipleInstancesJoinChecker(joinChecker);
            this.push(joinChecker);
        } else {
            this.problems.add(new Problem("Unable to add a multiple activities join checker with class name " + className + " on an object of type: " + this.getClass(obj), "error"));
        }
        return this;
    }

    public ProcessBuilder asynchronous() {
        Object obj = this.peek(ActivityDefinitionImpl.class);
        if (this.isActivity(obj)) {
            ActivityDefinitionImpl activity = (ActivityDefinitionImpl)obj;
            activity.setAsynchronous(true);
        } else {
            this.problems.add(new Problem("Unable to set asynchronous on an object of type: " + this.getClass(obj), "error"));
        }
        return this;
    }

    public ProcessBuilder addJoinType(ActivityDefinition.JoinType join) {
        Misc.checkArgsNotNull(new Object[]{join});
        Object obj = this.peek(ActivityDefinitionImpl.class);
        if (this.isActivity(obj)) {
            ActivityDefinitionImpl activity = (ActivityDefinitionImpl)obj;
            activity.setJoinType(join);
        } else {
            this.problems.add(new Problem("Unable to set join type " + (Object)((Object)join) + " on an object of type: " + this.getClass(obj), "error"));
        }
        return this;
    }

    public ProcessBuilder addSplitType(ActivityDefinition.SplitType split) {
        Misc.checkArgsNotNull(new Object[]{split});
        Object obj = this.peek(ActivityDefinitionImpl.class);
        if (this.isActivity(obj)) {
            ActivityDefinitionImpl activity = (ActivityDefinitionImpl)obj;
            activity.setSplitType(split);
        } else {
            this.problems.add(new Problem("Unable to set split type " + (Object)((Object)split) + " on an object of type: " + this.getClass(obj), "error"));
        }
        return this;
    }

    public ProcessBuilder addDynamicDescription(String dynamicDescription) {
        Object obj = this.peek(ActivityDefinitionImpl.class);
        if (this.isActivity(obj)) {
            ((ActivityDefinitionImpl)obj).setDynamicDescription(dynamicDescription);
        } else {
            this.problems.add(new Problem("Unable to set dynamicDescription " + dynamicDescription + " on an object of type: " + this.getClass(obj), "error"));
        }
        return this;
    }

    public ProcessBuilder addDynamicLabel(String dynamicLabel) {
        Object obj = this.peek(ActivityDefinitionImpl.class);
        if (this.isActivity(obj)) {
            ((ActivityDefinitionImpl)obj).setDynamicLabel(dynamicLabel);
        } else {
            this.problems.add(new Problem("Unable to set dynamicLabel " + dynamicLabel + " on an object of type: " + this.getClass(obj), "error"));
        }
        return this;
    }

    public ProcessBuilder addDynamicExecutionSummary(String expression) {
        Object obj = this.peek(ActivityDefinitionImpl.class);
        if (this.isActivity(obj)) {
            ((ActivityDefinitionImpl)obj).setDynamicExecutionSummary(expression);
        } else {
            this.problems.add(new Problem("Unable to set the dynamic execution summary " + expression + " on an object of type: " + this.getClass(obj), "error"));
        }
        return this;
    }

    public ProcessBuilder addCategory(String category) {
        Object obj;
        Misc.checkArgsNotNull(category);
        if ("".equals(category.trim())) {
            this.problems.add(new Problem("Category name is an empty string.", "error"));
        }
        if (this.isProcess(obj = this.peek(ProcessDefinitionImpl.class))) {
            ProcessDefinitionImpl process = (ProcessDefinitionImpl)obj;
            process.addCategory(category);
        } else {
            this.problems.add(new Problem("Unable to add category " + category + " on an object of type: " + this.getClass(obj), "error"));
        }
        return this;
    }

    public ProcessBuilder addTimerTask(String taskName, String condition) {
        Object obj;
        Misc.checkArgsNotNull(taskName);
        if ("".equals(taskName.trim())) {
            this.problems.add(new Problem("Task name is an empty string.", "error"));
        }
        if ("".equals(condition.trim())) {
            this.problems.add(new Problem("Timer condition name is an empty string.", "error"));
        }
        if (this.isProcess(obj = this.peek(ProcessDefinitionImpl.class))) {
            ProcessDefinitionImpl process = (ProcessDefinitionImpl)obj;
            ActivityDefinitionImpl activity = ActivityDefinitionImpl.createTimerActivity(process.getUUID(), taskName, condition);
            process.addActivity(activity);
            this.push(activity);
        } else {
            this.problems.add(new Problem("Unable to add timer task " + taskName + " on an object of type: " + this.getClass(obj), "error"));
        }
        return this;
    }

    public ProcessBuilder addReceiveEventTask(String taskName, String eventName) {
        return this.addReceiveEventTask(taskName, eventName, null);
    }

    @Deprecated
    public ProcessBuilder addReceiveEventTask(String taskName, String eventName, String expression) {
        Object obj;
        Misc.checkArgsNotNull(taskName);
        if ("".equals(taskName.trim())) {
            this.problems.add(new Problem("Task name is an empty string.", "error"));
        }
        if ("".equals(eventName.trim())) {
            this.problems.add(new Problem("Event name is an empty string.", "error"));
        }
        if (expression != null && "".equals(expression.trim())) {
            this.problems.add(new Problem("Expression is an empty string.", "error"));
        }
        if (this.isProcess(obj = this.peek(ProcessDefinitionImpl.class))) {
            ProcessDefinitionImpl process = (ProcessDefinitionImpl)obj;
            ActivityDefinitionImpl activity = ActivityDefinitionImpl.createReceiveEventActivity(process.getUUID(), taskName, eventName, expression);
            process.addActivity(activity);
            this.push(activity);
        } else {
            this.problems.add(new Problem("Unable to add receive event task " + taskName + " on an object of type: " + this.getClass(obj), "error"));
        }
        return this;
    }

    public ProcessBuilder addReceiveEventConnector(String className, boolean throwingException) {
        Object obj;
        Misc.checkArgsNotNull(className);
        if ("".equals(className.trim())) {
            this.problems.add(new Problem("Class name is an empty string.", "error"));
        }
        if (this.isActivity(obj = this.peek(ActivityDefinitionImpl.class))) {
            ActivityDefinitionImpl activity = (ActivityDefinitionImpl)obj;
            ConnectorDefinitionImpl connector = new ConnectorDefinitionImpl(className);
            connector.setEvent(HookDefinition.Event.onEvent);
            connector.setThrowingException(throwingException);
            activity.addConnector(connector);
            this.push(connector);
        } else {
            this.problems.add(new Problem("Unable to add an event connector with class " + className + " on an object of type: " + this.getClass(obj), "error"));
        }
        return this;
    }

    public ProcessBuilder throwCatchError(String errorCode) {
        Object obj;
        Misc.checkArgsNotNull(errorCode);
        if ("".equals(errorCode.trim())) {
            this.problems.add(new Problem("Connector errorCode is an empty string.", "error"));
        }
        if (this.isConnector(obj = this.peek(ConnectorDefinitionImpl.class))) {
            ((ConnectorDefinitionImpl)obj).setErrorCode(errorCode);
        } else {
            this.problems.add(new Problem("Unable to add an errorCode: " + errorCode + " on an object of type: " + this.getClass(obj), "error"));
        }
        return this;
    }

    public ProcessBuilder addErrorEventTask(String eventName, String errorCode) {
        Object obj;
        Misc.checkArgsNotNull(eventName, errorCode);
        if ("".equals(eventName.trim())) {
            this.problems.add(new Problem("Event name is an empty string.", "error"));
        }
        if ("".equals(errorCode.trim())) {
            this.problems.add(new Problem("Error code is an empty string.", "error"));
        }
        if (this.isProcess(obj = this.peek(ProcessDefinitionImpl.class))) {
            ProcessDefinitionImpl process = (ProcessDefinitionImpl)obj;
            ActivityDefinitionImpl activity = ActivityDefinitionImpl.createErrorEventActivity(process.getUUID(), eventName, errorCode);
            process.addActivity(activity);
            this.push(activity);
        } else {
            this.problems.add(new Problem("Unable to add an error event task " + eventName + " on an object of type: " + this.getClass(obj), "error"));
        }
        return this;
    }

    public ProcessBuilder addSignalEventTask(String eventName, String signalCode) {
        return this.addSignalEventTask(eventName, signalCode, false);
    }

    public ProcessBuilder addSignalEventTask(String eventName, String signalCode, boolean catchEvent) {
        Object obj;
        Misc.checkArgsNotNull(eventName, signalCode);
        if ("".equals(eventName.trim())) {
            this.problems.add(new Problem("Event name is an empty string.", "error"));
        }
        if ("".equals(signalCode.trim())) {
            this.problems.add(new Problem("Signal code is an empty string.", "error"));
        }
        if (this.isProcess(obj = this.peek(ProcessDefinitionImpl.class))) {
            ProcessDefinitionImpl process = (ProcessDefinitionImpl)obj;
            ActivityDefinitionImpl activity = ActivityDefinitionImpl.createSignalEventActivity(process.getUUID(), eventName, signalCode);
            activity.setCatchEvent(catchEvent);
            process.addActivity(activity);
            this.push(activity);
        } else {
            this.problems.add(new Problem("Unable to add an error event task " + eventName + " on an object of type: " + this.getClass(obj), "error"));
        }
        return this;
    }

    public ProcessBuilder addSignalBoundaryEvent(String eventName, String signalCode) {
        Object obj;
        Misc.checkArgsNotNull(eventName);
        if ("".equals(eventName.trim())) {
            this.problems.add(new Problem("Event name is an empty string.", "error"));
        }
        if (signalCode != null && "".equals(signalCode.trim())) {
            this.problems.add(new Problem("Expression is an empty string.", "error"));
        }
        if (this.isActivity(obj = this.peek(ActivityDefinitionImpl.class))) {
            ActivityDefinitionImpl activity = (ActivityDefinitionImpl)obj;
            if (this.canAddBoundaryEvent(activity, "signal")) {
                SignalBoundaryEventImpl message = new SignalBoundaryEventImpl(eventName, activity.getProcessDefinitionUUID(), activity.getUUID(), null, signalCode);
                activity.addBoundaryEvent(message);
                this.push(message);
            } else {
                this.problems.add(new Problem("Unable to add a boundary message event on an activity of type: " + (Object)((Object)activity.getType()), "error"));
            }
        } else {
            this.problems.add(new Problem("Unable to add a boundary message event on an object of type: " + this.getClass(obj), "error"));
        }
        return this;
    }

    private EventDefinitionImpl getEventDefinition(String name) {
        Object obj = this.stack.peek();
        if (this.isActivity(obj)) {
            ActivityDefinitionImpl activity = (ActivityDefinitionImpl)obj;
            if (activity.isReceiveEvent()) {
                IncomingEventDefinition incomingEvent = activity.getIncomingEvent();
                if (incomingEvent.getExpression() != null) {
                    this.problems.add(new Problem("A correlation key cannot be added when an expression is set.", "error"));
                }
                return (IncomingEventDefinitionImpl)incomingEvent;
            }
            if (activity.isSendEvents()) {
                return this.outgoingEvent;
            }
            this.problems.add(new Problem("Unable to add a correlation key " + name + " on an object of type: " + this.getClass(obj), "error"));
        } else {
            this.problems.add(new Problem("Unable to add a correlation key " + name + " on an object of type: " + this.getClass(obj), "error"));
        }
        return null;
    }

    private MessageBoundaryEventImpl getMessageBoundaryEvent(String name) {
        Object obj = this.stack.peek();
        if (this.isMessageBoundaryEvent(obj)) {
            MessageBoundaryEventImpl messageEvent = (MessageBoundaryEventImpl)obj;
            if (messageEvent.getExpression() != null) {
                this.problems.add(new Problem("A correlation key cannot be added when an expression is set.", "error"));
            }
            return messageEvent;
        }
        return null;
    }

    public ProcessBuilder addMessageCorrelationKey(String name, String expression) {
        MessageBoundaryEventImpl messageEvent;
        Misc.checkArgsNotNull(name, expression);
        if ("".equals(name.trim())) {
            this.problems.add(new Problem("Correlation key name is an empty string.", "error"));
        }
        if ((messageEvent = this.getMessageBoundaryEvent(name)) != null) {
            if (messageEvent.getCorrelationKeyName1() == null) {
                messageEvent.setCorrelationKey1(name, expression);
            } else if (messageEvent.getCorrelationKeyName2() == null) {
                messageEvent.setCorrelationKey2(name, expression);
            } else if (messageEvent.getCorrelationKeyName3() == null) {
                messageEvent.setCorrelationKey3(name, expression);
            } else if (messageEvent.getCorrelationKeyName4() == null) {
                messageEvent.setCorrelationKey4(name, expression);
            } else if (messageEvent.getCorrelationKeyName5() == null) {
                messageEvent.setCorrelationKey5(name, expression);
            } else {
                this.problems.add(new Problem("5 Correlation keys are already set on " + messageEvent.getName(), "error"));
            }
        } else {
            EventDefinitionImpl event = this.getEventDefinition(name);
            if (event.getCorrelationKeyName1() == null) {
                event.setCorrelationKey1(name, expression);
            } else if (event.getCorrelationKeyName2() == null) {
                event.setCorrelationKey2(name, expression);
            } else if (event.getCorrelationKeyName3() == null) {
                event.setCorrelationKey3(name, expression);
            } else if (event.getCorrelationKeyName4() == null) {
                event.setCorrelationKey4(name, expression);
            } else if (event.getCorrelationKeyName5() == null) {
                event.setCorrelationKey5(name, expression);
            } else {
                this.problems.add(new Problem("5 Correlation keys are already set on " + event.getName(), "error"));
            }
        }
        return this;
    }

    public ProcessBuilder addSendEventTask(String taskName) {
        Object obj;
        Misc.checkArgsNotNull(taskName);
        if ("".equals(taskName.trim())) {
            this.problems.add(new Problem("Task name is an empty string.", "error"));
        }
        if (this.isProcess(obj = this.peek(ProcessDefinitionImpl.class))) {
            ProcessDefinitionImpl process = (ProcessDefinitionImpl)obj;
            ActivityDefinitionImpl activity = ActivityDefinitionImpl.createSendEventActivity(process.getUUID(), taskName);
            process.addActivity(activity);
            this.push(activity);
        } else {
            this.problems.add(new Problem("Unable to add send event task " + taskName + " on an object of type: " + this.getClass(obj), "error"));
        }
        return this;
    }

    public ProcessBuilder addOutgoingEvent(String eventName) {
        return this.addOutgoingEvent(eventName, null);
    }

    public ProcessBuilder addOutgoingEvent(String eventName, String destProcessName) {
        return this.addOutgoingEvent(eventName, destProcessName, null);
    }

    public ProcessBuilder addOutgoingEvent(String eventName, String destProcessName, String destActivityName) {
        return this.addOutgoingEvent(eventName, destProcessName, destActivityName, null);
    }

    public ProcessBuilder addOutgoingEvent(String eventName, String destProcessName, String destActivityName, Map<String, Object> parameters) {
        return this.addOutgoingEvent(eventName, destProcessName, destActivityName, -1L, parameters);
    }

    public ProcessBuilder addOutgoingEvent(String eventName, String destProcessName, String destActivityName, long timeToLive, Map<String, Object> parameters) {
        Object obj;
        Misc.checkArgsNotNull(eventName);
        if ("".equals(eventName.trim())) {
            this.problems.add(new Problem("Event name is an empty string.", "error"));
        }
        if (destProcessName != null && "".equals(destProcessName.trim())) {
            this.problems.add(new Problem("Dest process name is an empty string.", "error"));
        }
        if (destActivityName != null && "".equals(destActivityName.trim())) {
            this.problems.add(new Problem("Dest activity name is an empty string.", "error"));
        }
        if (this.isActivity(obj = this.peek(ActivityDefinitionImpl.class))) {
            ActivityDefinitionImpl activity = (ActivityDefinitionImpl)obj;
            OutgoingEventDefinitionImpl outgoingEvent = new OutgoingEventDefinitionImpl(eventName, destProcessName, destActivityName, parameters, timeToLive);
            activity.addOutgoingEvent(outgoingEvent);
            this.outgoingEvent = outgoingEvent;
        } else {
            this.problems.add(new Problem("Unable to add outgoing event " + eventName + " on an object of type: " + this.getClass(obj), "error"));
        }
        return this;
    }

    public ProcessBuilder addTerminateEndEvent(String eventName) {
        Object obj;
        Misc.checkArgsNotNull(eventName);
        if ("".equals(eventName.trim())) {
            this.problems.add(new Problem("Event name is an empty string.", "error"));
        }
        if (this.isProcess(obj = this.peek(ProcessDefinitionImpl.class))) {
            ProcessDefinitionImpl process = (ProcessDefinitionImpl)obj;
            ActivityDefinitionImpl activity = ActivityDefinitionImpl.createAutomaticActivity(process.getUUID(), eventName);
            activity.setTerminateProcess(true);
            process.addActivity(activity);
            this.push(activity);
        } else {
            this.problems.add(new Problem("Unable to add terminate end event " + eventName + " on an object of type: " + this.getClass(obj), "error"));
        }
        return this;
    }

    public ProcessBuilder addActivityExecutingTime(long executingTime) {
        Object obj;
        if (executingTime < 1000L) {
            this.problems.add(new Problem("The executing time cannot be less than one second.", "error"));
        }
        if (this.isActivity(obj = this.peek(ActivityDefinitionImpl.class))) {
            ActivityDefinitionImpl activity = (ActivityDefinitionImpl)obj;
            activity.setExecutingTime(executingTime);
        } else {
            this.problems.add(new Problem("Unable to set an executing time on an object of type: " + this.getClass(obj), "error"));
        }
        return this;
    }

    public ProcessBuilder addActivityPriority(int priority) {
        Object obj = this.peek(ActivityDefinitionImpl.class);
        if (this.isActivity(obj)) {
            ActivityDefinitionImpl activity = (ActivityDefinitionImpl)obj;
            activity.setPriority(priority);
        } else {
            this.problems.add(new Problem("Unable to set a priority on an object of type: " + this.getClass(obj), "error"));
        }
        return this;
    }

    public ProcessBuilder addLoop(String condition, boolean beforeExecution) {
        return this.addLoop(condition, beforeExecution, null);
    }

    public ProcessBuilder addLoop(String condition, boolean beforeExecution, String loopMaximum) {
        Object obj;
        Misc.checkArgsNotNull(condition);
        if ("".equals(condition.trim())) {
            this.problems.add(new Problem("Condition expression is an empty string.", "error"));
        }
        if (this.isActivity(obj = this.peek(ActivityDefinitionImpl.class))) {
            ActivityDefinitionImpl activity = (ActivityDefinitionImpl)obj;
            activity.setLoop(condition, beforeExecution, loopMaximum);
        } else {
            this.problems.add(new Problem("Unable to set a loop on an object of type: " + this.getClass(obj), "error"));
        }
        return this;
    }

    public ProcessBuilder addTimerBoundaryEvent(String eventName, String condition) {
        Misc.checkArgsNotNull(eventName, condition);
        Object obj = this.peek(ActivityDefinitionImpl.class);
        if (this.isActivity(obj)) {
            ActivityDefinitionImpl activity = (ActivityDefinitionImpl)obj;
            if (this.canAddBoundaryEvent(activity, "timer")) {
                TimerBoundaryEventImpl timer = new TimerBoundaryEventImpl(eventName, activity.getProcessDefinitionUUID(), activity.getUUID(), null, condition);
                activity.addBoundaryEvent(timer);
                this.push(timer);
            } else {
                this.problems.add(new Problem("Unable to add a boundary timer event on an activity of type: " + (Object)((Object)activity.getType()), "error"));
            }
        } else {
            this.problems.add(new Problem("Unable to add a boundary timer event on an object of type: " + this.getClass(obj), "error"));
        }
        return this;
    }

    public ProcessBuilder addMessageBoundaryEvent(String eventName, String expression) {
        Object obj;
        Misc.checkArgsNotNull(eventName);
        if ("".equals(eventName.trim())) {
            this.problems.add(new Problem("Event name is an empty string.", "error"));
        }
        if (expression != null && "".equals(expression.trim())) {
            this.problems.add(new Problem("Expression is an empty string.", "error"));
        }
        if (this.isActivity(obj = this.peek(ActivityDefinitionImpl.class))) {
            ActivityDefinitionImpl activity = (ActivityDefinitionImpl)obj;
            if (this.canAddBoundaryEvent(activity, "message")) {
                MessageBoundaryEventImpl message = new MessageBoundaryEventImpl(eventName, activity.getProcessDefinitionUUID(), activity.getUUID(), null, expression);
                activity.addBoundaryEvent(message);
                this.push(message);
            } else {
                this.problems.add(new Problem("Unable to add a boundary message event on an activity of type: " + (Object)((Object)activity.getType()), "error"));
            }
        } else {
            this.problems.add(new Problem("Unable to add a boundary message event on an object of type: " + this.getClass(obj), "error"));
        }
        return this;
    }

    public ProcessBuilder addErrorBoundaryEvent(String eventName) {
        return this.addErrorBoundaryEvent(eventName, null);
    }

    public ProcessBuilder addErrorBoundaryEvent(String eventName, String errorCode) {
        Object obj;
        Misc.checkArgsNotNull(eventName);
        if ("".equals(eventName.trim())) {
            this.problems.add(new Problem("Event name is an empty string.", "error"));
        }
        if (errorCode != null && "".equals(errorCode.trim())) {
            this.problems.add(new Problem("Expression is an empty string.", "error"));
        }
        if (this.isActivity(obj = this.peek(ActivityDefinitionImpl.class))) {
            ActivityDefinitionImpl activity = (ActivityDefinitionImpl)obj;
            if (this.canAddBoundaryEvent(activity, "error")) {
                ErrorBoundaryEventImpl error = new ErrorBoundaryEventImpl(eventName, activity.getProcessDefinitionUUID(), activity.getUUID(), null, errorCode);
                activity.addBoundaryEvent(error);
                this.push(error);
            } else {
                this.problems.add(new Problem("Unable to add a boundary message event on an object of type: " + (Object)((Object)activity.getType()), "error"));
            }
        } else {
            this.problems.add(new Problem("Unable to add a boundary message event on an object of type: " + this.getClass(obj), "error"));
        }
        return this;
    }

    public ProcessBuilder addTransition(String fromActivityName, String toActivityName) {
        return this.addTransition(fromActivityName + "__" + toActivityName, fromActivityName, toActivityName);
    }

    public ProcessBuilder addExceptionTransition(String fromActivityName, String boundaryEventName, String toActivityName) {
        Misc.checkArgsNotNull(boundaryEventName);
        return this.addTransition(fromActivityName + "__" + boundaryEventName + "__" + toActivityName, fromActivityName, boundaryEventName, toActivityName);
    }

    public ProcessBuilder addTransition(String transitionName, String fromActivityName, String toActivityName) {
        return this.addTransition(transitionName, fromActivityName, null, toActivityName);
    }

    private ProcessBuilder addTransition(String transitionName, String fromActivityName, String boundaryEventName, String toActivityName) {
        Object obj;
        Misc.checkArgsNotNull(transitionName, fromActivityName, toActivityName);
        if ("".equals(transitionName.trim())) {
            this.problems.add(new Problem("Transition name is an empty string.", "error"));
        }
        if (fromActivityName == null) {
            this.problems.add(new Problem("From attribute is not defined on transition: " + transitionName, "error"));
        } else if ("".equals(fromActivityName.trim())) {
            this.problems.add(new Problem("Transition from activity name is an empty string.", "error"));
        }
        if (toActivityName == null) {
            this.problems.add(new Problem("To attribute is not defined on transition: " + transitionName, "error"));
        } else if ("".equals(toActivityName.trim())) {
            this.problems.add(new Problem("Transition to activity name is an empty string.", "error"));
        }
        if (boundaryEventName != null && "".equals(boundaryEventName.trim())) {
            this.problems.add(new Problem("The name of the boundary event is an empty string.", "error"));
        }
        if (this.isProcess(obj = this.peek(ProcessDefinitionImpl.class))) {
            ProcessDefinitionImpl process = (ProcessDefinitionImpl)obj;
            ActivityDefinition fromActivity = process.getActivity(fromActivityName);
            BoundaryEvent event = null;
            if (fromActivity != null && boundaryEventName != null) {
                event = fromActivity.getBoundaryEvent(boundaryEventName);
            }
            ActivityDefinition toActivity = process.getActivity(toActivityName);
            if (fromActivity == null) {
                this.problems.add(new Problem("Unable to add transition from " + fromActivityName + " to " + toActivityName + ". From activity does not exists", "error"));
            } else if (toActivity == null) {
                this.problems.add(new Problem("Unable to add transition from " + fromActivityName + " to " + toActivityName + ". To activity does not exists", "error"));
            } else if (boundaryEventName != null && event == null) {
                this.problems.add(new Problem("Unable to add an exception transition from " + fromActivityName + ", boundary event: " + boundaryEventName + " to " + toActivityName + ". Boundary event does not exists", "error"));
            } else {
                TransitionDefinitionImpl transition = new TransitionDefinitionImpl(process.getUUID(), transitionName, fromActivityName, toActivityName);
                ((ActivityDefinitionImpl)toActivity).addIncomingTransition(transition);
                if (boundaryEventName != null) {
                    transition.setFromBoundaryEvent(boundaryEventName);
                    ((ActivityDefinitionImpl)fromActivity).addExceptionTransition(boundaryEventName, transition);
                } else {
                    ((ActivityDefinitionImpl)fromActivity).addOutgoingTransition(transition);
                }
                this.push(transition);
            }
        } else {
            this.problems.add(new Problem("Unable to add transition " + transitionName + " on an object of type: " + this.getClass(obj), "error"));
        }
        return this;
    }

    public ProcessBuilder setDefault() {
        Object obj = this.peek(TransitionDefinitionImpl.class);
        if (this.isTransition(obj)) {
            TransitionDefinitionImpl transition = (TransitionDefinitionImpl)obj;
            if (transition.getFromBoundaryEvent() != null) {
                this.problems.add(new Problem("Unable to set the default exception transition '" + transition.getName() + "' as a default transition", "error"));
            }
            transition.setDefault(true);
        } else {
            this.problems.add(new Problem("Unable to set default transition on an object of type: " + this.getClass(obj), "error"));
        }
        return this;
    }

    public ProcessBuilder addCondition(String expression) {
        Object obj;
        Misc.checkArgsNotNull(expression);
        if ("".equals(expression.trim())) {
            this.problems.add(new Problem("Condition expression is an empty string.", "error"));
        }
        if (this.isTransition(obj = this.peek(TransitionDefinitionImpl.class))) {
            TransitionDefinitionImpl transition = (TransitionDefinitionImpl)obj;
            if (transition.getFromBoundaryEvent() != null) {
                this.problems.add(new Problem("Unable to set condition " + expression + " on the exception transition: " + transition.getName(), "error"));
            }
            transition.setCondition(expression);
        } else {
            this.problems.add(new Problem("Unable to set condition " + expression + " on an object of type: " + this.getClass(obj), "error"));
        }
        return this;
    }

    public ProcessDefinition done() {
        ProcessDefinitionImpl process = (ProcessDefinitionImpl)this.stack.get(0);
        this.checkNames();
        this.checkStartEvents(process);
        this.checkEventSubProcess(process);
        this.checkDefaultTransitions(process);
        this.checkExceptionsTransitions(process);
        this.checkMultiInstantiation(process);
        this.checkTransientVariables();
        Misc.showProblems(this.problems, "process builder");
        this.setSubProcesses(process);
        return process;
    }

    private void checkStartEvents(ProcessDefinitionImpl process) {
        for (ActivityDefinition activity : process.getActivities()) {
            if (activity.getIncomingTransitions().size() != 0) continue;
            if (activity.isThrowingSignalEvent()) {
                this.problems.add(new Problem("Process " + process.getName() + " cannot start with a throw signal event", "error"));
                continue;
            }
            if (activity.isThrowingSignalEvent()) {
                this.problems.add(new Problem("Process " + process.getName() + " cannot start with a throw error event", "error"));
                continue;
            }
            if (!activity.isCatchingErrorEvent() || !LightProcessDefinition.ProcessType.PROCESS.equals((Object)process.getType())) continue;
            this.problems.add(new Problem("Process " + process.getName() + " cannot start with a catch error event because it is not an event sub-process.", "error"));
        }
    }

    private void setSubProcesses(ProcessDefinitionImpl process) {
        HashSet<String> subProcesses = new HashSet<String>();
        for (ActivityDefinition activity : process.getActivities()) {
            if (!activity.isSubflow()) continue;
            subProcesses.add(activity.getSubflowProcessName());
        }
        if (!subProcesses.isEmpty()) {
            process.setSubProcesses(subProcesses);
        }
    }

    private void checkEventSubProcess(ProcessDefinitionImpl process) {
        if (LightProcessDefinition.ProcessType.EVENT_SUB_PROCESS.equals((Object)process.getType())) {
            for (ActivityDefinition activity : process.getActivities()) {
                if (activity.getIncomingTransitions().size() != 0 || activity.isTimer() || activity.isCatchingSignalEvent() || activity.isReceiveEvent() || activity.isCatchingErrorEvent()) continue;
                this.problems.add(new Problem("Process " + process.getName() + " must not begin with a \"none\" start event", "error"));
            }
        }
    }

    private void checkDefaultTransitions(ProcessDefinitionImpl process) {
        for (ActivityDefinition activity : process.getActivities()) {
            boolean hasDefault = false;
            Set<TransitionDefinition> outgoingTransitions = activity.getOutgoingTransitions();
            if (outgoingTransitions.isEmpty()) continue;
            for (TransitionDefinition tr : activity.getOutgoingTransitions()) {
                if (!tr.isDefault()) continue;
                if (hasDefault) {
                    this.problems.add(new Problem("Activity " + activity.getName() + " has multiple default outgoing transitions", "error"));
                }
                if (tr.getCondition() != null) {
                    this.problems.add(new Problem("Activity " + activity.getName() + " has a default condition with a condition:" + tr.getName(), "error"));
                }
                hasDefault = true;
            }
        }
    }

    private void checkExceptionsTransitions(ProcessDefinitionImpl process) {
        for (ActivityDefinition activity : process.getActivities()) {
            List<BoundaryEvent> boundaryEvents = activity.getBoundaryEvents();
            for (BoundaryEvent boundaryEvent : boundaryEvents) {
                if (boundaryEvent.getTransition() != null) continue;
                this.problems.add(new Problem("The boundary event '" + boundaryEvent.getName() + "' on activity '" + activity.getName() + "' must have an exception transition", "error"));
            }
        }
    }

    private void checkMultiInstantiation(ProcessDefinitionImpl process) {
        for (ActivityDefinition activity : process.getActivities()) {
            MultiInstantiationDefinition multiInstantiationDefinition = activity.getMultiInstantiationDefinition();
            MultiInstantiationDefinition instantiator = activity.getMultipleInstancesInstantiator();
            MultiInstantiationDefinition joinChecker = activity.getMultipleInstancesJoinChecker();
            if (instantiator == null && joinChecker == null && multiInstantiationDefinition == null) continue;
            if (multiInstantiationDefinition != null) {
                String variableId = multiInstantiationDefinition.getVariableName();
                boolean variableExists = false;
                if (activity.getDataFields() != null) {
                    for (DataFieldDefinition var : activity.getDataFields()) {
                        if (!var.getName().equals(variableId)) continue;
                        variableExists = true;
                        break;
                    }
                }
                if (variableExists) continue;
                this.problems.add(new Problem("MultiInstantiation variable " + variableId + " must be a local variable of activity " + activity.getName(), "error"));
                continue;
            }
            if (instantiator != null && joinChecker == null) {
                this.problems.add(new Problem("JoinChecker is undefined", "error"));
                continue;
            }
            if (instantiator != null || joinChecker == null) continue;
            this.problems.add(new Problem("Instantiator is undefined", "error"));
        }
    }

    private boolean isConnector(Object obj) {
        return obj instanceof ConnectorDefinitionImpl;
    }

    private boolean isDescriptionElement(Object obj) {
        return obj instanceof DescriptionElementImpl;
    }

    private boolean isNamedElement(Object obj) {
        return obj instanceof NamedElementImpl;
    }

    private boolean isActivity(Object obj) {
        return obj instanceof ActivityDefinitionImpl;
    }

    private boolean isMessageBoundaryEvent(Object obj) {
        return obj instanceof MessageBoundaryEventImpl;
    }

    private boolean isProcess(Object obj) {
        return obj instanceof ProcessDefinitionImpl;
    }

    private boolean isParticipant(Object obj) {
        return obj instanceof ParticipantDefinitionImpl;
    }

    private boolean isTransition(Object obj) {
        return obj instanceof TransitionDefinitionImpl;
    }

    private boolean isDataFieldDefinition(Object obj) {
        return obj instanceof DataFieldDefinitionImpl;
    }

    private ProcessDefinitionImpl getProcess() {
        return (ProcessDefinitionImpl)this.stack.get(0);
    }

    private void push(Object obj) {
        this.stack.push(obj);
    }

    private Object peek(Class<?> clazz) {
        Misc.checkArgsNotNull(clazz);
        while (this.stack.size() > 1) {
            if (clazz.isAssignableFrom(this.stack.peek().getClass())) {
                return this.stack.peek();
            }
            this.stack.pop();
        }
        return this.stack.peek();
    }

    private String getClass(Object obj) {
        if (obj == null) {
            return null;
        }
        Class<?> clazz = obj.getClass();
        Class<?>[] itf = clazz.getInterfaces();
        if (itf == null || itf.length == 0) {
            return clazz.toString();
        }
        return itf[0].getName();
    }

    private void checkNames() {
        Set<ActivityDefinition> activities;
        Set<TransitionDefinition> transitions;
        Map<String, AttachmentDefinition> attachments;
        ProcessDefinitionImpl definition = (ProcessDefinitionImpl)this.stack.get(0);
        Set<ParticipantDefinition> groups = definition.getParticipants();
        if (groups != null) {
            ArrayList<String> groupNames = new ArrayList<String>();
            for (ParticipantDefinition group : groups) {
                String groupName = group.getName();
                if (groupNames.contains(groupName)) {
                    this.problems.add(new Problem("Impossible to have more than one group/human with the name: " + groupName, "error"));
                    continue;
                }
                groupNames.add(groupName);
            }
        }
        Set<DataFieldDefinition> processDataFields = definition.getDataFields();
        ArrayList<String> dataFieldNames = new ArrayList<String>();
        if (processDataFields != null) {
            for (DataFieldDefinition datafield : processDataFields) {
                String dataFieldName = datafield.getName();
                if (dataFieldNames.contains(dataFieldName)) {
                    this.problems.add(new Problem("Impossible to have more than one data with the name: " + dataFieldName, "error"));
                    continue;
                }
                dataFieldNames.add(dataFieldName);
            }
        }
        if ((attachments = definition.getAttachments()) != null) {
            for (String attachmentName : attachments.keySet()) {
                if (!dataFieldNames.contains(attachmentName)) continue;
                this.problems.add(new Problem("Impossible to have data and an attachment with the same name: " + attachmentName, "error"));
            }
        }
        if ((transitions = definition.getTransitions()) != null) {
            ArrayList<String> transitionNames = new ArrayList<String>();
            for (TransitionDefinition transition : transitions) {
                String transitionName = transition.getName();
                if (transitionNames.contains(transitionName)) {
                    this.problems.add(new Problem("Impossible to have more than one transition with the name: " + transitionName, "error"));
                    continue;
                }
                transitionNames.add(transitionName);
            }
        }
        if ((activities = definition.getActivities()) != null) {
            ArrayList<String> activityNames = new ArrayList<String>();
            for (ActivityDefinition activity : activities) {
                String activityName = activity.getName();
                if (activityNames.contains(activityName)) {
                    this.problems.add(new Problem("Impossible to have more than one activity with the name: " + activityName, "error"));
                } else {
                    activityNames.add(activityName);
                }
                Set<DataFieldDefinition> activityDataFields = activity.getDataFields();
                if (activityDataFields != null) {
                    ArrayList<String> activityDataNames = new ArrayList<String>();
                    for (DataFieldDefinition activityDataField : activityDataFields) {
                        String activityDataName = activityDataField.getName();
                        if (activityDataNames.contains(activityDataName)) {
                            this.problems.add(new Problem("Impossible to have more than one data with name:" + activityDataName + " in the same activity", "error"));
                            continue;
                        }
                        activityDataNames.add(activityDataName);
                    }
                }
                List<BoundaryEvent> events = activity.getBoundaryEvents();
                for (BoundaryEvent boundaryEvent : events) {
                    if (boundaryEvent.getTransition() != null) continue;
                    this.problems.add(new Problem("The boundary event " + boundaryEvent + " must have an outgoing transition in activity " + activityName + ".", "error"));
                }
                if (activity.isTerminateProcess() && !activity.getOutgoingTransitions().isEmpty()) {
                    this.problems.add(new Problem("The activity " + activityName + " cannot terminate a process with outgoing transitions", "error"));
                }
                if (!activity.isSendEvents() || !activity.getOutgoingEvents().isEmpty()) continue;
                this.problems.add(new Problem("The send message event " + activityName + " must throw at least a message", "error"));
            }
        }
    }

    private void checkTransientVariables() {
        ProcessDefinitionImpl definition = (ProcessDefinitionImpl)this.stack.get(0);
        for (DataFieldDefinition data : definition.getDataFields()) {
            if (!data.isTransient()) continue;
            this.problems.add(new Problem("The process variable " + data.getName() + " cannot be setted as transient. Only activity variables can be transient.", "error"));
        }
    }

    public static ProcessDefinition createProcessFromXmlDefFile(URL xmlDefUrl, Properties context) {
        Parse parse = new XmlDefParser().createParse();
        parse.setContextProperties(context);
        File file = null;
        try {
            InputStream in = xmlDefUrl.openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            String line = null;
            file = Misc.createTempFile("tempProcessDef", ".xml", new File(BonitaConstants.getTemporaryFolder()));
            FileOutputStream fos = new FileOutputStream(file);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)bos, "UTF-8");
            String productVersionTag = "<process-definition product-version=\"";
            String productVersion = null;
            while ((line = reader.readLine()) != null) {
                if (line.contains("<process-definition product-version=\"")) {
                    int startIndex = line.indexOf("<process-definition product-version=\"") + "<process-definition product-version=\"".length();
                    int lastIndex = line.indexOf("\">");
                    productVersion = line.substring(startIndex, lastIndex);
                }
                line = ProcessBuilder.resolveWithContext(line, context);
                out.write(line);
            }
            Misc.close(reader);
            Misc.close(in);
            Misc.close(out);
            parse.setFile(file);
            if (!"5.10".equals(productVersion)) {
                String message = "The given business archive was created with a different version of BOS. Please use the current BOS version (5.10) to export your process";
                file.delete();
                Misc.showProblems(Collections.singleton(new Problem("The given business archive was created with a different version of BOS. Please use the current BOS version (5.10) to export your process", "fatal-error")), " your xml");
            }
            ProcessDefinition process = (ProcessDefinition)parse.execute().getDocumentObject();
            file.delete();
            Misc.showProblems(parse.getProblems(), "xml file");
            Misc.badStateIfNull(process, "Ouch! The returned Clientprocess is null!");
            return process;
        }
        catch (IOException ex) {
            throw new BonitaRuntimeException(ex);
        }
    }

    static String resolveWithContext(String value, Properties context) {
        if (!value.contains("#context[")) {
            return value;
        }
        StringBuilder builder = new StringBuilder(value);
        int startIndex = 0;
        while ((startIndex = builder.indexOf("#context[", startIndex)) != -1) {
            int closingIndex = builder.indexOf("]", startIndex);
            String key = builder.substring(startIndex + "#context[".length(), closingIndex);
            if (context.containsKey(key)) {
                builder.replace(startIndex, closingIndex + 1, context.get(key).toString());
            }
            ++startIndex;
        }
        return builder.toString();
    }

    private boolean canAddBoundaryEvent(ActivityDefinition activity, String eventType) {
        boolean can = false;
        if (activity.isAutomatic() && "error".equals(eventType)) {
            can = true;
        }
        if (activity.isSubflow() || activity.isTask() || activity.isReceiveEvent()) {
            can = true;
        }
        return can;
    }
}

