/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.Misc;

public class TraceFormatter
extends SimpleFormatter {
    public static final String UNAVAILABLE_SYMBOL = "-";
    public static final String LEGEND_MSG = TraceFormatter.class.getName() + " uses the following format:" + Misc.LINE_SEPARATOR + "L DATE thr#Id Logger Class.Method(): MSG" + Misc.LINE_SEPARATOR + "Where L can be: " + Misc.LINE_SEPARATOR + "\tC for Level.CONFIG," + Misc.LINE_SEPARATOR + "\tF for Level.FINE, Level.FINER and Level.FINEST" + Misc.LINE_SEPARATOR + "\tI for Level.INFO" + Misc.LINE_SEPARATOR + "\tW for Level.WARNING" + Misc.LINE_SEPARATOR + "\tS for Level.SEVERE" + Misc.LINE_SEPARATOR + "\tE for log.entering() or log.exiting() log type" + Misc.LINE_SEPARATOR + "\tT for log.throwing() log type" + Misc.LINE_SEPARATOR + "\t" + "-" + " means that the information is unavailable." + Misc.LINE_SEPARATOR;
    public static final String ALIAS_HELP = "Alias can be provided to shorten the output with the property " + ALIAS_PROPERTY_KEY + " set to something similar to: string1~alias1,string2~alias2,...";
    private static final DateFormat CONCISE_DATE_FORMATTER = new SimpleDateFormat("yy-MM-dd HH:mm:ss.SSS");
    public static final String ALIAS_PROPERTY_KEY = TraceFormatter.class.getName() + ".alias";
    private static final String PREFIX = "   ";
    private final Map<String, String> alias = new HashMap<String, String>();
    private boolean firstTime = true;

    public TraceFormatter() {
        String aliasConfig = LogManager.getLogManager().getProperty(ALIAS_PROPERTY_KEY);
        if (aliasConfig == null) {
            aliasConfig = System.getProperty(ALIAS_PROPERTY_KEY);
        }
        if (aliasConfig != null) {
            StringTokenizer configTokenizer = new StringTokenizer(aliasConfig, ",");
            while (configTokenizer.hasMoreTokens()) {
                String alia = configTokenizer.nextToken();
                StringTokenizer aliaTokenizer = new StringTokenizer(alia, "~");
                if (aliaTokenizer.countTokens() != 2) {
                    String message = ExceptionManager.getInstance().getFullMessage("buc_TF_1", aliasConfig);
                    throw new IllegalArgumentException(message);
                }
                this.alias.put(aliaTokenizer.nextToken(), aliaTokenizer.nextToken());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String format(LogRecord record) {
        Object[] params;
        String tmp;
        StringBuilder sb = new StringBuilder(160);
        if (this.firstTime) {
            this.firstTime = false;
            sb.append(LEGEND_MSG);
            if (this.alias.isEmpty()) {
                sb.append(ALIAS_HELP);
            } else {
                sb.append("Using alias: " + this.alias);
            }
            sb.append(Misc.LINE_SEPARATOR + Misc.LINE_SEPARATOR);
        }
        String msg = record.getMessage();
        boolean entry = msg.startsWith("ENTRY");
        boolean exit = msg.startsWith("RETURN");
        boolean throwing = msg.startsWith("THROW");
        if (entry || exit) {
            sb.append('E');
        } else if (throwing) {
            sb.append('T');
        } else {
            sb.append(record.getLevel().getName().charAt(0));
        }
        sb.append(' ');
        DateFormat dateFormat = CONCISE_DATE_FORMATTER;
        synchronized (dateFormat) {
            tmp = CONCISE_DATE_FORMATTER.format(record.getMillis());
        }
        sb.append(tmp);
        sb.append(" thr#");
        sb.append(record.getThreadID());
        sb.append(' ');
        tmp = record.getLoggerName();
        String logger = tmp == null ? UNAVAILABLE_SYMBOL : this.replaceWithAlias(tmp);
        sb.append(logger);
        sb.append(' ');
        tmp = record.getSourceClassName();
        String className = tmp == null ? UNAVAILABLE_SYMBOL : this.replaceWithAlias(tmp);
        sb.append(className);
        sb.append('.');
        tmp = record.getSourceMethodName();
        sb.append(tmp == null ? UNAVAILABLE_SYMBOL : tmp);
        sb.append('(');
        if (entry && (params = record.getParameters()) != null) {
            int last = params.length - 1;
            for (int i = 0; i < last; ++i) {
                sb.append(params[i]);
                sb.append(", ");
            }
            sb.append(params[last]);
        }
        sb.append(')');
        Throwable throwable = record.getThrown();
        if (exit || throwing) {
            sb.append(" -> ");
            if (exit) {
                Object returnedValue = record.getParameters()[0];
                sb.append(returnedValue == null ? UNAVAILABLE_SYMBOL : returnedValue);
            } else {
                sb.append(throwable == null ? UNAVAILABLE_SYMBOL : throwable);
            }
        } else if (!entry) {
            sb.append(": ");
            sb.append(msg);
        }
        sb.append(Misc.LINE_SEPARATOR);
        if (throwable != null && !throwing) {
            sb.append(PREFIX);
            sb.append(throwable);
            sb.append(Misc.prefixAllLines(Misc.getStackTraceFrom(throwable), PREFIX));
            sb.append(Misc.LINE_SEPARATOR);
        }
        return new String(sb);
    }

    private String replaceWithAlias(String src) {
        if (src == null) {
            return src;
        }
        StringBuilder dst = new StringBuilder(src);
        for (String key : this.alias.keySet()) {
            int index = dst.indexOf(key);
            if (index == -1) continue;
            dst.delete(index, index + key.length());
            dst.insert(index, this.alias.get(key));
        }
        return new String(dst);
    }
}

