/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util;

import java.util.List;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.def.InternalProcessDefinition;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.services.EventService;
import org.ow2.bonita.util.Command;
import org.ow2.bonita.util.EnvTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateJobLocksCommand
implements Command<Void> {
    private static final long serialVersionUID = -7175668322844266834L;
    private static final int MAX_RESULTS = 1000;
    private static final Logger LOG = LoggerFactory.getLogger(UpdateJobLocksCommand.class);

    @Override
    public Void execute(Environment environment) throws Exception {
        this.createProcDefJobLocks();
        this.createRootProcInstJobLocks();
        return null;
    }

    private void createProcessDefinitionJobLocks(List<InternalProcessDefinition> processes) {
        EventService eventService = EnvTool.getEventService();
        for (InternalProcessDefinition internalProcessDefinition : processes) {
            eventService.lockProcessDefinition(internalProcessDefinition.getUUID());
        }
    }

    private void createRootInstanceJobLocks(List<InternalProcessInstance> procInsts) {
        EventService eventService = EnvTool.getEventService();
        for (InternalProcessInstance procInst : procInsts) {
            eventService.lockRootInstance(procInst.getUUID());
        }
    }

    private void createProcDefJobLocks() {
        LOG.info("updating job locks for process definitions ...");
        int fromIndex = 0;
        List<InternalProcessDefinition> processes = null;
        do {
            processes = EnvTool.getJournal().getProcesses(fromIndex, 1000);
            this.createProcessDefinitionJobLocks(processes);
            fromIndex += 1000;
        } while (processes != null && !processes.isEmpty());
    }

    private void createRootProcInstJobLocks() {
        LOG.info("updating job locks for process instances ...");
        int fromIndex = 0;
        List<InternalProcessInstance> procInsts = null;
        do {
            procInsts = EnvTool.getJournal().getParentProcessInstances(fromIndex, 1000);
            this.createRootInstanceJobLocks(procInsts);
            fromIndex += 1000;
        } while (procInsts != null && !procInsts.isEmpty());
    }
}

