/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ow2.bonita.facade.exception.GroupAlreadyExistsException;
import org.ow2.bonita.facade.exception.GroupNotFoundException;
import org.ow2.bonita.facade.exception.MembershipNotFoundException;
import org.ow2.bonita.facade.exception.MetadataAlreadyExistsException;
import org.ow2.bonita.facade.exception.MetadataNotFoundException;
import org.ow2.bonita.facade.exception.RoleAlreadyExistsException;
import org.ow2.bonita.facade.exception.RoleNotFoundException;
import org.ow2.bonita.facade.exception.UserAlreadyExistsException;
import org.ow2.bonita.facade.exception.UserNotFoundException;
import org.ow2.bonita.facade.identity.Group;
import org.ow2.bonita.facade.identity.Membership;
import org.ow2.bonita.facade.identity.ProfileMetadata;
import org.ow2.bonita.facade.identity.Role;
import org.ow2.bonita.facade.identity.User;
import org.ow2.bonita.facade.paging.GroupCriterion;
import org.ow2.bonita.facade.paging.RoleCriterion;
import org.ow2.bonita.facade.paging.UserCriterion;

public interface IdentityAPI {
    public static final String GROUP_PATH_SEPARATOR = "/";
    public static final String MEMBERSHIP_SEPARATOR = ":";
    public static final String DEFAULT_GROUP_NAME = "platform";
    public static final String DEFAULT_GROUP_LABEL = "Platform";
    public static final String DEFAULT_GROUP_DESCRIPTION = "The default group";
    public static final String USER_ROLE_NAME = "user";
    public static final String USER_ROLE_LABEL = "User";
    public static final String USER_ROLE_DESCRIPTION = "The user role";
    public static final String ADMIN_ROLE_NAME = "admin";
    public static final String ADMIN_ROLE_LABEL = "Admin";
    public static final String ADMIN_ROLE_DESCRIPTION = "The admin role";

    public ProfileMetadata getProfileMetadataByUUID(String var1) throws MetadataNotFoundException;

    public ProfileMetadata findProfileMetadataByName(String var1) throws MetadataNotFoundException;

    public List<ProfileMetadata> getAllProfileMetadata();

    public List<ProfileMetadata> getProfileMetadata(int var1, int var2);

    public int getNumberOfProfileMetadata();

    public ProfileMetadata addProfileMetadata(String var1) throws MetadataAlreadyExistsException;

    public ProfileMetadata addProfileMetadata(String var1, String var2) throws MetadataAlreadyExistsException;

    public ProfileMetadata updateProfileMetadataByUUID(String var1, String var2, String var3) throws MetadataNotFoundException, MetadataAlreadyExistsException;

    public void removeProfileMetadataByUUID(String var1) throws MetadataNotFoundException;

    public void removeProfileMetadata(Collection<String> var1) throws MetadataNotFoundException;

    @Deprecated
    public User getUser(String var1) throws UserNotFoundException;

    public User findUserByUserName(String var1) throws UserNotFoundException;

    public User getUserByUUID(String var1) throws UserNotFoundException;

    @Deprecated
    public Set<User> getUsers();

    public List<User> getAllUsers();

    public List<User> getUsers(int var1, int var2);

    public List<User> getUsers(int var1, int var2, UserCriterion var3);

    public int getNumberOfUsers();

    public User addUser(String var1, String var2) throws UserAlreadyExistsException;

    @Deprecated
    public User addUser(String var1, String var2, String var3, String var4, String var5) throws UserAlreadyExistsException;

    public User addUser(String var1, String var2, String var3, String var4, String var5, String var6, String var7, Map<String, String> var8) throws UserAlreadyExistsException, UserNotFoundException, MetadataNotFoundException;

    public User importUser(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, Map<String, String> var9) throws UserAlreadyExistsException, MetadataNotFoundException;

    public void updateUserDelegee(String var1, String var2) throws UserNotFoundException;

    public void updateUserPersonalContactInfo(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, String var10, String var11, String var12, String var13) throws UserNotFoundException;

    public void updateUserProfessionalContactInfo(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, String var10, String var11, String var12, String var13) throws UserNotFoundException;

    @Deprecated
    public User updateUser(String var1, String var2, String var3, String var4, String var5, String var6) throws UserNotFoundException, UserAlreadyExistsException;

    public User updateUserByUUID(String var1, String var2, String var3, String var4, String var5, String var6, String var7, Map<String, String> var8) throws UserNotFoundException, UserAlreadyExistsException, MetadataNotFoundException;

    public User updateUserPassword(String var1, String var2) throws UserNotFoundException;

    @Deprecated
    public Set<User> getUsersInRole(String var1) throws RoleNotFoundException;

    public List<User> getAllUsersInRole(String var1) throws RoleNotFoundException;

    public List<User> getUsersInRole(String var1, int var2, int var3) throws RoleNotFoundException;

    public List<User> getUsersInRole(String var1, int var2, int var3, UserCriterion var4) throws RoleNotFoundException;

    public int getNumberOfUsersInRole(String var1);

    public List<User> getAllUsersInGroup(String var1) throws GroupNotFoundException;

    public List<User> getUsersInGroup(String var1, int var2, int var3) throws GroupNotFoundException;

    public List<User> getUsersInGroup(String var1, int var2, int var3, UserCriterion var4) throws GroupNotFoundException;

    public int getNumberOfUsersInGroup(String var1);

    public List<User> getAllUsersInMembership(String var1) throws MembershipNotFoundException;

    public List<User> getAllUsersInRoleAndGroup(String var1, String var2) throws RoleNotFoundException, GroupNotFoundException;

    public List<User> getUsersByManagerUUID(String var1) throws UserNotFoundException;

    public void removeUserByUUID(String var1) throws UserNotFoundException;

    public void removeUsers(Collection<String> var1) throws UserNotFoundException;

    @Deprecated
    public void removeUser(String var1) throws UserNotFoundException;

    @Deprecated
    public Role getRole(String var1) throws RoleNotFoundException;

    public Role findRoleByName(String var1) throws RoleNotFoundException;

    public Role getRoleByUUID(String var1) throws RoleNotFoundException;

    @Deprecated
    public Set<Role> getRoles();

    public List<Role> getAllRoles();

    public List<Role> getRoles(int var1, int var2);

    public List<Role> getRoles(int var1, int var2, RoleCriterion var3);

    public int getNumberOfRoles();

    @Deprecated
    public Set<Role> getUserRoles(String var1) throws UserNotFoundException;

    public Role addRole(String var1) throws RoleAlreadyExistsException;

    public Role addRole(String var1, String var2, String var3) throws RoleAlreadyExistsException;

    public Role importRole(String var1, String var2, String var3, String var4) throws RoleAlreadyExistsException;

    public Role updateRoleByUUID(String var1, String var2, String var3, String var4) throws RoleNotFoundException, RoleAlreadyExistsException;

    @Deprecated
    public Role updateRole(String var1, String var2, String var3, String var4) throws RoleNotFoundException, RoleAlreadyExistsException;

    public void removeRoleByUUID(String var1) throws RoleNotFoundException;

    public void removeRoles(Collection<String> var1) throws RoleNotFoundException;

    @Deprecated
    public void removeRole(String var1) throws RoleNotFoundException;

    public Group getGroupByUUID(String var1) throws GroupNotFoundException;

    public List<Group> getAllGroups();

    public List<Group> getGroups(int var1, int var2);

    public List<Group> getGroups(int var1, int var2, GroupCriterion var3);

    public int getNumberOfGroups();

    public List<Group> getChildrenGroupsByUUID(String var1);

    public List<Group> getChildrenGroups(String var1, int var2, int var3) throws GroupNotFoundException;

    public List<Group> getChildrenGroups(String var1, int var2, int var3, GroupCriterion var4) throws GroupNotFoundException;

    public int getNumberOfChildrenGroups(String var1) throws GroupNotFoundException;

    public Group addGroup(String var1, String var2) throws GroupAlreadyExistsException, GroupNotFoundException;

    public Group addGroup(String var1, String var2, String var3, String var4) throws GroupAlreadyExistsException, GroupNotFoundException;

    public boolean groupExists(String var1);

    public Group importGroup(String var1, String var2, String var3, String var4, String var5) throws GroupAlreadyExistsException, GroupNotFoundException;

    public Group updateGroupByUUID(String var1, String var2, String var3, String var4, String var5) throws GroupNotFoundException, GroupAlreadyExistsException;

    public void removeGroupByUUID(String var1) throws GroupNotFoundException;

    public void removeGroups(Collection<String> var1) throws GroupNotFoundException;

    public Membership getMembershipByUUID(String var1) throws MembershipNotFoundException;

    public Membership getMembershipForRoleAndGroup(String var1, String var2) throws RoleNotFoundException, GroupNotFoundException;

    public void addMembershipToUser(String var1, String var2) throws UserNotFoundException, MembershipNotFoundException;

    public void addMembershipsToUser(String var1, Collection<String> var2) throws UserNotFoundException, MembershipNotFoundException;

    public void removeMembershipFromUser(String var1, String var2) throws UserNotFoundException, MembershipNotFoundException;

    public void removeMembershipsFromUser(String var1, Collection<String> var2) throws UserNotFoundException, MembershipNotFoundException;

    public void setUserMemberships(String var1, Collection<String> var2) throws UserNotFoundException, MembershipNotFoundException;

    @Deprecated
    public void addRoleToUser(String var1, String var2) throws UserNotFoundException, RoleNotFoundException;

    @Deprecated
    public void setUserRoles(String var1, Set<String> var2) throws UserNotFoundException, RoleNotFoundException;

    @Deprecated
    public void removeRoleFromUser(String var1, String var2) throws UserNotFoundException, RoleNotFoundException;

    public List<User> getUsersByUUIDs(Collection<String> var1) throws UserNotFoundException;

    public List<Role> getRolesByUUIDs(Collection<String> var1) throws RoleNotFoundException;

    public List<Group> getGroupsByUUIDs(Collection<String> var1) throws GroupNotFoundException;

    public List<Membership> getMembershipsByUUIDs(Collection<String> var1) throws MembershipNotFoundException;

    public Group getGroupUsingPath(List<String> var1);
}

