/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.def.element.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.ow2.bonita.util.CopyTool;

public class IterationDescriptor
implements Serializable,
Comparable<IterationDescriptor> {
    private static final long serialVersionUID = -3306138069531809523L;
    protected Set<String> otherNodes;
    protected Set<String> entryNodes;
    protected Set<String> exitNodes;

    protected IterationDescriptor() {
    }

    public IterationDescriptor(Set<String> otherNodes, Set<String> entryNodes, Set<String> exitNodes) {
        this.otherNodes = otherNodes;
        this.entryNodes = entryNodes;
        this.exitNodes = exitNodes;
    }

    public IterationDescriptor(IterationDescriptor id) {
        this.otherNodes = CopyTool.copy(id.getOtherNodes());
        this.entryNodes = CopyTool.copy(id.getEntryNodes());
        this.exitNodes = CopyTool.copy(id.getExitNodes());
    }

    private Set<String> getOtherNodes() {
        if (this.otherNodes == null) {
            return Collections.emptySet();
        }
        return this.otherNodes;
    }

    public Set<String> getEntryNodes() {
        if (this.entryNodes == null) {
            return Collections.emptySet();
        }
        return this.entryNodes;
    }

    public Set<String> getExitNodes() {
        if (this.exitNodes == null) {
            return Collections.emptySet();
        }
        return this.exitNodes;
    }

    public boolean containsNode(String node) {
        return this.getCycleNodes().contains(node);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IterationDescriptor)) {
            return false;
        }
        IterationDescriptor other = (IterationDescriptor)obj;
        return ((Object)other.getEntryNodes()).equals(this.getEntryNodes()) && ((Object)other.getExitNodes()).equals(this.getExitNodes()) && ((Object)other.getOtherNodes()).equals(this.getOtherNodes());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.entryNodes == null ? 0 : ((Object)this.entryNodes).hashCode());
        result = 31 * result + (this.exitNodes == null ? 0 : ((Object)this.exitNodes).hashCode());
        result = 31 * result + (this.otherNodes == null ? 0 : ((Object)this.otherNodes).hashCode());
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
        builder.append(": ").append("\nEntry nodes : ");
        for (String st : this.getEntryNodes()) {
            builder.append(st).append(", ");
        }
        builder.append("\nExit nodes : ");
        for (String st : this.getExitNodes()) {
            builder.append(st).append(", ");
        }
        builder.append("\nOther nodes : ");
        for (String st : this.getOtherNodes()) {
            builder.append(st).append(", ");
        }
        return builder.toString();
    }

    public Set<String> getCycleNodes() {
        HashSet<String> cycleNodes = new HashSet<String>();
        cycleNodes.addAll(this.getEntryNodes());
        cycleNodes.addAll(this.getExitNodes());
        cycleNodes.addAll(this.getOtherNodes());
        return cycleNodes;
    }

    @Override
    public int compareTo(IterationDescriptor anotherDescriptor) {
        return this.toString().compareTo(anotherDescriptor.toString());
    }
}

