/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.internal;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.ow2.bonita.facade.def.element.AttachmentDefinition;
import org.ow2.bonita.facade.def.element.BusinessArchive;
import org.ow2.bonita.facade.def.majorElement.ActivityDefinition;
import org.ow2.bonita.facade.def.majorElement.DataFieldDefinition;
import org.ow2.bonita.facade.def.majorElement.ParticipantDefinition;
import org.ow2.bonita.facade.def.majorElement.ProcessDefinition;
import org.ow2.bonita.facade.exception.ActivityDefNotFoundException;
import org.ow2.bonita.facade.exception.ActivityNotFoundException;
import org.ow2.bonita.facade.exception.DataFieldNotFoundException;
import org.ow2.bonita.facade.exception.ParticipantNotFoundException;
import org.ow2.bonita.facade.exception.ProcessNotFoundException;
import org.ow2.bonita.facade.paging.ProcessDefinitionCriterion;
import org.ow2.bonita.facade.runtime.InitialAttachment;
import org.ow2.bonita.facade.uuid.ActivityDefinitionUUID;
import org.ow2.bonita.facade.uuid.ParticipantDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.light.LightProcessDefinition;

@Path(value="/API/queryDefinitionAPI/")
@Produces(value={"text/*", "application/xml"})
@Consumes(value={"application/x-www-form-urlencoded", "text/*", "application/xml"})
public interface RemoteQueryDefinitionAPI
extends Remote {
    @POST
    @Path(value="getProcess/{processId}/{processVersion}")
    public ProcessDefinition getProcess(@PathParam(value="processId") String var1, @PathParam(value="processVersion") String var2, @FormParam(value="options") Map<String, String> var3) throws ProcessNotFoundException, RemoteException;

    @POST
    @Path(value="getProcesses")
    public Set<ProcessDefinition> getProcesses(@FormParam(value="options") Map<String, String> var1) throws RemoteException;

    @POST
    @Path(value="getLightProcesses")
    public Set<LightProcessDefinition> getLightProcesses(@FormParam(value="options") Map<String, String> var1) throws RemoteException;

    @POST
    @Path(value="getNumberOfProcesses")
    public int getNumberOfProcesses(@FormParam(value="options") Map<String, String> var1) throws RemoteException;

    @POST
    @Path(value="getProcessesByProcessId/{processId}")
    public Set<ProcessDefinition> getProcesses(@PathParam(value="processId") String var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException;

    @POST
    @Path(value="getLightProcessesByIndexAndPageSize")
    public List<LightProcessDefinition> getLightProcesses(@QueryParam(value="fromIndex") int var1, @QueryParam(value="pageSize") int var2, @FormParam(value="options") Map<String, String> var3) throws RemoteException;

    @POST
    @Path(value="getLightProcessesByIndexAndPageSizeWithPagingCriterion")
    public List<LightProcessDefinition> getLightProcesses(@QueryParam(value="fromIndex") int var1, @QueryParam(value="pageSize") int var2, @QueryParam(value="pagingCriterion") ProcessDefinitionCriterion var3, @FormParam(value="options") Map<String, String> var4) throws RemoteException;

    @POST
    @Path(value="getProcessesByIndexAndPageSize")
    public List<ProcessDefinition> getProcesses(@QueryParam(value="fromIndex") int var1, @QueryParam(value="pageSize") int var2, @FormParam(value="options") Map<String, String> var3) throws RemoteException;

    @POST
    @Path(value="getProcess/{processDefinitionUUID}")
    public ProcessDefinition getProcess(@PathParam(value="processDefinitionUUID") ProcessDefinitionUUID var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException, ProcessNotFoundException;

    @POST
    @Path(value="getLightProcess/{processDefinitionUUID}")
    public LightProcessDefinition getLightProcess(@PathParam(value="processDefinitionUUID") ProcessDefinitionUUID var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException, ProcessNotFoundException;

    @POST
    @Path(value="getProcessesByState/{processState}")
    public Set<ProcessDefinition> getProcesses(@PathParam(value="processState") ProcessDefinition.ProcessState var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException;

    @POST
    @Path(value="getLightProcesses/{processState}")
    public Set<LightProcessDefinition> getLightProcesses(@PathParam(value="processState") ProcessDefinition.ProcessState var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException;

    @POST
    @Path(value="getProcessesByProcessIdAndState/{processId}/{processState}")
    public Set<ProcessDefinition> getProcesses(@PathParam(value="processId") String var1, @PathParam(value="processState") ProcessDefinition.ProcessState var2, @FormParam(value="options") Map<String, String> var3) throws RemoteException;

    @Produces(value={"application/octet-stream"})
    @POST
    @Path(value="getBusinessArchive/{processDefinitionUUID}")
    public BusinessArchive getBusinessArchive(@PathParam(value="processDefinitionUUID") ProcessDefinitionUUID var1, @FormParam(value="options") Map<String, String> var2) throws ProcessNotFoundException, RemoteException;

    @POST
    @Path(value="getProcessParticipants/{processDefinitionUUID}")
    public Set<ParticipantDefinition> getProcessParticipants(@PathParam(value="processDefinitionUUID") ProcessDefinitionUUID var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException, ProcessNotFoundException;

    @POST
    @Path(value="getProcessParticipant/{processDefinitionUUID}/{participantId}")
    public ParticipantDefinition getProcessParticipant(@PathParam(value="processDefinitionUUID") ProcessDefinitionUUID var1, @PathParam(value="participantId") String var2, @FormParam(value="options") Map<String, String> var3) throws RemoteException, ProcessNotFoundException, ParticipantNotFoundException;

    @POST
    @Path(value="getProcessActivities/{processDefinitionUUID}")
    public Set<ActivityDefinition> getProcessActivities(@PathParam(value="processDefinitionUUID") ProcessDefinitionUUID var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException, ProcessNotFoundException;

    @POST
    @Path(value="getProcessActivity/{processDefinitionUUID}/{activityId}")
    public ActivityDefinition getProcessActivity(@PathParam(value="processDefinitionUUID") ProcessDefinitionUUID var1, @PathParam(value="activityId") String var2, @FormParam(value="options") Map<String, String> var3) throws RemoteException, ProcessNotFoundException, ActivityNotFoundException;

    @POST
    @Path(value="getProcessActivityId/{processDefinitionUUID}/{activityName}")
    public ActivityDefinitionUUID getProcessActivityId(@PathParam(value="processDefinitionUUID") ProcessDefinitionUUID var1, @PathParam(value="activityName") String var2, @FormParam(value="options") Map<String, String> var3) throws RemoteException, ProcessNotFoundException;

    @POST
    @Path(value="getProcessParticipantId/{processDefinitionUUID}/{participantName}")
    public ParticipantDefinitionUUID getProcessParticipantId(@PathParam(value="processDefinitionUUID") ProcessDefinitionUUID var1, @PathParam(value="participantName") String var2, @FormParam(value="options") Map<String, String> var3) throws RemoteException, ProcessNotFoundException;

    @POST
    @Path(value="getLastProcess/{processId}")
    public ProcessDefinition getLastProcess(@PathParam(value="processId") String var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException, ProcessNotFoundException;

    @POST
    @Path(value="getLastLightProcess/{processName}")
    public LightProcessDefinition getLastLightProcess(@PathParam(value="processName") String var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException, ProcessNotFoundException;

    @POST
    @Path(value="getProcessDataFields/{processDefinitionUUID}")
    public Set<DataFieldDefinition> getProcessDataFields(@PathParam(value="processDefinitionUUID") ProcessDefinitionUUID var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException, ProcessNotFoundException;

    @POST
    @Path(value="getProcessDataField/{processDefinitionUUID}/{dataFieldId}")
    public DataFieldDefinition getProcessDataField(@PathParam(value="processDefinitionUUID") ProcessDefinitionUUID var1, @PathParam(value="dataFieldId") String var2, @FormParam(value="options") Map<String, String> var3) throws RemoteException, ProcessNotFoundException, DataFieldNotFoundException;

    @POST
    @Path(value="getActivityDataFields/{uuid}")
    public Set<DataFieldDefinition> getActivityDataFields(@PathParam(value="uuid") ActivityDefinitionUUID var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException, ActivityDefNotFoundException;

    @POST
    @Path(value="getActivityDataField/{activityDefinitionUUID}/{dataFieldId}")
    public DataFieldDefinition getActivityDataField(@PathParam(value="activityDefinitionUUID") ActivityDefinitionUUID var1, @PathParam(value="dataFieldId") String var2, @FormParam(value="options") Map<String, String> var3) throws RemoteException, ActivityDefNotFoundException, DataFieldNotFoundException;

    @POST
    @Path(value="getProcessMetaData/{uuid}/{key}")
    public String getProcessMetaData(@PathParam(value="uuid") ProcessDefinitionUUID var1, @PathParam(value="key") String var2, @FormParam(value="options") Map<String, String> var3) throws RemoteException, ProcessNotFoundException;

    @POST
    @Path(value="getProcessAttachments/{processUUID}")
    public Set<InitialAttachment> getProcessAttachments(@PathParam(value="processUUID") ProcessDefinitionUUID var1, @FormParam(value="options") Map<String, String> var2) throws ProcessNotFoundException, RemoteException;

    @POST
    @Path(value="getProcessAttachment/{processUUID}/{attachmentName}")
    public InitialAttachment getProcessAttachment(@PathParam(value="processUUID") ProcessDefinitionUUID var1, @PathParam(value="attachmentName") String var2, @FormParam(value="options") Map<String, String> var3) throws ProcessNotFoundException, RemoteException;

    @POST
    @Path(value="getAttachmentDefinitions/{processUUID}")
    public Set<AttachmentDefinition> getAttachmentDefinitions(@PathParam(value="processUUID") ProcessDefinitionUUID var1, @FormParam(value="options") Map<String, String> var2) throws ProcessNotFoundException, RemoteException;

    @POST
    @Path(value="getAttachmentDefinition/{processUUID}/{attachmentName}")
    public AttachmentDefinition getAttachmentDefinition(@PathParam(value="processUUID") ProcessDefinitionUUID var1, @PathParam(value="attachmentName") String var2, @FormParam(value="options") Map<String, String> var3) throws ProcessNotFoundException, RemoteException;

    @POST
    @Path(value="getResource/{definitionUUID}")
    public byte[] getResource(@PathParam(value="definitionUUID") ProcessDefinitionUUID var1, @QueryParam(value="resourcePath") String var2, @FormParam(value="options") Map<String, String> var3) throws ProcessNotFoundException, RemoteException;

    @POST
    @Path(value="getLightProcessesByProcessDefinitionUUIDs")
    public Set<LightProcessDefinition> getLightProcesses(@FormParam(value="processUUIDs") Set<ProcessDefinitionUUID> var1, @FormParam(value="options") Map<String, String> var2) throws ProcessNotFoundException, RemoteException;

    @POST
    @Path(value="getLightProcessesByProcessDefinitionUUIDsWithPagingCriterion")
    public List<LightProcessDefinition> getLightProcesses(@FormParam(value="processUUIDs") Set<ProcessDefinitionUUID> var1, @QueryParam(value="fromIndex") int var2, @QueryParam(value="pageSize") int var3, @QueryParam(value="pagingCriterion") ProcessDefinitionCriterion var4, @FormParam(value="options") Map<String, String> var5) throws ProcessNotFoundException, RemoteException;

    @POST
    @Path(value="getAllLightProcessesExcept")
    public List<LightProcessDefinition> getAllLightProcessesExcept(@FormParam(value="processUUIDs") Set<ProcessDefinitionUUID> var1, @QueryParam(value="fromIndex") int var2, @QueryParam(value="pageSize") int var3, @FormParam(value="options") Map<String, String> var4) throws RemoteException;

    @POST
    @Path(value="getAllLightProcessesExceptWithPagingCriterion")
    public List<LightProcessDefinition> getAllLightProcessesExcept(@FormParam(value="processUUIDs") Set<ProcessDefinitionUUID> var1, @QueryParam(value="fromIndex") int var2, @QueryParam(value="pageSize") int var3, @QueryParam(value="pagingCriterion") ProcessDefinitionCriterion var4, @FormParam(value="options") Map<String, String> var5) throws RemoteException;

    @POST
    @Path(value="getProcessUUIDs/{category}")
    public Set<ProcessDefinitionUUID> getProcessUUIDs(@PathParam(value="category") String var1, @FormParam(value="options") Map<String, String> var2) throws RemoteException;

    @POST
    @Path(value="getProcessTaskUUIDs/{processsUUID}")
    public Set<ActivityDefinitionUUID> getProcessTaskUUIDs(@PathParam(value="processsUUID") ProcessDefinitionUUID var1, @FormParam(value="options") Map<String, String> var2) throws ProcessNotFoundException, RemoteException;

    @POST
    @Path(value="getMigrationDate/{processUUID}")
    public Date getMigrationDate(@PathParam(value="processUUID") ProcessDefinitionUUID var1, @FormParam(value="options") Map<String, String> var2) throws ProcessNotFoundException, RemoteException;
}

