/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.rest;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.env.Authentication;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.QueryDefinitionAPI;
import org.ow2.bonita.facade.def.majorElement.DataFieldDefinition;
import org.ow2.bonita.facade.exception.ActivityDefNotFoundException;
import org.ow2.bonita.facade.exception.BonitaInternalException;
import org.ow2.bonita.facade.exception.DataFieldNotFoundException;
import org.ow2.bonita.facade.exception.ProcessNotFoundException;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.interceptor.InterceptorUtil;
import org.ow2.bonita.facade.rest.wrapper.RESTCommand;
import org.ow2.bonita.facade.rest.wrapper.RESTMap;
import org.ow2.bonita.facade.rest.wrapper.RESTObject;
import org.ow2.bonita.facade.runtime.ActivityInstance;
import org.ow2.bonita.facade.runtime.impl.InternalActivityInstance;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.identity.auth.APIMethodsSecurity;
import org.ow2.bonita.identity.auth.UserOwner;
import org.ow2.bonita.util.Command;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.Misc;
import org.ow2.bonita.util.xml.XStreamUtil;

public class RESTServerAPIInterceptorCommand
implements Command<Object> {
    private static final long serialVersionUID = 7925435794747108162L;
    protected static final Logger LOG = Logger.getLogger(RESTServerAPIInterceptorCommand.class.getName());
    private static final String SET_ACTIVITY_INSTANCE_VARIABLE = "setActivityInstanceVariable";
    private static final String SET_PROCESS_INSTANCE_VARIABLE = "setProcessInstanceVariable";
    private static final String SET_VARIABLE = "setVariable";
    private final transient Method m;
    private final Object[] args;
    private final Object api;

    public RESTServerAPIInterceptorCommand(Method m, Object[] args, Object api) {
        this.args = args;
        this.m = m;
        this.api = api;
        if (LOG.isLoggable(Level.FINE)) {
            this.logCommandCreation(m, args);
        }
    }

    private void logCommandCreation(Method m, Object[] args) {
        StringBuffer sb = new StringBuffer();
        sb.append("Creating APIInterceptorCommand: " + this + ". Method: " + m);
        if (args != null) {
            for (Object arg : args) {
                sb.append(" - Arg: " + arg);
            }
        } else {
            sb.append(" Args: null.");
        }
        LOG.fine(sb.toString());
    }

    @Override
    public Object execute(Environment environment) throws Exception {
        try {
            this.handleSecurity();
            return this.doInvocation();
        }
        catch (InvocationTargetException e) {
            Throwable invocationExceptionCause = e.getCause();
            if (invocationExceptionCause instanceof RemoteException) {
                RemoteException remoteException = (RemoteException)invocationExceptionCause;
                Throwable remoteCause = this.getRemoteCause(remoteException);
                InterceptorUtil.manageInvokeExceptionCause(this.m, remoteCause);
            } else if (invocationExceptionCause instanceof Exception) {
                throw (Exception)invocationExceptionCause;
            }
            String message = ExceptionManager.getInstance().getFullMessage("baa_CAPII_1", e);
            throw new BonitaInternalException(message, e);
        }
    }

    private Object doInvocation() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, IOException, ClassNotFoundException {
        this.preprocessInputParametersDependingOnMethodName(this.args, this.m);
        Object ret = this.m.invoke(this.api, this.args);
        if (this.isAmbigousReturnType(this.m, ret)) {
            ret = new RESTObject((Serializable)ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preprocessInputParametersDependingOnMethodName(Object[] args, Method m) {
        ClassLoader baseClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader localClassLoader = null;
            if (this.isSetVariableMethod(args, m)) {
                this.processSetVariableMethods(args);
            } else if (this.isExecuteMethod(m, args)) {
                this.processExecuteMethod(args, localClassLoader);
            } else if (this.isInstantiateProcessMethod(m, args)) {
                this.processInstantiateProcessMethod(args);
            } else if (this.isGetModifiedObjectMethod(m, args)) {
                this.processGetModifiedObjectMethod(args);
            }
        }
        catch (Exception e) {
            if (LOG.isLoggable(Level.SEVERE)) {
                LOG.severe("Error on RESTServerInterceptor: " + Misc.getStackTraceFrom(e));
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(baseClassLoader);
        }
    }

    private void handleSecurity() {
        if (APIMethodsSecurity.isSecuredMethod(this.m)) {
            String userId = null;
            try {
                userId = EnvTool.getBonitaSecurityContext().getUser();
            }
            catch (Throwable t) {
                userId = UserOwner.getUser();
            }
            Authentication.setUserId(userId);
        }
    }

    private void processGetModifiedObjectMethod(Object[] args) throws IOException, ClassNotFoundException {
        ProcessDefinitionUUID processUUID = (ProcessDefinitionUUID)args[0];
        if (args[2] instanceof RESTObject) {
            args[2] = this.getObjectFromRESTObject((RESTObject)args[2], processUUID);
        }
        if (args[3] instanceof RESTObject) {
            args[3] = this.getObjectFromRESTObject((RESTObject)args[3], processUUID);
        }
    }

    private boolean isGetModifiedObjectMethod(Method m, Object[] args) {
        return m.getName().equals("getModifiedJavaObject") && args[0] instanceof ProcessDefinitionUUID && args.length == 4;
    }

    private void processInstantiateProcessMethod(Object[] args) {
        ClassLoader localClassLoader = EnvTool.getClassDataLoader().getProcessClassLoader((ProcessDefinitionUUID)args[0]);
        Thread.currentThread().setContextClassLoader(localClassLoader);
        args[1] = ((RESTMap)args[1]).getActualMap();
    }

    private boolean isInstantiateProcessMethod(Method m, Object[] args) {
        return m.getName().equals("instantiateProcess") && (args.length == 2 || args.length == 3) && args[1] instanceof RESTMap;
    }

    private void processExecuteMethod(Object[] args, ClassLoader localClassLoader) throws IOException, ClassNotFoundException {
        if (args.length == 1) {
            localClassLoader = EnvTool.getClassDataLoader().getCommonClassLoader();
        } else if (args.length == 2 && args[1] instanceof ProcessDefinitionUUID) {
            localClassLoader = EnvTool.getClassDataLoader().getProcessClassLoader((ProcessDefinitionUUID)args[1]);
        }
        Thread.currentThread().setContextClassLoader(localClassLoader);
        args[0] = ((RESTCommand)args[0]).getCommand();
    }

    private boolean isExecuteMethod(Method m, Object[] args) {
        return m.getName().equals("execute") && args.length >= 1 && args[0] instanceof RESTCommand;
    }

    private void processSetVariableMethods(Object[] args) throws IOException, ClassNotFoundException, ActivityDefNotFoundException, ProcessNotFoundException, DataFieldNotFoundException {
        String variableName;
        DataFieldDefinition dataField;
        String variableValue;
        ProcessDefinitionUUID processUUID = null;
        InternalActivityInstance activity = null;
        if (args[0] instanceof ActivityInstanceUUID) {
            ActivityInstanceUUID activityUUID = (ActivityInstanceUUID)args[0];
            activity = EnvTool.getAllQueriers().getActivityInstance(activityUUID);
            processUUID = activity.getProcessDefinitionUUID();
        } else if (args[0] instanceof ProcessInstanceUUID) {
            ProcessInstanceUUID instanceUUID = (ProcessInstanceUUID)args[0];
            InternalProcessInstance instance = EnvTool.getAllQueriers().getProcessInstance(instanceUUID);
            processUUID = instance.getProcessDefinitionUUID();
        }
        if (args[2] instanceof RESTObject) {
            args[2] = this.getObjectFromRESTObject((RESTObject)args[2], processUUID);
        } else if (args[2] instanceof String && (variableValue = (String)args[2]).startsWith("<") && !(dataField = this.getDataFieldDefinition(processUUID, activity, variableName = (String)args[1])).getDataTypeClassName().equals(String.class.getName())) {
            args[2] = this.getObjectFromXML(variableValue, processUUID);
        }
    }

    private boolean isSetVariableMethod(Object[] args, Method m) {
        return !(!m.getName().equals(SET_VARIABLE) && !m.getName().equals(SET_PROCESS_INSTANCE_VARIABLE) && !m.getName().equals(SET_ACTIVITY_INSTANCE_VARIABLE) || args.length != 3 || !(args[2] instanceof RESTObject) && !(args[2] instanceof String));
    }

    private DataFieldDefinition getDataFieldDefinition(ProcessDefinitionUUID processUUID, ActivityInstance activity, String variableName) throws ActivityDefNotFoundException, ProcessNotFoundException, DataFieldNotFoundException {
        StandardAPIAccessorImpl apiAccessor = new StandardAPIAccessorImpl();
        QueryDefinitionAPI queryDefinitionAPI = apiAccessor.getQueryDefinitionAPI();
        DataFieldDefinition dataField = null;
        if (activity != null) {
            try {
                dataField = queryDefinitionAPI.getActivityDataField(activity.getActivityDefinitionUUID(), variableName);
            }
            catch (DataFieldNotFoundException e) {
                dataField = queryDefinitionAPI.getProcessDataField(processUUID, variableName);
            }
        } else {
            dataField = queryDefinitionAPI.getProcessDataField(processUUID, variableName);
        }
        return dataField;
    }

    private boolean isAmbigousReturnType(Method m, Object ret) {
        if (ret == null || !ret.getClass().isArray()) {
            return false;
        }
        String methodName = m.getName();
        return "execute".equals(methodName) || "getVariable".equals(methodName) || "getActivityInstanceVariable".equals(methodName) || "getProcessInstanceVariable".equals(methodName) || "evaluateGroovyExpression".equals(methodName);
    }

    private Object getObjectFromRESTObject(RESTObject restObject, ProcessDefinitionUUID processUUID) throws IOException, ClassNotFoundException {
        Serializable result = null;
        ClassLoader localClassLoader = null;
        try {
            result = restObject.getObject();
        }
        catch (ClassNotFoundException e) {
            localClassLoader = EnvTool.getClassDataLoader().getProcessClassLoader(processUUID);
            Thread.currentThread().setContextClassLoader(localClassLoader);
            try {
                result = restObject.getObject();
            }
            catch (ClassNotFoundException ex) {
                localClassLoader = EnvTool.getClassDataLoader().getCommonClassLoader();
                Thread.currentThread().setContextClassLoader(localClassLoader);
                result = restObject.getObject();
            }
        }
        return result;
    }

    private Object getObjectFromXML(String xmlRepresentation, ProcessDefinitionUUID processUUID) {
        XStream xstream = XStreamUtil.getDefaultXstream();
        Object result = null;
        ClassLoader localClassLoader = null;
        try {
            result = xstream.fromXML(xmlRepresentation);
        }
        catch (Exception e) {
            localClassLoader = EnvTool.getClassDataLoader().getProcessClassLoader(processUUID);
            Thread.currentThread().setContextClassLoader(localClassLoader);
            try {
                result = xstream.fromXML(xmlRepresentation);
            }
            catch (Exception ex) {
                localClassLoader = EnvTool.getClassDataLoader().getCommonClassLoader();
                Thread.currentThread().setContextClassLoader(localClassLoader);
                result = xstream.fromXML(xmlRepresentation);
            }
        }
        return result;
    }

    private Throwable getRemoteCause(RemoteException e) {
        Throwable t = e;
        while (t instanceof RemoteException) {
            t = ((Throwable)t).getCause();
        }
        return t;
    }
}

