/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.runtime.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.QueryRuntimeAPI;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.runtime.ActivityState;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.light.LightActivityInstance;
import org.ow2.bonita.util.Command;

public class GetProcessInstancesActivitiesCommand
implements Command<Map<ProcessInstanceUUID, List<LightActivityInstance>>> {
    private static final long serialVersionUID = 1L;
    private final Set<ProcessInstanceUUID> instanceUUIDs;
    private final boolean considerSystemTaks;

    public GetProcessInstancesActivitiesCommand(Set<ProcessInstanceUUID> instanceUUIDs, boolean considerSystemTaks) {
        this.instanceUUIDs = instanceUUIDs;
        this.considerSystemTaks = considerSystemTaks;
    }

    @Override
    public Map<ProcessInstanceUUID, List<LightActivityInstance>> execute(Environment environment) throws Exception {
        Map<ProcessInstanceUUID, List<LightActivityInstance>> activities;
        block4: {
            QueryRuntimeAPI allQueryRuntimeAPI;
            QueryRuntimeAPI journalQueryRuntimeAPI;
            block3: {
                StandardAPIAccessorImpl accessor = new StandardAPIAccessorImpl();
                journalQueryRuntimeAPI = accessor.getQueryRuntimeAPI("journalQueryList");
                allQueryRuntimeAPI = accessor.getQueryRuntimeAPI();
                if (!this.considerSystemTaks) break block3;
                Map<ProcessInstanceUUID, LightActivityInstance> lastUpdatedActivities = allQueryRuntimeAPI.getLightLastUpdatedActivityInstanceFromRoot(this.instanceUUIDs, this.considerSystemTaks);
                activities = new HashMap<ProcessInstanceUUID, List<LightActivityInstance>>();
                for (Map.Entry<ProcessInstanceUUID, LightActivityInstance> entry : lastUpdatedActivities.entrySet()) {
                    activities.put(entry.getKey(), Arrays.asList(entry.getValue()));
                }
                break block4;
            }
            activities = journalQueryRuntimeAPI.getLightActivityInstancesFromRoot(this.instanceUUIDs, ActivityState.READY);
            HashSet<ProcessInstanceUUID> instancesWithoutReadyTask = new HashSet<ProcessInstanceUUID>();
            for (ProcessInstanceUUID instanceUUID : this.instanceUUIDs) {
                if (activities.get(instanceUUID) != null && !activities.get(instanceUUID).isEmpty()) continue;
                instancesWithoutReadyTask.add(instanceUUID);
            }
            if (instancesWithoutReadyTask.isEmpty()) break block4;
            Map<ProcessInstanceUUID, LightActivityInstance> lastUpdatedActivities = allQueryRuntimeAPI.getLightLastUpdatedActivityInstanceFromRoot(instancesWithoutReadyTask, this.considerSystemTaks);
            for (Map.Entry<ProcessInstanceUUID, LightActivityInstance> entry : lastUpdatedActivities.entrySet()) {
                ArrayList<LightActivityInstance> list = new ArrayList<LightActivityInstance>();
                list.add(entry.getValue());
                activities.put(entry.getKey(), list);
            }
        }
        return activities;
    }
}

