/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.runtime.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.ManagementAPI;
import org.ow2.bonita.facade.QueryRuntimeAPI;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.privilege.PrivilegePolicy;
import org.ow2.bonita.facade.privilege.Rule;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.light.LightProcessInstance;
import org.ow2.bonita.util.Command;

public class WebGetLightProcessInstancesFromActiveUsers
implements Command<List<LightProcessInstance>> {
    private static final long serialVersionUID = 6000496066108490089L;
    private String userId;
    private final Collection<String> roleUUIDs;
    private final Collection<String> groupUUIDs;
    private final Collection<String> membershipUUIDs;
    private final String username;
    private int fromIndex;
    private int pageSize;

    public WebGetLightProcessInstancesFromActiveUsers(String userUUID, Collection<String> roleUUIDs, Collection<String> groupUUIDs, Collection<String> membershipUUIDs, String username, int fromIndex, int pageSize) {
        this.userId = userUUID;
        this.roleUUIDs = roleUUIDs;
        this.groupUUIDs = groupUUIDs;
        this.membershipUUIDs = membershipUUIDs;
        this.username = username;
        this.fromIndex = fromIndex;
        this.pageSize = pageSize;
    }

    @Override
    public List<LightProcessInstance> execute(Environment environment) throws Exception {
        StandardAPIAccessorImpl accessor = new StandardAPIAccessorImpl();
        QueryRuntimeAPI queryRuntimeAPI = accessor.getQueryRuntimeAPI("journalQueryList");
        ManagementAPI managementAPI = accessor.getManagementAPI();
        List<Object> applicableRules = new ArrayList();
        HashSet<String> exceptions = new HashSet<String>();
        applicableRules = managementAPI.getApplicableRules(Rule.RuleType.PROCESS_READ, this.userId, this.roleUUIDs, this.groupUUIDs, this.membershipUUIDs, this.username);
        for (Rule rule : applicableRules) {
            exceptions.addAll(rule.getItems());
        }
        HashSet<ProcessDefinitionUUID> processUUIDs = new HashSet<ProcessDefinitionUUID>();
        for (String processUUID : exceptions) {
            processUUIDs.add(new ProcessDefinitionUUID(processUUID));
        }
        PrivilegePolicy privilegePolicy = managementAPI.getRuleTypePolicy(Rule.RuleType.PROCESS_READ);
        switch (privilegePolicy) {
            case ALLOW_BY_DEFAULT: {
                List<LightProcessInstance> result;
                if (processUUIDs != null && !processUUIDs.isEmpty()) {
                    result = queryRuntimeAPI.getLightParentProcessInstancesWithActiveUserExcept(this.username, this.fromIndex, this.pageSize, processUUIDs);
                    return result;
                }
                result = queryRuntimeAPI.getLightParentProcessInstancesWithActiveUser(this.username, this.fromIndex, this.pageSize);
                return result;
            }
            case DENY_BY_DEFAULT: {
                List<LightProcessInstance> result;
                if (processUUIDs.size() > 0) {
                    result = queryRuntimeAPI.getLightParentProcessInstancesWithActiveUser(this.username, this.fromIndex, this.pageSize, processUUIDs);
                    return result;
                }
                return Collections.emptyList();
            }
        }
        throw new IllegalArgumentException();
    }
}

