/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.runtime.command;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.ManagementAPI;
import org.ow2.bonita.facade.QueryRuntimeAPI;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.privilege.PrivilegePolicy;
import org.ow2.bonita.facade.privilege.Rule;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.util.Command;

public class WebGetNumberOfParentProcessInstancesWithOverdueTasks
implements Command<Integer> {
    private static final long serialVersionUID = 6841540520107266785L;
    private String userId;
    private final Set<String> roleUUIDs;
    private final Set<String> groupUUIDs;
    private final Set<String> membershipUUIDs;
    private final String username;

    public WebGetNumberOfParentProcessInstancesWithOverdueTasks(String userId, Set<String> roleUUIDs, Set<String> groupUUIDs, Set<String> membershipUUIDs, String username) {
        this.userId = userId;
        this.roleUUIDs = roleUUIDs;
        this.groupUUIDs = groupUUIDs;
        this.membershipUUIDs = membershipUUIDs;
        this.username = username;
    }

    @Override
    public Integer execute(Environment environment) throws Exception {
        StandardAPIAccessorImpl accessor = new StandardAPIAccessorImpl();
        QueryRuntimeAPI queryRuntimeAPI = accessor.getQueryRuntimeAPI("journalQueryList");
        ManagementAPI managementAPI = accessor.getManagementAPI();
        List<Object> applicableRules = new ArrayList();
        HashSet<String> exceptions = new HashSet<String>();
        applicableRules = managementAPI.getApplicableRules(Rule.RuleType.PROCESS_READ, this.userId, this.roleUUIDs, this.groupUUIDs, this.membershipUUIDs, this.username);
        for (Rule rule : applicableRules) {
            exceptions.addAll(rule.getItems());
        }
        HashSet<ProcessDefinitionUUID> processUUIDs = new HashSet<ProcessDefinitionUUID>();
        for (String processUUID : exceptions) {
            processUUIDs.add(new ProcessDefinitionUUID(processUUID));
        }
        PrivilegePolicy privilegePolicy = managementAPI.getRuleTypePolicy(Rule.RuleType.PROCESS_READ);
        switch (privilegePolicy) {
            case ALLOW_BY_DEFAULT: {
                Integer result;
                if (processUUIDs != null && !processUUIDs.isEmpty()) {
                    result = queryRuntimeAPI.getNumberOfParentProcessInstancesWithOverdueTasksExcept(this.username, processUUIDs);
                    return result;
                }
                result = queryRuntimeAPI.getNumberOfParentProcessInstancesWithOverdueTasks(this.username);
                return result;
            }
            case DENY_BY_DEFAULT: {
                Integer result;
                if (processUUIDs.size() > 0) {
                    result = queryRuntimeAPI.getNumberOfParentProcessInstancesWithOverdueTasks(this.username, processUUIDs);
                    return result;
                }
                return 0;
            }
        }
        throw new IllegalArgumentException();
    }
}

