/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.runtime.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.ManagementAPI;
import org.ow2.bonita.facade.WebAPI;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.privilege.PrivilegePolicy;
import org.ow2.bonita.facade.privilege.Rule;
import org.ow2.bonita.facade.runtime.Category;
import org.ow2.bonita.facade.uuid.CategoryUUID;
import org.ow2.bonita.util.Command;

public class WebGetVisibleCategoriesCommand
implements Command<Set<Category>> {
    private static final long serialVersionUID = 7823810918005448800L;
    private final String userUUID;
    private final Collection<String> roleUUIDs;
    private final Collection<String> groupUUIDs;
    private final Collection<String> membershipUUIDs;
    private final String entityID;

    public WebGetVisibleCategoriesCommand(String userUUID, Collection<String> roleUUIDs, Collection<String> groupUUIDs, Collection<String> membershipUUIDs, String entityID) {
        this.userUUID = userUUID;
        this.roleUUIDs = roleUUIDs;
        this.groupUUIDs = groupUUIDs;
        this.membershipUUIDs = membershipUUIDs;
        this.entityID = entityID;
    }

    @Override
    public Set<Category> execute(Environment environment) throws Exception {
        StandardAPIAccessorImpl accessor = new StandardAPIAccessorImpl();
        ManagementAPI managementAPI = accessor.getManagementAPI();
        WebAPI webAPI = accessor.getWebAPI();
        List<Object> applicableRules = new ArrayList();
        HashSet<CategoryUUID> exceptions = new HashSet<CategoryUUID>();
        applicableRules = managementAPI.getApplicableRules(Rule.RuleType.CATEGORY_READ, this.userUUID, this.roleUUIDs, this.groupUUIDs, this.membershipUUIDs, this.entityID);
        for (Rule rule : applicableRules) {
            for (String theCategoryID : rule.getItems()) {
                exceptions.add(new CategoryUUID(theCategoryID));
            }
        }
        PrivilegePolicy currentPolicy = managementAPI.getRuleTypePolicy(Rule.RuleType.CATEGORY_READ);
        switch (currentPolicy) {
            case ALLOW_BY_DEFAULT: {
                if (exceptions != null && !exceptions.isEmpty()) {
                    return webAPI.getAllCategoriesByUUIDExcept(exceptions);
                }
                return webAPI.getAllCategories();
            }
            case DENY_BY_DEFAULT: {
                if (exceptions.size() > 0) {
                    Set<Category> set = webAPI.getCategoriesByUUIDs(exceptions);
                    if (set == null || set.isEmpty()) {
                        return Collections.emptySet();
                    }
                    return set;
                }
                return Collections.emptySet();
            }
        }
        throw new IllegalArgumentException();
    }
}

