/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.facade.runtime.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ow2.bonita.facade.runtime.ActivityInstance;
import org.ow2.bonita.facade.runtime.AttachmentInstance;
import org.ow2.bonita.facade.runtime.Comment;
import org.ow2.bonita.facade.runtime.InstanceStateUpdate;
import org.ow2.bonita.facade.runtime.ProcessInstance;
import org.ow2.bonita.facade.runtime.TaskInstance;
import org.ow2.bonita.facade.runtime.VariableUpdate;
import org.ow2.bonita.facade.runtime.impl.ActivityInstanceImpl;
import org.ow2.bonita.facade.runtime.impl.AttachmentInstanceImpl;
import org.ow2.bonita.facade.runtime.impl.CommentImpl;
import org.ow2.bonita.facade.runtime.impl.InstanceStateUpdateImpl;
import org.ow2.bonita.facade.runtime.impl.VariableUpdateImpl;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.light.impl.LightProcessInstanceImpl;
import org.ow2.bonita.util.CopyTool;
import org.ow2.bonita.util.Misc;

public class ProcessInstanceImpl
extends LightProcessInstanceImpl
implements ProcessInstance {
    private static final long serialVersionUID = 8366284714927360659L;
    protected Set<ProcessInstanceUUID> childrenInstanceUUID;
    protected Map<String, Object> clientVariables;
    protected List<VariableUpdate> variableUpdates = new ArrayList<VariableUpdate>();
    protected List<InstanceStateUpdate> instanceStateUpdates = new ArrayList<InstanceStateUpdate>();
    protected List<Comment> commentFeed;
    protected Set<ActivityInstance> activities;
    protected List<AttachmentInstance> attachments;
    protected Set<String> involvedUsers;
    protected Set<String> activeUsers;

    @Override
    public String toString() {
        return this.getClass().getName() + "[uuid: " + this.getUUID() + ", processDefinitionUUID: " + this.getProcessDefinitionUUID() + ", processUUID: " + this.getProcessInstanceUUID() + ", parentInstanceUUID: " + this.getParentInstanceUUID() + ", rootInstanceUUID: " + this.getRootInstanceUUID() + ", childrenInstanceUUID: " + this.getChildrenInstanceUUID() + ", startedBy: " + this.getStartedBy() + ", endedBy: " + this.getEndedBy() + ", startedDate: " + this.getStartedDate() + ", endedDate: " + this.getEndedDate() + ", initialVariableValues: " + this.getInitialVariableValues() + ", activeUsers: " + (this.getActiveUsers() == null ? 0 : this.getActiveUsers().size()) + "]";
    }

    protected ProcessInstanceImpl() {
    }

    protected ProcessInstanceImpl(ProcessDefinitionUUID processUUID, ProcessInstanceUUID instanceUUID, ProcessInstanceUUID rootInstanceUUID, long iterationId) {
        super(processUUID, instanceUUID, rootInstanceUUID, iterationId);
        this.commentFeed = new ArrayList<Comment>();
    }

    public ProcessInstanceImpl(ProcessInstance processInstance) {
        super(processInstance);
        List<AttachmentInstance> lai;
        List<InstanceStateUpdate> lisu;
        Set<ProcessInstanceUUID> children = processInstance.getChildrenInstanceUUID();
        if (children != null && !children.isEmpty()) {
            this.childrenInstanceUUID = new HashSet<ProcessInstanceUUID>();
            for (ProcessInstanceUUID child : children) {
                this.childrenInstanceUUID.add(child);
            }
        }
        this.clientVariables = processInstance.getInitialVariableValues();
        List<VariableUpdate> vu = processInstance.getVariableUpdates();
        if (vu != null && !vu.isEmpty()) {
            this.variableUpdates = new ArrayList<VariableUpdate>();
            for (VariableUpdate varUpdate : vu) {
                this.variableUpdates.add(new VariableUpdateImpl(varUpdate));
            }
        }
        if ((lisu = processInstance.getInstanceStateUpdates()) != null && !lisu.isEmpty()) {
            this.instanceStateUpdates = new ArrayList<InstanceStateUpdate>();
            for (InstanceStateUpdate isu : lisu) {
                this.instanceStateUpdates.add(new InstanceStateUpdateImpl(isu));
            }
        }
        if ((lai = processInstance.getAttachments()) != null && !lai.isEmpty()) {
            this.attachments = new ArrayList<AttachmentInstance>();
            for (AttachmentInstance ai : lai) {
                this.attachments.add(new AttachmentInstanceImpl(ai));
            }
        }
        List<Comment> comments = processInstance.getCommentFeed();
        this.commentFeed = new ArrayList<Comment>();
        for (Comment comment : comments) {
            this.commentFeed.add(new CommentImpl(comment));
        }
        Set<ActivityInstance> acts = processInstance.getActivities();
        if (acts != null) {
            this.activities = new HashSet<ActivityInstance>();
            for (ActivityInstance activity : acts) {
                this.activities.add(new ActivityInstanceImpl(activity));
            }
        }
        this.involvedUsers = CopyTool.copy(processInstance.getInvolvedUsers());
        if (processInstance.getActiveUsers() != null) {
            this.activeUsers = new HashSet<String>();
            for (String activeUser : processInstance.getActiveUsers()) {
                this.activeUsers.add(activeUser);
            }
        }
    }

    @Override
    public Set<String> getInvolvedUsers() {
        return this.involvedUsers;
    }

    @Override
    public Map<String, Object> getInitialVariableValues() {
        return this.clientVariables;
    }

    @Override
    public Set<ProcessInstanceUUID> getChildrenInstanceUUID() {
        if (this.childrenInstanceUUID == null) {
            return new HashSet<ProcessInstanceUUID>();
        }
        return this.childrenInstanceUUID;
    }

    @Override
    public Object getInitialVariableValue(String variableId) {
        return this.getInitialVariableValues().get(variableId);
    }

    @Override
    public Map<String, Object> getLastKnownVariableValues() {
        Map<String, Object> var = this.getInitialVariableValues();
        var = var != null ? new HashMap<String, Object>(var) : new HashMap<String, Object>();
        for (VariableUpdate varUp : this.getVariableUpdates()) {
            var.put(varUp.getName(), varUp.getValue());
        }
        return var;
    }

    @Override
    public List<VariableUpdate> getVariableUpdates() {
        if (this.variableUpdates == null) {
            return Collections.emptyList();
        }
        return this.variableUpdates;
    }

    @Override
    public List<InstanceStateUpdate> getInstanceStateUpdates() {
        return this.instanceStateUpdates;
    }

    @Override
    public List<Comment> getCommentFeed() {
        return this.commentFeed;
    }

    @Override
    public Set<ActivityInstance> getActivities() {
        return this.activities;
    }

    @Override
    public List<AttachmentInstance> getAttachments() {
        if (this.attachments == null) {
            return Collections.emptyList();
        }
        return this.attachments;
    }

    @Override
    public List<AttachmentInstance> getAttachments(String attachmentName) {
        ArrayList<AttachmentInstance> matchingAttachments = new ArrayList<AttachmentInstance>();
        for (AttachmentInstance attachmentInstance : this.getAttachments()) {
            if (!attachmentName.equals(attachmentInstance.getName())) continue;
            matchingAttachments.add(attachmentInstance);
        }
        return matchingAttachments;
    }

    @Override
    public Set<TaskInstance> getTasks() {
        HashSet<TaskInstance> matchingActivities = new HashSet<TaskInstance>();
        if (this.getActivities() != null) {
            for (ActivityInstance activity : this.getActivities()) {
                if (!activity.isTask()) continue;
                matchingActivities.add(activity.getTask());
            }
        }
        return matchingActivities;
    }

    @Override
    public Set<ActivityInstance> getActivities(String activityId) {
        HashSet<ActivityInstance> matchingActivities = new HashSet<ActivityInstance>();
        if (this.getActivities() != null) {
            for (ActivityInstance activity : this.getActivities()) {
                if (!activity.getActivityName().equals(activityId)) continue;
                matchingActivities.add(activity);
            }
        }
        return matchingActivities;
    }

    @Override
    public ActivityInstance getActivity(String activityId, String iterationId, String activityInstanceId) {
        if (this.getActivities() != null) {
            for (ActivityInstance activity : this.getActivities()) {
                if (!activity.getActivityName().equals(activityId) || (activity.getIterationId() != null || iterationId != null) && !activity.getIterationId().equals(iterationId) || (activity.getActivityInstanceId() != null || activityInstanceId != null) && !activity.getActivityInstanceId().equals(activityInstanceId)) continue;
                return activity;
            }
        }
        return null;
    }

    @Override
    public ActivityInstance getActivity(ActivityInstanceUUID activityUUID) {
        if (this.getActivities() != null) {
            for (ActivityInstance activity : this.getActivities()) {
                if (!activity.getUUID().equals(activityUUID)) continue;
                return activity;
            }
        }
        return null;
    }

    @Override
    public long getNb() {
        return this.nb;
    }

    public void setStartedDate(Date date) {
        this.startedDate = Misc.getTime(date);
    }

    public void setEndedDate(Date date) {
        this.endedDate = Misc.getTime(date);
    }

    @Override
    public ProcessInstanceUUID getRootInstanceUUID() {
        return this.rootInstanceUUID;
    }

    public void addInvolvedUser(String user) {
        if (user != null) {
            if (this.involvedUsers == null) {
                this.involvedUsers = new HashSet<String>();
            }
            this.involvedUsers.add(user);
        }
    }

    public void addInvolvedUsers(Set<String> users) {
        if (users != null) {
            if (this.involvedUsers == null) {
                this.involvedUsers = new HashSet<String>();
            }
            this.involvedUsers.addAll(users);
        }
    }

    public void setIsArchived(boolean isArchived) {
        this.isArchived = isArchived;
    }

    @Override
    public Set<String> getActiveUsers() {
        if (this.activeUsers != null) {
            return new HashSet<String>(this.activeUsers);
        }
        return Collections.emptySet();
    }

    public void addActiveUser(String user) {
        if (user != null) {
            if (this.activeUsers == null) {
                this.activeUsers = new HashSet<String>();
            }
            this.activeUsers.add(user);
        }
    }

    public void addActiveUsers(Set<String> users) {
        if (users != null) {
            if (this.activeUsers == null) {
                this.activeUsers = new HashSet<String>();
            }
            this.activeUsers.addAll(users);
        }
    }

    public void removeActiveUser(String user) {
        if (user != null) {
            HashSet<String> usersToBeRemoved = new HashSet<String>();
            usersToBeRemoved.add(user);
            this.removeActiveUsers(usersToBeRemoved);
        }
    }

    public void removeActiveUsers(Set<String> users) {
        if (users != null && !users.isEmpty()) {
            HashSet<String> usersToRemove = new HashSet<String>(users);
            if (this.activeUsers != null && this.activeUsers.size() > 0) {
                for (String userToBeRemoved : usersToRemove) {
                    if (!this.activeUsers.contains(userToBeRemoved)) continue;
                    this.activeUsers.remove(userToBeRemoved);
                }
            }
        }
    }
}

