/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.light.impl;

import java.util.Date;
import org.ow2.bonita.facade.runtime.InstanceState;
import org.ow2.bonita.facade.runtime.ProcessInstance;
import org.ow2.bonita.facade.runtime.impl.RuntimeRecordImpl;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.light.LightProcessInstance;
import org.ow2.bonita.util.Misc;

public class LightProcessInstanceImpl
extends RuntimeRecordImpl
implements LightProcessInstance {
    private static final long serialVersionUID = 8366284714927360659L;
    protected ProcessInstanceUUID parentInstanceUUID;
    protected ActivityInstanceUUID parentActivityUUID;
    protected long nb;
    protected long lastUpdate;
    protected InstanceState state;
    protected String endedBy;
    protected long endedDate;
    protected String startedBy;
    protected long startedDate;
    protected boolean isArchived;

    protected LightProcessInstanceImpl() {
    }

    public LightProcessInstanceImpl(ProcessDefinitionUUID processUUID, ProcessInstanceUUID instanceUUID, ProcessInstanceUUID rootInstanceUUID, long instanceNb) {
        super(processUUID, instanceUUID, rootInstanceUUID);
        this.nb = instanceNb;
        this.state = InstanceState.STARTED;
        this.lastUpdate = System.currentTimeMillis();
        this.isArchived = false;
    }

    public LightProcessInstanceImpl(ProcessInstance processInstance) {
        super(processInstance);
        if (processInstance.getParentInstanceUUID() != null) {
            this.parentInstanceUUID = new ProcessInstanceUUID(processInstance.getParentInstanceUUID());
        }
        if (processInstance.getParentActivityUUID() != null) {
            this.parentActivityUUID = new ActivityInstanceUUID(processInstance.getParentActivityUUID());
        }
        this.nb = processInstance.getNb();
        this.lastUpdate = Misc.getTime(processInstance.getLastUpdate());
        this.state = processInstance.getInstanceState();
        this.endedBy = processInstance.getEndedBy();
        this.endedDate = Misc.getTime(processInstance.getEndedDate());
        this.startedBy = processInstance.getStartedBy();
        this.startedDate = Misc.getTime(processInstance.getStartedDate());
        this.isArchived = processInstance.isArchived();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        LightProcessInstanceImpl other = (LightProcessInstanceImpl)obj;
        if (other.getUUID() == null) {
            return this.getUUID() == null;
        }
        return other.getUUID().equals(this.getUUID());
    }

    public int hashCode() {
        return this.getUUID().hashCode();
    }

    @Override
    public String getEndedBy() {
        return this.endedBy;
    }

    @Override
    public Date getEndedDate() {
        return Misc.getDate(this.endedDate);
    }

    @Override
    public String getStartedBy() {
        return this.startedBy;
    }

    @Override
    public Date getStartedDate() {
        return Misc.getDate(this.startedDate);
    }

    @Override
    public InstanceState getInstanceState() {
        return this.state;
    }

    @Override
    public ProcessInstanceUUID getParentInstanceUUID() {
        return this.parentInstanceUUID;
    }

    @Override
    public ActivityInstanceUUID getParentActivityUUID() {
        return this.parentActivityUUID;
    }

    @Override
    public ProcessInstanceUUID getUUID() {
        return this.getProcessInstanceUUID();
    }

    @Override
    public Date getLastUpdate() {
        return Misc.getDate(this.lastUpdate);
    }

    @Override
    public long getNb() {
        return this.nb;
    }

    @Override
    public ProcessInstanceUUID getRootInstanceUUID() {
        return this.rootInstanceUUID;
    }

    @Override
    public boolean isArchived() {
        return this.isArchived;
    }

    public String toString() {
        return this.getClass().getName() + "[uuid: " + this.getUUID() + ", processDefinitionUUID: " + this.getProcessDefinitionUUID() + ", processUUID: " + this.getProcessInstanceUUID() + ", parentInstanceUUID: " + this.getParentInstanceUUID() + ", parentActivityUUID: " + this.getParentActivityUUID() + ", startedBy: " + this.getStartedBy() + ", endedBy: " + this.getEndedBy() + ", startedDate: " + this.getStartedDate() + ", endedDate: " + this.getEndedDate() + ", rootInstanceUUID: " + this.getRootInstanceUUID() + ", archived:" + this.isArchived + "]";
    }
}

