/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.runtime.event;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.runtime.event.EventAddedNotification;
import org.ow2.bonita.runtime.event.EventMatcher;
import org.ow2.bonita.runtime.event.ExpressionMessageEventAddedNotification;
import org.ow2.bonita.runtime.event.ExpressionMessageEventMatcher;
import org.ow2.bonita.runtime.event.GetDomainCommand;
import org.ow2.bonita.runtime.event.JobExecutor;
import org.ow2.bonita.runtime.event.JobExecutorThread;
import org.ow2.bonita.runtime.event.NewJobNotification;
import org.ow2.bonita.services.CommandService;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.Misc;
import org.ow2.bonita.util.ReflectUtil;

public class EventExecutor
implements Serializable {
    private static final Logger LOG = Logger.getLogger(EventExecutor.class.getName());
    private static final long serialVersionUID = 1L;
    transient CommandService commandService;
    int nbrOfThreads = 3;
    int idleMillis = 5000;
    int lockMillis = 120000;
    int minimumInterval = 50;
    int retries = 1;
    boolean expressionMessageMatcherEnable = true;
    boolean mainMatcherEnable = true;
    String name;
    private transient ThreadPoolExecutor threadPool;
    private transient EventMatcher eventMatcher = null;
    private transient ExpressionMessageEventMatcher expressionMessageMatcher = null;
    String jobExecutorClassName;
    private transient JobExecutor jobExecutor = null;
    int maxParallelJobs = 50;
    boolean cleanLocks = false;
    private boolean isActive = false;

    public synchronized void start() {
        String domain = this.commandService.execute(new GetDomainCommand());
        this.name = EventExecutor.class.getSimpleName() + "-" + Misc.getHostName() + "-" + domain;
        if (this.isActive) {
            LOG.severe("Cannot start event executor '" + this.name + "' because it is already running...");
            return;
        }
        if (!this.isActive) {
            this.isActive = true;
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("starting event executor threads for event executor '" + this.name + "'...");
            }
            this.threadPool = new ThreadPoolExecutor(this.nbrOfThreads, this.nbrOfThreads, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(this.nbrOfThreads), EventRejectionHandler.INSTANCE);
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Starting job dispatcher thread for executing events '" + this.name + "'...");
            }
            Class<?> jobExecutorClass = ReflectUtil.loadClass(Thread.currentThread().getContextClassLoader(), this.jobExecutorClassName);
            Constructor<?> constructor = ReflectUtil.getConstructor(jobExecutorClass, new Class[]{EventExecutor.class, String.class});
            this.jobExecutor = (JobExecutor)ReflectUtil.newInstance(constructor, new Object[]{this, JobExecutorThread.class.getSimpleName() + "-" + Misc.getHostName() + "-" + domain});
            this.jobExecutor.setMaxParallelJobs(this.maxParallelJobs);
            this.jobExecutor.setCleanLocks(this.cleanLocks);
            this.jobExecutor.start();
            if (this.expressionMessageMatcherEnable) {
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.info("Starting matcher of message correlation based on an expression '" + this.name + "'...");
                }
                this.expressionMessageMatcher = new ExpressionMessageEventMatcher(this, ExpressionMessageEventMatcher.class.getSimpleName() + "-" + Misc.getHostName() + "-" + domain);
                this.expressionMessageMatcher.start();
            }
            if (this.mainMatcherEnable) {
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.info("Starting matcher of message correlation based on correlation keys/no expression '" + this.name + "'...");
                }
                this.eventMatcher = new EventMatcher(this, EventMatcher.class.getSimpleName() + "-" + Misc.getHostName() + "-" + domain);
                this.eventMatcher.start();
            }
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public synchronized void stop() {
        this.stop(false);
    }

    public synchronized void stop(boolean join) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("stopping event executor");
        }
        if (this.isActive) {
            this.isActive = false;
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Event executor: deactivating job dispatcher thread...");
            }
            this.jobExecutor.deactivate(true);
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Event executor: job dispatcher thread deactivated...");
            }
            if (this.eventMatcher != null) {
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.info("Event executor: deactivating event matcher...");
                }
                this.eventMatcher.deactivate(true);
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.info("Event executor: message event deactivated...");
                }
            }
            if (this.expressionMessageMatcher != null) {
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.info("Event executor: deactivating expression message matcher...");
                }
                this.expressionMessageMatcher.deactivate(true);
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.info("Event executor: expression message matcher deactivated...");
                }
            }
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Event executor: shutdown threadpool...");
            }
            this.threadPool.shutdown();
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Event executor: threadpool shutdowned...");
            }
            if (join) {
                try {
                    if (LOG.isLoggable(Level.INFO)) {
                        LOG.info("Event executor: waiting for threadPool termination...");
                    }
                    this.threadPool.awaitTermination(300000L, TimeUnit.MILLISECONDS);
                    if (LOG.isLoggable(Level.INFO)) {
                        LOG.info("Event executor: threadPool termination OK...");
                    }
                }
                catch (InterruptedException e) {
                    LOG.severe("joining got interrupted");
                }
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("ignoring stop: event executor '" + this.name + "' not started");
        }
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Event executor stopped");
        }
    }

    public int getNbrOfThreads() {
        return this.nbrOfThreads;
    }

    public ThreadPoolExecutor getThreadPool() {
        return this.threadPool;
    }

    public int getIdleMillis() {
        return this.idleMillis;
    }

    public int getLockMillis() {
        return this.lockMillis;
    }

    public CommandService getCommandService() {
        return this.commandService;
    }

    public int getMinimumInterval() {
        return this.minimumInterval;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setCommandService(CommandService commandService) {
        this.commandService = commandService;
    }

    public void notifyJobThreadFinished(ProcessInstanceUUID rootInstanceUUID) {
        this.jobExecutor.notifyThreadFinished(rootInstanceUUID);
    }

    public void internalJobExecutorRefresh() {
        if (this.jobExecutor != null && this.jobExecutor.isActive()) {
            this.jobExecutor.refresh();
        }
    }

    public void internalExpressionMessageEventMatcherRefresh() {
        if (this.expressionMessageMatcher != null && this.expressionMessageMatcher.isActive()) {
            this.expressionMessageMatcher.refresh();
        }
    }

    public void internalEventMatcherRefresh() {
        if (this.eventMatcher != null && this.eventMatcher.isActive()) {
            this.eventMatcher.refresh();
        }
    }

    public void refreshJobExecutor() {
        EnvTool.getTransaction().registerSynchronization(new NewJobNotification(this));
    }

    public void refreshExpressionMessageEventMatcher() {
        EnvTool.getTransaction().registerSynchronization(new ExpressionMessageEventAddedNotification(this));
    }

    public void refreshMatchers() {
        EnvTool.getTransaction().registerSynchronization(new ExpressionMessageEventAddedNotification(this));
        EnvTool.getTransaction().registerSynchronization(new EventAddedNotification(this));
    }

    public void refreshEventMatcher() {
        EnvTool.getTransaction().registerSynchronization(new EventAddedNotification(this));
    }

    static final class EventRejectionHandler
    implements RejectedExecutionHandler {
        static final EventRejectionHandler INSTANCE = new EventRejectionHandler();

        EventRejectionHandler() {
        }

        @Override
        public void rejectedExecution(Runnable task, ThreadPoolExecutor executor) {
            try {
                executor.getQueue().put(task);
            }
            catch (InterruptedException e) {
                throw new RejectedExecutionException("queuing " + task + " got interrupted", e);
            }
        }
    }
}

