/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.runtime.model;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hibernate.AssertionFailure;
import org.hibernate.StaleStateException;
import org.hibernate.exception.LockAcquisitionException;
import org.ow2.bonita.definition.activity.ExternalActivity;
import org.ow2.bonita.facade.def.InternalActivityDefinition;
import org.ow2.bonita.facade.def.InternalProcessDefinition;
import org.ow2.bonita.facade.exception.UnRollbackableException;
import org.ow2.bonita.facade.runtime.impl.InternalActivityInstance;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.runtime.ExtensionPointsPolicy;
import org.ow2.bonita.runtime.model.Execution;
import org.ow2.bonita.services.Recorder;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.ExceptionManager;

public class ExecuteNode {
    static final Logger LOG = Logger.getLogger(ExecuteNode.class.getName());

    public void perform(Execution execution) {
        this.perform(execution, true);
    }

    public void perform(Execution execution, boolean checkJoinType) {
        InternalActivityDefinition node = execution.getNode();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(execution.toString() + " executes " + node);
        }
        ExternalActivity activity = node.getBehaviour();
        try {
            execution.setPropagation(Execution.Propagation.UNSPECIFIED);
            activity.execute(execution, checkJoinType);
        }
        catch (StaleStateException sse) {
            throw sse;
        }
        catch (AssertionFailure af) {
            throw af;
        }
        catch (LockAcquisitionException lae) {
            throw lae;
        }
        catch (UnRollbackableException ure) {
            throw ure;
        }
        catch (Throwable e) {
            this.handleException(execution, e);
        }
        if (execution.getPropagation() == Execution.Propagation.UNSPECIFIED) {
            execution.proceed();
        }
    }

    private void handleException(Execution execution, Throwable e) {
        if (LOG.isLoggable(Level.WARNING)) {
            InternalActivityInstance activityInstance = execution.getActivityInstance();
            if (activityInstance != null) {
                LOG.log(Level.WARNING, "Exception caught in activity instance " + activityInstance.getUUID() + " of process instance" + activityInstance.getProcessInstanceUUID(), e);
            } else {
                InternalProcessInstance instance = execution.getInstance();
                if (instance != null) {
                    LOG.log(Level.WARNING, "Exception caught in process instance " + instance.getUUID(), e);
                } else {
                    InternalActivityDefinition node = execution.getNode();
                    if (node != null) {
                        LOG.log(Level.WARNING, "Exception caught in activity " + node.getUUID() + " of process " + node.getProcessDefinitionUUID(), e);
                    } else {
                        InternalProcessDefinition definition = execution.getProcessDefinition();
                        if (definition != null) {
                            LOG.log(Level.WARNING, "Exception caught in process " + definition.getUUID(), e);
                        } else {
                            LOG.log(Level.WARNING, "Exception caught in execution " + execution.getName(), e);
                        }
                    }
                }
            }
        }
        Recorder recorder = EnvTool.getRecorder();
        Collection<Execution> executions = execution.getExecutions();
        if (executions != null && !executions.isEmpty()) {
            for (Execution nextExecution : executions) {
                InternalActivityInstance activityInstance = nextExecution.getActivityInstance();
                if (activityInstance != null) {
                    recorder.recordActivityFailed(activityInstance);
                    if (!ExtensionPointsPolicy.THROW_EXCPTION_ON_FAIL.equals((Object)EnvTool.getExtensionPointsPolicy())) continue;
                    throw new UnRollbackableException("Error while performing activity", e);
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                String message = ExceptionManager.getInstance().getFullMessage("bp_EHI_5", e + ": " + e.getMessage(), e.getMessage());
                throw new BonitaRuntimeException(message, e);
            }
        } else {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            String message = ExceptionManager.getInstance().getFullMessage("bp_EHI_5", e + ": " + e.getMessage(), e.getMessage());
            throw new BonitaRuntimeException(message, e);
        }
    }

    public String toString() {
        return "execute(node)";
    }
}

