/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.runtime.tx;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.Synchronization;
import org.ow2.bonita.env.Transaction;
import org.ow2.bonita.runtime.tx.StandardResource;
import org.ow2.bonita.runtime.tx.StandardSynchronization;
import org.ow2.bonita.runtime.tx.TransactionException;
import org.ow2.bonita.util.ExceptionManager;

public class StandardTransaction
implements Transaction,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(StandardTransaction.class.getName());
    protected List<StandardResource> resources;
    protected List<StandardSynchronization> synchronizations;
    protected State state = State.CREATED;

    @Override
    public void begin() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("beginning " + this);
        }
        this.state = State.ACTIVE;
    }

    @Override
    public void complete() {
        if (this.state == State.ACTIVE) {
            this.commit();
        } else if (this.state == State.ROLLBACKONLY) {
            this.rollback();
        } else {
            String message = ExceptionManager.getInstance().getFullMessage("bp_ST_1", new Object[]{this.state});
            throw new TransactionException(message);
        }
    }

    @Override
    public void setRollbackOnly() {
        if (this.state != State.ACTIVE) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_ST_2", new Object[]{this.state});
            throw new TransactionException(message);
        }
        this.state = State.ROLLBACKONLY;
    }

    @Override
    public boolean isRollbackOnly() {
        return this.state == State.ROLLBACKONLY || this.state == State.ROLLEDBACK;
    }

    public void commit() {
        if (this.state != State.ACTIVE) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_ST_3", new Object[]{this.state});
            throw new TransactionException(message);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("committing " + this);
        }
        try {
            this.beforeCompletion();
            if (this.resources != null) {
                for (StandardResource standardResource : this.resources) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("preparing resource " + standardResource);
                    }
                    standardResource.prepare();
                }
            }
        }
        catch (Exception exception) {
            block21: {
                try {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("resource threw exception in prepare.  rolling back.");
                    }
                    this.rollbackResources();
                }
                catch (Exception rollbackException) {
                    if (!LOG.isLoggable(Level.SEVERE)) break block21;
                    LOG.severe("rollback failed as well: " + rollbackException);
                }
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            String message = ExceptionManager.getInstance().getFullMessage("bp_ST_4", new Object[0]);
            throw new TransactionException(message, exception);
        }
        Throwable commitException = null;
        if (this.resources != null) {
            for (StandardResource standardResource : this.resources) {
                try {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("committing resource " + standardResource);
                    }
                    standardResource.commit();
                }
                catch (Throwable t) {
                    if (LOG.isLoggable(Level.SEVERE)) {
                        LOG.severe("commit failed for resource " + standardResource + ": " + t);
                    }
                    if (commitException != null) continue;
                    commitException = t;
                }
            }
        }
        this.state = State.COMMITTED;
        this.afterCompletion();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("committed " + this);
        }
        if (commitException != null) {
            if (commitException instanceof RuntimeException) {
                throw (RuntimeException)commitException;
            }
            if (commitException instanceof Error) {
                throw (Error)commitException;
            }
            String message = ExceptionManager.getInstance().getFullMessage("bp_ST_5", new Object[0]);
            throw new TransactionException(message, commitException);
        }
    }

    public void rollback() {
        if (this.state != State.ACTIVE && this.state != State.ROLLBACKONLY) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_ST_6", new Object[]{this.state});
            throw new TransactionException(message);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("rolling back " + this);
        }
        this.beforeCompletion();
        this.rollbackResources();
    }

    void rollbackResources() {
        if (this.resources != null) {
            for (StandardResource resource : this.resources) {
                try {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("rolling back resource " + resource);
                    }
                    resource.rollback();
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.SEVERE)) continue;
                    LOG.severe("rollback failed for resource " + resource);
                }
            }
        }
        this.state = State.ROLLEDBACK;
        this.afterCompletion();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("rolled back");
        }
    }

    @Override
    public void registerSynchronization(Synchronization synchronization) {
        if (this.synchronizations == null) {
            this.synchronizations = new ArrayList<StandardSynchronization>();
        }
        this.synchronizations.add(new StandardSynchronization(synchronization));
    }

    public void afterCompletion() {
        if (this.synchronizations != null) {
            for (StandardSynchronization synchronization : this.synchronizations) {
                synchronization.afterCompletion(this.state);
            }
        }
    }

    public void beforeCompletion() {
        if (this.synchronizations != null) {
            for (StandardSynchronization synchronization : this.synchronizations) {
                synchronization.beforeCompletion();
            }
        }
    }

    public void enlistResource(StandardResource standardResource) {
        if (this.resources == null) {
            this.resources = new ArrayList<StandardResource>();
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("enlisting resource " + standardResource + " to standard transaction");
        }
        this.resources.add(standardResource);
    }

    List<StandardResource> getResources() {
        return this.resources;
    }

    public String toString() {
        return "StandardTransaction[" + System.identityHashCode(this) + "]";
    }

    static enum State {
        CREATED,
        ACTIVE,
        ROLLBACKONLY,
        COMMITTED,
        ROLLEDBACK;

    }
}

