/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.services.impl;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.facade.uuid.ActivityDefinitionUUID;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.persistence.EventDbSession;
import org.ow2.bonita.runtime.event.EventAdded;
import org.ow2.bonita.runtime.event.EventCouple;
import org.ow2.bonita.runtime.event.EventInstance;
import org.ow2.bonita.runtime.event.IncomingEventInstance;
import org.ow2.bonita.runtime.event.Job;
import org.ow2.bonita.runtime.event.OutgoingEventInstance;
import org.ow2.bonita.runtime.model.Execution;
import org.ow2.bonita.services.EventService;
import org.ow2.bonita.util.EnvTool;

public class DbThreadEventService
implements EventService {
    private static final Logger LOG = Logger.getLogger(DbThreadEventService.class.getName());
    private String persistenceServiceName;

    protected DbThreadEventService() {
    }

    public DbThreadEventService(String persistenceServiceName) {
        this.persistenceServiceName = persistenceServiceName;
    }

    protected EventDbSession getDbSession() {
        return EnvTool.getEventServiceDbSession(this.persistenceServiceName);
    }

    private void refreshMatchers() {
        EnvTool.getEventExecutor().refreshMatchers();
    }

    private void refreshExpressionMessageMatcher() {
        EnvTool.getEventExecutor().refreshExpressionMessageEventMatcher();
    }

    private void refreshMessageMatcher() {
        EnvTool.getEventExecutor().refreshEventMatcher();
    }

    @Override
    public void enableEventsInFailureIncomingEvents(ActivityInstanceUUID activityUUID) {
        Execution execution = EnvTool.getJournal().getExecutionOnActivity(activityUUID.getProcessInstanceUUID(), activityUUID);
        List<Job> jobs = this.getDbSession().getJobsOfExecution(execution.getEventUUID());
        int retries = EnvTool.getEventExecutor().getRetries();
        for (Job job : jobs) {
            if (job.getRetries() != 0) continue;
            job.setRetries(retries);
        }
        this.refreshJobExecutor();
    }

    @Override
    public void enablePermanentEventsInFailure(ActivityDefinitionUUID activityUUID) {
        Job job = this.getDbSession().getJob(activityUUID);
        int retries = EnvTool.getEventExecutor().getRetries();
        if (job.getRetries() == 0) {
            job.setRetries(retries);
        }
        this.refreshJobExecutor();
    }

    @Override
    public void fire(OutgoingEventInstance outgoingEventInstance) {
        this.getDbSession().save(outgoingEventInstance);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Firing event outgoing event: " + outgoingEventInstance + "...");
        }
        this.refreshMatchers();
    }

    @Override
    public void subscribe(IncomingEventInstance incomingEventInstance) {
        long originalEnableTime = incomingEventInstance.getEnableTime();
        incomingEventInstance.setEnableTime(Long.MAX_VALUE);
        this.getDbSession().save(incomingEventInstance);
        EnvTool.getTransaction().registerSynchronization(new EventAdded(this.getDbSession(), incomingEventInstance.getId(), originalEnableTime));
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Firing event incoming event: " + incomingEventInstance + "...");
        }
        if (incomingEventInstance.getExpression() != null) {
            this.refreshExpressionMessageMatcher();
        } else {
            this.refreshMessageMatcher();
        }
    }

    @Override
    public Set<IncomingEventInstance> getIncomingEvents() {
        Set<IncomingEventInstance> incomings = this.getDbSession().getIncomingEvents();
        if (incomings == null) {
            return Collections.emptySet();
        }
        return incomings;
    }

    @Override
    public Set<OutgoingEventInstance> getOutgoingEvents() {
        Set<OutgoingEventInstance> outgoings = this.getDbSession().getOutgoingEvents();
        if (outgoings == null) {
            return Collections.emptySet();
        }
        return outgoings;
    }

    @Override
    public Set<OutgoingEventInstance> getOutgoingEvents(String eventName, String toProcessName, String toActivityName, ActivityInstanceUUID activityUUID) {
        Set<OutgoingEventInstance> outgoings = this.getDbSession().getOutgoingEvents(eventName, toProcessName, toActivityName, activityUUID);
        if (outgoings == null) {
            return Collections.emptySet();
        }
        return outgoings;
    }

    @Override
    public Set<IncomingEventInstance> getIncomingEvents(String eventName, String toProcessName, String toActivityName, ActivityInstanceUUID activityUUID) {
        Set<IncomingEventInstance> incomings = this.getDbSession().getIncomingEvents(eventName, toProcessName, toActivityName, activityUUID);
        if (incomings == null) {
            return Collections.emptySet();
        }
        return incomings;
    }

    @Override
    public Set<OutgoingEventInstance> getOutgoingEvents(ProcessInstanceUUID instanceUUID) {
        Set<OutgoingEventInstance> outgoings = this.getDbSession().getOutgoingEvents(instanceUUID);
        if (outgoings == null) {
            return Collections.emptySet();
        }
        return outgoings;
    }

    @Override
    public Set<IncomingEventInstance> getIncomingEvents(ProcessInstanceUUID instanceUUID) {
        Set<IncomingEventInstance> incomings = this.getDbSession().getIncomingEvents(instanceUUID);
        if (incomings == null) {
            return Collections.emptySet();
        }
        return incomings;
    }

    public Set<IncomingEventInstance> getIncomingEvents(ActivityDefinitionUUID activityUUID) {
        Set<IncomingEventInstance> incomings = this.getDbSession().getIncomingEvents(activityUUID);
        if (incomings == null) {
            return Collections.emptySet();
        }
        return incomings;
    }

    @Override
    public Set<IncomingEventInstance> getIncomingEvents(ActivityInstanceUUID activityUUID) {
        Set<IncomingEventInstance> incomings = this.getDbSession().getIncomingEvents(activityUUID);
        if (incomings == null) {
            return Collections.emptySet();
        }
        return incomings;
    }

    @Override
    public Set<IncomingEventInstance> getBoundaryIncomingEvents(ActivityInstanceUUID activityUUID) {
        Set<IncomingEventInstance> incomings = this.getDbSession().getBoundaryIncomingEvents(activityUUID);
        if (incomings == null) {
            return Collections.emptySet();
        }
        return incomings;
    }

    @Override
    public Set<OutgoingEventInstance> getBoundaryOutgoingEvents(ActivityInstanceUUID activityUUID) {
        Set<OutgoingEventInstance> outgoings = this.getDbSession().getBoundaryOutgoingEvents(activityUUID);
        if (outgoings == null) {
            return Collections.emptySet();
        }
        return outgoings;
    }

    @Override
    public IncomingEventInstance getIncomingEvent(long incomingId) {
        return this.getDbSession().getIncomingEvent(incomingId);
    }

    @Override
    public OutgoingEventInstance getOutgoingEvent(long outgoingId) {
        return this.getDbSession().getOutgoingEvent(outgoingId);
    }

    @Override
    public IncomingEventInstance getIncomingEvent(ProcessInstanceUUID instanceUUID, String name) {
        return this.getDbSession().getIncomingEvent(instanceUUID, name);
    }

    public void removeFiredEvent(OutgoingEventInstance outgoing) {
        this.getDbSession().deleteIncompatibleEvents(outgoing);
        this.getDbSession().delete(outgoing);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Removing outgoing event: " + outgoing + "...");
        }
    }

    @Override
    public Set<OutgoingEventInstance> getOverdueEvents() {
        return this.getDbSession().getOverdueEvents();
    }

    @Override
    public Set<IncomingEventInstance> getSignalIncomingEvents(String signal) {
        return this.getDbSession().getSignalIncomingEvents(signal);
    }

    public void removeSubscription(IncomingEventInstance incoming) {
        this.getDbSession().delete(incoming);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Removing incoming event: " + incoming + "...");
        }
    }

    @Override
    public void removeSubscriptions(ProcessInstanceUUID instanceUUID) {
        Set<IncomingEventInstance> events = this.getIncomingEvents(instanceUUID);
        if (events != null && !events.isEmpty()) {
            for (IncomingEventInstance event : events) {
                this.removeSubscription(event);
            }
        }
    }

    @Override
    public void removeSubscriptions(ActivityDefinitionUUID activityUUID) {
        Set<IncomingEventInstance> events = this.getIncomingEvents(activityUUID);
        if (events != null && !events.isEmpty()) {
            for (IncomingEventInstance event : events) {
                this.removeSubscription(event);
            }
        }
    }

    @Override
    public void removeFiredEvents(ProcessInstanceUUID instanceUUID) {
        Set<OutgoingEventInstance> events = this.getOutgoingEvents(instanceUUID);
        if (events != null && !events.isEmpty()) {
            for (OutgoingEventInstance event : events) {
                this.removeFiredEvent(event);
            }
        }
    }

    @Override
    public void removeEvent(EventInstance event) {
        if (event instanceof OutgoingEventInstance) {
            this.removeFiredEvent((OutgoingEventInstance)event);
        } else {
            this.removeSubscription((IncomingEventInstance)event);
        }
    }

    @Override
    public IncomingEventInstance getSignalStartIncomingEvent(List<String> processNames, String signalCode) {
        return this.getDbSession().getSignalStartIncomingEvent(processNames, signalCode);
    }

    @Override
    public List<IncomingEventInstance> getMessageStartIncomingEvents(Set<String> processNames) {
        return this.getDbSession().getMessageStartIncomingEvents(processNames);
    }

    @Override
    public void storeJob(Job job) {
        int retries = EnvTool.getEventExecutor().getRetries();
        job.setRetries(retries);
        this.getDbSession().save(job);
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("New job: " + job + "...");
        }
        this.refreshJobExecutor();
    }

    private void refreshJobExecutor() {
        EnvTool.getEventExecutor().refreshJobExecutor();
    }

    @Override
    public Job getJob(Long jobId) {
        return this.getDbSession().getJob(jobId);
    }

    @Override
    public void removeJob(Job job) {
        this.getDbSession().delete(job);
    }

    @Override
    public void removeJob(ActivityDefinitionUUID activityUUID) {
        Job job = this.getDbSession().getJob(activityUUID);
        if (job != null) {
            this.getDbSession().delete(job);
        }
    }

    @Override
    public List<Job> getExecutableJobs(List<ProcessInstanceUUID> lockedRootInstances, int maxResult) {
        return this.getDbSession().getExecutableJobs(lockedRootInstances, maxResult);
    }

    @Override
    public Long getNextJobDueDate() {
        return this.getDbSession().getNextJobDueDate();
    }

    @Override
    public List<EventCouple> getMessageEventCouples() {
        return this.getDbSession().getMessageEventCouples();
    }

    @Override
    public List<Job> getJobs() {
        return this.getDbSession().getJobs();
    }

    @Override
    public void removeJobs(String executionEventUUID) {
        List<Job> jobs = this.getDbSession().getJobsOfExecution(executionEventUUID);
        for (Job job : jobs) {
            this.getDbSession().delete(job);
        }
    }

    @Override
    public void removeJobs(ProcessInstanceUUID instanceUUID) {
        List<Job> jobs = this.getDbSession().getJobsOfInstance(instanceUUID);
        for (Job job : jobs) {
            this.getDbSession().delete(job);
        }
    }

    @Override
    public List<Job> getTimerJobs() {
        return this.getDbSession().getJobs("timer");
    }

    @Override
    public List<Job> getTimerJobs(ProcessInstanceUUID instanceUUID) {
        return this.getDbSession().getJobs("timer", instanceUUID);
    }

    @Override
    public List<Job> getTimerJobs(String eventUUID) {
        return this.getDbSession().getJobs("timer", eventUUID);
    }

    @Override
    public List<EventCouple> getCorrelationKeyMessageEventCouples() {
        return this.getDbSession().getCorrelationKeyMessageEventCouples();
    }

    @Override
    public Long getNextEventDueDate() {
        return this.getDbSession().getNextEventDueDate();
    }

    @Override
    public Long getNextExpressionEventDueDate() {
        return this.getDbSession().getNextExpressionEventDueDate();
    }
}

