/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.services.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ow2.bonita.facade.exception.DocumentAlreadyExistsException;
import org.ow2.bonita.facade.exception.DocumentNotFoundException;
import org.ow2.bonita.facade.exception.DocumentationCreationException;
import org.ow2.bonita.facade.impl.SearchResult;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.persistence.DocumentDbSession;
import org.ow2.bonita.search.DocumentSearchBuilder;
import org.ow2.bonita.services.Document;
import org.ow2.bonita.services.DocumentDescriptor;
import org.ow2.bonita.services.DocumentDescriptorMapping;
import org.ow2.bonita.services.DocumentStorageService;
import org.ow2.bonita.services.DocumentVersion;
import org.ow2.bonita.services.DocumentationManager;
import org.ow2.bonita.services.impl.DocumentDescriptorImpl;
import org.ow2.bonita.services.impl.DocumentDescriptorMappingImpl;
import org.ow2.bonita.services.impl.DocumentImpl;
import org.ow2.bonita.services.impl.DocumentVersionImpl;
import org.ow2.bonita.util.EnvTool;

public class DocumentManagerImpl
implements DocumentationManager {
    private static final int MAX_RESULTS = 100;
    private final String persistenceServiceName;
    private final DocumentStorageService documentStorageService;
    private final Map<Long, Object> documentsLock = new HashMap<Long, Object>(3);
    private final Map<Long, Long> documentsLockCount = new HashMap<Long, Long>();
    private final Object lock = new Object();

    public DocumentManagerImpl(String persistenceServiceName) {
        this.documentStorageService = EnvTool.getDocumentStorageService();
        this.persistenceServiceName = persistenceServiceName;
    }

    public DocumentDbSession getDbSession() {
        return EnvTool.getDocumentDbSession(this.persistenceServiceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureHasLockEntry(Long documentDescId) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.documentsLock.containsKey(documentDescId)) {
                this.documentsLock.put(documentDescId, new Object());
                this.documentsLockCount.put(documentDescId, 1L);
            } else {
                this.documentsLockCount.put(documentDescId, this.documentsLockCount.get(documentDescId) + 1L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLockEntryIfPossible(Long documentDescId) {
        Object object = this.lock;
        synchronized (object) {
            Long count = this.documentsLockCount.get(documentDescId);
            if (count == 1L) {
                this.documentsLockCount.remove(documentDescId);
                this.documentsLock.remove(documentDescId);
            } else {
                this.documentsLockCount.put(documentDescId, count - 1L);
            }
        }
    }

    @Override
    public Document createDocument(String name, ProcessDefinitionUUID definitionUUID) throws DocumentationCreationException, DocumentAlreadyExistsException {
        return this.createDocument(name, definitionUUID, null, null, null, null);
    }

    @Override
    public Document createDocument(String name, ProcessDefinitionUUID definitionUUID, ProcessInstanceUUID instanceUUID) throws DocumentationCreationException, DocumentAlreadyExistsException {
        return this.createDocument(name, definitionUUID, instanceUUID, null, null, null);
    }

    @Override
    public Document createDocument(String name, ProcessDefinitionUUID definitionUUID, String fileName, String contentMimeType, byte[] fileContent) throws DocumentationCreationException, DocumentAlreadyExistsException {
        return this.createDocument(name, definitionUUID, null, fileName, contentMimeType, fileContent);
    }

    @Override
    public Document createDocument(String name, ProcessDefinitionUUID definitionUUID, ProcessInstanceUUID instanceUUID, String fileName, String contentMimeType, byte[] fileContent) throws DocumentationCreationException, DocumentAlreadyExistsException {
        return this.createDocument(name, definitionUUID, instanceUUID, fileName, contentMimeType, fileContent, false);
    }

    @Override
    public Document createDocument(String name, ProcessDefinitionUUID definitionUUID, ProcessInstanceUUID instanceUUID, String fileName, String contentMimeType, byte[] fileContent, String author, Date creationDate, Date lastModificationDate) throws DocumentationCreationException, DocumentAlreadyExistsException {
        return this.createDocument(name, definitionUUID, instanceUUID, fileName, contentMimeType, fileContent, false, author, creationDate, lastModificationDate);
    }

    private Document createDocument(String name, ProcessDefinitionUUID definitionUUID, ProcessInstanceUUID instanceUUID, String fileName, String contentMimeType, byte[] fileContent, boolean metaDocument) throws DocumentationCreationException, DocumentAlreadyExistsException {
        Date now = new Date();
        return this.createDocument(name, definitionUUID, instanceUUID, fileName, contentMimeType, fileContent, metaDocument, EnvTool.getUserId(), now, now);
    }

    private Document createDocument(String name, ProcessDefinitionUUID definitionUUID, ProcessInstanceUUID instanceUUID, String fileName, String contentMimeType, byte[] fileContent, boolean metaDocument, String author, Date creationDate, Date lastModificationDate) throws DocumentationCreationException, DocumentAlreadyExistsException {
        long nbOfDocuments = 0L;
        nbOfDocuments = instanceUUID != null ? this.getDbSession().hasDocuments(instanceUUID, name, metaDocument) : this.getDbSession().hasDocuments(definitionUUID, name, metaDocument);
        if (nbOfDocuments > 0L) {
            throw new DocumentAlreadyExistsException("DAEE", name);
        }
        DocumentDescriptorImpl documentDescriptorImpl = new DocumentDescriptorImpl(name, definitionUUID, instanceUUID, metaDocument, 0L);
        this.getDbSession().save(documentDescriptorImpl);
        DocumentDescriptorMappingImpl docDescMapping = new DocumentDescriptorMappingImpl(documentDescriptorImpl.getId(), definitionUUID, instanceUUID);
        this.getDbSession().save(docDescMapping);
        return this.createDocumentVersionUsingDescriptor(fileName, contentMimeType, fileContent, true, author, creationDate, lastModificationDate, documentDescriptorImpl);
    }

    private Document createDocumentVersionUsingDescriptor(String fileName, String contentMimeType, byte[] fileContent, boolean isMajorVersion, String author, Date creationDate, Date lastModificationDate, DocumentDescriptor documentDescriptor) throws DocumentationCreationException {
        long length = fileContent == null ? 0L : (long)fileContent.length;
        long versionLabel = documentDescriptor.getLastVersionLabel() + 1L;
        DocumentVersionImpl documentVersionImpl = new DocumentVersionImpl(author, creationDate, lastModificationDate, isMajorVersion, documentDescriptor.getId(), fileName, contentMimeType, length, versionLabel);
        this.documentStorageService.storeDocumentContent(documentVersionImpl, fileContent);
        this.getDbSession().save(documentVersionImpl);
        documentDescriptor.setLastVersionId(documentVersionImpl.getId());
        documentDescriptor.setLastVersionLabel(versionLabel);
        return this.toDocument(documentDescriptor, documentVersionImpl);
    }

    private Document toDocument(DocumentDescriptor docDesc, DocumentVersion docVersion) {
        boolean isLatest = docDesc.getLastVersionId() == docVersion.getId();
        DocumentImpl documentImpl = new DocumentImpl(docDesc.getName(), docVersion.getAuthor(), new Date(docVersion.getCreationDate()), new Date(docVersion.getLastModificationDate()), isLatest, docVersion.isMajorVersion(), String.valueOf(docVersion.getVersionLabel()), String.valueOf(docVersion.getVersionSeriesId()), docVersion.getContentFileName(), docVersion.getContentMimeType(), docVersion.getContentSize(), docDesc.getProcessDefinitionUUID(), docDesc.getProcessInstanceUUID(), docVersion.getContentStorageId());
        documentImpl.setId(String.valueOf(docVersion.getId()));
        return documentImpl;
    }

    @Override
    public Document getDocument(String documentId) throws DocumentNotFoundException {
        DocumentVersion documentVersion = this.getDbSession().getDocumentVersion(Long.valueOf(documentId));
        if (documentVersion == null) {
            throw new DocumentNotFoundException(documentId);
        }
        DocumentDescriptor documentDescriptor = this.getDbSession().getDocumentDescriptor(documentVersion.getVersionSeriesId());
        return this.toDocument(documentDescriptor, documentVersion);
    }

    @Override
    public void deleteDocument(String documentId, boolean allVersions) throws DocumentNotFoundException {
        DocumentVersion documentVersion = this.getDbSession().getDocumentVersion(Long.valueOf(documentId));
        DocumentDescriptor documentDescriptor = this.getDbSession().getDocumentDescriptor(documentVersion.getVersionSeriesId());
        if (allVersions) {
            this.deleteDocuments(documentDescriptor);
        } else {
            this.deleteVersionAndContent(documentVersion);
            List<DocumentVersion> documentVersions = this.getDbSession().getDocumentVersions(documentDescriptor.getId());
            if (documentVersions.isEmpty()) {
                this.getDbSession().delete(documentDescriptor);
            } else if (documentDescriptor.getLastVersionId() == documentVersion.getId()) {
                documentDescriptor.setLastVersionId(documentVersions.get(0).getId());
            }
        }
    }

    @Override
    public byte[] getContent(Document document) throws DocumentNotFoundException {
        return this.documentStorageService.getContent(document.getContentStorageId());
    }

    @Override
    public List<Document> getVersionsOfDocument(String documentId) throws DocumentNotFoundException {
        DocumentVersion currentDocumentVersion = this.getDbSession().getDocumentVersion(Long.valueOf(documentId));
        DocumentDescriptor documentDescriptor = this.getDbSession().getDocumentDescriptor(currentDocumentVersion.getVersionSeriesId());
        List<DocumentVersion> documentVersions = this.getDbSession().getDocumentVersions(documentDescriptor.getId());
        ArrayList<Document> documents = new ArrayList<Document>(documentVersions.size());
        for (DocumentVersion documentVersion : documentVersions) {
            documents.add(this.toDocument(documentDescriptor, documentVersion));
        }
        return documents;
    }

    @Override
    public Document createVersion(String documentId, boolean isMajorVersion) throws DocumentationCreationException {
        return this.createVersion(documentId, isMajorVersion, null, "application/octet-stream", null);
    }

    @Override
    public Document createVersion(String documentId, boolean isMajorVersion, String fileName, String mimeType, byte[] content) throws DocumentationCreationException {
        Date now = new Date();
        return this.createVersion(documentId, isMajorVersion, fileName, mimeType, content, EnvTool.getUserId(), now, now);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Document createVersion(String documentId, boolean isMajorVersion, String fileName, String mimeType, byte[] content, String author, Date creationDate, Date lastModificationDate) throws DocumentationCreationException {
        DocumentVersion lastVersion = this.getDbSession().getDocumentVersion(Long.valueOf(documentId));
        Long documentDescriptorId = lastVersion.getVersionSeriesId();
        this.ensureHasLockEntry(documentDescriptorId);
        Document document = null;
        Object object = this.documentsLock.get(documentDescriptorId);
        synchronized (object) {
            DocumentDescriptor documentDescriptor = this.getDbSession().getDocumentDescriptor(documentDescriptorId);
            document = this.createDocumentVersionUsingDescriptor(fileName, mimeType, content, isMajorVersion, author, creationDate, lastModificationDate, documentDescriptor);
        }
        this.removeLockEntryIfPossible(documentDescriptorId);
        return document;
    }

    private int toInt(long longValue) {
        if (longValue > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(longValue + " cannot be cast to int because it's too long");
        }
        return (int)longValue;
    }

    @Override
    public SearchResult search(DocumentSearchBuilder builder, int fromResult, int maxResults) {
        List<Document> documents = this.getDbSession().searchDocuments(builder, fromResult, maxResults);
        long numberOfDocuments = this.getDbSession().getNumberOfDocuments(builder);
        return new SearchResult(documents, this.toInt(numberOfDocuments));
    }

    @Override
    public void clear() throws DocumentNotFoundException {
        List<DocumentDescriptor> documentDescriptors = Collections.emptyList();
        DocumentDbSession dbSession = this.getDbSession();
        do {
            documentDescriptors = dbSession.getDocumentDescriptors(0, 100);
            this.deleteDocuments(documentDescriptors);
        } while (!documentDescriptors.isEmpty());
    }

    private void deleteDocuments(List<DocumentDescriptor> documentDescriptors) throws DocumentNotFoundException {
        for (DocumentDescriptor documentDesc : documentDescriptors) {
            this.deleteDocuments(documentDesc);
        }
    }

    private void deleteDocuments(DocumentDescriptor documentDesc) throws DocumentNotFoundException {
        this.deleteVersions(documentDesc);
        this.deleteMappingDescriptors(documentDesc);
        this.getDbSession().delete(documentDesc);
    }

    private void deleteMappingDescriptors(DocumentDescriptor documentDesc) {
        List<Object> mappings = Collections.emptyList();
        do {
            mappings = this.getDbSession().getDocumentDescriptorMappings(documentDesc.getId(), 0, 100);
            for (DocumentDescriptorMapping documentDescriptorMapping : mappings) {
                this.getDbSession().delete(documentDescriptorMapping);
            }
        } while (!mappings.isEmpty());
    }

    private void deleteVersions(DocumentDescriptor documentDesc) throws DocumentNotFoundException {
        List<Object> documentVersions = Collections.emptyList();
        do {
            documentVersions = this.getDbSession().getDocumentVersions(0, 100, documentDesc.getId());
            for (DocumentVersion documentVersion : documentVersions) {
                this.deleteVersionAndContent(documentVersion);
            }
        } while (!documentVersions.isEmpty());
    }

    private void deleteVersionAndContent(DocumentVersion documentVersion) throws DocumentNotFoundException {
        this.documentStorageService.deleteContent(documentVersion.getContentStorageId());
        this.getDbSession().delete(documentVersion);
    }

    @Override
    public void attachDocumentTo(ProcessDefinitionUUID processDefinitionUUID, ProcessInstanceUUID processInstanceUUID, String documentId) throws DocumentNotFoundException {
        DocumentVersion documentVersion = this.getDbSession().getDocumentVersion(Long.valueOf(documentId));
        DocumentDescriptorMappingImpl docDescMapping = new DocumentDescriptorMappingImpl(documentVersion.getVersionSeriesId(), processDefinitionUUID, processInstanceUUID);
        this.getDbSession().save(docDescMapping);
    }

    @Override
    public List<Document> getDocuments(ProcessInstanceUUID instanceUUID, int fromResult, int maxResults) {
        return this.getDbSession().getDocuments(instanceUUID, fromResult, maxResults);
    }

    @Override
    public List<Document> getDocuments(ProcessInstanceUUID instanceUUID, String documentName, int fromResult, int maxResults) {
        return this.getDbSession().getDocuments(instanceUUID, documentName, fromResult, maxResults);
    }

    @Override
    public List<Document> getDocuments(ProcessDefinitionUUID processDefUUID, String documentName, int fromResult, int maxResults) {
        return this.getDbSession().getDocuments(processDefUUID, documentName, fromResult, maxResults);
    }

    @Override
    public List<Document> getDocumentsOfProcessDefinitionWithoutInstances(ProcessDefinitionUUID processDefUUID, int fromResult, int maxResults) {
        return this.getDbSession().getDocumentsOfProcessDefinitionWithoutInstances(processDefUUID, fromResult, maxResults);
    }

    @Override
    public long getNbOfDocuments(ProcessInstanceUUID instanceUUID, String documentName) {
        return this.getDbSession().getNbOfDocuments(instanceUUID, documentName);
    }

    @Override
    public Document createMetaDocument(ProcessDefinitionUUID definitionUUID, String name, String fileName, String contentMimeType, byte[] fileContent) throws DocumentationCreationException, DocumentAlreadyExistsException {
        return this.createDocument(name, definitionUUID, null, fileName, contentMimeType, fileContent, true);
    }

    @Override
    public Document createMetaDocument(ProcessDefinitionUUID definitionUUID, String name, String fileName, String contentMimeType, byte[] fileContent, String author, Date creationDate, Date lastModificationDate) throws DocumentationCreationException, DocumentAlreadyExistsException {
        return this.createDocument(name, definitionUUID, null, fileName, contentMimeType, fileContent, true, author, creationDate, lastModificationDate);
    }

    @Override
    public List<Document> getMetaDocuments(ProcessDefinitionUUID processDefinitionUUID) {
        return this.getDbSession().getMetaDocumentOfProcessDefinition(processDefinitionUUID, 0, Integer.MAX_VALUE);
    }

    @Override
    public void deleteDocuments(ProcessDefinitionUUID definitionUUID) throws DocumentNotFoundException {
        List<DocumentDescriptor> documentDescriptors = Collections.emptyList();
        do {
            documentDescriptors = this.getDbSession().getDocumentDescriptors(definitionUUID, 0, 100);
            this.deleteDocuments(documentDescriptors);
        } while (!documentDescriptors.isEmpty());
    }
}

