/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util;

import groovy.lang.Binding;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import java.io.IOException;
import java.io.NotSerializableException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ow2.bonita.facade.RuntimeAPI;
import org.ow2.bonita.facade.exception.ActivityDefNotFoundException;
import org.ow2.bonita.facade.exception.DataFieldNotFoundException;
import org.ow2.bonita.facade.exception.ProcessNotFoundException;
import org.ow2.bonita.facade.impl.StandardAPIAccessorImpl;
import org.ow2.bonita.facade.runtime.impl.InternalActivityInstance;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.facade.runtime.impl.ObjectVariable;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.util.BonitaException;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.GroovyBindingBuilder;
import org.ow2.bonita.util.GroovyException;
import org.ow2.bonita.util.GroovyScriptBuilder;
import org.ow2.bonita.util.Misc;

public class GroovyUtil {
    public static Object evaluate(String expression, Map<String, Object> variables, ClassLoader classLoader) throws GroovyException {
        return GroovyUtil.evaluate(expression, variables, null, null, null, false, false, false, classLoader);
    }

    public static Object evaluate(String expression, Map<String, Object> variables) throws GroovyException {
        return GroovyUtil.evaluate(expression, variables, null, null, null, false, false, false, null);
    }

    public static Object evaluate(String expression, Map<String, Object> context, ActivityInstanceUUID activityUUID, boolean useActivityScope, boolean propagate) throws GroovyException {
        InternalActivityInstance activity = EnvTool.getAllQueriers().getActivityInstance(activityUUID);
        ProcessInstanceUUID processInstanceUUID = activity.getProcessInstanceUUID();
        ProcessDefinitionUUID processDefinitionUUID = activity.getProcessDefinitionUUID();
        return GroovyUtil.evaluate(expression, context, processDefinitionUUID, activityUUID, processInstanceUUID, useActivityScope, false, propagate, null);
    }

    public static Object evaluate(String expression, Map<String, Object> context, ProcessInstanceUUID instanceUUID, boolean useInitialVariableValues, boolean propagate) throws GroovyException {
        ProcessDefinitionUUID processDefinitionUUID = null;
        boolean archived = false;
        if (instanceUUID != null) {
            InternalProcessInstance instance = EnvTool.getAllQueriers().getProcessInstance(instanceUUID);
            archived = instance.isArchived();
            processDefinitionUUID = instance.getProcessDefinitionUUID();
        }
        return GroovyUtil.evaluate(expression, context, processDefinitionUUID, null, instanceUUID, false, useInitialVariableValues, propagate && !archived, null);
    }

    public static Object evaluate(String expression, Map<String, Object> context, ProcessDefinitionUUID processUUID, boolean propagate) throws GroovyException {
        return GroovyUtil.evaluate(expression, context, processUUID, null, null, false, false, propagate, null);
    }

    private static Object evaluate(String expression, Map<String, Object> context, ProcessDefinitionUUID processDefinitionUUID, ActivityInstanceUUID activityUUID, ProcessInstanceUUID instanceUUID, boolean useActivityScope, boolean useInitialVariableValues, boolean propagate, ClassLoader classLoader) throws GroovyException {
        String insideExpression;
        boolean oneUuidNotNull;
        int end;
        if (expression == null || "".equals(expression.trim())) {
            String message = GroovyUtil.getMessage(activityUUID, instanceUUID, processDefinitionUUID, "The expression is null or empty.");
            throw new GroovyException(message);
        }
        int begin = expression.indexOf("${");
        if (begin >= (end = expression.indexOf("}"))) {
            String message = GroovyUtil.getMessage(activityUUID, instanceUUID, processDefinitionUUID, "The expression is not a Groovy one: " + expression + ".");
            throw new GroovyException(message);
        }
        boolean bl = oneUuidNotNull = processDefinitionUUID != null || instanceUUID != null || activityUUID != null;
        if (Misc.isJustAGroovyExpression(expression) && oneUuidNotNull && Misc.isJavaIdentifier(insideExpression = expression.substring(begin + "${".length(), end).trim()) && !"true".equals(insideExpression) && !"false".equals(insideExpression)) {
            try {
                Object injectedVariable = GroovyBindingBuilder.getInjectedVariable(insideExpression, processDefinitionUUID, instanceUUID, activityUUID);
                if (injectedVariable != null) {
                    return injectedVariable;
                }
                Map<String, Object> allVariables = GroovyBindingBuilder.getContext(context, processDefinitionUUID, activityUUID, instanceUUID, useActivityScope, useInitialVariableValues);
                if (allVariables.containsKey(insideExpression)) {
                    Object result = allVariables.get(insideExpression);
                    if (result instanceof ObjectVariable) {
                        return ((ObjectVariable)result).getValue();
                    }
                    return result;
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        ClassLoader ori = Thread.currentThread().getContextClassLoader();
        try {
            ProcessDefinitionUUID pUUID = processDefinitionUUID;
            boolean archived = false;
            InternalActivityInstance activity = null;
            if (pUUID == null && instanceUUID != null) {
                InternalProcessInstance instance = EnvTool.getAllQueriers().getProcessInstance(instanceUUID);
                archived = instance.isArchived();
                pUUID = instance.getProcessDefinitionUUID();
            } else if (activityUUID != null) {
                activity = EnvTool.getJournalQueriers().getActivityInstance(activityUUID);
                if (activity == null) {
                    archived = true;
                    activity = EnvTool.getHistoryQueriers().getActivityInstance(activityUUID);
                }
                if (pUUID == null) {
                    pUUID = activity.getProcessDefinitionUUID();
                }
            }
            if (pUUID != null && classLoader == null) {
                ClassLoader processClassLoader = EnvTool.getClassDataLoader().getProcessClassLoader(pUUID);
                Thread.currentThread().setContextClassLoader(processClassLoader);
            } else if (classLoader != null) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            boolean propagateWhenInJournal = propagate && !archived;
            Binding binding = null;
            binding = propagateWhenInJournal ? GroovyBindingBuilder.getPropagateBinding(processDefinitionUUID, instanceUUID, activityUUID, context, useActivityScope, useInitialVariableValues) : GroovyBindingBuilder.getSimpleBinding(processDefinitionUUID, instanceUUID, activityUUID, context, useActivityScope, useInitialVariableValues);
            Object result = GroovyUtil.evaluate(expression, binding);
            if (propagateWhenInJournal && instanceUUID != null) {
                GroovyUtil.propagateVariables(((GroovyBindingBuilder.PropagateBinding)binding).getVariablesToPropagate(), activityUUID, instanceUUID);
            }
            Object object = result;
            return object;
        }
        catch (Exception e) {
            String message = GroovyUtil.getMessage(activityUUID, instanceUUID, processDefinitionUUID, "Exception while evaluating expression.");
            throw new GroovyException(message, e);
        }
        finally {
            if (ori != null && ori != Thread.currentThread().getContextClassLoader()) {
                Thread.currentThread().setContextClassLoader(ori);
            }
        }
    }

    public static Object evaluate(String expression, Binding binding) throws GroovyException, NotSerializableException, ActivityDefNotFoundException, DataFieldNotFoundException, ProcessNotFoundException, IOException, ClassNotFoundException {
        String workingExpression = expression;
        Object result = null;
        if (Misc.isJustAGroovyExpression(workingExpression)) {
            workingExpression = workingExpression.substring("${".length());
            result = Misc.isJavaIdentifier(workingExpression = workingExpression.substring(0, workingExpression.lastIndexOf("}"))) && binding.getVariables().containsKey(workingExpression) ? binding.getVariable(workingExpression) : GroovyUtil.evaluateGroovyExpression(workingExpression, binding);
        } else {
            result = GroovyUtil.evaluate(GroovyUtil.getExpressions(workingExpression), binding);
        }
        return result;
    }

    public static void propagateVariables(Map<String, Object> variables, ActivityInstanceUUID activityUUID, ProcessInstanceUUID instanceUUID) throws GroovyException {
        StandardAPIAccessorImpl accessor = new StandardAPIAccessorImpl();
        RuntimeAPI runtime = accessor.getRuntimeAPI();
        if (variables != null) {
            for (Map.Entry<String, Object> variable : variables.entrySet()) {
                try {
                    if (activityUUID != null) {
                        runtime.setVariable(activityUUID, variable.getKey(), variable.getValue());
                        continue;
                    }
                    runtime.setProcessInstanceVariable(instanceUUID, variable.getKey(), variable.getValue());
                }
                catch (BonitaException e) {
                    String message = GroovyUtil.getMessage(activityUUID, instanceUUID, "Error while propagating variables.");
                    throw new GroovyException(message, e);
                }
            }
        }
    }

    private static Object evaluateGroovyExpression(String script, Binding binding) throws GroovyException {
        ClassLoader scriptClassLoader = Thread.currentThread().getContextClassLoader();
        Script groovyScript = GroovyScriptBuilder.getScript(script, scriptClassLoader);
        groovyScript.setBinding(binding);
        Object result = null;
        try {
            result = groovyScript.run();
        }
        catch (MissingPropertyException e) {
            String lineSeparator = System.getProperty("line.separator", "\n");
            StringBuilder stb = new StringBuilder();
            stb.append("Error in Groovy script: unable to use element \"" + e.getProperty() + "\"");
            stb.append(lineSeparator);
            stb.append(lineSeparator);
            stb.append("Possible cause:");
            stb.append(lineSeparator);
            stb.append("- missing import");
            stb.append(lineSeparator);
            stb.append("- variable not found (wrong name, undefined)");
            stb.append(lineSeparator);
            stb.append("- ...");
            stb.append(lineSeparator);
            stb.append(lineSeparator);
            stb.append("Script:");
            stb.append(lineSeparator);
            stb.append("\"" + script + "\"");
            stb.append(lineSeparator);
            throw new GroovyException(stb.toString(), e);
        }
        return result;
    }

    private static String evaluate(List<String> expressions, Binding binding) throws GroovyException {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < expressions.size(); ++i) {
            String expression = expressions.get(i);
            if (expression.equals("${")) {
                expression = expressions.get(++i);
                builder.append(GroovyUtil.evaluateGroovyExpression(expression, binding));
                continue;
            }
            builder.append(expression);
        }
        return builder.toString();
    }

    private static List<String> getExpressions(String expression) {
        ArrayList<String> expressions = new ArrayList<String>();
        String concat = expression;
        while (concat.contains("${")) {
            int index = concat.indexOf("${");
            expressions.add(concat.substring(0, index));
            concat = concat.substring(index);
            expressions.add("${");
            int endGroovy = Misc.getGroovyExpressionEndIndex(concat);
            expressions.add(concat.substring(2, endGroovy - 1));
            concat = concat.substring(endGroovy);
        }
        expressions.add(concat);
        return expressions;
    }

    private static String getMessage(ActivityInstanceUUID activityUUID, ProcessInstanceUUID instanceUUID, ProcessDefinitionUUID processDefUUID, String message) {
        String partialMessage = GroovyUtil.getMessage(activityUUID, instanceUUID, message);
        StringBuilder stb = new StringBuilder(partialMessage);
        if (processDefUUID != null) {
            stb.append(" ProcessDefinitionUUID: '").append(processDefUUID).append("'.");
        }
        return stb.toString();
    }

    private static String getMessage(ActivityInstanceUUID activityUUID, ProcessInstanceUUID instanceUUID, String message) {
        StringBuilder stb = new StringBuilder(message);
        if (instanceUUID != null) {
            stb.append(" ProcessInstanceUUID: '").append(instanceUUID).append("'.");
        }
        if (activityUUID != null) {
            stb.append(" ActivityInstanceUUID: '").append(activityUUID).append("'.");
        }
        return stb.toString();
    }
}

