/**
 * CMI : Cluster Method Invocation
 * Copyright (C) 2007 Bull S.A.S.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id:CMIContextException.java 914 2007-05-25 16:48:16Z loris $
 * --------------------------------------------------------------------------
 */

package org.ow2.cmi.jndi.context;


/**
 * Exception thrown if there is a failure in the wrapper of context {@link CMIContext}.
 * @author The new CMI team
 */
public class CMIContextException extends Exception {

    /**
     * Id for serializable class.
     */
    private static final long serialVersionUID = -4852804260448350455L;


    /**
     * @param msg
     */
    public CMIContextException(final String msg) {
        super(msg);
    }

    /**
     * @param msg
     * @param cause
     */
    public CMIContextException(final String msg, final Throwable cause) {
        super(msg, cause);
    }

}
