/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm;

import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.rmi.PortableRemoteObject;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionRolledbackException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.objectweb.jotm.Control;
import org.objectweb.jotm.Coordinator;
import org.objectweb.jotm.Current;
import org.objectweb.jotm.HeuristicMixed;
import org.objectweb.jotm.InternalTransactionContext;
import org.objectweb.jotm.JavaXidImpl;
import org.objectweb.jotm.RecoveryCoordinator;
import org.objectweb.jotm.SubCoordinator;
import org.objectweb.jotm.Terminator;
import org.objectweb.jotm.TimerEvent;
import org.objectweb.jotm.TimerEventListener;
import org.objectweb.jotm.TraceTm;
import org.objectweb.jotm.TransactionContext;
import org.objectweb.jotm.XAResourceHelper;
import org.objectweb.jotm.Xid;
import org.objectweb.jotm.XidImpl;

public class TransactionImpl
implements Transaction,
TimerEventListener {
    private SubCoordinator subcoord = null;
    private TransactionContext myCtx = null;
    private Xid myXid = null;
    private boolean genXidhashcode = false;
    private boolean genXidtostring = false;
    private int myXidhashcode = 0;
    private String myXidtostring = null;
    private Date txDate = null;
    private TimerEvent timer = null;
    private RecoveryCoordinator recoveryCoord = null;
    private final List<XAResource> enlistedXARes = Collections.synchronizedList(new ArrayList());
    private List<XAResource> delistedXARes = null;
    private boolean propagateCtx = true;
    private final List<javax.transaction.xa.Xid> enlistedJavaxXid = Collections.synchronizedList(new ArrayList());
    private Map<Object, Object> userResourceMap = null;
    private int localstatus = 0;
    private boolean toremove = false;
    private boolean isCorbaCompliant;

    public TransactionImpl(Xid xid, int timeout, boolean isCorbaCompliant) throws SystemException {
        this.isCorbaCompliant = isCorbaCompliant;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("xid= " + xid), new Object[0]);
            TraceTm.jta.debug((Object)("timeout= " + timeout), new Object[0]);
        }
        this.myXid = xid;
        this.myCtx = new InternalTransactionContext(timeout, null, xid);
    }

    public TransactionImpl(TransactionContext pctx, boolean isCorbaCompliant) {
        this.isCorbaCompliant = isCorbaCompliant;
        if (pctx == null) {
            TraceTm.jotm.error((Object)"TransactionImpl: null PropagationContext", new Object[0]);
            return;
        }
        this.myCtx = pctx;
        this.myXid = pctx.getXid();
        try {
            this.makeSubCoord(true, true);
        }
        catch (RollbackException e) {
            this.toremove = true;
            TraceTm.jotm.debug((Object)"already rolled back", new Object[0]);
            this.localstatus = 4;
        }
        catch (SystemException e) {
            this.toremove = true;
            TraceTm.jotm.error((Object)"cannot make subcoordinator", new Object[0]);
            this.localstatus = 4;
        }
    }

    public synchronized void putUserResource(Object key, Object value) {
        if (this.userResourceMap == null) {
            this.userResourceMap = Collections.synchronizedMap(new HashMap());
        }
        this.userResourceMap.put(key, value);
    }

    public synchronized Object getUserResource(Object key) {
        if (this.userResourceMap == null) {
            return null;
        }
        return this.userResourceMap.get(key);
    }

    public void registerInterposedSynchronization(Synchronization sync) throws IllegalStateException {
        try {
            this.registerSynchronization(sync);
        }
        catch (Exception e) {
            throw new IllegalStateException();
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException {
        Terminator term;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("TransactionImpl.commit (tx= " + this + ")"), new Object[0]);
        }
        if ((term = this.myCtx.getTerminator()) != null) {
            try {
                this.propagateCtx = false;
                term.commit(true);
            }
            catch (TransactionRolledbackException e) {
                Current.getCurrent().forgetTx(this.getXid());
                if (TraceTm.jta.isDebugEnabled()) {
                    TraceTm.jta.debug((Object)"Commit distributed transaction -> rolled back!", new Object[0]);
                }
                this.localstatus = 4;
                throw new RollbackException();
            }
            catch (RemoteException e) {
                if (TraceTm.jta.isWarnEnabled()) {
                    TraceTm.jta.warn((Object)"got a RemoteException", new Object[]{e});
                }
                if (e.detail instanceof TransactionRolledbackException) {
                    Current.getCurrent().forgetTx(this.getXid());
                    if (TraceTm.jta.isDebugEnabled()) {
                        TraceTm.jta.debug((Object)"Commit distributed transaction -> rolled back!", new Object[0]);
                    }
                    this.localstatus = 4;
                    throw new RollbackException();
                }
                if (e.detail instanceof HeuristicMixed) {
                    TraceTm.jotm.info((Object)"Commit distributed transaction -> Heuristic mixed!", new Object[0]);
                    throw new HeuristicMixedException();
                }
                throw new SystemException("Unexpected RemoteException on commit:" + e.detail.getMessage());
            }
            catch (Exception e) {
                TraceTm.jotm.error((Object)"Unexpected Exception on commit:", new Object[]{e});
                throw new SystemException("Unexpected Exception on commit");
            }
            finally {
                this.propagateCtx = true;
                if (this.subcoord == null) {
                    this.unsetTimer();
                }
            }
            Current.getCurrent().forgetTx(this.getXid());
            this.localstatus = 3;
            return;
        }
        if (this.subcoord != null) {
            try {
                this.subcoord.commit_one_phase();
            }
            catch (TransactionRolledbackException e) {
                if (TraceTm.jta.isDebugEnabled()) {
                    TraceTm.jta.debug((Object)"Commit local transaction -> rolled back!", new Object[0]);
                }
                Current.getCurrent().forgetTx(this.getXid());
                this.localstatus = 4;
                throw new RollbackException();
            }
            catch (RemoteException e) {
                TraceTm.jotm.error((Object)"Unexpected Exception on commit_one_phase:", new Object[]{e});
                Current.getCurrent().forgetTx(this.getXid());
                this.localstatus = 5;
                throw new SystemException("Unexpected Exception on commit_one_phase");
            }
        } else {
            this.unsetTimer();
            Current.getCurrent().forgetTx(this.getXid());
            this.localstatus = 3;
        }
    }

    public boolean delistResource(XAResource xares, int flag) throws IllegalStateException, SystemException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"TransactionImpl.delistResource", new Object[0]);
            TraceTm.jta.debug((Object)("xares= " + xares + ", flag= " + flag), new Object[0]);
        }
        if (this.enlistedXARes == null) {
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.error((Object)"No XA resources enlisted by JOTM", new Object[0]);
            }
            return false;
        }
        if (!this.enlistedXARes.contains(xares)) {
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.error((Object)("XAResouce " + xares + " not enlisted by JOTM"), new Object[0]);
            }
            return false;
        }
        javax.transaction.xa.Xid javaxxid = this.subcoord.getJavaxXid(this.subcoord.getXaresIndex(xares));
        if (!this.enlistedJavaxXid.contains(javaxxid)) {
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.error((Object)("XAResouce " + xares + " not enlisted by JOTM"), new Object[0]);
            }
            return false;
        }
        int javaxxidindex = this.enlistedJavaxXid.indexOf(javaxxid);
        javax.transaction.xa.Xid myjavaxxid = this.enlistedJavaxXid.get(javaxxidindex);
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("delisted with resource= " + xares), new Object[0]);
            TraceTm.jta.debug((Object)("end myjavaxxid= " + myjavaxxid), new Object[0]);
        }
        try {
            xares.end(myjavaxxid, flag);
        }
        catch (XAException e) {
            String error = "Cannot send XA end:" + e + " (error code = " + e.errorCode + ") --" + e.getMessage();
            TraceTm.jotm.error((Object)error, new Object[0]);
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jotm.debug((Object)("xares.end= " + xares), new Object[0]);
            }
            throw new SystemException(error);
        }
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("enlistedXAres.remove xares= " + xares), new Object[0]);
        }
        this.enlistedXARes.remove(xares);
        this.enlistedJavaxXid.remove(javaxxid);
        return true;
    }

    public boolean enlistResource(XAResource xares) throws RollbackException, IllegalStateException, SystemException {
        int flag;
        boolean found;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"TransactionImpl.enlistResource", new Object[0]);
            TraceTm.jta.debug((Object)("xares= " + xares), new Object[0]);
        }
        if (xares == null) {
            TraceTm.jotm.error((Object)"enlistResource: null argument", new Object[0]);
            throw new SystemException("enlistResource: null argument");
        }
        if (this.myCtx == null) {
            throw new SystemException("enlistResource: no Transactional Context");
        }
        if (this.subcoord == null) {
            this.makeSubCoord(false, true);
            if (this.subcoord == null) {
                TraceTm.jotm.error((Object)"enlistResource: could not create subcoordinator", new Object[0]);
                throw new SystemException("enlistResource: could not create subcoordinator");
            }
        }
        try {
            found = this.subcoord.addResource(xares);
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException("enlistResource: could not addResource " + xares);
        }
        int n = flag = found ? 0x200000 : 0;
        if (this.delistedXARes != null && this.delistedXARes.contains(xares)) {
            flag = 0x8000000;
        }
        XidImpl resXid = new XidImpl(this.getXid(), this.subcoord.getXaresIndex(xares));
        JavaXidImpl javaxxid = new JavaXidImpl(resXid);
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("enlisted with resource= " + xares), new Object[0]);
            TraceTm.jta.debug((Object)("start javaxxid= " + javaxxid), new Object[0]);
        }
        if (!found) {
            this.subcoord.addJavaxXid(javaxxid);
        }
        try {
            xares.start(javaxxid, flag);
        }
        catch (XAException e) {
            String error = "Cannot send XA(" + xares + ") start:" + e + " (error code = " + e.errorCode + ") --" + e.getMessage();
            TraceTm.jotm.error((Object)error, new Object[0]);
            throw new SystemException(error);
        }
        if (!this.enlistedXARes.contains(xares)) {
            this.enlistedXARes.add(xares);
            this.enlistedJavaxXid.add(javaxxid);
        }
        int status = this.getStatus();
        switch (status) {
            case 0: 
            case 7: {
                break;
            }
            case 2: {
                throw new IllegalStateException("Transaction already prepared.");
            }
            case 8: {
                break;
            }
            case 3: {
                throw new IllegalStateException("Transaction already committed.");
            }
            case 1: {
                throw new RollbackException("Transaction already marked for rollback");
            }
            case 9: {
                throw new RollbackException("Transaction already started rolling back.");
            }
            case 4: {
                throw new RollbackException("Transaction already rolled back.");
            }
            case 6: {
                throw new IllegalStateException("No current transaction.");
            }
            case 5: {
                throw new IllegalStateException("Unknown transaction status");
            }
            default: {
                throw new IllegalStateException("Illegal transaction status: " + status);
            }
        }
        return true;
    }

    public void doDetach(int flag) throws SystemException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("TransactionImpl.doDetach flag= " + XAResourceHelper.getFlagName(flag)), new Object[0]);
            TraceTm.jta.debug((Object)("number of enlisted= " + this.enlistedXARes.size()), new Object[0]);
        }
        this.delistedXARes = new ArrayList<XAResource>(this.enlistedXARes);
        for (XAResource xar : this.delistedXARes) {
            this.delistResource(xar, flag);
        }
    }

    public void doAttach(int flag) throws SystemException, RollbackException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("TransactionImpl.doAttach flag= " + XAResourceHelper.getFlagName(flag)), new Object[0]);
            TraceTm.jta.debug((Object)("number of enlisted= " + this.enlistedXARes.size()), new Object[0]);
        }
        boolean rollbackonenlist = false;
        RollbackException mye = null;
        if (flag == 0x8000000) {
            for (int i = 0; this.delistedXARes != null && i < this.delistedXARes.size(); ++i) {
                try {
                    this.enlistResource(this.delistedXARes.get(i));
                    continue;
                }
                catch (RollbackException e) {
                    if (rollbackonenlist) continue;
                    rollbackonenlist = true;
                    mye = e;
                }
            }
        }
        this.delistedXARes = null;
        if (rollbackonenlist) {
            throw new RollbackException(mye.getMessage());
        }
    }

    public List getEnlistedXAResource() {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("getEnlistedXAResource size= " + this.enlistedXARes.size()), new Object[0]);
        }
        return new ArrayList<XAResource>(this.enlistedXARes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStatus() throws SystemException {
        Coordinator coord;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"TransactionImpl.getStatus()", new Object[0]);
        }
        if ((coord = this.myCtx.getCoordinator()) != null) {
            int ret;
            try {
                this.propagateCtx = false;
                ret = coord.get_status();
            }
            catch (Exception e) {
                TraceTm.jotm.error((Object)"cannot reach JTM:", new Object[]{e});
                int n = 6;
                return n;
            }
            finally {
                this.propagateCtx = true;
            }
            return ret;
        }
        if (this.subcoord != null) {
            return this.subcoord.getStatus();
        }
        return this.localstatus;
    }

    public void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("Synchro=" + sync), new Object[0]);
        }
        if (this.subcoord == null) {
            this.makeSubCoord(false, true);
        }
        this.subcoord.addSynchronization(sync);
    }

    public void rollback() throws IllegalStateException, SystemException {
        Terminator term;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("TransactionImpl.rollback(tx= " + this + ")"), new Object[0]);
        }
        if ((term = this.myCtx.getTerminator()) != null) {
            try {
                this.propagateCtx = false;
                term.rollback();
            }
            catch (ServerException e) {
                throw new IllegalStateException("Exception on rollback:" + e);
            }
            catch (Exception e) {
                Current.getCurrent().forgetTx(this.getXid());
                this.localstatus = 5;
                this.clearUserResourceMap();
                throw new SystemException("Unexpected Exception on rollback");
            }
            finally {
                this.propagateCtx = true;
            }
            if (this.subcoord == null) {
                this.unsetTimer();
            }
            Current.getCurrent().forgetTx(this.getXid());
            this.localstatus = 4;
            this.clearUserResourceMap();
            return;
        }
        if (this.subcoord != null) {
            try {
                this.subcoord.rollback();
            }
            catch (RemoteException e) {
                Current.getCurrent().forgetTx(this.getXid());
                this.localstatus = 5;
                this.clearUserResourceMap();
                throw new IllegalStateException("Exception on rollback:" + e);
            }
        } else {
            this.unsetTimer();
        }
        Current.getCurrent().forgetTx(this.getXid());
        this.localstatus = 4;
        this.clearUserResourceMap();
    }

    public int prepare() throws IllegalStateException, SystemException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("TransactionImpl.prepare(tx= " + this + ")"), new Object[0]);
        }
        int ret = 0;
        if (this.subcoord != null) {
            try {
                ret = this.subcoord.prepare();
            }
            catch (RemoteException e) {
                TraceTm.jotm.error((Object)"Unexpected Exception on prepare:", new Object[]{e});
                throw new SystemException("Unexpected Exception on prepare");
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRollbackOnly() throws IllegalStateException, SystemException {
        Coordinator coord;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("Tx=" + this), new Object[0]);
        }
        if ((coord = this.myCtx.getCoordinator()) != null) {
            try {
                this.propagateCtx = false;
                coord.rollback_only();
            }
            catch (RemoteException e) {
                TraceTm.jotm.error((Object)"Cannot perform coordinator rollback only", new Object[]{e});
            }
            finally {
                this.propagateCtx = true;
            }
        }
        if (this.subcoord == null) {
            try {
                this.makeSubCoord(false, false);
            }
            catch (RollbackException e) {
                TraceTm.jotm.debug((Object)"already rolled back", new Object[0]);
                return;
            }
        }
        this.subcoord.setRollbackOnly();
    }

    public void timeoutExpired(Object arg) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"TransactionImpl.timeoutExpired", new Object[0]);
        }
        Current.getCurrent().incrementExpiredCounter();
        if (this.subcoord == null) {
            Terminator term = this.myCtx.getTerminator();
            if (term != null) {
                if (TraceTm.jta.isDebugEnabled()) {
                    TraceTm.jta.debug((Object)("forget tx (tx=" + this + ")"), new Object[0]);
                }
                Current.getCurrent().forgetTx(this.getXid());
                this.localstatus = 4;
                return;
            }
            try {
                this.makeSubCoord(false, false);
            }
            catch (RollbackException e) {
                TraceTm.jotm.debug((Object)"already rolled back", new Object[0]);
                this.localstatus = 4;
                return;
            }
            catch (SystemException e) {
                TraceTm.jotm.error((Object)"cannot make subcoordinator", new Object[0]);
                this.localstatus = 4;
                return;
            }
        }
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("set rollback only (tx=" + this + ")"), new Object[0]);
        }
        try {
            this.subcoord.setRollbackOnly();
        }
        catch (Exception e) {
            TraceTm.jotm.error((Object)("cannot rollbackonly:" + e), new Object[0]);
        }
    }

    public boolean equals(Object obj2) {
        if (obj2 instanceof TransactionImpl) {
            TransactionImpl tx2 = (TransactionImpl)obj2;
            if (tx2 == this) {
                return true;
            }
            return this.getXid().equals(tx2.getXid());
        }
        return false;
    }

    public int hashCode() {
        if (!this.genXidhashcode) {
            this.genXidhashcode = true;
            this.myXidhashcode = this.getXid().hashCode();
        }
        return this.myXidhashcode;
    }

    public String toString() {
        if (!this.genXidtostring) {
            this.genXidtostring = true;
            this.myXidtostring = this.getXid().toString();
        }
        return this.myXidtostring;
    }

    public synchronized TransactionContext getPropagationContext(boolean hold) {
        if (this.propagateCtx) {
            return this.myCtx;
        }
        return null;
    }

    public void setTimer(TimerEvent timer) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("set timer for tx (timer=" + timer + ", tx=" + this + ")"), new Object[0]);
        }
        this.timer = timer;
    }

    public void unsetTimer() {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("unset timer for tx (timer=" + this.timer + ", tx=" + this + ")"), new Object[0]);
        }
        if (this.timer != null) {
            this.timer.unset();
            this.timer = null;
        }
    }

    public void setTxDate(Date date) {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("set date for tx (data=" + date + ", tx=" + this + ")"), new Object[0]);
        }
        this.txDate = (Date)date.clone();
    }

    public Date getTxDate() {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("get date for tx (date=" + this.txDate + ", tx=" + this + ")"), new Object[0]);
        }
        return (Date)this.txDate.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updatePropagationContext(TransactionContext pctx) {
        Coordinator remoteCoord;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"TransactionImpl.updatePropagationContext", new Object[0]);
        }
        if ((remoteCoord = pctx.getCoordinator()) == null && this.myCtx.getCoordinator() != null) {
            TraceTm.jotm.error((Object)"setPropagationContext: Bad Coordinator", new Object[0]);
            TraceTm.jotm.error((Object)("remoteCoord = " + remoteCoord), new Object[0]);
            TraceTm.jotm.error((Object)("myCtx.getCoordinator()= " + this.myCtx.getCoordinator()), new Object[0]);
            return;
        }
        if (remoteCoord != null && this.myCtx.getCoordinator() == null) {
            this.myCtx.setCoordinator(pctx.getCoordinator());
            if (this.subcoord != null) {
                TraceTm.jta.debug((Object)"register the subCoordinator as a Resource", new Object[0]);
                try {
                    this.propagateCtx = false;
                    this.recoveryCoord = remoteCoord.register_resource(this.subcoord);
                }
                catch (RemoteException e) {
                    TraceTm.jotm.warn((Object)("Cannot make interposition :" + e.getCause()), new Object[]{e});
                    return;
                }
                finally {
                    this.propagateCtx = true;
                }
            }
        }
        if (pctx.getTerminator() != null) {
            this.myCtx.setTerminator(pctx.getTerminator());
        }
    }

    public Xid getXid() {
        return this.myXid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeSubCoord(boolean interpose, boolean active) throws RollbackException, SystemException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"make subcoordinator", new Object[0]);
        }
        try {
            this.subcoord = new SubCoordinator(this, this.getXid(), this.isCorbaCompliant);
        }
        catch (RemoteException e) {
            TraceTm.jotm.error((Object)"new SubCoordinator raised exception: ", new Object[]{e});
            return;
        }
        if (!active) {
            return;
        }
        Coordinator remoteCoord = this.myCtx.getCoordinator();
        if (interpose && remoteCoord == null) {
            try {
                if (TraceTm.jta.isDebugEnabled()) {
                    TraceTm.jta.debug((Object)"Creating a remote Control on JTM for a distributed transaction", new Object[0]);
                }
                this.propagateCtx = false;
                Control coord = Current.getJTM().recreate(this.myCtx);
                remoteCoord = (Coordinator)PortableRemoteObject.narrow((Object)coord, Coordinator.class);
            }
            catch (RemoteException e) {
                TraceTm.jotm.error((Object)"Cannot create distributed transaction:", new Object[]{e});
                this.cleanup();
                return;
            }
            finally {
                this.propagateCtx = true;
            }
            this.myCtx.setCoordinator(remoteCoord);
            if (this.myCtx.getTerminator() == null) {
                this.myCtx.setTerminator((Terminator)((Object)remoteCoord));
            }
        }
        if (remoteCoord != null && this.recoveryCoord == null) {
            try {
                this.propagateCtx = false;
                this.recoveryCoord = remoteCoord.register_resource(this.subcoord);
            }
            catch (RemoteException e) {
                this.cleanup();
                if (e.getCause() instanceof TransactionRolledbackException) {
                    TraceTm.jotm.warn((Object)"Cannot Make Interposition: rolled back occured", new Object[0]);
                    throw new RollbackException("Cannot Make Interposition");
                }
                TraceTm.jotm.warn((Object)("Cannot make Interposition:" + e.getCause()), new Object[]{e});
                throw new SystemException("Cannot Make Interposition");
            }
            finally {
                this.propagateCtx = true;
            }
        }
        Current.getCurrent().incrementBeginCounter();
    }

    public boolean toRemove() {
        return this.toremove;
    }

    public void cleanup() {
        if (this.subcoord != null) {
            TraceTm.jta.debug((Object)"unexport SubCoordinator", new Object[0]);
            try {
                this.subcoord.cleanup();
            }
            catch (NoSuchObjectException e) {
                TraceTm.jta.debug((Object)("Cannot unexport subcoord:" + e), new Object[0]);
            }
            this.subcoord = null;
        }
    }

    private synchronized void clearUserResourceMap() {
        if (this.userResourceMap != null && !this.userResourceMap.isEmpty()) {
            this.userResourceMap.clear();
            this.userResourceMap = null;
        }
    }
}

