/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.SQLException;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.data.knownexploited.json.KnownExploitedVulnerabilitiesSchema;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.nvdcve.DatabaseProperties;
import org.owasp.dependencycheck.data.update.CachedWebDataSource;
import org.owasp.dependencycheck.data.update.cisa.KnownExploitedVulnerabilityParser;
import org.owasp.dependencycheck.data.update.exception.CorruptedDatastreamException;
import org.owasp.dependencycheck.data.update.exception.UpdateException;
import org.owasp.dependencycheck.utils.HttpResourceConnection;
import org.owasp.dependencycheck.utils.ResourceNotFoundException;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.TooManyRequestsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnownExploitedDataSource
implements CachedWebDataSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(KnownExploitedDataSource.class);
    private static final String DEFAULT_URL = "https://www.cisa.gov/sites/default/files/feeds/known_exploited_vulnerabilities.json";
    private CveDB cveDB;
    private Settings settings;
    private DatabaseProperties dbProperties = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean update(Engine engine) throws UpdateException {
        this.cveDB = engine.getDatabase();
        this.settings = engine.getSettings();
        this.dbProperties = this.cveDB.getDatabaseProperties();
        boolean autoUpdate = this.settings.getBoolean("odc.autoupdate", true);
        boolean kevEnabled = this.settings.getBoolean("analyzer.knownexploited.enabled", true);
        if (!autoUpdate) return false;
        if (!kevEnabled) return false;
        if (!this.shouldUpdate()) return false;
        try {
            URL url = new URL(this.settings.getString("kev.url", DEFAULT_URL));
            LOGGER.info("Updating CISA Known Exploited Vulnerability list: " + url.toString());
            HttpResourceConnection conn = new HttpResourceConnection(this.settings);
            try (InputStream in = conn.fetch(url);){
                KnownExploitedVulnerabilityParser parser = new KnownExploitedVulnerabilityParser();
                KnownExploitedVulnerabilitiesSchema data = parser.parse(in);
                String currentVersion = this.dbProperties.getProperty("kev.version", "");
                if (!currentVersion.equals(data.getCatalogVersion())) {
                    this.cveDB.updateKnownExploitedVulnerabilities(data.getVulnerabilities());
                }
                this.dbProperties.save("kev.checked", Long.toString(System.currentTimeMillis() / 1000L));
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException | SQLException | DatabaseException | CorruptedDatastreamException | ResourceNotFoundException | TooManyRequestsException ex) {
            throw new UpdateException(ex);
        }
    }

    @Override
    public boolean purge(Engine engine) {
        return true;
    }

    private boolean shouldUpdate() throws UpdateException {
        boolean proceed = true;
        int validForHours = this.settings.getInt("kev.check.validforhours", 24);
        if (this.cveDB.dataExists() && 0 < validForHours) {
            long validForSeconds = (long)validForHours * 60L * 60L;
            long lastChecked = this.dbProperties.getPropertyInSeconds("kev.checked");
            long now = System.currentTimeMillis() / 1000L;
            boolean bl = proceed = now - lastChecked > validForSeconds;
            if (!proceed) {
                LOGGER.info("Skipping Known Exploited Vulnerabilities update check since last check was within {} hours.", (Object)validForHours);
            }
        }
        return proceed;
    }
}

