/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.jcs3.access.exception.CacheException;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.JarAnalyzer;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.analyzer.exception.UnexpectedAnalysisException;
import org.owasp.dependencycheck.data.cache.DataCache;
import org.owasp.dependencycheck.data.cache.DataCacheFactory;
import org.owasp.dependencycheck.data.central.CentralSearch;
import org.owasp.dependencycheck.data.nexus.MavenArtifact;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Evidence;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.DownloadFailedException;
import org.owasp.dependencycheck.utils.Downloader;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.owasp.dependencycheck.utils.FileUtils;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.ResourceNotFoundException;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.TooManyRequestsException;
import org.owasp.dependencycheck.xml.pom.Model;
import org.owasp.dependencycheck.xml.pom.PomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class CentralAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(CentralAnalyzer.class);
    private static final String ANALYZER_NAME = "Central Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INFORMATION_COLLECTION;
    private static final String SUPPORTED_EXTENSIONS = "jar";
    private static final FileFilter FILTER = FileFilterBuilder.newInstance().addExtensions("jar").build();
    private static final int BASE_RETRY_WAIT = 1500;
    private static int numberOfRetries = 7;
    private CentralSearch searcher;
    private DataCache<Model> cache;

    @Override
    public synchronized void initialize(Settings settings) {
        super.initialize(settings);
        this.setEnabled(this.checkEnabled());
        numberOfRetries = this.getSettings().getInt("analyzer.central.retry.count", numberOfRetries);
        if (settings.getBoolean("analyzer.central.use.cache", true)) {
            try {
                DataCacheFactory factory = new DataCacheFactory(settings);
                this.cache = factory.getPomCache();
            }
            catch (CacheException ex) {
                settings.setBoolean("analyzer.central.use.cache", false);
                LOGGER.debug("Error creating cache, disabling caching", (Throwable)ex);
            }
        }
    }

    @Override
    public boolean supportsParallelProcessing() {
        return this.getSettings().getBoolean("analyzer.central.parallel.analysis", true);
    }

    private boolean checkEnabled() {
        try {
            return this.getSettings().getBoolean("analyzer.central.enabled");
        }
        catch (InvalidSettingException ise) {
            LOGGER.warn("Invalid setting. Disabling the Central analyzer");
            return false;
        }
    }

    @Override
    public void prepareFileTypeAnalyzer(Engine engine) throws InitializationException {
        LOGGER.debug("Initializing Central analyzer");
        LOGGER.debug("Central analyzer enabled: {}", (Object)this.isEnabled());
        if (this.isEnabled()) {
            try {
                this.searcher = new CentralSearch(this.getSettings());
            }
            catch (MalformedURLException ex) {
                this.setEnabled(false);
                throw new InitializationException("The configured URL to Maven Central is malformed", ex);
            }
        }
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.central.enabled";
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected FileFilter getFileFilter() {
        return FILTER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        String message;
        for (Evidence e : dependency.getEvidence(EvidenceType.VENDOR)) {
            if (!"pom".equals(e.getSource())) continue;
            return;
        }
        try {
            List<MavenArtifact> mas = this.fetchMavenArtifacts(dependency);
            Confidence confidence = mas.size() > 1 ? Confidence.HIGH : Confidence.HIGHEST;
            for (MavenArtifact ma : mas) {
                LOGGER.debug("Central analyzer found artifact ({}) for dependency ({})", (Object)ma, (Object)dependency.getFileName());
                dependency.addAsEvidence("central", ma, confidence);
                if (ma.getPomUrl() == null) continue;
                File pomFile = null;
                try {
                    File baseDir = this.getSettings().getTempDirectory();
                    pomFile = File.createTempFile("pom", ".xml", baseDir);
                    if (!pomFile.delete()) {
                        LOGGER.warn("Unable to fetch pom.xml for {} from Central; this could result in undetected CPE/CVEs.", (Object)dependency.getFileName());
                        LOGGER.debug("Unable to delete temp file");
                    }
                    int maxAttempts = this.getSettings().getInt("analyzer.central.retry.count", 3);
                    int retryCount = 0;
                    long sleepingTimeBetweenRetriesInMillis = 1500L;
                    boolean success = false;
                    Model model = null;
                    if (this.cache != null) {
                        model = this.cache.get(ma.getPomUrl());
                    }
                    if (model != null) {
                        success = true;
                        LOGGER.debug("Cache hit for {}", (Object)ma.getPomUrl());
                    } else {
                        LOGGER.debug("Downloading {}", (Object)ma.getPomUrl());
                        do {
                            try {
                                Downloader.getInstance().fetchFile(new URL(ma.getPomUrl()), pomFile);
                                success = true;
                            }
                            catch (DownloadFailedException ex) {
                                try {
                                    Thread.sleep(sleepingTimeBetweenRetriesInMillis);
                                }
                                catch (InterruptedException ex1) {
                                    Thread.currentThread().interrupt();
                                    throw new UnexpectedAnalysisException(ex1);
                                }
                                sleepingTimeBetweenRetriesInMillis *= 2L;
                            }
                            catch (ResourceNotFoundException ex) {
                                LOGGER.debug("pom.xml does not exist in Central for {}", (Object)dependency.getFileName());
                                if (pomFile != null && pomFile.exists() && !FileUtils.delete((File)pomFile)) {
                                    LOGGER.debug("Failed to delete temporary pom file {}", (Object)pomFile);
                                    pomFile.deleteOnExit();
                                }
                                return;
                            }
                        } while (!success && retryCount++ < maxAttempts);
                    }
                    if (success) {
                        if (model == null) {
                            model = PomUtils.readPom(pomFile);
                            if (this.cache != null) {
                                this.cache.put(ma.getPomUrl(), model);
                            }
                        }
                        boolean isMainPom = mas.size() == 1 || dependency.getActualFilePath().contains(ma.getVersion());
                        JarAnalyzer.setPomEvidence(dependency, model, null, isMainPom);
                        continue;
                    }
                    LOGGER.warn("Unable to download pom.xml for {} from Central; this could result in undetected CPE/CVEs.", (Object)dependency.getFileName());
                }
                catch (AnalysisException ex) {
                    LOGGER.warn(MessageFormat.format("Unable to analyze pom.xml for {0} from Central; this could result in undetected CPE/CVEs.", dependency.getFileName()), (Throwable)ex);
                }
                finally {
                    if (pomFile == null || !pomFile.exists() || FileUtils.delete((File)pomFile)) continue;
                    LOGGER.debug("Failed to delete temporary pom file {}", (Object)pomFile);
                    pomFile.deleteOnExit();
                }
            }
        }
        catch (TooManyRequestsException tre) {
            this.setEnabled(false);
            message = "Connections to Central search refused. Analysis failed.";
            LOGGER.error("Connections to Central search refused. Analysis failed.", (Throwable)tre);
            throw new AnalysisException("Connections to Central search refused. Analysis failed.", tre);
        }
        catch (IllegalArgumentException iae) {
            LOGGER.info("invalid sha1-hash on {}", (Object)dependency.getFileName());
        }
        catch (FileNotFoundException fnfe) {
            LOGGER.debug("Artifact not found in repository: '{}", (Object)dependency.getFileName());
        }
        catch (IOException ioe) {
            message = "Could not connect to Central search. Analysis failed.";
            LOGGER.error("Could not connect to Central search. Analysis failed.", (Throwable)ioe);
            throw new AnalysisException("Could not connect to Central search. Analysis failed.", ioe);
        }
    }

    protected List<MavenArtifact> fetchMavenArtifacts(Dependency dependency) throws IOException, TooManyRequestsException {
        IOException lastException = null;
        long sleepingTimeBetweenRetriesInMillis = 1500L;
        int triesLeft = numberOfRetries;
        while (triesLeft-- > 0) {
            try {
                return this.searcher.searchSha1(dependency.getSha1sum());
            }
            catch (FileNotFoundException fnfe) {
                throw fnfe;
            }
            catch (IOException ioe) {
                LOGGER.debug("Could not connect to Central search (tries left: {}): {}", (Object)triesLeft, (Object)ioe.getMessage());
                lastException = ioe;
                if (triesLeft <= 0) continue;
                try {
                    Thread.sleep(sleepingTimeBetweenRetriesInMillis);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new UnexpectedAnalysisException(e);
                }
                sleepingTimeBetweenRetriesInMillis *= 2L;
            }
        }
        String message = "Finally failed connecting to Central search. Giving up after " + numberOfRetries + " tries.";
        throw new IOException(message, lastException);
    }

    protected void setCentralSearch(CentralSearch searcher) {
        this.searcher = searcher;
    }
}

