/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import com.github.packageurl.PackageURLBuilder;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.ThreadSafe;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.dependency.naming.PurlIdentifier;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.Checksum;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class LibmanAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final String DEPENDENCY_ECOSYSTEM = "nodejs";
    private static final Logger LOGGER = LoggerFactory.getLogger(LibmanAnalyzer.class);
    private static final String ANALYZER_NAME = "Libman Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INFORMATION_COLLECTION;
    private static final String FILE_NAME = "libman.json";
    private static final FileFilter FILTER = FileFilterBuilder.newInstance().addFilenames("libman.json").build();
    private static final Pattern LIBRARY_REGEX = Pattern.compile("(\\@(?<package>[a-zA-Z]+)\\/)?(?<name>.+)\\@(?<version>.+)", 2);

    @Override
    public void prepareFileTypeAnalyzer(Engine engine) throws InitializationException {
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.libman.enabled";
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected FileFilter getFileFilter() {
        return FILTER;
    }

    @Override
    public void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        File dependencyFile;
        LOGGER.debug("Checking file {}", (Object)dependency.getActualFilePath());
        if (FILE_NAME.equals(dependency.getFileName()) && !dependency.isVirtual()) {
            engine.removeDependency(dependency);
        }
        if (!(dependencyFile = dependency.getActualFile()).isFile() || dependencyFile.length() == 0L) {
            return;
        }
        try (JsonReader jsonReader = Json.createReader((InputStream)Files.newInputStream(dependencyFile.toPath(), new OpenOption[0]));){
            JsonObject json = jsonReader.readObject();
            String libmanVersion = json.getString("version");
            if (!"1.0".equals(libmanVersion)) {
                LOGGER.warn("The Libman analyzer currently only supports Libman version 1.0");
                return;
            }
            String defaultProvider = json.getString("defaultProvider");
            JsonArray libraries = json.getJsonArray("libraries");
            libraries.forEach(e -> {
                JsonObject reference = (JsonObject)e;
                String provider = reference.getString("provider", defaultProvider);
                String library = reference.getString("library");
                if ("filesystem".equals(provider)) {
                    LOGGER.warn("Unable to determine name and version for filesystem package: {}", (Object)library);
                    return;
                }
                Matcher matcher = LIBRARY_REGEX.matcher(library);
                if (!matcher.find()) {
                    LOGGER.warn("Unable to parse library, unknown format: {}", (Object)library);
                    return;
                }
                String vendor = matcher.group("package");
                String name = matcher.group("name");
                String version = matcher.group("version");
                LOGGER.debug("Found Libman package: vendor {}, name {}, version {}", new Object[]{vendor, name, version});
                Dependency child = new Dependency(dependency.getActualFile(), true);
                child.setEcosystem(DEPENDENCY_ECOSYSTEM);
                child.setName(name);
                child.setVersion(version);
                if (vendor != null) {
                    child.addEvidence(EvidenceType.VENDOR, FILE_NAME, "vendor", vendor, Confidence.HIGHEST);
                }
                child.addEvidence(EvidenceType.VENDOR, FILE_NAME, "name", name, Confidence.HIGH);
                child.addEvidence(EvidenceType.PRODUCT, FILE_NAME, "name", name, Confidence.HIGHEST);
                child.addEvidence(EvidenceType.VERSION, FILE_NAME, "version", version, Confidence.HIGHEST);
                String packagePath = String.format("%s:%s", name, version);
                child.setSha1sum(Checksum.getSHA1Checksum((String)packagePath));
                child.setSha256sum(Checksum.getSHA256Checksum((String)packagePath));
                child.setMd5sum(Checksum.getMD5Checksum((String)packagePath));
                child.setPackagePath(packagePath);
                try {
                    PackageURL purl = PackageURLBuilder.aPackageURL().withType("libman").withName(name).withVersion(version).build();
                    PurlIdentifier id = new PurlIdentifier(purl, Confidence.HIGHEST);
                    child.addSoftwareIdentifier(id);
                }
                catch (MalformedPackageURLException ex) {
                    LOGGER.warn("Unable to build package url for {}", (Object)ex.toString());
                }
                engine.addDependency(child);
            });
        }
        catch (JsonException e2) {
            LOGGER.warn(String.format("Failed to parse %s file", FILE_NAME), (Throwable)e2);
        }
        catch (IOException e3) {
            throw new AnalysisException("Problem occurred while reading dependency file", e3);
        }
    }
}

