/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nodeaudit;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import javax.json.JsonObject;
import org.apache.commons.jcs3.access.exception.CacheException;
import org.apache.hc.client5.http.HttpResponseException;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.message.BasicHeader;
import org.json.JSONException;
import org.json.JSONObject;
import org.owasp.dependencycheck.analyzer.exception.SearchException;
import org.owasp.dependencycheck.analyzer.exception.UnexpectedAnalysisException;
import org.owasp.dependencycheck.data.cache.DataCache;
import org.owasp.dependencycheck.data.cache.DataCacheFactory;
import org.owasp.dependencycheck.data.nodeaudit.Advisory;
import org.owasp.dependencycheck.data.nodeaudit.NpmAuditParser;
import org.owasp.dependencycheck.utils.Checksum;
import org.owasp.dependencycheck.utils.DownloadFailedException;
import org.owasp.dependencycheck.utils.Downloader;
import org.owasp.dependencycheck.utils.ResourceNotFoundException;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.TooManyRequestsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class NodeAuditSearch {
    private final URL nodeAuditUrl;
    private final boolean useProxy;
    private final Settings settings;
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeAuditSearch.class);
    private DataCache<List<Advisory>> cache;

    public NodeAuditSearch(Settings settings) throws MalformedURLException {
        String searchUrl = settings.getString("analyzer.node.audit.url", "https://registry.npmjs.org/-/npm/v1/security/audits");
        LOGGER.debug("Node Audit Search URL: {}", (Object)searchUrl);
        this.nodeAuditUrl = new URL(searchUrl);
        this.settings = settings;
        if (null != settings.getString("proxy.server")) {
            this.useProxy = true;
            LOGGER.debug("Using proxy");
        } else {
            this.useProxy = false;
            LOGGER.debug("Not using proxy");
        }
        if (settings.getBoolean("analyzer.node.audit.use.cache", true)) {
            try {
                DataCacheFactory factory = new DataCacheFactory(settings);
                this.cache = factory.getNodeAuditCache();
            }
            catch (CacheException ex) {
                settings.setBoolean("analyzer.node.audit.use.cache", false);
                LOGGER.debug("Error creating cache, disabling caching", (Throwable)ex);
            }
        }
    }

    public List<Advisory> submitPackage(JsonObject packageJson) throws SearchException, IOException {
        List<Advisory> cached;
        String key = null;
        if (this.cache != null && (cached = this.cache.get(key = Checksum.getSHA256Checksum((String)packageJson.toString()))) != null) {
            LOGGER.debug("cache hit for node audit: " + key);
            return cached;
        }
        return this.submitPackage(packageJson, key, 0);
    }

    private List<Advisory> submitPackage(JsonObject packageJson, String key, int count) throws SearchException, IOException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("----------------------------------------");
            LOGGER.trace("Node Audit Payload:");
            LOGGER.trace(packageJson.toString());
            LOGGER.trace("----------------------------------------");
            LOGGER.trace("----------------------------------------");
        }
        ArrayList<BasicHeader> additionalHeaders = new ArrayList<BasicHeader>();
        additionalHeaders.add(new BasicHeader("User-Agent", (Object)"npm/6.1.0 node/v10.5.0 linux x64"));
        additionalHeaders.add(new BasicHeader("npm-in-ci", (Object)"false"));
        additionalHeaders.add(new BasicHeader("npm-scope", (Object)""));
        additionalHeaders.add(new BasicHeader("npm-session", (Object)this.generateRandomSession()));
        try {
            String response = Downloader.getInstance().postBasedFetchContent(this.nodeAuditUrl.toURI(), packageJson.toString(), ContentType.APPLICATION_JSON, additionalHeaders);
            JSONObject jsonResponse = new JSONObject(response);
            NpmAuditParser parser = new NpmAuditParser();
            List<Advisory> advisories = parser.parse(jsonResponse);
            if (this.cache != null) {
                this.cache.put(key, advisories);
            }
            return advisories;
        }
        catch (RuntimeException | URISyntaxException | JSONException | ResourceNotFoundException | TooManyRequestsException ex) {
            LOGGER.debug("Error connecting to Node Audit API. Error: {}", (Object)ex.getMessage());
            throw new SearchException("Could not connect to Node Audit API: " + ex.getMessage(), ex);
        }
        catch (DownloadFailedException e) {
            if (e.getCause() instanceof HttpResponseException) {
                HttpResponseException hre = (HttpResponseException)e.getCause();
                switch (hre.getStatusCode()) {
                    case 503: {
                        LOGGER.debug("Node Audit API returned `{} {}` - retrying request.", (Object)hre.getStatusCode(), (Object)hre.getReasonPhrase());
                        if (count < 5) {
                            int next = count + 1;
                            try {
                                Thread.sleep(1500L * (long)next);
                            }
                            catch (InterruptedException ex) {
                                Thread.currentThread().interrupt();
                                throw new UnexpectedAnalysisException(ex);
                            }
                            return this.submitPackage(packageJson, key, next);
                        }
                        throw new SearchException("Could not perform Node Audit analysis - service returned a 503.", e);
                    }
                    case 400: {
                        LOGGER.debug("Invalid payload submitted to Node Audit API. Received response code: {} {}", (Object)hre.getStatusCode(), (Object)hre.getReasonPhrase());
                        throw new SearchException("Could not perform Node Audit analysis. Invalid payload submitted to Node Audit API.", e);
                    }
                }
                LOGGER.debug("Could not connect to Node Audit API. Received response code: {} {}", (Object)hre.getStatusCode(), (Object)hre.getReasonPhrase());
                throw new IOException("Could not connect to Node Audit API", e);
            }
            LOGGER.debug("Could not connect to Node Audit API. Received generic DownloadException", (Throwable)e);
            throw new IOException("Could not connect to Node Audit API", e);
        }
    }

    private String generateRandomSession() {
        int length = 16;
        SecureRandom r = new SecureRandom();
        StringBuilder sb = new StringBuilder();
        while (sb.length() < 16) {
            sb.append(Integer.toHexString(r.nextInt()));
        }
        return sb.substring(0, 16);
    }
}

