/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck;

import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.io.FileUtils;
import org.apache.commons.jcs.JCS;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.owasp.dependencycheck.AnalysisTask;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Analyzer;
import org.owasp.dependencycheck.analyzer.AnalyzerService;
import org.owasp.dependencycheck.analyzer.FileTypeAnalyzer;
import org.owasp.dependencycheck.data.nvdcve.ConnectionFactory;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.nvdcve.DatabaseProperties;
import org.owasp.dependencycheck.data.update.CachedWebDataSource;
import org.owasp.dependencycheck.data.update.UpdateService;
import org.owasp.dependencycheck.data.update.exception.UpdateException;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.exception.ExceptionCollection;
import org.owasp.dependencycheck.exception.H2DBLockException;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.exception.NoDataException;
import org.owasp.dependencycheck.exception.ReportException;
import org.owasp.dependencycheck.reporting.ReportGenerator;
import org.owasp.dependencycheck.utils.H2DBLock;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class Engine
implements FileFilter,
AutoCloseable {
    private final List<Dependency> dependencies = Collections.synchronizedList(new ArrayList());
    private Dependency[] dependenciesExternalView = null;
    private final Map<AnalysisPhase, List<Analyzer>> analyzers = new EnumMap<AnalysisPhase, List<Analyzer>>(AnalysisPhase.class);
    private final Set<FileTypeAnalyzer> fileTypeAnalyzers = new HashSet<FileTypeAnalyzer>();
    private final Mode mode;
    private final ClassLoader serviceClassLoader;
    private CveDB database = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(Engine.class);
    private final Settings settings;

    public Engine(@NotNull Settings settings) {
        this(Mode.STANDALONE, settings);
    }

    public Engine(@NotNull Mode mode, @NotNull Settings settings) {
        this(Thread.currentThread().getContextClassLoader(), mode, settings);
    }

    public Engine(@NotNull ClassLoader serviceClassLoader, @NotNull Settings settings) {
        this(serviceClassLoader, Mode.STANDALONE, settings);
    }

    public Engine(@NotNull ClassLoader serviceClassLoader, @NotNull Mode mode, @NotNull Settings settings) {
        this.settings = settings;
        this.serviceClassLoader = serviceClassLoader;
        this.mode = mode;
        this.initializeEngine();
    }

    protected final void initializeEngine() {
        this.loadAnalyzers();
    }

    @Override
    public void close() {
        if (this.mode.isDatabaseRequired() && this.database != null) {
            this.database.close();
            this.database = null;
        }
        JCS.shutdown();
    }

    private void loadAnalyzers() {
        if (!this.analyzers.isEmpty()) {
            return;
        }
        this.mode.getPhases().forEach(phase -> {
            List cfr_ignored_0 = this.analyzers.put((AnalysisPhase)((Object)phase), new ArrayList());
        });
        AnalyzerService service = new AnalyzerService(this.serviceClassLoader, this.settings);
        List<Analyzer> iterator = service.getAnalyzers((List<AnalysisPhase>)this.mode.getPhases());
        iterator.forEach(a -> {
            a.initialize(this.settings);
            this.analyzers.get((Object)a.getAnalysisPhase()).add((Analyzer)a);
            if (a instanceof FileTypeAnalyzer) {
                this.fileTypeAnalyzers.add((FileTypeAnalyzer)a);
            }
        });
    }

    public List<Analyzer> getAnalyzers(AnalysisPhase phase) {
        return this.analyzers.get((Object)phase);
    }

    public synchronized void addDependency(Dependency dependency) {
        this.dependencies.add(dependency);
        this.dependenciesExternalView = null;
    }

    public synchronized void sortDependencies() {
    }

    public synchronized void removeDependency(@NotNull Dependency dependency) {
        this.dependencies.remove(dependency);
        this.dependenciesExternalView = null;
    }

    @SuppressFBWarnings(justification="This is the intended external view of the dependencies", value={"EI_EXPOSE_REP"})
    public synchronized Dependency[] getDependencies() {
        if (this.dependenciesExternalView == null) {
            this.dependenciesExternalView = this.dependencies.toArray(new Dependency[0]);
        }
        return this.dependenciesExternalView;
    }

    public synchronized void setDependencies(@NotNull List<Dependency> dependencies) {
        this.dependencies.clear();
        this.dependencies.addAll(dependencies);
        this.dependenciesExternalView = null;
    }

    public List<Dependency> scan(@NotNull String[] paths) {
        return this.scan(paths, null);
    }

    public List<Dependency> scan(@NotNull String[] paths, @Nullable String projectReference) {
        ArrayList<Dependency> deps = new ArrayList<Dependency>();
        for (String path : paths) {
            List<Dependency> d = this.scan(path, projectReference);
            if (d == null) continue;
            deps.addAll(d);
        }
        return deps;
    }

    public List<Dependency> scan(@NotNull String path) {
        return this.scan(path, null);
    }

    public List<Dependency> scan(@NotNull String path, String projectReference) {
        File file = new File(path);
        return this.scan(file, projectReference);
    }

    public List<Dependency> scan(File[] files) {
        return this.scan(files, null);
    }

    public List<Dependency> scan(File[] files, String projectReference) {
        ArrayList<Dependency> deps = new ArrayList<Dependency>();
        for (File file : files) {
            List<Dependency> d = this.scan(file, projectReference);
            if (d == null) continue;
            deps.addAll(d);
        }
        return deps;
    }

    public List<Dependency> scan(Collection<File> files) {
        return this.scan(files, null);
    }

    public List<Dependency> scan(Collection<File> files, String projectReference) {
        ArrayList<Dependency> deps = new ArrayList<Dependency>();
        files.stream().map(file -> this.scan((File)file, projectReference)).filter(d -> d != null).forEach(d -> deps.addAll((Collection<Dependency>)d));
        return deps;
    }

    public List<Dependency> scan(File file) {
        return this.scan(file, null);
    }

    @Nullable
    public List<Dependency> scan(@NotNull File file, String projectReference) {
        if (file.exists()) {
            if (file.isDirectory()) {
                return this.scanDirectory(file, projectReference);
            }
            Dependency d = this.scanFile(file, projectReference);
            if (d != null) {
                ArrayList<Dependency> deps = new ArrayList<Dependency>();
                deps.add(d);
                return deps;
            }
        }
        return null;
    }

    protected List<Dependency> scanDirectory(File dir) {
        return this.scanDirectory(dir, null);
    }

    protected List<Dependency> scanDirectory(@NotNull File dir, @Nullable String projectReference) {
        File[] files = dir.listFiles();
        ArrayList<Dependency> deps = new ArrayList<Dependency>();
        if (files != null) {
            for (File f : files) {
                Object d;
                if (f.isDirectory()) {
                    d = this.scanDirectory(f, projectReference);
                    if (d == null) continue;
                    deps.addAll((Collection<Dependency>)d);
                    continue;
                }
                d = this.scanFile(f, projectReference);
                if (d == null) continue;
                deps.add((Dependency)d);
            }
        }
        return deps;
    }

    protected Dependency scanFile(@NotNull File file) {
        return this.scanFile(file, null);
    }

    protected synchronized Dependency scanFile(@NotNull File file, @Nullable String projectReference) {
        Dependency dependency = null;
        if (file.isFile()) {
            if (this.accept(file)) {
                dependency = new Dependency(file);
                if (projectReference != null) {
                    dependency.addProjectReference(projectReference);
                }
                String sha1 = dependency.getSha1sum();
                boolean found = false;
                if (sha1 != null) {
                    for (Dependency existing : this.dependencies) {
                        if (!sha1.equals(existing.getSha1sum())) continue;
                        found = true;
                        if (projectReference != null) {
                            existing.addProjectReference(projectReference);
                        }
                        if (existing.getActualFilePath() != null && dependency.getActualFilePath() != null && !existing.getActualFilePath().equals(dependency.getActualFilePath())) {
                            existing.addRelatedDependency(dependency);
                            break;
                        }
                        dependency = existing;
                        break;
                    }
                }
                if (!found) {
                    this.dependencies.add(dependency);
                    this.dependenciesExternalView = null;
                }
            }
        } else {
            LOGGER.debug("Path passed to scanFile(File) is not a file that can be scanned by dependency-check: {}. Skipping the file.", (Object)file);
        }
        return dependency;
    }

    public void analyzeDependencies() throws ExceptionCollection {
        List<Throwable> exceptions = Collections.synchronizedList(new ArrayList());
        this.initializeAndUpdateDatabase(exceptions);
        try {
            this.ensureDataExists();
        }
        catch (NoDataException ex) {
            this.throwFatalExceptionCollection("Unable to continue dependency-check analysis.", ex, exceptions);
        }
        LOGGER.debug("\n----------------------------------------------------\nBEGIN ANALYSIS\n----------------------------------------------------");
        LOGGER.info("Analysis Started");
        long analysisStart = System.currentTimeMillis();
        for (AnalysisPhase phase2 : this.mode.getPhases()) {
            List<Analyzer> analyzerList2 = this.analyzers.get((Object)phase2);
            for (Analyzer analyzer : analyzerList2) {
                long analyzerStart = System.currentTimeMillis();
                try {
                    this.initializeAnalyzer(analyzer);
                }
                catch (InitializationException ex) {
                    exceptions.add(ex);
                    if (ex.isFatal()) continue;
                }
                if (analyzer.isEnabled()) {
                    this.executeAnalysisTasks(analyzer, exceptions);
                    long analyzerDurationMillis = System.currentTimeMillis() - analyzerStart;
                    long analyzerDurationSeconds = TimeUnit.MILLISECONDS.toSeconds(analyzerDurationMillis);
                    LOGGER.info("Finished {} ({} seconds)", (Object)analyzer.getName(), (Object)analyzerDurationSeconds);
                    continue;
                }
                LOGGER.debug("Skipping {} (not enabled)", (Object)analyzer.getName());
            }
        }
        this.mode.getPhases().stream().map(phase -> this.analyzers.get(phase)).forEach(analyzerList -> analyzerList.forEach(a -> this.closeAnalyzer((Analyzer)a)));
        LOGGER.debug("\n----------------------------------------------------\nEND ANALYSIS\n----------------------------------------------------");
        long analysisDurationSeconds = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - analysisStart);
        LOGGER.info("Analysis Complete ({} seconds)", (Object)analysisDurationSeconds);
        if (exceptions.size() > 0) {
            throw new ExceptionCollection(exceptions);
        }
    }

    private void initializeAndUpdateDatabase(@NotNull List<Throwable> exceptions) throws ExceptionCollection {
        if (!this.mode.isDatabaseRequired()) {
            return;
        }
        boolean autoUpdate = this.settings.getBoolean("autoupdate", true);
        if (autoUpdate) {
            try {
                this.doUpdates(true);
            }
            catch (UpdateException ex) {
                exceptions.add(ex);
                LOGGER.warn("Unable to update 1 or more Cached Web DataSource, using local data instead. Results may not include recent vulnerabilities.");
                LOGGER.debug("Update Error", (Throwable)ex);
            }
            catch (DatabaseException ex) {
                this.throwFatalDatabaseException(ex, exceptions);
            }
        } else {
            try {
                if (ConnectionFactory.isH2Connection(this.settings) && !ConnectionFactory.h2DataFileExists(this.settings)) {
                    throw new ExceptionCollection(new NoDataException("Autoupdate is disabled and the database does not exist"), true);
                }
                this.openDatabase(true, true);
            }
            catch (IOException ex) {
                throw new ExceptionCollection(new DatabaseException("Autoupdate is disabled and unable to connect to the database"), true);
            }
            catch (DatabaseException ex) {
                this.throwFatalDatabaseException(ex, exceptions);
            }
        }
    }

    private void throwFatalDatabaseException(DatabaseException ex, List<Throwable> exceptions) throws ExceptionCollection {
        String msg = ex.getMessage().contains("Unable to connect") && ConnectionFactory.isH2Connection(this.settings) ? "Unable to connect to the database - if this error persists it may be due to a corrupt database. Consider running `purge` to delete the existing database" : "Unable to connect to the dependency-check database";
        exceptions.add(new DatabaseException(msg, ex));
        throw new ExceptionCollection(exceptions, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeAnalysisTasks(@NotNull Analyzer analyzer, List<Throwable> exceptions) throws ExceptionCollection {
        LOGGER.debug("Starting {}", (Object)analyzer.getName());
        List<AnalysisTask> analysisTasks = this.getAnalysisTasks(analyzer, exceptions);
        ExecutorService executorService = this.getExecutorService(analyzer);
        try {
            int timeout = this.settings.getInt("odc.analysis.timeout", 20);
            List results = executorService.invokeAll(analysisTasks, timeout, TimeUnit.MINUTES);
            for (Future result : results) {
                try {
                    result.get();
                }
                catch (ExecutionException e) {
                    this.throwFatalExceptionCollection("Analysis task failed with a fatal exception.", e, exceptions);
                }
                catch (CancellationException e) {
                    this.throwFatalExceptionCollection("Analysis task was cancelled.", e, exceptions);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.throwFatalExceptionCollection("Analysis has been interrupted.", e, exceptions);
        }
        finally {
            executorService.shutdown();
        }
    }

    protected synchronized List<AnalysisTask> getAnalysisTasks(Analyzer analyzer, List<Throwable> exceptions) {
        ArrayList<AnalysisTask> result = new ArrayList<AnalysisTask>();
        this.dependencies.stream().map(dependency -> new AnalysisTask(analyzer, (Dependency)dependency, this, exceptions)).forEach(task -> result.add((AnalysisTask)task));
        return result;
    }

    protected ExecutorService getExecutorService(Analyzer analyzer) {
        if (analyzer.supportsParallelProcessing()) {
            int maximumNumberOfThreads = Runtime.getRuntime().availableProcessors();
            LOGGER.debug("Parallel processing with up to {} threads: {}.", (Object)maximumNumberOfThreads, (Object)analyzer.getName());
            return Executors.newFixedThreadPool(maximumNumberOfThreads);
        }
        LOGGER.debug("Parallel processing is not supported: {}.", (Object)analyzer.getName());
        return Executors.newSingleThreadExecutor();
    }

    protected void initializeAnalyzer(@NotNull Analyzer analyzer) throws InitializationException {
        try {
            LOGGER.debug("Initializing {}", (Object)analyzer.getName());
            analyzer.prepare(this);
        }
        catch (InitializationException ex) {
            LOGGER.error("Exception occurred initializing {}.", (Object)analyzer.getName());
            LOGGER.debug("", (Throwable)ex);
            if (ex.isFatal()) {
                try {
                    analyzer.close();
                }
                catch (Throwable ex1) {
                    LOGGER.trace("", ex1);
                }
            }
            throw ex;
        }
        catch (Throwable ex) {
            LOGGER.error("Unexpected exception occurred initializing {}.", (Object)analyzer.getName());
            LOGGER.debug("", ex);
            try {
                analyzer.close();
            }
            catch (Throwable ex1) {
                LOGGER.trace("", ex1);
            }
            throw new InitializationException("Unexpected Exception", ex);
        }
    }

    protected void closeAnalyzer(@NotNull Analyzer analyzer) {
        LOGGER.debug("Closing Analyzer '{}'", (Object)analyzer.getName());
        try {
            analyzer.close();
        }
        catch (Throwable ex) {
            LOGGER.trace("", ex);
        }
    }

    public void doUpdates() throws UpdateException, DatabaseException {
        this.doUpdates(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doUpdates(boolean remainOpen) throws UpdateException, DatabaseException {
        if (this.mode.isDatabaseRequired()) {
            H2DBLock dblock = null;
            try {
                if (ConnectionFactory.isH2Connection(this.settings)) {
                    dblock = new H2DBLock(this.settings);
                    LOGGER.debug("locking for update");
                    dblock.lock();
                }
                this.openDatabase(false, false);
                LOGGER.info("Checking for updates");
                long updateStart = System.currentTimeMillis();
                UpdateService service = new UpdateService(this.serviceClassLoader);
                Iterator<CachedWebDataSource> iterator = service.getDataSources();
                boolean dbUpdatesMade = false;
                UpdateException updateException = null;
                while (iterator.hasNext()) {
                    try {
                        CachedWebDataSource source = iterator.next();
                        dbUpdatesMade |= source.update(this);
                    }
                    catch (UpdateException ex) {
                        updateException = ex;
                        LOGGER.error(ex.getMessage());
                    }
                }
                if (dbUpdatesMade) {
                    this.database.defrag();
                }
                this.database.close();
                this.database = null;
                if (updateException != null) {
                    throw updateException;
                }
                LOGGER.info("Check for updates complete ({} ms)", (Object)(System.currentTimeMillis() - updateStart));
                if (!remainOpen) return;
                this.openDatabase(true, false);
                return;
            }
            catch (H2DBLockException ex) {
                throw new UpdateException("Unable to obtain an exclusive lock on the H2 database to perform updates", ex);
            }
            finally {
                if (dblock != null) {
                    dblock.release();
                }
            }
        } else {
            LOGGER.info("Skipping update check in evidence collection mode.");
        }
    }

    public boolean purge() {
        File cache;
        boolean result = true;
        UpdateService service = new UpdateService(this.serviceClassLoader);
        Iterator<CachedWebDataSource> iterator = service.getDataSources();
        while (iterator.hasNext()) {
            result &= iterator.next().purge(this);
        }
        try {
            cache = new File(this.settings.getDataDirectory(), "cache");
            if (cache.exists() && FileUtils.deleteQuietly((File)cache)) {
                LOGGER.info("Cache directory purged");
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        try {
            cache = new File(this.settings.getDataDirectory(), "oss_cache");
            if (cache.exists() && FileUtils.deleteQuietly((File)cache)) {
                LOGGER.info("OSS Cache directory purged");
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return result;
    }

    public void openDatabase() throws DatabaseException {
        this.openDatabase(false, true);
    }

    public void openDatabase(boolean readOnly, boolean lockRequired) throws DatabaseException {
        if (this.mode.isDatabaseRequired() && this.database == null) {
            this.database = new CveDB(this.settings);
            if (readOnly && ConnectionFactory.isH2Connection(this.settings) && this.settings.getString("data.connection_string").contains("file:%s")) {
                H2DBLock lock = null;
                try {
                    File db = ConnectionFactory.getH2DataFile(this.settings);
                    if (db.isFile()) {
                        this.database.close();
                        if (lockRequired) {
                            lock = new H2DBLock(this.settings);
                            lock.lock();
                        }
                        LOGGER.debug("copying database");
                        File temp = this.settings.getTempDirectory();
                        File tempDB = new File(temp, db.getName());
                        Files.copy(db.toPath(), tempDB.toPath(), new CopyOption[0]);
                        LOGGER.debug("copying complete '{}'", (Object)temp.toPath());
                        this.settings.setString("data.h2.directory", temp.getPath());
                        String connStr = this.settings.getString("data.connection_string");
                        if (!connStr.contains("ACCESS_MODE_DATA")) {
                            this.settings.setString("data.connection_string", connStr + "ACCESS_MODE_DATA=r");
                        }
                        this.database = new CveDB(this.settings);
                    }
                }
                catch (IOException ex) {
                    throw new DatabaseException("Unable to open db in read only mode", ex);
                }
                catch (H2DBLockException ex) {
                    throw new DatabaseException("Failed to obtain lock - unable to open db in read only mode", ex);
                }
                finally {
                    if (lock != null) {
                        lock.release();
                    }
                }
            }
        }
    }

    public CveDB getDatabase() {
        return this.database;
    }

    @NotNull
    public List<Analyzer> getAnalyzers() {
        ArrayList<Analyzer> ret = new ArrayList<Analyzer>();
        this.mode.getPhases().stream().map(phase -> this.analyzers.get(phase)).forEachOrdered(analyzerList -> ret.addAll((Collection<Analyzer>)analyzerList));
        return ret;
    }

    @Override
    public boolean accept(@Nullable File file) {
        if (file == null) {
            return false;
        }
        return this.fileTypeAnalyzers.stream().map(a -> a.accept(file)).reduce(false, (accumulator, result) -> accumulator != false || result != false);
    }

    public Set<FileTypeAnalyzer> getFileTypeAnalyzers() {
        return this.fileTypeAnalyzers;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public Mode getMode() {
        return this.mode;
    }

    protected void addFileTypeAnalyzer(@NotNull FileTypeAnalyzer fta) {
        this.fileTypeAnalyzers.add(fta);
    }

    private void ensureDataExists() throws NoDataException {
        if (this.mode.isDatabaseRequired() && (this.database == null || !this.database.dataExists())) {
            throw new NoDataException("No documents exist");
        }
    }

    private void throwFatalExceptionCollection(String message, @NotNull Throwable throwable, @NotNull List<Throwable> exceptions) throws ExceptionCollection {
        LOGGER.error(message);
        LOGGER.debug("", throwable);
        exceptions.add(throwable);
        throw new ExceptionCollection(exceptions, true);
    }

    public synchronized void writeReports(String applicationName, @Nullable String groupId, @Nullable String artifactId, @Nullable String version, @NotNull File outputDir, String format) throws ReportException {
        if (this.mode == Mode.EVIDENCE_COLLECTION) {
            throw new UnsupportedOperationException("Cannot generate report in evidence collection mode.");
        }
        DatabaseProperties prop = this.database.getDatabaseProperties();
        ReportGenerator r = new ReportGenerator(applicationName, groupId, artifactId, version, this.dependencies, this.getAnalyzers(), prop, this.settings);
        try {
            r.write(outputDir.getAbsolutePath(), format);
        }
        catch (ReportException ex) {
            String msg = String.format("Error generating the report for %s", applicationName);
            throw new ReportException(msg, ex);
        }
    }

    public void writeReports(String applicationName, File outputDir, String format) throws ReportException {
        this.writeReports(applicationName, null, null, null, outputDir, format);
    }

    public static enum Mode {
        EVIDENCE_COLLECTION(false, AnalysisPhase.INITIAL, AnalysisPhase.PRE_INFORMATION_COLLECTION, AnalysisPhase.INFORMATION_COLLECTION, AnalysisPhase.POST_INFORMATION_COLLECTION),
        EVIDENCE_PROCESSING(true, AnalysisPhase.PRE_IDENTIFIER_ANALYSIS, AnalysisPhase.IDENTIFIER_ANALYSIS, AnalysisPhase.POST_IDENTIFIER_ANALYSIS, AnalysisPhase.PRE_FINDING_ANALYSIS, AnalysisPhase.FINDING_ANALYSIS, AnalysisPhase.POST_FINDING_ANALYSIS, AnalysisPhase.FINAL),
        STANDALONE(true, AnalysisPhase.values());

        private final boolean databaseRequired;
        private final ImmutableList<AnalysisPhase> phases;

        private boolean isDatabaseRequired() {
            return this.databaseRequired;
        }

        public ImmutableList<AnalysisPhase> getPhases() {
            return this.phases;
        }

        private Mode(boolean databaseRequired, AnalysisPhase ... phases) {
            this.databaseRequired = databaseRequired;
            this.phases = new ImmutableList.Builder().add((Object[])phases).build();
        }
    }
}

