/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Experimental;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.Checksum;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class CMakeAnalyzer
extends AbstractFileTypeAnalyzer {
    public static final String DEPENDENCY_ECOSYSTEM = "CMAKE";
    private static final Logger LOGGER = LoggerFactory.getLogger(CMakeAnalyzer.class);
    private static final int REGEX_OPTIONS = 42;
    private static final Pattern PROJECT_VERSION = Pattern.compile("^\\s*set\\s*\\(\\s*VERSION\\s*\"([^\"]*)\"\\)", 42);
    private static final Pattern PROJECT = Pattern.compile("^ *project *\\([ \\n]*(\\w+)[ \\n]*.*?\\)", 42);
    private static final Pattern SET_VERSION = Pattern.compile("^ *set\\s*\\(\\s*(\\w+)_version\\s+\"?(\\d+(?:\\.\\d+)+)[\\s\"]?\\)", 42);
    private static final FileFilter FILTER = FileFilterBuilder.newInstance().addExtensions(".cmake").addFilenames("CMakeLists.txt").build();

    @Override
    public String getName() {
        return "CMake Analyzer";
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return AnalysisPhase.INFORMATION_COLLECTION;
    }

    @Override
    protected FileFilter getFileFilter() {
        return FILTER;
    }

    @Override
    protected void prepareFileTypeAnalyzer(Engine engine) throws InitializationException {
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        String contents;
        dependency.setEcosystem(DEPENDENCY_ECOSYSTEM);
        File file = dependency.getActualFile();
        String name = file.getName();
        try {
            contents = FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset()).trim();
        }
        catch (IOException e) {
            throw new AnalysisException("Problem occurred while reading dependency file.", e);
        }
        if (StringUtils.isNotBlank((CharSequence)contents)) {
            Matcher m = PROJECT.matcher(contents);
            int count = 0;
            while (m.find()) {
                ++count;
                LOGGER.debug(String.format("Found project command match with %d groups: %s", m.groupCount(), m.group(0)));
                String group = m.group(1);
                LOGGER.debug("Group 1: {}", (Object)group);
                dependency.addEvidence(EvidenceType.PRODUCT, name, "Project", group, Confidence.HIGH);
                dependency.addEvidence(EvidenceType.VENDOR, name, "Project", group, Confidence.HIGH);
                dependency.setName(group);
            }
            if (count > 0) {
                dependency.addEvidence(EvidenceType.VENDOR, "CmakeAnalyzer", "hint", "gnu", Confidence.MEDIUM);
            }
            LOGGER.debug("Found {} matches.", (Object)count);
            Matcher mVersion = PROJECT_VERSION.matcher(contents);
            count = 0;
            while (mVersion.find()) {
                ++count;
                LOGGER.debug(String.format("Found set version command match with %d groups: %s", mVersion.groupCount(), mVersion.group(0)));
                String group = mVersion.group(1);
                LOGGER.debug("Group 1: {}", (Object)group);
                dependency.addEvidence(EvidenceType.VERSION, name, "VERSION", group, Confidence.HIGH);
                dependency.setVersion(group);
            }
            this.analyzeSetVersionCommand(dependency, engine, contents);
        }
    }

    private void analyzeSetVersionCommand(Dependency dependency, Engine engine, String contents) {
        Dependency currentDep = dependency;
        Matcher m = SET_VERSION.matcher(contents);
        int count = 0;
        while (m.find()) {
            ++count;
            LOGGER.debug("Found project command match with {} groups: {}", (Object)m.groupCount(), (Object)m.group(0));
            String product = m.group(1);
            String version = m.group(2);
            LOGGER.debug("Group 1: {}", (Object)product);
            LOGGER.debug("Group 2: {}", (Object)version);
            String aliasPrefix = "ALIASOF_";
            if (product.startsWith("ALIASOF_")) {
                product = product.replaceFirst("ALIASOF_", "");
            }
            if (count > 1) {
                currentDep = new Dependency(dependency.getActualFile());
                currentDep.setEcosystem(DEPENDENCY_ECOSYSTEM);
                String filePath = String.format("%s:%s", dependency.getFilePath(), product);
                currentDep.setFilePath(filePath);
                currentDep.setSha1sum(Checksum.getSHA1Checksum((String)filePath));
                currentDep.setSha256sum(Checksum.getSHA256Checksum((String)filePath));
                currentDep.setMd5sum(Checksum.getMD5Checksum((String)filePath));
                engine.addDependency(currentDep);
            }
            String source = currentDep.getFileName();
            currentDep.addEvidence(EvidenceType.PRODUCT, source, "Product", product, Confidence.MEDIUM);
            currentDep.addEvidence(EvidenceType.VENDOR, source, "Vendor", product, Confidence.MEDIUM);
            currentDep.addEvidence(EvidenceType.VERSION, source, "Version", version, Confidence.MEDIUM);
            if (StringUtils.isEmpty((CharSequence)currentDep.getName())) {
                currentDep.setName(product);
            }
            if (!StringUtils.isEmpty((CharSequence)currentDep.getVersion())) continue;
            currentDep.setVersion(version);
        }
        LOGGER.debug("Found {} matches.", (Object)count);
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.cmake.enabled";
    }
}

