/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.analyzer.exception.LambdaExceptionWrapper;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.dependency.naming.CpeIdentifier;

@ThreadSafe
public class NvdCveAnalyzer
extends AbstractAnalyzer {
    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        CveDB cveDB = engine.getDatabase();
        try {
            dependency.getVulnerableSoftwareIdentifiers().stream().filter(i -> i instanceof CpeIdentifier).map(i -> (CpeIdentifier)i).forEach(i -> {
                try {
                    List<Vulnerability> vulns = cveDB.getVulnerabilities(i.getCpe());
                    dependency.addVulnerabilities(vulns);
                }
                catch (DatabaseException ex) {
                    throw new LambdaExceptionWrapper(new AnalysisException(ex));
                }
            });
            dependency.getSuppressedIdentifiers().stream().filter(i -> i instanceof CpeIdentifier).map(i -> (CpeIdentifier)i).forEach(i -> {
                try {
                    List<Vulnerability> vulns = cveDB.getVulnerabilities(i.getCpe());
                    dependency.addSuppressedVulnerabilities(vulns);
                }
                catch (DatabaseException ex) {
                    throw new LambdaExceptionWrapper(new AnalysisException(ex));
                }
            });
        }
        catch (LambdaExceptionWrapper ex) {
            throw (AnalysisException)ex.getCause();
        }
    }

    @Override
    public String getName() {
        return "NVD CVE Analyzer";
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return AnalysisPhase.FINDING_ANALYSIS;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.nvdcve.enabled";
    }
}

