/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.xml.hints;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.owasp.dependencycheck.utils.FileUtils;
import org.owasp.dependencycheck.utils.XmlUtils;
import org.owasp.dependencycheck.xml.hints.HintErrorHandler;
import org.owasp.dependencycheck.xml.hints.HintHandler;
import org.owasp.dependencycheck.xml.hints.HintParseException;
import org.owasp.dependencycheck.xml.hints.HintRule;
import org.owasp.dependencycheck.xml.hints.VendorDuplicatingHintRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

@NotThreadSafe
public class HintParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(HintParser.class);
    public static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String HINT_SCHEMA_1_2 = "schema/dependency-hint.1.2.xsd";
    private static final String HINT_SCHEMA_1_1 = "schema/dependency-hint.1.1.xsd";
    private static final String HINT_SCHEMA_1_3 = "schema/dependency-hint.1.3.xsd";
    private List<HintRule> hintRules;
    private List<VendorDuplicatingHintRule> vendorDuplicatingHintRules;

    public List<HintRule> getHintRules() {
        return this.hintRules;
    }

    public List<VendorDuplicatingHintRule> getVendorDuplicatingHintRules() {
        return this.vendorDuplicatingHintRules;
    }

    @SuppressFBWarnings(justification="try with resources will clean up the input stream", value={"OBL_UNSATISFIED_OBLIGATION"})
    public void parseHints(File file) throws HintParseException {
        try (FileInputStream fis = new FileInputStream(file);){
            this.parseHints(fis);
        }
        catch (IOException | SAXException ex) {
            LOGGER.debug("", (Throwable)ex);
            throw new HintParseException(ex);
        }
    }

    public void parseHints(InputStream inputStream) throws HintParseException, SAXException {
        try (InputStream schemaStream13 = FileUtils.getResourceAsStream((String)HINT_SCHEMA_1_3);
             InputStream schemaStream12 = FileUtils.getResourceAsStream((String)HINT_SCHEMA_1_2);
             InputStream schemaStream11 = FileUtils.getResourceAsStream((String)HINT_SCHEMA_1_1);){
            HintHandler handler = new HintHandler();
            SAXParser saxParser = XmlUtils.buildSecureSaxParser((InputStream[])new InputStream[]{schemaStream13, schemaStream12, schemaStream11});
            XMLReader xmlReader = saxParser.getXMLReader();
            xmlReader.setErrorHandler(new HintErrorHandler());
            xmlReader.setContentHandler(handler);
            try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
                InputSource in = new InputSource(reader);
                xmlReader.parse(in);
                this.hintRules = handler.getHintRules();
                this.vendorDuplicatingHintRules = handler.getVendorDuplicatingHintRules();
            }
        }
        catch (FileNotFoundException | ParserConfigurationException ex) {
            LOGGER.debug("", (Throwable)ex);
            throw new HintParseException(ex);
        }
        catch (SAXException ex) {
            if (ex.getMessage().contains("Cannot find the declaration of element 'hints'.")) {
                throw ex;
            }
            LOGGER.debug("", (Throwable)ex);
            throw new HintParseException(ex);
        }
        catch (IOException ex) {
            LOGGER.debug("", (Throwable)ex);
            throw new HintParseException(ex);
        }
    }
}

