/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.xml.suppression;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.dependency.naming.CpeIdentifier;
import org.owasp.dependencycheck.dependency.naming.Identifier;
import org.owasp.dependencycheck.dependency.naming.PurlIdentifier;
import org.owasp.dependencycheck.xml.suppression.PropertyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.springett.parsers.cpe.Cpe;
import us.springett.parsers.cpe.exceptions.CpeEncodingException;

@NotThreadSafe
public class SuppressionRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(SuppressionRule.class);
    private PropertyType filePath;
    private String sha1;
    private List<PropertyType> cpe = new ArrayList<PropertyType>();
    private List<Float> cvssBelow = new ArrayList<Float>();
    private List<String> cwe = new ArrayList<String>();
    private List<String> cve = new ArrayList<String>();
    private PropertyType gav = null;
    private String notes;
    private boolean base;
    private Calendar until;

    public Calendar getUntil() {
        return this.until;
    }

    public void setUntil(Calendar until) {
        this.until = until;
    }

    public PropertyType getFilePath() {
        return this.filePath;
    }

    public void setFilePath(PropertyType filePath) {
        this.filePath = filePath;
    }

    public String getSha1() {
        return this.sha1;
    }

    public void setSha1(String sha1) {
        this.sha1 = sha1;
    }

    public List<PropertyType> getCpe() {
        return this.cpe;
    }

    public void setCpe(List<PropertyType> cpe) {
        this.cpe = cpe;
    }

    public void addCpe(PropertyType cpe) {
        this.cpe.add(cpe);
    }

    public boolean hasCpe() {
        return !this.cpe.isEmpty();
    }

    public List<Float> getCvssBelow() {
        return this.cvssBelow;
    }

    public void setCvssBelow(List<Float> cvssBelow) {
        this.cvssBelow = cvssBelow;
    }

    public void addCvssBelow(Float cvss) {
        this.cvssBelow.add(cvss);
    }

    public boolean hasCvssBelow() {
        return !this.cvssBelow.isEmpty();
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public void addNotes(String notes) {
        this.notes = notes;
    }

    public boolean hasNotes() {
        return !this.cve.isEmpty();
    }

    public List<String> getCwe() {
        return this.cwe;
    }

    public void setCwe(List<String> cwe) {
        this.cwe = cwe;
    }

    public void addCwe(String cwe) {
        this.cwe.add(cwe);
    }

    public boolean hasCwe() {
        return !this.cwe.isEmpty();
    }

    public List<String> getCve() {
        return this.cve;
    }

    public void setCve(List<String> cve) {
        this.cve = cve;
    }

    public void addCve(String cve) {
        this.cve.add(cve);
    }

    public boolean hasCve() {
        return !this.cve.isEmpty();
    }

    public PropertyType getGav() {
        return this.gav;
    }

    public void setGav(PropertyType gav) {
        this.gav = gav;
    }

    public boolean hasGav() {
        return this.gav != null;
    }

    public boolean isBase() {
        return this.base;
    }

    public void setBase(boolean base) {
        this.base = base;
    }

    public void process(Dependency dependency) {
        if (this.filePath != null && !this.filePath.matches(dependency.getFilePath())) {
            return;
        }
        if (this.sha1 != null && !this.sha1.equalsIgnoreCase(dependency.getSha1sum())) {
            return;
        }
        if (this.gav != null) {
            Iterator<Identifier> itr = dependency.getSoftwareIdentifiers().iterator();
            boolean gavFound = false;
            while (itr.hasNext()) {
                Identifier i2 = itr.next();
                if (!this.identifierMatches(this.gav, i2)) continue;
                gavFound = true;
                break;
            }
            if (!gavFound) {
                return;
            }
        }
        if (this.hasCpe()) {
            HashSet<Identifier> removalList = new HashSet<Identifier>();
            block1: for (Identifier i2 : dependency.getVulnerableSoftwareIdentifiers()) {
                for (PropertyType c : this.cpe) {
                    if (!this.identifierMatches(c, i2)) continue;
                    if (!this.isBase()) {
                        if (this.notes != null) {
                            i2.setNotes(this.notes);
                        }
                        dependency.addSuppressedIdentifier(i2);
                    }
                    removalList.add(i2);
                    continue block1;
                }
            }
            removalList.forEach(i -> dependency.removeVulnerableSoftwareIdentifier((Identifier)i));
        }
        if (this.hasCve() || this.hasCwe() || this.hasCvssBelow()) {
            HashSet<Vulnerability> removeVulns = new HashSet<Vulnerability>();
            for (Vulnerability v : dependency.getVulnerabilities()) {
                boolean remove = false;
                for (String entry : this.cve) {
                    if (!entry.equalsIgnoreCase(v.getName())) continue;
                    removeVulns.add(v);
                    remove = true;
                    break;
                }
                if (!remove) {
                    for (String entry : this.cwe) {
                        if (v.getCwes() == null) continue;
                        String toMatch = String.format("CWE-%s", entry);
                        if (!v.getCwes().stream().anyMatch(toTest -> toMatch.regionMatches(0, (String)toTest, 0, toMatch.length()))) continue;
                        remove = true;
                        removeVulns.add(v);
                        break;
                    }
                }
                if (!remove) {
                    Iterator<Object> iterator = this.cvssBelow.iterator();
                    while (iterator.hasNext()) {
                        float cvss = ((Float)iterator.next()).floatValue();
                        if (v.getCvssV2() != null && v.getCvssV2().getScore() < cvss) {
                            remove = true;
                            removeVulns.add(v);
                            break;
                        }
                        if (v.getCvssV3() == null || !(v.getCvssV3().getBaseScore() < cvss)) continue;
                        remove = true;
                        removeVulns.add(v);
                        break;
                    }
                }
                if (!remove || this.isBase()) continue;
                if (this.notes != null) {
                    v.setNotes(this.notes);
                }
                dependency.addSuppressedVulnerability(v);
            }
            for (Vulnerability v : removeVulns) {
                dependency.removeVulnerability(v);
            }
        }
    }

    protected boolean cpeHasNoVersion(PropertyType c) {
        return !c.isRegex() && this.countCharacter(c.getValue(), ':') <= 3;
    }

    private int countCharacter(String str, char c) {
        int count = 0;
        int pos = str.indexOf(c) + 1;
        while (pos > 0) {
            ++count;
            pos = str.indexOf(c, pos) + 1;
        }
        return count;
    }

    protected boolean identifierMatches(PropertyType suppressionEntry, Identifier identifier) {
        block10: {
            if (identifier instanceof PurlIdentifier) {
                PurlIdentifier purl = (PurlIdentifier)identifier;
                return suppressionEntry.matches(purl.toGav());
            }
            if (identifier instanceof CpeIdentifier) {
                String id;
                Cpe cpeId = ((CpeIdentifier)identifier).getCpe();
                if (suppressionEntry.isRegex()) {
                    try {
                        return suppressionEntry.matches(cpeId.toCpe22Uri());
                    }
                    catch (CpeEncodingException ex) {
                        LOGGER.debug("Unable to convert CPE to 22 URI?" + cpeId.toString());
                        break block10;
                    }
                }
                if (suppressionEntry.isCaseSensitive()) {
                    try {
                        return cpeId.toCpe22Uri().startsWith(suppressionEntry.getValue());
                    }
                    catch (CpeEncodingException ex) {
                        LOGGER.debug("Unable to convert CPE to 22 URI?" + cpeId.toString());
                        break block10;
                    }
                }
                try {
                    id = cpeId.toCpe22Uri().toLowerCase();
                }
                catch (CpeEncodingException ex) {
                    LOGGER.debug("Unable to convert CPE to 22 URI?" + cpeId.toString());
                    return false;
                }
                String check = suppressionEntry.getValue().toLowerCase();
                return id.startsWith(check);
            }
        }
        return suppressionEntry.matches(identifier.getValue());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("SuppressionRule{");
        if (this.until != null) {
            sb.append("until=").append(this.until).append(',');
        }
        if (this.filePath != null) {
            sb.append("filePath=").append(this.filePath).append(',');
        }
        if (this.sha1 != null) {
            sb.append("sha1=").append(this.sha1).append(',');
        }
        if (this.gav != null) {
            sb.append("gav=").append(this.gav).append(',');
        }
        if (this.cpe != null && !this.cpe.isEmpty()) {
            sb.append("cpe={");
            for (PropertyType propertyType : this.cpe) {
                sb.append(propertyType).append(',');
            }
            sb.append('}');
        }
        if (this.cwe != null && !this.cwe.isEmpty()) {
            sb.append("cwe={");
            for (String string : this.cwe) {
                sb.append(string).append(',');
            }
            sb.append('}');
        }
        if (this.cve != null && !this.cve.isEmpty()) {
            sb.append("cve={");
            for (String string : this.cve) {
                sb.append(string).append(',');
            }
            sb.append('}');
        }
        if (this.cvssBelow != null && !this.cvssBelow.isEmpty()) {
            sb.append("cvssBelow={");
            for (Float f : this.cvssBelow) {
                sb.append(f).append(',');
            }
            sb.append('}');
        }
        sb.append('}');
        return sb.toString();
    }
}

