/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.dependency;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.owasp.dependencycheck.analyzer.exception.UnexpectedAnalysisException;
import org.owasp.dependencycheck.data.nexus.MavenArtifact;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.EvidenceCollection;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.dependency.naming.CpeIdentifier;
import org.owasp.dependencycheck.dependency.naming.Identifier;
import org.owasp.dependencycheck.dependency.naming.PurlIdentifier;
import org.owasp.dependencycheck.utils.Checksum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class Dependency
extends EvidenceCollection
implements Serializable {
    private static final long serialVersionUID = 7388854637023297752L;
    private static final Logger LOGGER = LoggerFactory.getLogger(Dependency.class);
    private static final HashingFunction MD5_HASHING_FUNCTION = file -> Checksum.getMD5Checksum((File)file);
    private static final HashingFunction SHA1_HASHING_FUNCTION = file -> Checksum.getSHA1Checksum((File)file);
    private static final HashingFunction SHA256_HASHING_FUNCTION = file -> Checksum.getSHA256Checksum((File)file);
    private final Set<Identifier> softwareIdentifiers = new TreeSet<Identifier>();
    private final Set<Identifier> vulnerabileSoftwareIdentifiers = new TreeSet<Identifier>();
    private final Set<Identifier> suppressedIdentifiers = new TreeSet<Identifier>();
    private final Set<Vulnerability> suppressedVulnerabilities = new HashSet<Vulnerability>();
    private final Set<Vulnerability> vulnerabilities = new HashSet<Vulnerability>();
    private final Set<Dependency> relatedDependencies = new HashSet<Dependency>();
    private final Set<String> projectReferences = new HashSet<String>();
    private final List<String> availableVersions = new ArrayList<String>();
    private String actualFilePath;
    private String filePath;
    private String fileName;
    private String packagePath;
    private String md5sum;
    private String sha1sum;
    private String sha256sum;
    private String displayName = null;
    private String description;
    private String license;
    private boolean isVirtual = false;
    private String name;
    private String version;
    private String ecosystem;

    public Dependency() {
    }

    public Dependency(File file) {
        this(file, false);
    }

    public Dependency(File file, boolean isVirtual) {
        this();
        this.isVirtual = isVirtual;
        this.filePath = this.actualFilePath = file.getAbsolutePath();
        this.fileName = file.getName();
        this.packagePath = this.filePath;
        if (!isVirtual && file.isFile()) {
            this.calculateChecksums(file);
        }
    }

    private void calculateChecksums(File file) {
        try {
            this.md5sum = Checksum.getMD5Checksum((File)file);
            this.sha1sum = Checksum.getSHA1Checksum((File)file);
            this.sha256sum = Checksum.getSHA256Checksum((File)file);
        }
        catch (IOException | NoSuchAlgorithmException ex) {
            LOGGER.debug(String.format("Unable to calculate checksums on %s", file), (Throwable)ex);
        }
    }

    public Dependency(boolean isVirtual) {
        this();
        this.isVirtual = isVirtual;
    }

    public String getPackagePath() {
        return this.packagePath;
    }

    public void setPackagePath(String packagePath) {
        this.packagePath = packagePath;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getActualFilePath() {
        return this.actualFilePath;
    }

    public void setActualFilePath(String actualFilePath) {
        this.actualFilePath = actualFilePath;
        this.sha1sum = null;
        this.sha256sum = null;
        this.md5sum = null;
        File file = this.getActualFile();
        if (file.isFile()) {
            this.calculateChecksums(this.getActualFile());
        }
    }

    public File getActualFile() {
        return new File(this.actualFilePath);
    }

    public String getDisplayFileName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        if (!this.isVirtual) {
            return this.fileName;
        }
        if (this.name == null) {
            return this.fileName;
        }
        if (this.version == null) {
            return this.name;
        }
        return this.name + ":" + this.version;
    }

    public void setDisplayFileName(String displayName) {
        this.displayName = displayName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getMd5sum() {
        if (this.md5sum == null) {
            this.md5sum = this.determineHashes(MD5_HASHING_FUNCTION);
        }
        return this.md5sum;
    }

    public void setMd5sum(String md5sum) {
        this.md5sum = md5sum;
    }

    public String getSha1sum() {
        if (this.sha1sum == null) {
            this.sha1sum = this.determineHashes(SHA1_HASHING_FUNCTION);
        }
        return this.sha1sum;
    }

    public void setSha1sum(String sha1sum) {
        this.sha1sum = sha1sum;
    }

    public String getSha256sum() {
        if (this.sha256sum == null) {
            this.sha256sum = this.determineHashes(SHA256_HASHING_FUNCTION);
        }
        return this.sha256sum;
    }

    public void setSha256sum(String sha256sum) {
        this.sha256sum = sha256sum;
    }

    public synchronized Set<Identifier> getSoftwareIdentifiers() {
        return Collections.unmodifiableSet(new TreeSet<Identifier>(this.softwareIdentifiers));
    }

    public synchronized Set<Identifier> getVulnerableSoftwareIdentifiers() {
        return Collections.unmodifiableSet(new TreeSet<Identifier>(this.vulnerabileSoftwareIdentifiers));
    }

    protected synchronized void addSoftwareIdentifiers(Set<Identifier> identifiers) {
        this.softwareIdentifiers.addAll(identifiers);
    }

    protected synchronized void addVulnerableSoftwareIdentifiers(Set<Identifier> identifiers) {
        this.vulnerabileSoftwareIdentifiers.addAll(identifiers);
    }

    public synchronized void addSoftwareIdentifier(Identifier identifier) {
        assert (!(identifier instanceof CpeIdentifier)) : "vulnerability identifier cannot be added to software identifiers";
        Optional<Identifier> found = this.softwareIdentifiers.stream().filter(id -> id.getValue().equals(identifier.getValue())).findFirst();
        if (found.isPresent()) {
            Identifier existing = found.get();
            if (existing.getConfidence().compareTo(identifier.getConfidence()) < 0) {
                existing.setConfidence(identifier.getConfidence());
            }
            if (existing.getNotes() != null && identifier.getNotes() != null) {
                existing.setNotes(existing.getNotes() + " " + identifier.getNotes());
            } else if (identifier.getNotes() != null) {
                existing.setNotes(identifier.getNotes());
            }
            if (existing.getUrl() == null && identifier.getUrl() != null) {
                existing.setUrl(identifier.getUrl());
            }
        } else {
            this.softwareIdentifiers.add(identifier);
        }
    }

    public synchronized void addVulnerableSoftwareIdentifier(Identifier identifier) {
        this.vulnerabileSoftwareIdentifiers.add(identifier);
    }

    public synchronized void removeVulnerableSoftwareIdentifier(Identifier i) {
        this.vulnerabileSoftwareIdentifiers.remove(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAsEvidence(String source, MavenArtifact mavenArtifact, Confidence confidence) {
        if (mavenArtifact.getGroupId() != null && !mavenArtifact.getGroupId().isEmpty()) {
            this.addEvidence(EvidenceType.VENDOR, source, "groupid", mavenArtifact.getGroupId(), confidence);
        }
        if (mavenArtifact.getArtifactId() != null && !mavenArtifact.getArtifactId().isEmpty()) {
            this.addEvidence(EvidenceType.PRODUCT, source, "artifactid", mavenArtifact.getArtifactId(), confidence);
        }
        if (mavenArtifact.getVersion() != null && !mavenArtifact.getVersion().isEmpty()) {
            this.addEvidence(EvidenceType.VERSION, source, "version", mavenArtifact.getVersion(), confidence);
        }
        boolean found = false;
        if (mavenArtifact.getArtifactUrl() != null && !mavenArtifact.getArtifactUrl().isEmpty()) {
            Dependency dependency = this;
            synchronized (dependency) {
                for (Identifier i : this.softwareIdentifiers) {
                    if (!(i instanceof PurlIdentifier)) continue;
                    PurlIdentifier id = (PurlIdentifier)i;
                    if (!mavenArtifact.getArtifactId().equals(id.getName()) || !mavenArtifact.getGroupId().equals(id.getNamespace())) continue;
                    found = true;
                    i.setConfidence(Confidence.HIGHEST);
                    String url = "http://search.maven.org/#search|ga|1|1%3A%22" + this.getSha1sum() + "%22";
                    i.setUrl(url);
                    LOGGER.debug("Already found identifier {}. Confidence set to highest", (Object)i.getValue());
                    break;
                }
            }
        }
        if (!(found || Strings.isNullOrEmpty((String)mavenArtifact.getGroupId()) || Strings.isNullOrEmpty((String)mavenArtifact.getArtifactId()) || Strings.isNullOrEmpty((String)mavenArtifact.getVersion()))) {
            try {
                LOGGER.debug("Adding new maven identifier {}", (Object)mavenArtifact);
                PackageURL p = new PackageURL("maven", mavenArtifact.getGroupId(), mavenArtifact.getArtifactId(), mavenArtifact.getVersion(), null, null);
                PurlIdentifier id = new PurlIdentifier(p, Confidence.HIGHEST);
                this.addSoftwareIdentifier(id);
            }
            catch (MalformedPackageURLException ex) {
                throw new UnexpectedAnalysisException(ex);
            }
        }
    }

    public synchronized Set<Identifier> getSuppressedIdentifiers() {
        return Collections.unmodifiableSet(new TreeSet<Identifier>(this.suppressedIdentifiers));
    }

    public synchronized void addSuppressedIdentifier(Identifier identifier) {
        this.suppressedIdentifiers.add(identifier);
    }

    public synchronized Set<Vulnerability> getVulnerabilities() {
        return this.getVulnerabilities(false);
    }

    public synchronized Set<Vulnerability> getVulnerabilities(boolean sorted) {
        Set<Vulnerability> vulnerabilitySet = sorted ? new TreeSet<Vulnerability>(this.vulnerabilities) : this.vulnerabilities;
        return Collections.unmodifiableSet(vulnerabilitySet);
    }

    public synchronized Set<Vulnerability> getSuppressedVulnerabilities() {
        return this.getSuppressedVulnerabilities(false);
    }

    public synchronized Set<Vulnerability> getSuppressedVulnerabilities(boolean sorted) {
        Set<Vulnerability> vulnerabilitySet = sorted ? new TreeSet<Vulnerability>(this.suppressedVulnerabilities) : this.suppressedVulnerabilities;
        return Collections.unmodifiableSet(vulnerabilitySet);
    }

    public synchronized void addSuppressedVulnerability(Vulnerability vulnerability) {
        this.suppressedVulnerabilities.add(vulnerability);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private String determineHashes(HashingFunction hashFunction) {
        if (this.isVirtual) {
            return null;
        }
        try {
            File file = this.getActualFile();
            return hashFunction.hash(file);
        }
        catch (IOException | RuntimeException ex) {
            LOGGER.warn("Unable to read '{}' to determine hashes.", (Object)this.actualFilePath);
            LOGGER.debug("", (Throwable)ex);
        }
        catch (NoSuchAlgorithmException ex) {
            LOGGER.warn("Unable to use MD5 or SHA1 checksums.");
            LOGGER.debug("", (Throwable)ex);
        }
        return null;
    }

    public synchronized void addVulnerability(Vulnerability vulnerability) {
        this.vulnerabilities.add(vulnerability);
    }

    public synchronized void addVulnerabilities(List<Vulnerability> vulnerabilities) {
        this.vulnerabilities.addAll(vulnerabilities);
    }

    public synchronized void removeVulnerability(Vulnerability v) {
        this.vulnerabilities.remove(v);
    }

    public synchronized Set<Dependency> getRelatedDependencies() {
        return Collections.unmodifiableSet(new HashSet<Dependency>(this.relatedDependencies));
    }

    public synchronized Set<String> getProjectReferences() {
        return Collections.unmodifiableSet(new HashSet<String>(this.projectReferences));
    }

    public synchronized void addProjectReference(String projectReference) {
        this.projectReferences.add(projectReference);
    }

    public synchronized void addAllProjectReferences(Set<String> projectReferences) {
        this.projectReferences.addAll(projectReferences);
    }

    public synchronized void addRelatedDependency(Dependency dependency) {
        if (this == dependency) {
            LOGGER.warn("Attempted to add a circular reference - please post the log file to issue #172 here https://github.com/jeremylong/DependencyCheck/issues/172");
            LOGGER.debug("this: {}", (Object)this);
            LOGGER.debug("dependency: {}", (Object)dependency);
        } else if (!this.relatedDependencies.add(dependency)) {
            LOGGER.debug("Failed to add dependency, likely due to referencing the same file as another dependency in the set.");
            LOGGER.debug("this: {}", (Object)this);
            LOGGER.debug("dependency: {}", (Object)dependency);
        }
    }

    public synchronized void removeRelatedDependencies(Dependency dependency) {
        this.relatedDependencies.remove(dependency);
    }

    public synchronized List<String> getAvailableVersions() {
        return Collections.unmodifiableList(new ArrayList<String>(this.availableVersions));
    }

    public synchronized void addAvailableVersion(String version) {
        this.availableVersions.add(version);
    }

    public boolean isVirtual() {
        return this.isVirtual;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Dependency)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Dependency other = (Dependency)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.actualFilePath, (Object)other.actualFilePath).append((Object)this.filePath, (Object)other.filePath).append((Object)this.fileName, (Object)other.fileName).append((Object)this.packagePath, (Object)other.packagePath).append((Object)this.md5sum, (Object)other.md5sum).append((Object)this.sha1sum, (Object)other.sha1sum).append((Object)this.sha256sum, (Object)other.sha256sum).append(this.softwareIdentifiers, other.softwareIdentifiers).append(this.vulnerabileSoftwareIdentifiers, other.vulnerabileSoftwareIdentifiers).append(this.suppressedIdentifiers, other.suppressedIdentifiers).append((Object)this.description, (Object)other.description).append((Object)this.license, (Object)other.license).append(this.vulnerabilities, other.vulnerabilities).append(this.projectReferences, other.projectReferences).append(this.availableVersions, other.availableVersions).append((Object)this.version, (Object)other.version).append((Object)this.ecosystem, (Object)other.ecosystem).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(3, 47).appendSuper(super.hashCode()).append((Object)this.actualFilePath).append((Object)this.filePath).append((Object)this.fileName).append((Object)this.packagePath).append((Object)this.md5sum).append((Object)this.sha1sum).append((Object)this.sha256sum).append(this.softwareIdentifiers).append(this.vulnerabileSoftwareIdentifiers).append(this.suppressedIdentifiers).append((Object)this.description).append((Object)this.license).append(this.vulnerabilities).append(this.projectReferences).append(this.availableVersions).append((Object)this.version).append((Object)this.ecosystem).toHashCode();
    }

    @Override
    public synchronized String toString() {
        return "Dependency{ fileName='" + this.fileName + "', actualFilePath='" + this.actualFilePath + "', filePath='" + this.filePath + "', packagePath='" + this.packagePath + "'}";
    }

    public synchronized void addSuppressedVulnerabilities(List<Vulnerability> vulns) {
        this.suppressedVulnerabilities.addAll(vulns);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getEcosystem() {
        return this.ecosystem;
    }

    public void setEcosystem(String ecosystem) {
        this.ecosystem = ecosystem;
    }

    static interface HashingFunction {
        public String hash(File var1) throws IOException, NoSuchAlgorithmException;
    }
}

